/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;

public class SpringProblemFileHighlightFilter
implements Condition<VirtualFile> {
    private final Project project;

    public SpringProblemFileHighlightFilter(Project project) {
        this.project = project;
    }

    public boolean value(VirtualFile virtualFile) {
        if (!FileTypeRegistry.getInstance().isFileOfType(virtualFile, (FileType)XmlFileType.INSTANCE)) {
            return false;
        }
        if (!SpringCommonUtils.isSpringConfigured((Module)ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)this.project))) {
            return false;
        }
        return (Boolean)ReadAction.compute(() -> {
            PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(virtualFile);
            return psiFile instanceof XmlFile && SpringDomUtils.isSpringXml((XmlFile)((XmlFile)psiFile));
        });
    }
}

