/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.facet.SpringSchemaVersion;
import com.intellij.spring.model.converters.SpringImportResourceConverter;
import com.intellij.spring.model.utils.resources.SpringResourcesBuilder;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.spring.model.values.converters.resources.SpringResourceTypeProvider;
import com.intellij.spring.model.xml.beans.SpringImport;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringImportResourceConverterImpl
extends SpringImportResourceConverter
implements SpringResourceTypeProvider {
    public Set<PsiFile> fromString(@Nullable String s, @NotNull ConvertContext context) {
        if (context == null) {
            SpringImportResourceConverterImpl.$$$reportNull$$$0(0);
        }
        if (s == null) {
            return null;
        }
        GenericAttributeValue element = (GenericAttributeValue)context.getInvocationElement();
        if (DomUtil.hasXml((DomElement)element) && !s.contains("${")) {
            PsiReference[] references = this.createReferences((GenericDomValue)element, (PsiElement)context.getFile(), context);
            List files = SpringImportResourceConverterImpl.getFiles((PsiReference[])references);
            if (files.isEmpty()) {
                return null;
            }
            return new LinkedHashSet<PsiFile>(files);
        }
        return Collections.emptySet();
    }

    public String toString(@Nullable Set<PsiFile> psiFile, @NotNull ConvertContext context) {
        if (context == null) {
            SpringImportResourceConverterImpl.$$$reportNull$$$0(1);
        }
        return null;
    }

    public PsiReference @NotNull [] createReferences(GenericDomValue genericDomValue, PsiElement element, ConvertContext context) {
        String s = genericDomValue.getStringValue();
        if (s == null || SpringImportResourceConverterImpl.hasTrailingSpace(s) || element == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SpringImportResourceConverterImpl.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (s.contains("${")) {
            PsiReference[] psiReferenceArray = PlaceholderUtils.getInstance().createPlaceholderPropertiesReferences(genericDomValue);
            if (psiReferenceArray == null) {
                SpringImportResourceConverterImpl.$$$reportNull$$$0(3);
            }
            return psiReferenceArray;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SpringImportResourceConverterImpl.$$$reportNull$$$0(4);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        SpringResourcesBuilder builder = SpringResourcesBuilder.create((PsiElement)element, (String)s, (int)1).fromRoot(s.startsWith("/")).filter(SpringDomUtils.SPRING_XML_CONDITION).modules(JamCommonUtil.getAllDependentModules((Module)module)).newFileTemplateName(SpringSchemaVersion.SPRING_SCHEMA.getTemplateName());
        PsiReference[] psiReferenceArray = SpringResourcesUtil.getInstance().getReferences(builder);
        if (psiReferenceArray == null) {
            SpringImportResourceConverterImpl.$$$reportNull$$$0(5);
        }
        return psiReferenceArray;
    }

    @Nullable
    public Condition<PsiFileSystemItem> getResourceFilter(@NotNull GenericDomValue genericDomValue) {
        if (genericDomValue == null) {
            SpringImportResourceConverterImpl.$$$reportNull$$$0(6);
        }
        if (genericDomValue.getParent() instanceof SpringImport) {
            return SpringDomUtils.SPRING_XML_CONDITION;
        }
        return null;
    }

    @Nullable
    public String getErrorMessage(@Nullable String s, @NotNull ConvertContext context) {
        if (context == null) {
            SpringImportResourceConverterImpl.$$$reportNull$$$0(7);
        }
        if (s != null && SpringImportResourceConverterImpl.hasTrailingSpace(s)) {
            return SpringBundle.message("spring.import.resource.error.message.trailing.space", s);
        }
        return super.getErrorMessage(s, context);
    }

    private static boolean hasTrailingSpace(@NotNull String s) {
        if (s == null) {
            SpringImportResourceConverterImpl.$$$reportNull$$$0(8);
        }
        return !s.contains("IntellijIdeaRulezzz ") && StringUtil.trimTrailing((String)s).length() != s.length();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/converters/SpringImportResourceConverterImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericDomValue";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/converters/SpringImportResourceConverterImpl";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getResourceFilter";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasTrailingSpace";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

