/*
 * Decompiled with CFR 0.152.
 */
package org.joox.selector;

import java.util.List;
import java.util.regex.Pattern;
import org.joox.selector.AttributeSpecifier;
import org.joox.selector.PseudoClassSpecifier;
import org.joox.selector.PseudoNthSpecifier;
import org.joox.selector.Scanner;
import org.joox.selector.Selector;
import org.joox.selector.Specifier;

public final class CSS2XPath {
    private static final Pattern SIMPLE_SELECTOR = Pattern.compile("[\\w\\-]+");

    public static final String css2xpath(String css) {
        return CSS2XPath.css2xpath(css, true);
    }

    public static final String css2xpath(String css, boolean isRoot) {
        Scanner scanner = new Scanner(css);
        List<List<Selector>> selectors = scanner.scan();
        StringBuilder sb = new StringBuilder();
        String selectorSeparator = "";
        for (List<Selector> selector : selectors) {
            sb.append(selectorSeparator);
            if (!isRoot) {
                sb.append(".");
            }
            for (Selector s : selector) {
                switch (s.getCombinator()) {
                    case CHILD: {
                        sb.append("/");
                        break;
                    }
                    case DESCENDANT: {
                        sb.append("//");
                        break;
                    }
                    case ADJACENT_SIBLING: {
                        sb.append("?????");
                        break;
                    }
                    case GENERAL_SIBLING: {
                        sb.append("?????");
                    }
                }
                if (SIMPLE_SELECTOR.matcher(s.getTagName()).matches()) {
                    sb.append("*[local-name() = '").append(s.getTagName()).append("']");
                } else {
                    sb.append(s.getTagName());
                }
                if (!s.hasSpecifiers()) continue;
                block21: for (Specifier specifier : s.getSpecifiers()) {
                    switch (specifier.getType()) {
                        case ATTRIBUTE: {
                            AttributeSpecifier a = (AttributeSpecifier)specifier;
                            sb.append("[");
                            if (a.getMatch() == null) {
                                sb.append("@");
                                sb.append(a.getName());
                            } else {
                                switch (a.getMatch()) {
                                    case EXACT: {
                                        sb.append("@");
                                        sb.append(a.getName());
                                        sb.append("='");
                                        sb.append(a.getValue().replace("'", "\\'"));
                                        sb.append("'");
                                        break;
                                    }
                                    case CONTAINS: {
                                        sb.append("contains(@");
                                        sb.append(a.getName());
                                        sb.append(", '");
                                        sb.append(a.getValue().replace("'", "\\'"));
                                        sb.append("')");
                                        break;
                                    }
                                    case HYPHEN: {
                                        sb.append("@");
                                        sb.append(a.getName());
                                        sb.append("='");
                                        sb.append(a.getValue().replace("'", "\\'"));
                                        sb.append("' or starts-with(@");
                                        sb.append(a.getName());
                                        sb.append(", '");
                                        sb.append(a.getValue().replace("'", "\\'"));
                                        sb.append("-')");
                                        break;
                                    }
                                    case PREFIX: {
                                        sb.append("starts-with(@");
                                        sb.append(a.getName());
                                        sb.append(", '");
                                        sb.append(a.getValue().replace("'", "\\'"));
                                        sb.append("')");
                                        break;
                                    }
                                    case SUFFIX: {
                                        CSS2XPath.endsWith(sb, a.getName(), a.getValue());
                                        break;
                                    }
                                    case LIST: {
                                        sb.append("@");
                                        sb.append(a.getName());
                                        sb.append("='");
                                        sb.append(a.getValue().replace("'", "\\'"));
                                        sb.append("' or starts-with(@");
                                        sb.append(a.getName());
                                        sb.append(", '");
                                        sb.append(a.getValue().replace("'", "\\'"));
                                        sb.append(" ')");
                                        sb.append(" or ");
                                        CSS2XPath.endsWith(sb, a.getName(), " " + a.getValue());
                                        sb.append(" or contains(@");
                                        sb.append(a.getName());
                                        sb.append(", ' ");
                                        sb.append(a.getValue().replace("'", "\\'"));
                                        sb.append(" ')");
                                    }
                                }
                            }
                            sb.append("]");
                            break;
                        }
                        case NEGATION: {
                            sb.append("[not(");
                            sb.append(")]");
                            break;
                        }
                        case PSEUDO: {
                            String value;
                            Specifier p;
                            if (specifier instanceof PseudoClassSpecifier) {
                                p = (PseudoClassSpecifier)specifier;
                                value = ((PseudoClassSpecifier)p).getValue();
                                if ("empty".equals(value)) {
                                    sb.append("[not(*|@*|node())]");
                                    break;
                                }
                                if ("first-child".equals(value)) {
                                    sb.append("[not(preceding-sibling::*)]");
                                    break;
                                }
                                if ("last-child".equals(value)) {
                                    sb.append("[not(following-sibling::*)]");
                                    break;
                                }
                                if ("only-child".equals(value)) {
                                    sb.append("[not(preceding-sibling::*) and not(following-sibling::*)]");
                                    break;
                                }
                                if (!"root".equals(value)) continue block21;
                                sb.append("[not(parent::*)]");
                                break;
                            }
                            if (!(specifier instanceof PseudoNthSpecifier) || !"nth-child".equals(value = ((PseudoNthSpecifier)(p = (PseudoNthSpecifier)specifier)).getValue())) break;
                            sb.append("[count(preceding-sibling::*) = ");
                            sb.append(((PseudoNthSpecifier)p).getArgument());
                            sb.append(" - 1]");
                        }
                    }
                }
            }
            selectorSeparator = " | ";
        }
        return sb.toString();
    }

    private static void endsWith(StringBuilder sb, String attr, String value) {
        sb.append("'");
        sb.append(value.replace("'", "\\'"));
        sb.append("' = substring(@");
        sb.append(attr);
        sb.append(", string-length(@");
        sb.append(attr);
        sb.append(") - string-length('");
        sb.append(value.replace("'", "\\'"));
        sb.append("') + 1)");
    }
}

