/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.ide.documentation;

import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.protobuf.lang.psi.PbCommentOwner;
import com.intellij.protobuf.lang.psi.util.PbCommentUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class PbDocumentationProvider
extends AbstractDocumentationProvider {
    @Nullable
    @Nls
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        if (!(element instanceof PbCommentOwner)) {
            return null;
        }
        PbCommentOwner owner = (PbCommentOwner)element;
        List<PsiComment> comments = owner.getComments();
        if (comments.isEmpty()) {
            return null;
        }
        @NlsSafe StringBuilder commentBuilder = new StringBuilder("<pre>");
        for (String line : PbCommentUtil.extractText(comments)) {
            commentBuilder.append(StringUtil.escapeXmlEntities((String)line));
            commentBuilder.append("\n");
        }
        commentBuilder.append("</pre>");
        return commentBuilder.toString();
    }
}

