/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.psi.text;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.psi.KtDeclarationModifierList;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u001b\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t*\u0006\u0012\u0002\b\u00030\u000b\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"getQualifiedName", "", "typeElement", "Lorg/jetbrains/kotlin/psi/KtTypeElement;", "isSuspend", "", "userType", "Lorg/jetbrains/kotlin/psi/KtUserType;", "getAllModifierLists", "", "Lorg/jetbrains/kotlin/psi/KtDeclarationModifierList;", "Lorg/jetbrains/kotlin/psi/KtElementImplStub;", "(Lorg/jetbrains/kotlin/psi/KtElementImplStub;)[Lorg/jetbrains/kotlin/psi/KtDeclarationModifierList;", "decompiler-to-psi"})
@SourceDebugExtension(value={"SMAP\nByDescriptorIndexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByDescriptorIndexer.kt\norg/jetbrains/kotlin/analysis/decompiler/psi/text/ByDescriptorIndexerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,39:1\n1#2:40\n*E\n"})
public final class ByDescriptorIndexerKt {
    @Nullable
    public static final String getQualifiedName(@Nullable KtTypeElement typeElement, boolean isSuspend) {
        String string;
        KtTypeElement ktTypeElement = typeElement;
        if (ktTypeElement instanceof KtUserType) {
            string = ByDescriptorIndexerKt.getQualifiedName((KtUserType)typeElement);
        } else if (ktTypeElement instanceof KtFunctionType) {
            int parametersCount = 0;
            parametersCount = ((KtFunctionType)typeElement).getParameters().size();
            KtTypeReference ktTypeReference = ((KtFunctionType)typeElement).getReceiverTypeReference();
            if (ktTypeReference != null) {
                KtTypeReference it = ktTypeReference;
                boolean bl = false;
                int n = parametersCount;
                parametersCount = n + 1;
            }
            string = isSuspend ? StandardNames.getSuspendFunctionClassId(parametersCount).asFqNameString() : StandardNames.getFunctionClassId(parametersCount).asFqNameString();
        } else {
            string = ktTypeElement instanceof KtNullableType ? ByDescriptorIndexerKt.getQualifiedName(KtPsiUtilKt.unwrapNullability(typeElement), isSuspend) : null;
        }
        String referencedName = string;
        return referencedName;
    }

    private static final String getQualifiedName(KtUserType userType) {
        KtUserType ktUserType = userType.getQualifier();
        if (ktUserType == null) {
            return userType.getReferencedName();
        }
        KtUserType qualifier = ktUserType;
        return ByDescriptorIndexerKt.getQualifiedName(qualifier) + '.' + userType.getReferencedName();
    }

    @NotNull
    public static final KtDeclarationModifierList[] getAllModifierLists(@NotNull KtElementImplStub<?> $this$getAllModifierLists) {
        Intrinsics.checkNotNullParameter($this$getAllModifierLists, (String)"<this>");
        PsiElement[] psiElementArray = $this$getAllModifierLists.getStubOrPsiChildren(KtStubElementTypes.MODIFIER_LIST, KtStubElementTypes.MODIFIER_LIST.getArrayFactory());
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getStubOrPsiChildren(...)");
        return (KtDeclarationModifierList[])psiElementArray;
    }
}

