/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.lang.html.psi.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.BlockEx;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.formatter.xml.AnotherLanguageBlockWrapper;
import com.intellij.psi.formatter.xml.SyntheticBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.lang.expr.VueExprLanguagesKt;
import org.jetbrains.vuejs.lang.html.lexer.VueTokenTypes;
import org.jetbrains.vuejs.lang.html.psi.formatter.VueBlock;
import org.jetbrains.vuejs.lang.html.psi.formatter.VueCodeStyleSettings;
import org.jetbrains.vuejs.lang.html.psi.formatter.VueHtmlBlock;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cBC\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\n\u0010\u0010\u001a\u0004\u0018\u00010\rH\u0016J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/vuejs/lang/html/psi/formatter/VueSyntheticBlock;", "Lcom/intellij/psi/formatter/xml/SyntheticBlock;", "Lcom/intellij/formatting/BlockEx;", "subBlocks", "", "Lcom/intellij/formatting/Block;", "parent", "indent", "Lcom/intellij/formatting/Indent;", "policy", "Lcom/intellij/psi/formatter/xml/XmlFormattingPolicy;", "childIndent", "myLanguage", "Lcom/intellij/lang/Language;", "<init>", "(Ljava/util/List;Lcom/intellij/formatting/Block;Lcom/intellij/formatting/Indent;Lcom/intellij/psi/formatter/xml/XmlFormattingPolicy;Lcom/intellij/formatting/Indent;Lcom/intellij/lang/Language;)V", "getLanguage", "getSpacing", "Lcom/intellij/formatting/Spacing;", "child1", "child2", "startsWithText", "", "endsWithText", "findSibling", "block", "relativeIndex", "", "Companion", "intellij.vuejs.backend"})
public final class VueSyntheticBlock
extends SyntheticBlock
implements BlockEx {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Language myLanguage;

    public VueSyntheticBlock(@NotNull List<? extends Block> subBlocks, @NotNull Block parent, @Nullable Indent indent, @NotNull XmlFormattingPolicy policy, @Nullable Indent childIndent, @Nullable Language myLanguage) {
        Intrinsics.checkNotNullParameter(subBlocks, (String)"subBlocks");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
        super(subBlocks, parent, indent, policy, childIndent);
        this.myLanguage = myLanguage;
    }

    @Nullable
    public Language getLanguage() {
        return this.myLanguage;
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        Spacing spacing;
        Intrinsics.checkNotNullParameter((Object)child2, (String)"child2");
        if (Companion.isVueInterpolationBorder(child1, child2) || Companion.isVueInterpolationBorder(child2, child1)) {
            int spaces;
            AnotherLanguageBlockWrapper anotherLanguageBlockWrapper = child1 instanceof AnotherLanguageBlockWrapper ? (AnotherLanguageBlockWrapper)child1 : null;
            if (anotherLanguageBlockWrapper == null) {
                anotherLanguageBlockWrapper = (AnotherLanguageBlockWrapper)child2;
            }
            AnotherLanguageBlockWrapper injectedWrapper = anotherLanguageBlockWrapper;
            boolean spacesWithinInterpolation = false;
            boolean insertNewLine = false;
            VueCodeStyleSettings it = (VueCodeStyleSettings)this.myXmlFormattingPolicy.getSettings().getCustomSettings(VueCodeStyleSettings.class);
            boolean bl = false;
            spacesWithinInterpolation = it.SPACES_WITHIN_INTERPOLATION_EXPRESSIONS;
            insertNewLine = !(child1 instanceof AnotherLanguageBlockWrapper) ? it.INTERPOLATION_NEW_LINE_AFTER_START_DELIMITER : it.INTERPOLATION_NEW_LINE_BEFORE_END_DELIMITER;
            int n = spaces = spacesWithinInterpolation ? 1 : 0;
            if (insertNewLine) {
                Block prevBlock = this.findSibling((Block)injectedWrapper, -1);
                Block nextBlock = this.findSibling((Block)injectedWrapper, 1);
                spacing = prevBlock != null && nextBlock != null ? Spacing.createDependentLFSpacing((int)spaces, (int)spaces, (TextRange)new TextRange(prevBlock.getTextRange().getStartOffset(), nextBlock.getTextRange().getEndOffset()), (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines()) : Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
            } else {
                spacing = Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
            }
        } else {
            spacing = super.getSpacing(child1, child2);
        }
        return spacing;
    }

    public boolean startsWithText() {
        return super.startsWithText() || Intrinsics.areEqual((Object)this.myStartTreeNode.getElementType(), (Object)((Object)VueTokenTypes.INTERPOLATION_START));
    }

    public boolean endsWithText() {
        return super.endsWithText() || Intrinsics.areEqual((Object)this.myEndTreeNode.getElementType(), (Object)((Object)VueTokenTypes.INTERPOLATION_END));
    }

    private final Block findSibling(Block block, int relativeIndex) {
        List list = this.getSubBlocks();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSubBlocks(...)");
        List subBlocks = list;
        int ind = subBlocks.indexOf(block);
        if (ind >= 0 && ind + relativeIndex >= 0 && ind + relativeIndex < subBlocks.size()) {
            return (Block)subBlocks.get(ind + relativeIndex);
        }
        return null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/vuejs/lang/html/psi/formatter/VueSyntheticBlock$Companion;", "", "<init>", "()V", "isVueInterpolationBorder", "", "child1", "Lcom/intellij/formatting/Block;", "child2", "intellij.vuejs.backend"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isVueInterpolationBorder(@Nullable Block child1, @Nullable Block child2) {
            AnotherLanguageBlockWrapper anotherLanguageBlockWrapper;
            return (child1 instanceof VueHtmlBlock || child1 instanceof VueBlock) && VueExprLanguagesKt.isVueExprMetaLanguage((anotherLanguageBlockWrapper = child2 instanceof AnotherLanguageBlockWrapper ? (AnotherLanguageBlockWrapper)child2 : null) != null && (anotherLanguageBlockWrapper = anotherLanguageBlockWrapper.getNode()) != null && (anotherLanguageBlockWrapper = anotherLanguageBlockWrapper.getPsi()) != null ? anotherLanguageBlockWrapper.getLanguage() : null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

