/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui;

import com.intellij.execution.services.ServiceViewUIUtils;
import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.KubernetesResourceRefreshable;
import com.intellij.kubernetes.view.mappers.KubernetesColumnDescriptorsProvider;
import com.intellij.kubernetes.view.ui.KubernetesResourceContent;
import com.intellij.kubernetes.view.ui.KubernetesResourceInformationPanel;
import com.intellij.kubernetes.view.ui.actions.ActionUtilsKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.impl.ContentManagerImpl;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.JBUI;
import io.kubernetes.client.common.KubernetesObject;
import java.awt.Container;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00010\u00042\u00020\u0005B7\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0006\u001a\u00028\u0000H\u0096@\u00a2\u0006\u0002\u0010 J\b\u0010%\u001a\u00020\u001fH\u0016J&\u0010&\u001a\u00020'2\u0006\u0010\u001a\u001a\u00020\u001b2\u000f\b\u0002\u0010(\u001a\t\u0018\u00010)\u00a2\u0006\u0002\b*H\u0000\u00a2\u0006\u0002\b+J!\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020\u001b2\u000f\b\u0002\u0010(\u001a\t\u0018\u00010)\u00a2\u0006\u0002\b*H\u0007J\u0010\u0010.\u001a\u00020\u001f2\u0006\u0010/\u001a\u000200H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\"X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b#\u0010$\u00a8\u00061"}, d2={"Lcom/intellij/kubernetes/view/ui/KubernetesResourceContent;", "T", "Lio/kubernetes/client/common/KubernetesObject;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/kubernetes/view/KubernetesResourceRefreshable;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "resource", "parentDisposable", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "columnDescriptorsProvider", "Lcom/intellij/kubernetes/view/mappers/KubernetesColumnDescriptorsProvider;", "toolbarActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "<init>", "(Lio/kubernetes/client/common/KubernetesObject;Lcom/intellij/openapi/Disposable;Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;Lcom/intellij/kubernetes/view/mappers/KubernetesColumnDescriptorsProvider;Lcom/intellij/openapi/actionSystem/ActionGroup;)V", "getApiModel", "()Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "manager", "Lcom/intellij/ui/content/ContentManager;", "getManager$intellij_clouds_kubernetes", "()Lcom/intellij/ui/content/ContentManager;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "refresh", "", "(Lio/kubernetes/client/common/KubernetesObject;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "informationPanel", "Lcom/intellij/kubernetes/view/ui/KubernetesResourceInformationPanel;", "getInformationPanel$annotations", "()V", "dispose", "addTab", "Lcom/intellij/ui/content/Content;", "displayName", "", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "addTab$intellij_clouds_kubernetes", "addConsoleTab", "panel", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "intellij.clouds.kubernetes"})
public class KubernetesResourceContent<T extends KubernetesObject>
implements Disposable,
KubernetesResourceRefreshable<T>,
UiDataProvider {
    @NotNull
    private final KubernetesApiModelInterface apiModel;
    @Nullable
    private final ActionGroup toolbarActionGroup;
    @NotNull
    private final ContentManager manager;
    @NotNull
    private final KubernetesResourceInformationPanel<T> informationPanel;

    public KubernetesResourceContent(@NotNull T resource, @NotNull Disposable parentDisposable, @NotNull KubernetesApiModelInterface apiModel2, @NotNull KubernetesColumnDescriptorsProvider<T> columnDescriptorsProvider, @Nullable ActionGroup toolbarActionGroup) {
        Intrinsics.checkNotNullParameter(resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter(columnDescriptorsProvider, (String)"columnDescriptorsProvider");
        this.apiModel = apiModel2;
        this.toolbarActionGroup = toolbarActionGroup;
        ContentUI contentUI = ServiceViewUIUtils.getServicesAlignedTabbedPaneContentUI();
        Project project = this.getProject();
        this.manager = (ContentManager)new ContentManagerImpl(this, contentUI, project){
            {
                this.addUiDataProvider(arg_0 -> manager.1._init_$lambda$0($receiver, arg_0));
            }

            public List<AnAction> getAdditionalPopupActions(Content content2) {
                Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
                List list2 = super.getAdditionalPopupActions(content2);
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAdditionalPopupActions(...)");
                return CollectionsKt.plus((Collection)list2, (Object)ActionManager.getInstance().getAction("Kubernetes.StopPortForwarding"));
            }

            private static final void _init_$lambda$0(KubernetesResourceContent this$0, DataSink sink) {
                JComponent selectedComponent;
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                DataKey dataKey = PlatformCoreDataKeys.HELP_ID;
                Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"HELP_ID");
                sink.set(dataKey, (Object)"services.tool.window.kubernetes");
                Content content2 = this$0.getManager$intellij_clouds_kubernetes().getSelectedContent();
                JComponent jComponent = selectedComponent = content2 != null ? content2.getComponent() : null;
                if (selectedComponent instanceof UiDataProvider) {
                    sink.uiDataSnapshot((UiDataProvider)selectedComponent);
                }
            }
        };
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.informationPanel = new KubernetesResourceInformationPanel<T>(resource, this, columnDescriptorsProvider.getColumnDescriptorsForMultilineTable(this.apiModel));
        Content content2 = this.addTab$intellij_clouds_kubernetes(this.informationPanel, KubernetesBundle.message("KubernetesResourceContent.informationContent.displayName", new Object[0]));
        content2.getDisplayName();
        content2.setCloseable(false);
    }

    @NotNull
    public final KubernetesApiModelInterface getApiModel() {
        return this.apiModel;
    }

    @NotNull
    protected final Project getProject() {
        return this.apiModel.getProject();
    }

    @NotNull
    public final ContentManager getManager$intellij_clouds_kubernetes() {
        return this.manager;
    }

    @NotNull
    public final JComponent getComponent() {
        JComponent jComponent = this.manager.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    @Override
    @Nullable
    public Object refresh(@NotNull T resource, @NotNull Continuation<? super Unit> $completion) {
        return KubernetesResourceContent.refresh$suspendImpl(this, resource, $completion);
    }

    static /* synthetic */ <T extends KubernetesObject> Object refresh$suspendImpl(KubernetesResourceContent<T> $this, T resource, Continuation<? super Unit> $completion) {
        Object object = $this.informationPanel.refresh(resource, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static /* synthetic */ void getInformationPanel$annotations() {
    }

    public void dispose() {
    }

    @NotNull
    public final Content addTab$intellij_clouds_kubernetes(@NotNull JComponent component2, @Nullable String displayName) {
        Content content2;
        block1: {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            Content content3 = this.manager.getFactory().createContent(component2, displayName, true);
            Intrinsics.checkNotNullExpressionValue((Object)content3, (String)"createContent(...)");
            content2 = content3;
            if (this.toolbarActionGroup != null) {
                content2.setActions(this.toolbarActionGroup, "ServicesToolbar", component2);
            }
            this.manager.addContent(content2);
            Container container = component2.getParent();
            JComponent jComponent = container instanceof JComponent ? (JComponent)container : null;
            if (jComponent == null) break block1;
            jComponent.setBorder((Border)JBUI.Borders.empty());
        }
        return content2;
    }

    public static /* synthetic */ Content addTab$intellij_clouds_kubernetes$default(KubernetesResourceContent kubernetesResourceContent, JComponent jComponent, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addTab");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return kubernetesResourceContent.addTab$intellij_clouds_kubernetes(jComponent, string);
    }

    @RequiresEdt
    @NotNull
    public final Content addConsoleTab(@NotNull JComponent panel2, @Nullable String displayName) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        Content content2 = this.addTab$intellij_clouds_kubernetes(panel2, displayName);
        content2.setComponent(panel2);
        if (this.toolbarActionGroup != null) {
            content2.setActions(this.toolbarActionGroup, "ServicesToolbar", this.getComponent());
        }
        this.manager.setSelectedContent(content2, true);
        return content2;
    }

    public static /* synthetic */ Content addConsoleTab$default(KubernetesResourceContent kubernetesResourceContent, JComponent jComponent, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addConsoleTab");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return kubernetesResourceContent.addConsoleTab(jComponent, string);
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        sink.set(ActionUtilsKt.getKUBERNETES_CONTEXT(), (Object)this.apiModel.getCurrentContextObject());
    }
}

