/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.ultimate.project;

import com.intellij.indexing.shared.download.SharedIndexAuthParams;
import com.intellij.indexing.shared.download.SharedIndexDownloadAuthExtensionKt;
import com.intellij.indexing.shared.project.api.ProjectSharedIndexSource;
import com.intellij.indexing.shared.project.api.ProjectSharedIndexSourceProvider;
import com.intellij.indexing.shared.ultimate.project.ProjectSharedIndexSetting;
import com.intellij.indexing.shared.ultimate.project.ProjectSharedIndexState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.DigestUtilKt;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u001a\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0003*\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\n\u001a\u00020\u000b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getProjectSharedIndexSources", "", "Lcom/intellij/indexing/shared/project/api/ProjectSharedIndexSource;", "project", "Lcom/intellij/openapi/project/Project;", "resolvedProjectSettings", "Lcom/intellij/indexing/shared/ultimate/project/ProjectSharedIndexSetting;", "asConfigs", "indexIdBase", "", "intellij.indexing.shared.ultimate"})
@SourceDebugExtension(value={"SMAP\nProjectSharedIndexSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectSharedIndexSettings.kt\ncom/intellij/indexing/shared/ultimate/project/ProjectSharedIndexSettingsKt\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 7 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,148:1\n30#2,2:149\n1374#3:151\n1460#3,5:152\n1617#3,9:157\n1869#3:166\n1870#3:168\n1626#3:169\n1491#3:170\n1516#3,3:171\n1519#3,3:181\n1#4:167\n382#5,7:174\n126#6:184\n153#6,3:185\n13#7:188\n*S KotlinDebug\n*F\n+ 1 ProjectSharedIndexSettings.kt\ncom/intellij/indexing/shared/ultimate/project/ProjectSharedIndexSettingsKt\n*L\n113#1:149,2\n114#1:151\n114#1:152,5\n126#1:157,9\n126#1:166\n126#1:168\n126#1:169\n142#1:170\n142#1:171,3\n142#1:181,3\n126#1:167\n142#1:174,7\n142#1:184\n142#1:185,3\n67#1:188\n*E\n"})
public final class ProjectSharedIndexSettingsKt {
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    private static final List<ProjectSharedIndexSource> getProjectSharedIndexSources(Project project) {
        List list;
        if (project.isDefault()) {
            list = CollectionsKt.emptyList();
        } else {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            Object $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ProjectSharedIndexState> serviceClass$iv = ProjectSharedIndexState.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            $this$service$iv = ProjectSharedIndexSourceProvider.Companion.getEP_NAME().getExtensionList();
            Collection collection = ((ProjectSharedIndexState)((Object)object)).sharedIndexSources();
            boolean $i$f$flatMap = false;
            serviceClass$iv = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                ProjectSharedIndexSourceProvider it = (ProjectSharedIndexSourceProvider)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getSharedIndexSourcesFor(project);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        }
        return list;
    }

    @NotNull
    public static final List<ProjectSharedIndexSetting> resolvedProjectSettings(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List<ProjectSharedIndexSource> settings = ProjectSharedIndexSettingsKt.getProjectSharedIndexSources(project);
        String string = project.getLocationHash();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocationHash(...)");
        return ProjectSharedIndexSettingsKt.asConfigs(settings, string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ProjectSharedIndexSetting> asConfigs(@NotNull List<ProjectSharedIndexSource> $this$asConfigs, @NotNull String indexIdBase) {
        void $this$mapTo$iv$iv;
        Object $this$groupByTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$asConfigs, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)indexIdBase, (String)"indexIdBase");
        Iterable $this$mapNotNull$iv = CollectionsKt.distinct((Iterable)$this$asConfigs);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean bl = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            ProjectSharedIndexSetting projectSharedIndexSetting;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl4 = false;
            ProjectSharedIndexSource projectConfig = (ProjectSharedIndexSource)element$iv$iv;
            boolean bl2 = false;
            String serviceUrl = projectConfig.getUrl();
            if (StringsKt.isBlank((CharSequence)serviceUrl)) {
                projectSharedIndexSetting = null;
            } else {
                SharedIndexAuthParams authId = projectConfig.getAuthId();
                if (authId != null && SharedIndexDownloadAuthExtensionKt.resolveIndexDownloadAuthExtension((SharedIndexAuthParams)authId) == null) {
                    projectSharedIndexSetting = null;
                } else {
                    String string = ((Object)StringsKt.trim((CharSequence)serviceUrl)).toString().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                    String indexId = indexIdBase + "-" + DigestUtilKt.hashToHexString((String)string, (MessageDigest)DigestUtil.sha256());
                    projectSharedIndexSetting = new ProjectSharedIndexSetting(serviceUrl, indexId, authId, projectConfig.getResolveCommits());
                }
            }
            if (projectSharedIndexSetting == null) continue;
            ProjectSharedIndexSetting it$iv$iv = projectSharedIndexSetting;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$mapNotNullTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator<Object> iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object2;
            void $this$getOrPut$iv$iv$iv;
            Object t = iterator.next();
            ProjectSharedIndexSetting it = (ProjectSharedIndexSetting)t;
            boolean bl2 = false;
            String key$iv$iv = it.getUrl();
            Object bl4 = destination$iv$iv;
            String key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl5 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(t);
        }
        Object $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry entry : $this$mapTo$iv$iv.entrySet()) {
            object = entry;
            Object object3 = destination$iv$iv;
            boolean bl3 = false;
            String url = (String)object.getKey();
            List entries = (List)object.getValue();
            if (entries.size() != 1) {
                LOG.warn("Duplicated settings for " + url);
            }
            object3.add((ProjectSharedIndexSetting)CollectionsKt.first((List)entries));
        }
        return (List)destination$iv$iv;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ProjectSharedIndexState.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

