/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.scale;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.datetime.TimeZone;
import org.jetbrains.letsPlot.core.commons.data.DataType;
import org.jetbrains.letsPlot.core.commons.time.interval.NiceTimeInterval;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.scale.breaks.DateTimeBreaksGen;
import org.jetbrains.letsPlot.core.plot.builder.scale.ScaleProvider;
import org.jetbrains.letsPlot.core.plot.builder.scale.ScaleProviderBuilder;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00042\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ0\u0010\r\u001a\u00020\u000e2\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J2\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0004\"\u0004\b\u0000\u0010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00122\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u001a\u0010\u0013\u001a\u00020\u0014\"\u0004\b\u0000\u0010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0012\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/scale/ScaleProviderHelper;", "", "()V", "configureDateTimeScaleBreaks", "Lorg/jetbrains/letsPlot/core/plot/builder/scale/ScaleProviderBuilder;", "scaleProviderBuilder", "dateTimeFormatter", "Lkotlin/Function1;", "", "dataType", "Lorg/jetbrains/letsPlot/core/commons/data/DataType;", "tz", "Lorg/jetbrains/letsPlot/commons/intern/datetime/TimeZone;", "createDateTimeBreaksGen", "Lorg/jetbrains/letsPlot/core/plot/base/scale/breaks/DateTimeBreaksGen;", "createDateTimeScaleProviderBuilder", "T", "aes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "createDefault", "Lorg/jetbrains/letsPlot/core/plot/builder/scale/ScaleProvider;", "plot-builder"})
public final class ScaleProviderHelper {
    @NotNull
    public static final ScaleProviderHelper INSTANCE = new ScaleProviderHelper();

    private ScaleProviderHelper() {
    }

    @NotNull
    public final <T> ScaleProvider createDefault(@NotNull Aes<T> aes2) {
        Intrinsics.checkNotNullParameter(aes2, (String)"aes");
        return new ScaleProviderBuilder<T>(aes2).build();
    }

    @NotNull
    public final ScaleProviderBuilder<?> configureDateTimeScaleBreaks(@NotNull ScaleProviderBuilder<?> scaleProviderBuilder, @Nullable Function1<Object, String> dateTimeFormatter2, @NotNull DataType dataType, @Nullable TimeZone tz) {
        Intrinsics.checkNotNullParameter(scaleProviderBuilder, (String)"scaleProviderBuilder");
        Intrinsics.checkNotNullParameter((Object)((Object)dataType), (String)"dataType");
        return scaleProviderBuilder.breaksGeneratorIfNone(this.createDateTimeBreaksGen(dateTimeFormatter2, dataType, tz));
    }

    @NotNull
    public final <T> ScaleProviderBuilder<T> createDateTimeScaleProviderBuilder(@NotNull Aes<T> aes2, @NotNull DataType dataType, @Nullable TimeZone tz) {
        Intrinsics.checkNotNullParameter(aes2, (String)"aes");
        Intrinsics.checkNotNullParameter((Object)((Object)dataType), (String)"dataType");
        return new ScaleProviderBuilder<T>(aes2).breaksGenerator(this.createDateTimeBreaksGen(null, dataType, tz));
    }

    private final DateTimeBreaksGen createDateTimeBreaksGen(Function1<Object, String> dateTimeFormatter2, DataType dataType, TimeZone tz) {
        return new DateTimeBreaksGen(dateTimeFormatter2, NiceTimeInterval.Companion.minIntervalOf(dataType), NiceTimeInterval.Companion.maxIntervalOf(dataType), tz);
    }
}

