/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.servlet.role;

import com.intellij.javaee.web.model.xml.Servlet;
import com.intellij.javaee.web.model.xml.WebApp;
import com.intellij.psi.PsiClass;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.Nullable;

public final class ServletClassRole {
    private final Servlet myServlet;

    private ServletClassRole(Servlet servlet) {
        this.myServlet = servlet;
    }

    public Servlet getServlet() {
        return this.myServlet;
    }

    @Nullable
    public static ServletClassRole getClassRole(PsiClass psiClass, @Nullable WebApp webApp) {
        if (psiClass == null || webApp == null) {
            return null;
        }
        Servlet servlet = (Servlet)ContainerUtil.find((Iterable)webApp.getServlets(), object -> psiClass.equals(object.getServletClass().getValue()));
        return servlet == null ? null : new ServletClassRole(servlet);
    }
}

