/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.parser.v0.factories;

import java.util.ArrayList;
import java.util.List;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCMethod;
import org.openjdk.jmc.common.IMCStackTrace;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.MCFrame;
import org.openjdk.jmc.common.util.MCStackTrace;
import org.openjdk.jmc.flightrecorder.internal.InvalidJfrFileException;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.factories.IPoolFactory;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.model.ValueDescriptor;
import org.openjdk.jmc.flightrecorder.internal.util.CanonicalConstantMap;
import org.openjdk.jmc.flightrecorder.internal.util.ParserToolkit;

final class StackTraceFactory
implements IPoolFactory<IMCStackTrace> {
    private final int m_frameIndex;
    private final int m_truncateIndex;
    private final int m_methodIndex;
    private final int m_lineNumberIndex;
    private final int m_frameTypeIndex;
    private final int m_bciIndex;
    private final int m_fieldCount;
    private final CanonicalConstantMap<IMCStackTrace> traceMap;
    private final CanonicalConstantMap<IMCFrame> frameMap;

    public StackTraceFactory(ValueDescriptor[] traceDescriptors, CanonicalConstantMap<IMCStackTrace> traceMap, CanonicalConstantMap<IMCFrame> frameMap) throws InvalidJfrFileException {
        this.traceMap = traceMap;
        this.frameMap = frameMap;
        this.m_frameIndex = ValueDescriptor.getIndex(traceDescriptors, "frames");
        this.m_truncateIndex = ValueDescriptor.getIndex(traceDescriptors, "truncated");
        if (this.m_frameIndex != -1) {
            ValueDescriptor frameDescriptor = traceDescriptors[this.m_frameIndex];
            this.m_methodIndex = ValueDescriptor.getIndex(frameDescriptor.getChildren(), "method");
            this.m_lineNumberIndex = ValueDescriptor.getIndex(frameDescriptor.getChildren(), "line");
            this.m_frameTypeIndex = ValueDescriptor.getIndex(frameDescriptor.getChildren(), "type");
            this.m_bciIndex = ValueDescriptor.getIndex(frameDescriptor.getChildren(), "bci");
        } else {
            this.m_methodIndex = -1;
            this.m_lineNumberIndex = -1;
            this.m_frameTypeIndex = -1;
            this.m_bciIndex = -1;
        }
        this.m_fieldCount = traceDescriptors.length;
    }

    @Override
    public IMCStackTrace createObject(long identifier, Object o) {
        if (o != null) {
            return this.traceMap.canonicalize(this.createTrace(o));
        }
        return null;
    }

    private IMCStackTrace createTrace(Object o) {
        Object[] frames;
        Boolean truncated = null;
        if (this.m_fieldCount > 1) {
            Object[] objArr = (Object[])o;
            frames = (Object[])objArr[this.m_frameIndex];
            if (this.m_truncateIndex != -1) {
                truncated = (Boolean)objArr[this.m_truncateIndex];
            }
        } else {
            frames = (Object[])o;
        }
        IMCFrame[] flrFrames = new IMCFrame[frames.length];
        for (int n = 0; n < frames.length; ++n) {
            flrFrames[n] = this.createFrame((Object[])frames[n]);
        }
        return new MCStackTrace(StackTraceFactory.buildFilteredStackTrace(flrFrames), IMCStackTrace.TruncationState.fromBoolean(truncated));
    }

    private static List<IMCFrame> buildFilteredStackTrace(IMCFrame[] frames) {
        ArrayList<IMCFrame> list = new ArrayList<IMCFrame>(frames.length);
        for (IMCFrame f : frames) {
            if (f.getMethod() != null && f.getMethod().getType().getPackage() != null && f.getMethod().getType().getPackage().getName() != null && f.getMethod().getType().getPackage().getName().startsWith("oracle.jrockit.jfr.")) continue;
            list.add(f);
        }
        list.trimToSize();
        return list;
    }

    private IMCFrame createFrame(Object[] frameObject) {
        IMCMethod method = this.m_methodIndex != -1 ? (IMCMethod)frameObject[this.m_methodIndex] : null;
        Integer line = this.m_lineNumberIndex != -1 ? Integer.valueOf(((Number)frameObject[this.m_lineNumberIndex]).intValue()) : null;
        IMCFrame.Type type = this.m_frameTypeIndex != -1 ? ParserToolkit.parseFrameType((String)frameObject[this.m_frameTypeIndex]) : IMCFrame.Type.UNKNOWN;
        Integer bci = this.m_bciIndex != -1 ? Integer.valueOf(((Number)frameObject[this.m_bciIndex]).intValue()) : null;
        return this.frameMap.canonicalize(new MCFrame(method, bci, line, type));
    }

    @Override
    public ContentType<IMCStackTrace> getContentType() {
        return UnitLookup.STACKTRACE;
    }
}

