/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot.impl;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;
import java.util.Objects;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.impl.ModuleToUnnamedBridge;

final class ModuleToUnnamedThreadScopeGen
extends ModuleToUnnamedBridge.ModuleToUnnamedThreadScope {
    private static final Handles HANDLES;
    final Object receiver;

    public ModuleToUnnamedThreadScopeGen(AbstractPolyglotImpl engineImpl, Object receiver) {
        super(engineImpl);
        this.receiver = Objects.requireNonNull(receiver);
    }

    @Override
    public void close() {
        try {
            ModuleToUnnamedThreadScopeGen.HANDLES.close_.invoke(this.receiver);
        }
        catch (Throwable t) {
            throw ModuleToUnnamedThreadScopeGen.handleException_(t);
        }
    }

    private static <T extends Throwable> RuntimeException handleException_(Throwable t) throws T {
        throw t;
    }

    static {
        MethodHandles.Lookup lookup = ModuleToUnnamedThreadScopeGen.methodHandleLookup();
        if (lookup != null) {
            try {
                HANDLES = new Handles(lookup);
            }
            catch (ReflectiveOperationException e) {
                throw new InternalError("Failed to initialize method handles for module bridge.", e);
            }
        } else {
            HANDLES = null;
        }
    }

    static final class Handles {
        private final MethodHandle close_;

        Handles(MethodHandles.Lookup lookup) throws ReflectiveOperationException {
            Class<?> typeThreadScope = lookup.findClass(AbstractPolyglotImpl.ThreadScope.class.getName());
            this.close_ = lookup.findVirtual(typeThreadScope, "close", MethodType.methodType(Void.TYPE, List.of()));
        }
    }
}

