/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.spellchecker.BundledDictionaryProvider;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.StreamLoader;
import com.intellij.spellchecker.engine.SpellCheckerEngine;
import com.intellij.spellchecker.settings.SpellCheckerSettings;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a \u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\b\u0010\u0013\u001a\u00020\bH\u0002\u001a\b\u0010\u0014\u001a\u00020\bH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "BUNDLED_EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/spellchecker/BundledDictionaryProvider;", "isDic", "", "path", "", "affectCustomDictionaries", "project", "Lcom/intellij/openapi/project/Project;", "loadBundledDictionaries", "", "spellChecker", "Lcom/intellij/spellchecker/engine/SpellCheckerEngine;", "loadBundledDictionary", "provider", "dictionary", "getProjectDictionaryPath", "getProjectDictionaryName", "intellij.spellchecker"})
@SourceDebugExtension(value={"SMAP\nSpellCheckerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpellCheckerManager.kt\ncom/intellij/spellchecker/SpellCheckerManagerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,495:1\n1761#2,3:496\n13#3:499\n*S KotlinDebug\n*F\n+ 1 SpellCheckerManager.kt\ncom/intellij/spellchecker/SpellCheckerManagerKt\n*L\n446#1:496,3\n49#1:499\n*E\n"})
public final class SpellCheckerManagerKt {
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final ExtensionPointName<BundledDictionaryProvider> BUNDLED_EP_NAME;

    public static final boolean isDic(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return FileUtilRt.extensionEquals((String)path, (String)"dic") || FileUtilRt.extensionEquals((String)path, (String)"txt") || FileUtilRt.getExtension((CharSequence)path, null) == null;
    }

    private static final boolean affectCustomDictionaries(String path, Project project) {
        boolean bl;
        block3: {
            List<String> list = SpellCheckerSettings.getInstance(project).getCustomDictionariesPaths();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getCustomDictionariesPaths(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    String string = it;
                    Intrinsics.checkNotNull((Object)string);
                    if (!FileUtil.isAncestor((String)path, (String)string, (boolean)false)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final void loadBundledDictionaries(SpellCheckerEngine spellChecker) {
        for (BundledDictionaryProvider provider : BUNDLED_EP_NAME.getExtensionList()) {
            String[] stringArray;
            Intrinsics.checkNotNullExpressionValue((Object)provider.getBundledDictionaries(), (String)"getBundledDictionaries(...)");
            for (String dictionary : stringArray) {
                Intrinsics.checkNotNull((Object)dictionary);
                SpellCheckerManagerKt.loadBundledDictionary(provider, dictionary, spellChecker);
            }
        }
    }

    private static final void loadBundledDictionary(BundledDictionaryProvider provider, String dictionary, SpellCheckerEngine spellChecker) {
        spellChecker.loadDictionary(new StreamLoader(dictionary, provider.getClass()));
    }

    private static final String getProjectDictionaryPath() {
        return "dictionaries" + File.separator + StringsKt.replace$default((String)SpellCheckerManagerKt.getProjectDictionaryName(), (char)'.', (char)'_', (boolean)false, (int)4, null) + ".xml";
    }

    @NotNull
    public static final String getProjectDictionaryName() {
        String string;
        if (Registry.Companion.is("spellchecker.use.standard.project.dictionary.name")) {
            string = "project";
        } else {
            String string2 = System.getProperty("user.name");
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
        }
        return string;
    }

    public static final /* synthetic */ ExtensionPointName access$getBUNDLED_EP_NAME$p() {
        return BUNDLED_EP_NAME;
    }

    public static final /* synthetic */ void access$loadBundledDictionary(BundledDictionaryProvider provider, String dictionary, SpellCheckerEngine spellChecker) {
        SpellCheckerManagerKt.loadBundledDictionary(provider, dictionary, spellChecker);
    }

    public static final /* synthetic */ void access$loadBundledDictionaries(SpellCheckerEngine spellChecker) {
        SpellCheckerManagerKt.loadBundledDictionaries(spellChecker);
    }

    public static final /* synthetic */ String access$getProjectDictionaryPath() {
        return SpellCheckerManagerKt.getProjectDictionaryPath();
    }

    public static final /* synthetic */ boolean access$affectCustomDictionaries(String path, Project project) {
        return SpellCheckerManagerKt.affectCustomDictionaries(path, project);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SpellCheckerManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        BUNDLED_EP_NAME = new ExtensionPointName("com.intellij.spellchecker.bundledDictionaryProvider");
    }
}

