/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptParserBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.JSArrowFunctionDetector;
import com.intellij.lang.javascript.parsing.JSParseResult;
import com.intellij.lang.javascript.parsing.JSParsingContextUtil;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.parsing.StatementParser;
import com.intellij.openapi.util.Key;
import com.intellij.psi.tree.IElementType;
import java.util.EnumSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u001f\b\u0016\u0018\u0000 @*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0003>?@B\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\fH\u0016J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0004J\b\u0010\u0016\u001a\u00020\fH\u0016J\b\u0010\u001b\u001a\u00020\bH\u0016J\u0006\u0010\u001e\u001a\u00020\fJ\u0006\u0010\u001f\u001a\u00020\bJ\b\u0010 \u001a\u00020\bH\u0016J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\bJ\u0010\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\u0012H\u0016J\b\u0010&\u001a\u00020\"H\u0014J\u001a\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\b2\b\u0010)\u001a\u0004\u0018\u00010\u0018H\u0014J\b\u0010*\u001a\u00020\bH\u0016J\b\u0010-\u001a\u00020\fH\u0016J\u0006\u0010.\u001a\u00020\bJ\b\u0010/\u001a\u00020\fH\u0014J\u0006\u00100\u001a\u00020\bJ\u0010\u00101\u001a\u00020\b2\u0006\u00102\u001a\u00020\u0012H\u0014J\b\u00103\u001a\u00020\fH\u0002J\u0012\u00104\u001a\u00020\b2\b\u00105\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u00106\u001a\u00020\bH\u0016J\u0016\u0010;\u001a\u00020\b2\u0006\u0010<\u001a\u00020\u00122\u0006\u0010=\u001a\u00020\u0018R\u0014\u0010\t\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001c\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001aR\u0014\u0010+\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u001aR\u0014\u00107\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u0010\u001aR\u0014\u00109\u001a\u00020\u00188TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u001a\u00a8\u0006A"}, d2={"Lcom/intellij/lang/javascript/parsing/FunctionParser;", "T", "Lcom/intellij/lang/javascript/parsing/JavaScriptParser;", "Lcom/intellij/lang/javascript/parsing/JavaScriptParserBase;", "parser", "<init>", "(Lcom/intellij/lang/javascript/parsing/JavaScriptParser;)V", "parseFunctionExpression", "", "isFunctionDeclarationStart", "()Z", "parseFunctionDeclaration", "", "parseFunctionExpressionAttributeList", "parseFunctionNoMarker", "context", "Lcom/intellij/lang/javascript/parsing/FunctionParser$Context;", "functionMarker", "Lcom/intellij/lang/PsiBuilder$Marker;", "parseFunctionName", "functionKeywordWasOmitted", "parseGetSetAndNameAfterFunctionKeyword", "parseFunctionIdentifier", "functionDeclarationElementType", "Lcom/intellij/psi/tree/IElementType;", "getFunctionDeclarationElementType", "()Lcom/intellij/psi/tree/IElementType;", "parseAttributesList", "attributeListElementType", "getAttributeListElementType", "parseES7Decorators", "tryParseES7Decorators", "hasSupportDecorators", "parseParameterList", "Lcom/intellij/lang/javascript/parsing/JSParseResult;", "funExpr", "parseSingleParameter", "parameter", "doParseSingleParameter", "isParameterName", "allowPropertyNameAsIdentifier", "tokenType", "allowLastCommaInParameterAndArgumentList", "parameterType", "getParameterType", "parseParameterOptionalMark", "willParseDestructuringAssignment", "parseParameterAttributeList", "parseArrowFunction", "parseArrowFunctionWithoutModifiers", "arrowFunction", "parseArrowFunctionExpressionBody", "isValidFirstParameterStart", "next", "supportsColonTypeCast", "parameterListElementType", "getParameterListElementType", "functionExpressionElementType", "getFunctionExpressionElementType", "parseParameterListAndBody", "marker", "elementType", "MethodEmptiness", "Context", "Companion", "intellij.javascript.parser"})
@SourceDebugExtension(value={"SMAP\nFunctionParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionParser.kt\ncom/intellij/lang/javascript/parsing/FunctionParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,488:1\n1#2:489\n*E\n"})
public class FunctionParser<T extends JavaScriptParser>
extends JavaScriptParserBase<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Key<MethodEmptiness> methodsEmptinessKey;

    public FunctionParser(@NotNull T parser) {
        Intrinsics.checkNotNullParameter(parser, (String)"parser");
        super(parser);
    }

    public final boolean parseFunctionExpression() {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker mark = marker;
        this.parseFunctionExpressionAttributeList();
        return this.parseFunctionNoMarker(Context.EXPRESSION, mark);
    }

    public boolean isFunctionDeclarationStart() {
        return this.builder.getTokenType() == JSTokenTypes.FUNCTION_KEYWORD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void parseFunctionDeclaration() {
        MethodEmptiness prevMethodEmptiness = (MethodEmptiness)((Object)this.builder.getUserData(methodsEmptinessKey));
        try {
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker mark = marker;
            this.parseAttributesList();
            this.parseFunctionNoMarker(Context.SOURCE_ELEMENT, mark);
        }
        finally {
            this.builder.putUserData(methodsEmptinessKey, (Object)prevMethodEmptiness);
        }
    }

    public void parseFunctionExpressionAttributeList() {
        this.parseAttributesList();
    }

    public boolean parseFunctionNoMarker(@NotNull Context context, @NotNull PsiBuilder.Marker functionMarker) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        Intrinsics.checkNotNullParameter((Object)functionMarker, (String)"functionMarker");
        boolean functionKeywordWasOmitted = true;
        boolean parsedWithoutErrors = true;
        boolean isGeneratorContext = false;
        if (this.builder.getTokenType() == JSTokenTypes.FUNCTION_KEYWORD && context != Context.PROPERTY) {
            this.builder.advanceLexer();
            functionKeywordWasOmitted = false;
            if (this.builder.getTokenType() == JSTokenTypes.MULT && this.isJSorTS()) {
                this.builder.advanceLexer();
                isGeneratorContext = true;
            }
        }
        boolean wasGenerator = JSParsingContextUtil.isGeneratorContext(this.builder);
        JSParsingContextUtil.setIsGenerator(isGeneratorContext, this.builder);
        if (!this.parseFunctionName(functionKeywordWasOmitted, context)) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.function.name", new Object[0]));
            parsedWithoutErrors = false;
        }
        parsedWithoutErrors &= !this.parseParameterList((boolean)(context == Context.EXPRESSION || context == Context.PROPERTY ? true : false)).hasErrors;
        this.parser.getTypeParser().tryParseFunctionReturnType();
        MethodEmptiness methodEmptiness = (MethodEmptiness)((Object)this.builder.getUserData(methodsEmptinessKey));
        if (methodEmptiness == null) {
            if (functionKeywordWasOmitted && JSTokenTypes.ARROWS.contains(this.builder.getTokenType())) {
                this.builder.advanceLexer();
            }
            parsedWithoutErrors &= this.parser.getStatementParser().parseFunctionBody();
        } else if (methodEmptiness == MethodEmptiness.ALWAYS) {
            if (this.builder.getTokenType() == JSTokenTypes.SEMICOLON) {
                this.builder.advanceLexer();
            } else if (this.builder.getTokenType() == JSTokenTypes.LBRACE) {
                String errorMessage = this.builder.getUserData(StatementParser.withinInterfaceKey) == null ? JavaScriptParserBundle.message("javascript.ambient.declaration.should.have.no.body", new Object[0]) : JavaScriptParserBundle.message("interface.function.declaration.should.have.no.body", new Object[0]);
                parsedWithoutErrors = false;
                this.builder.error(errorMessage);
            }
        } else if (methodEmptiness == MethodEmptiness.POSSIBLY) {
            if (functionKeywordWasOmitted && JSTokenTypes.ARROWS.contains(this.builder.getTokenType())) {
                this.builder.advanceLexer();
                parsedWithoutErrors &= this.parser.getStatementParser().parseFunctionBody();
            } else if (this.builder.getTokenType() == JSTokenTypes.SEMICOLON) {
                this.builder.advanceLexer();
            } else if (this.builder.getTokenType() == JSTokenTypes.LBRACE) {
                parsedWithoutErrors &= this.parser.getStatementParser().parseFunctionBody();
            }
        }
        functionMarker.done(context == Context.SOURCE_ELEMENT ? this.getFunctionDeclarationElementType() : this.getFunctionExpressionElementType());
        functionMarker.setCustomEdgeTokenBinders(JavaScriptParserBase.INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        JSParsingContextUtil.setIsGenerator(wasGenerator, this.builder);
        return parsedWithoutErrors;
    }

    public boolean parseFunctionName(boolean functionKeywordWasOmitted, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        if (this.parser.getDialect().hasFeature(JSLanguageFeature.E4X) && this.parseGetSetAndNameAfterFunctionKeyword(context)) {
            return true;
        }
        IElementType tokenType = this.builder.getTokenType();
        if (!(this.isIdentifierToken(tokenType) || functionKeywordWasOmitted && JSKeywordSets.PROPERTY_NAMES.contains(tokenType))) {
            return context == Context.EXPRESSION;
        }
        this.parseFunctionIdentifier();
        return true;
    }

    protected final boolean parseGetSetAndNameAfterFunctionKeyword(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        IElementType firstToken = this.builder.getTokenType();
        if (JSTokenTypes.GET_SET.contains(firstToken) && context != Context.EXPRESSION) {
            IElementType lookAhead = this.builder.lookAhead(1);
            if (JSKeywordSets.PROPERTY_NAMES.contains(lookAhead)) {
                this.builder.advanceLexer();
            } else if (context == Context.PROPERTY && this.parser.getExpressionParser().isPropertyNameStart(lookAhead)) {
                this.builder.advanceLexer();
                this.parser.getExpressionParser().parsePropertyName();
                return true;
            }
        }
        return false;
    }

    public void parseFunctionIdentifier() {
        IElementType tokenType = this.builder.getTokenType();
        if (JSKeywordSets.PROPERTY_NAMES.contains(tokenType)) {
            this.parser.getExpressionParser().advancePropertyName(tokenType);
        } else {
            this.builder.advanceLexer();
        }
    }

    @NotNull
    public IElementType getFunctionDeclarationElementType() {
        return JSElementTypes.INSTANCE.getFUNCTION_DECLARATION();
    }

    public boolean parseAttributesList() {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker mark = marker;
        IElementType type = this.builder.getTokenType();
        if (type == JSTokenTypes.EXPORT_KEYWORD || type == JSTokenTypes.GET_KEYWORD || type == JSTokenTypes.SET_KEYWORD) {
            this.builder.advanceLexer();
        }
        mark.done(this.getAttributeListElementType());
        return true;
    }

    @NotNull
    public IElementType getAttributeListElementType() {
        return JSElementTypes.ATTRIBUTE_LIST;
    }

    public final void parseES7Decorators() {
        StatementParser.LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.AT);
        while (this.builder.getTokenType() == JSTokenTypes.AT) {
            PsiBuilder.Marker attribute;
            Intrinsics.checkNotNullExpressionValue((Object)this.builder.mark(), (String)"mark(...)");
            this.builder.advanceLexer();
            ExpressionParser<?> expressionParser = this.parser.getExpressionParser();
            EnumSet<Enum> enumSet = EnumSet.of((Enum)ExpressionParser.ParseLeftHandSideExpressionOptions.DISALLOW_INDEXER);
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
            expressionParser.parseLeftHandSideExpression((Set<ExpressionParser.ParseLeftHandSideExpressionOptions>)enumSet);
            attribute.done(JSElementTypes.ES6_DECORATOR);
        }
    }

    public final boolean tryParseES7Decorators() {
        boolean hadAnnotation;
        boolean bl = hadAnnotation = this.builder.getTokenType() == JSTokenTypes.AT;
        if (hadAnnotation && this.hasSupportDecorators()) {
            this.parseES7Decorators();
        }
        return hadAnnotation;
    }

    public boolean hasSupportDecorators() {
        return false;
    }

    @NotNull
    public final JSParseResult parseParameterList(boolean funExpr) {
        if (!this.parser.getTypeParser().tryParseTypeParameterList()) {
            return JSParseResult.UNACCEPTABLE;
        }
        PsiBuilder.Marker parameterList = null;
        if (this.builder.getTokenType() != JSTokenTypes.LPAR) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.lparen", new Object[0]));
            if (!funExpr) {
                PsiBuilder.Marker marker = this.builder.mark();
                Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
                parameterList = marker;
                parameterList.done(this.getParameterListElementType());
            }
            return JSParseResult.UNACCEPTABLE;
        }
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        parameterList = marker;
        this.builder.advanceLexer();
        boolean hasErrors = false;
        boolean first = true;
        while (this.builder.getTokenType() != JSTokenTypes.RPAR) {
            PsiBuilder.Marker parameter;
            if (first) {
                first = false;
            } else if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                this.builder.advanceLexer();
                if (this.builder.getTokenType() == JSTokenTypes.RPAR && this.allowLastCommaInParameterAndArgumentList()) {
                    break;
                }
            } else {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.comma.or.rparen", new Object[0]));
                hasErrors = true;
                break;
            }
            Intrinsics.checkNotNullExpressionValue((Object)this.builder.mark(), (String)"mark(...)");
            this.parseParameterAttributeList();
            if (this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT) {
                this.builder.advanceLexer();
            } else if (this.builder.getTokenType() == JSTokenTypes.DOT || this.builder.getTokenType() == JSTokenTypes.DOT_DOT) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.parameter.name", new Object[0]));
                while (this.builder.getTokenType() == JSTokenTypes.DOT || this.builder.getTokenType() == JSTokenTypes.DOT_DOT) {
                    this.builder.advanceLexer();
                }
                hasErrors = true;
            }
            hasErrors |= !this.parseSingleParameter(parameter);
        }
        if (this.builder.getTokenType() == JSTokenTypes.RPAR) {
            this.builder.advanceLexer();
        }
        parameterList.done(this.getParameterListElementType());
        return JSParseResult.Companion.acceptable(hasErrors, null);
    }

    public boolean parseSingleParameter(@NotNull PsiBuilder.Marker parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        JSParseResult result = this.doParseSingleParameter();
        IElementType elementType = result.elementType;
        if (elementType != null) {
            parameter.done(elementType);
        } else {
            parameter.drop();
        }
        return !result.hasErrors;
    }

    @NotNull
    protected JSParseResult doParseSingleParameter() {
        boolean hasErrors = false;
        boolean acceptResult = false;
        IElementType elementType = this.getParameterType();
        IElementType tokenType = this.builder.getTokenType();
        if (this.isParameterName(false, tokenType)) {
            this.builder.advanceLexer();
            this.parseParameterOptionalMark();
            this.parser.getTypeParser().tryParseType();
            if (this.builder.getTokenType() == JSTokenTypes.EQ) {
                this.builder.advanceLexer();
                if (!this.parser.getExpressionParser().parseAssignmentExpression(true)) {
                    this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
                }
            }
            acceptResult = true;
        } else if (this.willParseDestructuringAssignment()) {
            elementType = this.parser.getExpressionParser().parseDestructuringElementNoMarker(this.getParameterType(), true, true);
            acceptResult = true;
        } else {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.formal.parameter.name", new Object[0]));
            hasErrors = true;
            if (this.builder.getTokenType() == JSTokenTypes.EQ) {
                this.builder.advanceLexer();
                v0 = this.parser.getExpressionParser().parseAssignmentExpression(true);
            } else {
                v0 = this.parser.getTypeParser().tryParseType();
            }
            acceptResult = false;
        }
        return acceptResult ? JSParseResult.Companion.acceptable(hasErrors, elementType) : JSParseResult.UNACCEPTABLE;
    }

    protected boolean isParameterName(boolean allowPropertyNameAsIdentifier, @Nullable IElementType tokenType) {
        return this.isIdentifierToken(tokenType) || allowPropertyNameAsIdentifier && JSKeywordSets.IDENTIFIER_NAMES.contains(tokenType);
    }

    public boolean allowLastCommaInParameterAndArgumentList() {
        return false;
    }

    @NotNull
    public IElementType getParameterType() {
        return JSElementTypes.FORMAL_PARAMETER;
    }

    public void parseParameterOptionalMark() {
    }

    public final boolean willParseDestructuringAssignment() {
        return !this.isECMAL4() && Companion.willParseDestructuringAssignment(this.builder.getTokenType());
    }

    protected void parseParameterAttributeList() {
        if (this.hasSupportDecorators() && this.builder.getTokenType() == JSTokenTypes.AT) {
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker mark = marker;
            this.tryParseES7Decorators();
            mark.done(this.getAttributeListElementType());
        }
    }

    public final boolean parseArrowFunction() {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        return this.parseArrowFunctionWithoutModifiers(marker);
    }

    protected boolean parseArrowFunctionWithoutModifiers(@NotNull PsiBuilder.Marker arrowFunction) {
        Intrinsics.checkNotNullParameter((Object)arrowFunction, (String)"arrowFunction");
        IElementType firstToken = this.builder.getTokenType();
        if (this.isIdentifierToken(firstToken) && JSTokenTypes.ARROWS.contains(this.builder.lookAhead(1))) {
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker parameterList = marker;
            PsiBuilder.Marker marker2 = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker2, (String)"mark(...)");
            PsiBuilder.Marker parameter = marker2;
            this.builder.advanceLexer();
            parameter.done(this.getParameterType());
            parameterList.done(this.getParameterListElementType());
            parameterList.setCustomEdgeTokenBinders(JavaScriptParserBase.INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        } else {
            if (!JSArrowFunctionDetector.INSTANCE.isArrowFunctionExpression(this.builder, this)) {
                arrowFunction.rollbackTo();
                return false;
            }
            this.parseParameterList(true);
            this.parser.getTypeParser().tryParseArrowFunctionReturnType();
        }
        IElementType arrow = this.builder.getTokenType();
        if (JSTokenTypes.ARROWS.contains(arrow)) {
            this.builder.advanceLexer();
            if (this.builder.getTokenType() != JSTokenTypes.LBRACE) {
                this.parseArrowFunctionExpressionBody();
            } else {
                this.parser.getStatementParser().parseBlock();
            }
        } else {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.eqgt", new Object[0]));
        }
        arrowFunction.done(this.getFunctionExpressionElementType());
        arrowFunction.setCustomEdgeTokenBinders(JavaScriptParserBase.INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        return true;
    }

    private final void parseArrowFunctionExpressionBody() {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker expressionBody = marker;
        if (this.parser.getExpressionParser().parseAssignmentExpression(true)) {
            expressionBody.drop();
        } else {
            expressionBody.rollbackTo();
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.lbrace", new Object[0]));
        }
    }

    public boolean isValidFirstParameterStart(@Nullable IElementType next) {
        block8: {
            IElementType lookAhead;
            int lookaheadSteps;
            IElementType next2;
            block7: {
                IElementType iElementType;
                next2 = null;
                next2 = next;
                if (next2 == JSTokenTypes.RPAR || next2 == JSTokenTypes.DOT_DOT_DOT || !this.isECMAL4() && Companion.willParseDestructuringAssignment(next2)) {
                    return true;
                }
                boolean isParameterName = this.isParameterName(true, next2);
                if (!isParameterName) {
                    return false;
                }
                lookaheadSteps = 2;
                if (next2 == JSTokenTypes.CLASS_KEYWORD || next2 == JSTokenTypes.FUNCTION_KEYWORD) break block7;
                if (next2 != JSTokenTypes.ASYNC_KEYWORD) break block8;
                IElementType it = iElementType = this.builder.lookAhead(lookaheadSteps++);
                boolean bl = false;
                next2 = it;
                if (iElementType != JSTokenTypes.FUNCTION_KEYWORD) break block8;
            }
            if (this.isIdentifierToken(lookAhead = this.builder.lookAhead(lookaheadSteps))) {
                return false;
            }
            if (next2 == JSTokenTypes.FUNCTION_KEYWORD) {
                return lookAhead != JSTokenTypes.LPAR && lookAhead != JSTokenTypes.MULT;
            }
            return lookAhead != JSTokenTypes.LBRACE;
        }
        return true;
    }

    public boolean supportsColonTypeCast() {
        return false;
    }

    @NotNull
    public IElementType getParameterListElementType() {
        return JSElementTypes.PARAMETER_LIST;
    }

    @NotNull
    protected IElementType getFunctionExpressionElementType() {
        return JSElementTypes.FUNCTION_EXPRESSION;
    }

    public final boolean parseParameterListAndBody(@NotNull PsiBuilder.Marker marker, @NotNull IElementType elementType) {
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        boolean lexerAdvanced = !this.parser.getFunctionParser().parseParameterList((boolean)false).hasErrors;
        lexerAdvanced |= this.parser.getTypeParser().tryParseFunctionReturnType();
        marker.done(elementType);
        marker.setCustomEdgeTokenBinders(JavaScriptParserBase.INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        return lexerAdvanced |= this.parser.getStatementParser().parseFunctionBody();
    }

    @JvmStatic
    public static final boolean willParseDestructuringAssignment(@Nullable IElementType tokenType) {
        return Companion.willParseDestructuringAssignment(tokenType);
    }

    static {
        Key key = Key.create((String)"methodsEmptinessKey");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        methodsEmptinessKey = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/lang/javascript/parsing/FunctionParser$Companion;", "", "<init>", "()V", "methodsEmptinessKey", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/lang/javascript/parsing/FunctionParser$MethodEmptiness;", "willParseDestructuringAssignment", "", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "intellij.javascript.parser"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean willParseDestructuringAssignment(@Nullable IElementType tokenType) {
            return tokenType == JSTokenTypes.LBRACKET || tokenType == JSTokenTypes.LBRACE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/lang/javascript/parsing/FunctionParser$Context;", "", "<init>", "(Ljava/lang/String;I)V", "EXPRESSION", "SOURCE_ELEMENT", "PROPERTY", "intellij.javascript.parser"})
    public static final class Context
    extends Enum<Context> {
        public static final /* enum */ Context EXPRESSION = new Context();
        public static final /* enum */ Context SOURCE_ELEMENT = new Context();
        public static final /* enum */ Context PROPERTY = new Context();
        private static final /* synthetic */ Context[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Context[] values() {
            return (Context[])$VALUES.clone();
        }

        public static Context valueOf(String value) {
            return Enum.valueOf(Context.class, value);
        }

        @NotNull
        public static EnumEntries<Context> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = contextArray = new Context[]{Context.EXPRESSION, Context.SOURCE_ELEMENT, Context.PROPERTY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/lang/javascript/parsing/FunctionParser$MethodEmptiness;", "", "<init>", "(Ljava/lang/String;I)V", "ALWAYS", "POSSIBLY", "intellij.javascript.parser"})
    public static final class MethodEmptiness
    extends Enum<MethodEmptiness> {
        public static final /* enum */ MethodEmptiness ALWAYS = new MethodEmptiness();
        public static final /* enum */ MethodEmptiness POSSIBLY = new MethodEmptiness();
        private static final /* synthetic */ MethodEmptiness[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static MethodEmptiness[] values() {
            return (MethodEmptiness[])$VALUES.clone();
        }

        public static MethodEmptiness valueOf(String value) {
            return Enum.valueOf(MethodEmptiness.class, value);
        }

        @NotNull
        public static EnumEntries<MethodEmptiness> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = methodEmptinessArray = new MethodEmptiness[]{MethodEmptiness.ALWAYS, MethodEmptiness.POSSIBLY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

