/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.core.events.utils;

import com.intellij.code.provenance.DocumentChangesKind;
import com.intellij.code.provenance.core.ProvenanceEntry;
import com.intellij.code.provenance.core.events.mergeableEvents.DocumentChangesKt;
import com.intellij.code.provenance.core.events.storage.ProvenanceStorage;
import com.intellij.code.provenance.core.events.utils.ContentHasher;
import com.intellij.code.provenance.core.events.utils.UtilsKt;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.history.core.Content;
import com.intellij.history.core.StoredContent;
import com.intellij.history.core.changes.ContentChange;
import com.intellij.history.core.tree.FileEntry;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.TextPatchBuilder;
import com.intellij.openapi.diff.impl.patch.UnifiedDiffWriter;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.CoroutineScopeKt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.UtilKt;
import java.io.Closeable;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u00c0\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u001a\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n\u001a\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u0006*\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0017\u001a\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0019\u001a\u00020\n2\b\b\u0002\u0010\u0016\u001a\u00020\u0017\u001a\f\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u00020\u0015\u001a\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0019\u001a\u00020\n\u001a\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\nH\u0000\u001a\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!*\b\u0012\u0004\u0012\u00020\"0!\u001a\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0!*\b\u0012\u0004\u0012\u00020\"0!\u001a\u0014\u0010$\u001a\u0004\u0018\u00010\u0012*\u00020%2\u0006\u0010&\u001a\u00020'\u001a\u0014\u0010$\u001a\u0004\u0018\u00010\u0012*\u00020(2\u0006\u0010&\u001a\u00020'\u001a\u0016\u0010)\u001a\u0004\u0018\u00010\u0012*\u00020'2\u0006\u0010*\u001a\u00020+H\u0007\u001a\u0012\u0010,\u001a\u00020\u0012*\u00020\u001b2\u0006\u0010&\u001a\u00020'\u001a\u0014\u0010-\u001a\u0004\u0018\u00010\u0012*\u00020.2\u0006\u0010/\u001a\u00020'\u001aO\u00100\u001a\u0002H1\"\u0004\b\u0000\u001012\u0006\u0010*\u001a\u00020+2\u000b\u00102\u001a\u00070\u0006\u00a2\u0006\u0002\b32'\u00104\u001a#\b\u0001\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u0002H106\u0012\u0006\u0012\u0004\u0018\u00010705\u00a2\u0006\u0002\b8\u00a2\u0006\u0002\u00109\u001a\u001c\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\"2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020>0!\u001a+\u0010B\u001a\u0004\u0018\u00010>*\b\u0012\u0004\u0012\u00020>0!2\b\u0010C\u001a\u0004\u0018\u00010\u00102\b\u0010D\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010E\u001a&\u0010F\u001a\b\u0012\u0004\u0012\u00020\"0!*\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010G\u001a\u00020HH\u0086@\u00a2\u0006\u0002\u0010I\u001a\u0014\u0010J\u001a\u00020\"*\u00020\"2\u0006\u0010K\u001a\u00020;H\u0002\u001a\u001c\u0010L\u001a\b\u0012\u0004\u0012\u00020M0!2\u0006\u0010N\u001a\u00020\u00122\u0006\u0010O\u001a\u00020\u0012\"2\u0010\u000b\u001a&\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r \u000e*\u0012\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001c\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010?\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010A\u00a8\u0006P"}, d2={"newEditorDisposable", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/openapi/editor/Editor;", "parentScope", "Lkotlinx/coroutines/CoroutineScope;", "calculateDiff", "", "before", "after", "contextLineCount", "", "hasher", "Ljava/lang/ThreadLocal;", "Lcom/intellij/code/provenance/core/events/utils/ContentHasher;", "kotlin.jvm.PlatformType", "contentHash", "", "content", "", "UNAVAILABLE_CONTENT_ID", "getContent", "Lcom/intellij/code/provenance/core/ProvenanceEntry$ContentChangeByLocalHistory;", "encoding", "Ljava/nio/charset/Charset;", "getContentChangeContent", "contentId", "getBinaryContent", "", "MAX_TOTAL_CONTENT_LENGTH", "isTooBigContent", "", "contentLength", "filterValidChanges", "", "Lcom/intellij/code/provenance/core/ProvenanceEntry$DocumentChangeBase;", "filterValidHashChains", "decodeOldContent", "Lcom/intellij/history/core/changes/ContentChange;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/history/core/tree/FileEntry;", "decodeCurrentContent", "project", "Lcom/intellij/openapi/project/Project;", "decodeBinaryContent", "retrieveContent", "Lcom/intellij/openapi/vcs/changes/ContentRevision;", "file", "runInSuspendContext", "T", "title", "Lcom/intellij/openapi/util/NlsSafe;", "action", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "", "Lkotlin/ExtensionFunctionType;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "identifyMostConciseKind", "Lcom/intellij/code/provenance/DocumentChangesKind;", "entry", "metadata", "Lcom/intellij/code/provenance/core/ProvenanceEntry$MetadataEntryOfDocumentChange;", "emptyHash", "getEmptyHash", "()J", "matchEntryByHash", "oldHash", "newHash", "(Ljava/util/List;Ljava/lang/Long;Ljava/lang/Long;)Lcom/intellij/code/provenance/core/ProvenanceEntry$MetadataEntryOfDocumentChange;", "identifyMostConciseKinds", "storage", "Lcom/intellij/code/provenance/core/events/storage/ProvenanceStorage;", "(Ljava/util/List;Lcom/intellij/code/provenance/core/events/storage/ProvenanceStorage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "withKind", "newKind", "computeDocumentChanges", "Lcom/intellij/code/provenance/core/ProvenanceEntry$SingleDocumentChange;", "oldContent", "newContent", "intellij.code.provenance.core"})
@SourceDebugExtension(value={"SMAP\nutils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 utils.kt\ncom/intellij/code/provenance/core/events/utils/UtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,410:1\n1#2:411\n1#2:453\n1869#3,2:412\n1056#3:421\n774#3:429\n865#3,2:430\n1563#3:432\n1634#3,2:433\n1636#3:442\n1617#3,9:443\n1869#3:452\n1870#3:454\n1626#3:455\n1803#3,3:456\n382#4,7:414\n382#4,7:422\n382#4,7:435\n*S KotlinDebug\n*F\n+ 1 utils.kt\ncom/intellij/code/provenance/core/events/utils/UtilsKt\n*L\n384#1:453\n62#1:412,2\n175#1:421\n312#1:429\n312#1:430,2\n337#1:432\n337#1:433,2\n337#1:442\n384#1:443,9\n384#1:452\n384#1:454\n384#1:455\n407#1:456,3\n167#1:414,7\n182#1:422,7\n339#1:435,7\n*E\n"})
public final class UtilsKt {
    private static final ThreadLocal<ContentHasher> hasher = ThreadLocal.withInitial(UtilsKt::hasher$lambda$0);
    private static final int UNAVAILABLE_CONTENT_ID = 0;
    private static final int MAX_TOTAL_CONTENT_LENGTH = 1000000;
    private static final long emptyHash = UtilsKt.contentHash("");

    @NotNull
    public static final Disposable newEditorDisposable(@NotNull Editor $this$newEditorDisposable, @Nullable CoroutineScope parentScope) {
        CoroutineScope coroutineScope;
        Intrinsics.checkNotNullParameter((Object)$this$newEditorDisposable, (String)"<this>");
        CoroutineScope coroutineScope2 = parentScope;
        if (coroutineScope2 == null || (coroutineScope2 = CoroutineScopeKt.asDisposable((CoroutineScope)coroutineScope2)) == null) {
            Disposable disposable = Disposer.newDisposable((String)("Editor disposable for " + $this$newEditorDisposable));
            coroutineScope2 = disposable;
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        }
        CoroutineScope it = coroutineScope = coroutineScope2;
        boolean bl = false;
        EditorUtil.disposeWithEditor((Editor)$this$newEditorDisposable, (Disposable)it);
        return coroutineScope;
    }

    public static /* synthetic */ Disposable newEditorDisposable$default(Editor editor, CoroutineScope coroutineScope, int n, Object object) {
        if ((n & 1) != 0) {
            coroutineScope = null;
        }
        return UtilsKt.newEditorDisposable(editor, coroutineScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String calculateDiff(@NotNull String before, @NotNull String after2, int contextLineCount) {
        String string;
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        Intrinsics.checkNotNullParameter((Object)after2, (String)"after");
        List list = TextPatchBuilder.buildPatchHunks((String)before, (String)after2, (int)contextLineCount);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"buildPatchHunks(...)");
        List hunks = list;
        Closeable closeable = new StringWriter();
        Throwable throwable = null;
        try {
            StringWriter writer = (StringWriter)closeable;
            boolean bl = false;
            TextFilePatch patch = new TextFilePatch(StandardCharsets.UTF_8);
            Iterable $this$forEach$iv = hunks;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PatchHunk it;
                PatchHunk hunk = (PatchHunk)element$iv;
                boolean bl2 = false;
                if (hunk == null) continue;
                boolean bl3 = false;
                patch.addHunk(it);
            }
            UnifiedDiffWriter.writeBeforePath((Writer)writer, (FilePatch)((FilePatch)patch), (String)"\n", (boolean)false);
            UnifiedDiffWriter.writeAfterPath((Writer)writer, (FilePatch)((FilePatch)patch), (String)"\n", (boolean)false);
            UnifiedDiffWriter.writeHunk((Writer)writer, (TextFilePatch)patch, (String)"\n", (String)"\n");
            String string2 = writer.toString();
            string = string2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"use(...)");
        return string;
    }

    public static final long contentHash(@NotNull CharSequence content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return hasher.get().hash(content);
    }

    @Nullable
    public static final String getContent(@NotNull ProvenanceEntry.ContentChangeByLocalHistory $this$getContent, @NotNull Charset encoding) {
        Intrinsics.checkNotNullParameter((Object)$this$getContent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
        return UtilsKt.getContentChangeContent($this$getContent.getContentId(), encoding);
    }

    public static /* synthetic */ String getContent$default(ProvenanceEntry.ContentChangeByLocalHistory contentChangeByLocalHistory, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return UtilsKt.getContent(contentChangeByLocalHistory, charset);
    }

    @Nullable
    public static final String getContentChangeContent(int contentId, @NotNull Charset encoding) {
        Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
        byte[] byArray = UtilsKt.getBinaryContent(contentId);
        return byArray != null ? new String(byArray, encoding) : null;
    }

    public static /* synthetic */ String getContentChangeContent$default(int n, Charset charset, int n2, Object object) {
        if ((n2 & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        return UtilsKt.getContentChangeContent(n, charset);
    }

    @Nullable
    public static final byte[] getBinaryContent(@NotNull ProvenanceEntry.ContentChangeByLocalHistory $this$getBinaryContent) {
        Intrinsics.checkNotNullParameter((Object)$this$getBinaryContent, (String)"<this>");
        return UtilsKt.getBinaryContent($this$getBinaryContent.getContentId());
    }

    @Nullable
    public static final byte[] getBinaryContent(int contentId) {
        byte[] byArray;
        try {
            byArray = contentId == 0 ? ArrayUtilRt.EMPTY_BYTE_ARRAY : PersistentFS.getInstance().contentsToByteArray(contentId);
        }
        catch (Exception exception) {
            byArray = null;
        }
        return byArray;
    }

    public static final boolean isTooBigContent(@NotNull CharSequence content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return UtilsKt.isTooBigContent(content.length());
    }

    public static final boolean isTooBigContent(int contentLength) {
        return contentLength >= 1000000;
    }

    @NotNull
    public static final List<ProvenanceEntry.DocumentChangeBase> filterValidChanges(@NotNull List<? extends ProvenanceEntry.DocumentChangeBase> $this$filterValidChanges) {
        Intrinsics.checkNotNullParameter($this$filterValidChanges, (String)"<this>");
        return UtilsKt.filterValidHashChains($this$filterValidChanges);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ProvenanceEntry.DocumentChangeBase> filterValidHashChains(@NotNull List<? extends ProvenanceEntry.DocumentChangeBase> $this$filterValidHashChains) {
        Object list;
        Map map;
        Intrinsics.checkNotNullParameter($this$filterValidHashChains, (String)"<this>");
        Map $this$filterValidHashChains_u24lambda_u240 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        for (ProvenanceEntry.DocumentChangeBase documentChangeBase : $this$filterValidHashChains) {
            Object object;
            void $this$getOrPut$iv;
            String path = documentChangeBase.getDocumentPath();
            Map map2 = $this$filterValidHashChains_u24lambda_u240;
            String key$iv = path;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            list = (List)object;
            list.add(documentChangeBase);
        }
        Map entriesByPath = MapsKt.build((Map)map);
        Set validEntries = new LinkedHashSet();
        block1: for (List fileEntries : entriesByPath.values()) {
            Object key$iv;
            Iterable iterable = fileEntries;
            boolean $i$f$sortedBy = false;
            List sorted = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ProvenanceEntry.DocumentChangeBase it = (ProvenanceEntry.DocumentChangeBase)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.getTimestamp());
                    it = (ProvenanceEntry.DocumentChangeBase)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTimestamp()));
                }
            });
            if (sorted.isEmpty()) continue;
            Map map3 = new LinkedHashMap();
            for (ProvenanceEntry.DocumentChangeBase change : sorted) {
                Object object;
                void $this$getOrPut$iv;
                Long l = change.getOldContentHash();
                if (l == null) {
                    continue;
                }
                long oldHash = l;
                Long l2 = change.getNewContentHash();
                if (l2 == null) {
                    continue;
                }
                long newHash = l2;
                list = map3;
                key$iv = oldHash;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl3 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(TuplesKt.to((Object)change, (Object)newHash));
            }
            List candidates = CollectionsKt.toList((Iterable)sorted);
            while (!((Collection)candidates).isEmpty()) {
                ProvenanceEntry.DocumentChangeBase earliest = (ProvenanceEntry.DocumentChangeBase)CollectionsKt.first((List)candidates);
                ProvenanceEntry.DocumentChangeBase latest = (ProvenanceEntry.DocumentChangeBase)CollectionsKt.last((List)candidates);
                Long startHash = earliest.getOldContentHash();
                Long endHash = latest.getNewContentHash();
                if (startHash == null || endHash == null) {
                    candidates = CollectionsKt.dropLast((List)candidates, (int)1);
                    continue;
                }
                List validPaths = new ArrayList();
                key$iv = new Comparator(){

                    public final int compare(T a, T b) {
                        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00003\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J<\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\tH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"com/intellij/code/provenance/core/events/utils/UtilsKt$filterValidHashChains$PathState", "", "currentHash", "", "usedChanges", "", "Lcom/intellij/code/provenance/core/ProvenanceEntry$DocumentChangeBase;", "lastTimestamp", "externalCount", "", "<init>", "(JLjava/util/Set;JI)V", "getCurrentHash", "()J", "getUsedChanges", "()Ljava/util/Set;", "getLastTimestamp", "getExternalCount", "()I", "component1", "component2", "component3", "component4", "copy", "(JLjava/util/Set;JI)Lcom/intellij/code/provenance/core/events/utils/UtilsKt$filterValidHashChains$PathState;", "equals", "", "other", "hashCode", "toString", "", "intellij.code.provenance.core"})
                        public final class PathState {
                            private final long currentHash;
                            private final Set<ProvenanceEntry.DocumentChangeBase> usedChanges;
                            private final long lastTimestamp;
                            private final int externalCount;

                            public PathState(long currentHash, Set<? extends ProvenanceEntry.DocumentChangeBase> usedChanges, long lastTimestamp, int externalCount) {
                                Intrinsics.checkNotNullParameter(usedChanges, (String)"usedChanges");
                                this.currentHash = currentHash;
                                this.usedChanges = usedChanges;
                                this.lastTimestamp = lastTimestamp;
                                this.externalCount = externalCount;
                            }

                            public final long getCurrentHash() {
                                return this.currentHash;
                            }

                            public final Set<ProvenanceEntry.DocumentChangeBase> getUsedChanges() {
                                return this.usedChanges;
                            }

                            public final long getLastTimestamp() {
                                return this.lastTimestamp;
                            }

                            public final int getExternalCount() {
                                return this.externalCount;
                            }

                            public final long component1() {
                                return this.currentHash;
                            }

                            public final Set<ProvenanceEntry.DocumentChangeBase> component2() {
                                return this.usedChanges;
                            }

                            public final long component3() {
                                return this.lastTimestamp;
                            }

                            public final int component4() {
                                return this.externalCount;
                            }

                            public final PathState copy(long currentHash, Set<? extends ProvenanceEntry.DocumentChangeBase> usedChanges, long lastTimestamp, int externalCount) {
                                Intrinsics.checkNotNullParameter(usedChanges, (String)"usedChanges");
                                return new PathState(currentHash, usedChanges, lastTimestamp, externalCount);
                            }

                            public static /* synthetic */ PathState copy$default(PathState pathState, long l, Set set, long l2, int n, int n2, Object object) {
                                if ((n2 & 1) != 0) {
                                    l = pathState.currentHash;
                                }
                                if ((n2 & 2) != 0) {
                                    set = pathState.usedChanges;
                                }
                                if ((n2 & 4) != 0) {
                                    l2 = pathState.lastTimestamp;
                                }
                                if ((n2 & 8) != 0) {
                                    n = pathState.externalCount;
                                }
                                return pathState.copy(l, set, l2, n);
                            }

                            public String toString() {
                                return "PathState(currentHash=" + this.currentHash + ", usedChanges=" + this.usedChanges + ", lastTimestamp=" + this.lastTimestamp + ", externalCount=" + this.externalCount + ")";
                            }

                            public int hashCode() {
                                int result = Long.hashCode(this.currentHash);
                                result = result * 31 + ((Object)this.usedChanges).hashCode();
                                result = result * 31 + Long.hashCode(this.lastTimestamp);
                                result = result * 31 + Integer.hashCode(this.externalCount);
                                return result;
                            }

                            public boolean equals(Object other) {
                                if (this == other) {
                                    return true;
                                }
                                if (!(other instanceof PathState)) {
                                    return false;
                                }
                                PathState pathState = (PathState)other;
                                if (this.currentHash != pathState.currentHash) {
                                    return false;
                                }
                                if (!Intrinsics.areEqual(this.usedChanges, pathState.usedChanges)) {
                                    return false;
                                }
                                if (this.lastTimestamp != pathState.lastTimestamp) {
                                    return false;
                                }
                                return this.externalCount == pathState.externalCount;
                            }
                        }
                        PathState it = (PathState)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getExternalCount());
                        it = (PathState)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getExternalCount()));
                    }
                };
                TreeSet<PathState> queue = new TreeSet<PathState>(new Comparator((Comparator)key$iv){
                    final /* synthetic */ Comparator $this_thenBy;
                    {
                        this.$this_thenBy = $receiver;
                    }

                    public final int compare(T a, T b) {
                        int n;
                        int previousCompare = this.$this_thenBy.compare(a, b);
                        if (previousCompare != 0) {
                            n = previousCompare;
                        } else {
                            PathState it = (PathState)a;
                            boolean bl = false;
                            Comparable comparable = Long.valueOf(it.getCurrentHash());
                            it = (PathState)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getCurrentHash()));
                        }
                        return n;
                    }
                });
                queue.add(new PathState(startHash, SetsKt.emptySet(), Long.MIN_VALUE, 0));
                while (!((Collection)queue).isEmpty()) {
                    List neighbors;
                    PathState state = (PathState)queue.removeFirst();
                    Long l = endHash;
                    if (l != null && state.getCurrentHash() == l.longValue() && !((Collection)state.getUsedChanges()).isEmpty()) {
                        validPaths.add(state.getUsedChanges());
                        break;
                    }
                    if ((List)map3.get(state.getCurrentHash()) == null) continue;
                    for (Pair pair : neighbors) {
                        ProvenanceEntry.DocumentChangeBase change = (ProvenanceEntry.DocumentChangeBase)pair.component1();
                        long nextHash = ((Number)pair.component2()).longValue();
                        if (change.getTimestamp() < state.getLastTimestamp() || state.getUsedChanges().contains(change)) continue;
                        queue.add(new PathState(nextHash, SetsKt.plus(state.getUsedChanges(), (Object)change), change.getTimestamp(), state.getExternalCount() + (change.getKind() == DocumentChangesKind.EXTERNAL ? 1 : 0)));
                    }
                }
                if (!((Collection)validPaths).isEmpty()) {
                    Comparator comparator = new Comparator(){

                        public final int compare(T a, T b) {
                            int n;
                            boolean bl;
                            ProvenanceEntry.DocumentChangeBase it;
                            int count$iv;
                            int n2;
                            Set path = (Set)a;
                            boolean bl2 = false;
                            Iterable $this$count$iv = path;
                            boolean $i$f$count = false;
                            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                n2 = 0;
                            } else {
                                count$iv = 0;
                                for (T element$iv : $this$count$iv) {
                                    it = (ProvenanceEntry.DocumentChangeBase)element$iv;
                                    bl = false;
                                    if (!(it.getKind() == DocumentChangesKind.EXTERNAL) || ++count$iv >= 0) continue;
                                    CollectionsKt.throwCountOverflow();
                                }
                                n2 = count$iv;
                            }
                            path = (Set)b;
                            Comparable comparable = Integer.valueOf(n2);
                            bl2 = false;
                            $this$count$iv = path;
                            $i$f$count = false;
                            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                n = 0;
                            } else {
                                count$iv = 0;
                                for (T element$iv : $this$count$iv) {
                                    it = (ProvenanceEntry.DocumentChangeBase)element$iv;
                                    bl = false;
                                    if (!(it.getKind() == DocumentChangesKind.EXTERNAL) || ++count$iv >= 0) continue;
                                    CollectionsKt.throwCountOverflow();
                                }
                                n = count$iv;
                            }
                            return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(n));
                        }
                    };
                    Set bestPath = (Set)CollectionsKt.minWithOrThrow((Iterable)validPaths, (Comparator)new Comparator(comparator){
                        final /* synthetic */ Comparator $this_thenByDescending;
                        {
                            this.$this_thenByDescending = $receiver;
                        }

                        public final int compare(T a, T b) {
                            int n;
                            int previousCompare = this.$this_thenByDescending.compare(a, b);
                            if (previousCompare != 0) {
                                n = previousCompare;
                            } else {
                                Set it = (Set)b;
                                boolean bl = false;
                                Comparable comparable = Integer.valueOf(it.size());
                                it = (Set)a;
                                Comparable comparable2 = comparable;
                                bl = false;
                                n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.size()));
                            }
                            return n;
                        }
                    });
                    validEntries.addAll(bestPath);
                    continue block1;
                }
                candidates = CollectionsKt.dropLast((List)candidates, (int)1);
            }
        }
        return CollectionsKt.toList((Iterable)validEntries);
    }

    @Nullable
    public static final CharSequence decodeOldContent(@NotNull ContentChange $this$decodeOldContent, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeOldContent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Content content = $this$decodeOldContent.getOldContent();
        if (content instanceof StoredContent && ((StoredContent)content).getContentId() == 0) {
            return null;
        }
        byte[] byArray = $this$decodeOldContent.getOldContent().getBytesIfAvailable();
        return byArray != null ? UtilsKt.decodeBinaryContent(byArray, virtualFile) : null;
    }

    @Nullable
    public static final CharSequence decodeOldContent(@NotNull FileEntry $this$decodeOldContent, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeOldContent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        byte[] byArray = $this$decodeOldContent.getContent().getBytesIfAvailable();
        return byArray != null ? UtilsKt.decodeBinaryContent(byArray, virtualFile) : null;
    }

    @RequiresReadLock
    @Nullable
    public static final CharSequence decodeCurrentContent(@NotNull VirtualFile $this$decodeCurrentContent, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeCurrentContent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Document document = FileDocumentManager.getInstance().getDocument($this$decodeCurrentContent, project);
        return document != null ? document.getImmutableCharSequence() : null;
    }

    @NotNull
    public static final CharSequence decodeBinaryContent(@NotNull byte[] $this$decodeBinaryContent, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeBinaryContent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        CharSequence charSequence = LoadTextUtil.getTextByBinaryPresentation((byte[])$this$decodeBinaryContent, (VirtualFile)virtualFile, (boolean)false, (boolean)false, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getTextByBinaryPresentation(...)");
        return charSequence;
    }

    @Nullable
    public static final CharSequence retrieveContent(@NotNull ContentRevision $this$retrieveContent, @NotNull VirtualFile file) {
        Object binaryData;
        Object object;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)$this$retrieveContent, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                object = $this$retrieveContent instanceof ByteBackedContentRevision ? (ByteBackedContentRevision)$this$retrieveContent : null;
                if (object == null) break block5;
                byte[] byArray = object.getContentAsBytes();
                object = byArray;
                if (byArray != null) break block6;
            }
            String string = $this$retrieveContent.getContent();
            if (string != null) {
                String string2 = string;
                Charset charset = file.getCharset();
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"getCharset(...)");
                byte[] byArray = string2.getBytes(charset);
                object = byArray;
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            } else {
                object = null;
            }
        }
        Object object2 = binaryData = object;
        return object2 != null ? UtilsKt.decodeBinaryContent((byte[])object2, file) : null;
    }

    public static final <T> T runInSuspendContext(@NotNull Project project, @NotNull String title, @NotNull Function2<? super CoroutineScope, ? super Continuation<? super T>, ? extends Object> action) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        if (ApplicationKt.getApplication().isDispatchThread()) {
            return (T)TasksKt.runWithModalProgressBlocking((Project)project, (String)title, action);
        }
        return (T)CoroutinesKt.runBlockingCancellable(action);
    }

    @NotNull
    public static final DocumentChangesKind identifyMostConciseKind(@NotNull ProvenanceEntry.DocumentChangeBase entry, @NotNull List<ProvenanceEntry.MetadataEntryOfDocumentChange> metadata) {
        Long newHash;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter(metadata, (String)"metadata");
        if (!entry.getKind().getCanBeClarified()) {
            return entry.getKind();
        }
        Pair pair = WhenMappings.$EnumSwitchMapping$0[entry.getKind().ordinal()] == 1 ? TuplesKt.to((Object)entry.getNewContentHash(), (Object)entry.getOldContentHash()) : TuplesKt.to((Object)entry.getOldContentHash(), (Object)entry.getNewContentHash());
        Long oldHash = (Long)pair.component1();
        ProvenanceEntry.MetadataEntryOfDocumentChange metadataEntryOfDocumentChange = UtilsKt.matchEntryByHash(metadata, oldHash, newHash = (Long)pair.component2());
        if (metadataEntryOfDocumentChange == null || (metadataEntryOfDocumentChange = metadataEntryOfDocumentChange.getKind()) == null) {
            metadataEntryOfDocumentChange = entry.getKind();
        }
        return metadataEntryOfDocumentChange;
    }

    public static final long getEmptyHash() {
        return emptyHash;
    }

    @Nullable
    public static final ProvenanceEntry.MetadataEntryOfDocumentChange matchEntryByHash(@NotNull List<ProvenanceEntry.MetadataEntryOfDocumentChange> $this$matchEntryByHash, @Nullable Long oldHash, @Nullable Long newHash) {
        Object it;
        ProvenanceEntry.MetadataEntryOfDocumentChange it2;
        List $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$matchEntryByHash, (String)"<this>");
        Iterable $this$filter$iv = $this$matchEntryByHash;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ProvenanceEntry.MetadataEntryOfDocumentChange it3 = (ProvenanceEntry.MetadataEntryOfDocumentChange)element$iv$iv;
            boolean bl = false;
            if (!it3.getKind().getAffectsAuthorship()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List entries = (List)destination$iv$iv;
        if (entries.isEmpty()) {
            return null;
        }
        if (newHash != null) {
            long l = emptyHash;
            if (newHash != l) {
                Object v1;
                block10: {
                    $this$filterTo$iv$iv = entries;
                    destination$iv$iv = $this$filterTo$iv$iv.listIterator($this$filterTo$iv$iv.size());
                    while (destination$iv$iv.hasPrevious()) {
                        Object e = destination$iv$iv.previous();
                        it2 = (ProvenanceEntry.MetadataEntryOfDocumentChange)e;
                        boolean bl = false;
                        Long l2 = it2.getNewContentHash();
                        long l3 = newHash;
                        if (!(l2 != null && l2 == l3)) continue;
                        v1 = e;
                        break block10;
                    }
                    v1 = null;
                }
                ProvenanceEntry.MetadataEntryOfDocumentChange metadataEntryOfDocumentChange = v1;
                if (metadataEntryOfDocumentChange != null) {
                    it = metadataEntryOfDocumentChange;
                    boolean bl = false;
                    return it;
                }
            }
        }
        if (oldHash != null) {
            long l = emptyHash;
            if (oldHash != l) {
                Object v3;
                block11: {
                    it = entries;
                    ListIterator bl = it.listIterator(it.size());
                    while (bl.hasPrevious()) {
                        Object e = bl.previous();
                        it2 = (ProvenanceEntry.MetadataEntryOfDocumentChange)e;
                        boolean bl2 = false;
                        Long l4 = it2.getOldContentHash();
                        long l5 = oldHash;
                        if (!(l4 != null && l4 == l5)) continue;
                        v3 = e;
                        break block11;
                    }
                    v3 = null;
                }
                ProvenanceEntry.MetadataEntryOfDocumentChange metadataEntryOfDocumentChange = v3;
                if (metadataEntryOfDocumentChange != null) {
                    it = metadataEntryOfDocumentChange;
                    boolean bl = false;
                    return it;
                }
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public static final Object identifyMostConciseKinds(@NotNull List<? extends ProvenanceEntry.DocumentChangeBase> $this$identifyMostConciseKinds, @NotNull ProvenanceStorage storage, @NotNull Continuation<? super List<? extends ProvenanceEntry.DocumentChangeBase>> $completion) {
        block8: {
            block9: {
                if (!($completion instanceof identifyMostConciseKinds.1)) ** GOTO lbl-1000
                var23_3 = $completion;
                if ((var23_3.label & -2147483648) != 0) {
                    var23_3.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl($completion){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        Object L$3;
                        Object L$4;
                        Object L$5;
                        Object L$6;
                        Object L$7;
                        Object L$8;
                        Object L$9;
                        Object L$10;
                        Object L$11;
                        Object L$12;
                        Object L$13;
                        int I$0;
                        int I$1;
                        int I$2;
                        int I$3;
                        int I$4;
                        /* synthetic */ Object result;
                        int label;

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return UtilsKt.identifyMostConciseKinds(null, null, (Continuation<? super List<? extends ProvenanceEntry.DocumentChangeBase>>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var24_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                block0 : switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        metadataCache = new LinkedHashMap<K, V>();
                        $this$map$iv = $this$identifyMostConciseKinds;
                        $i$f$map = 0;
                        var6_9 = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = 0;
                        var9_12 = $this$mapTo$iv$iv.iterator();
lbl19:
                        // 2 sources

                        while (var9_12.hasNext()) {
                            item$iv$iv /* !! */  = var9_12.next();
                            var11_14 = (ProvenanceEntry.DocumentChangeBase)item$iv$iv /* !! */ ;
                            var21_24 = destination$iv$iv;
                            $i$a$-map-UtilsKt$identifyMostConciseKinds$2 = 0;
                            documentPath = entry.getDocumentPath();
                            var14_17 = metadataCache;
                            key$iv = documentPath;
                            $i$f$getOrPut = 0;
                            value$iv = $this$getOrPut$iv.get(key$iv);
                            if (value$iv != null) break block0;
                            $i$a$-getOrPut-UtilsKt$identifyMostConciseKinds$2$metadata$1 = 0;
                            $continuation.L$0 = SpillingKt.nullOutSpilledVariable($this$identifyMostConciseKinds);
                            $continuation.L$1 = storage;
                            $continuation.L$2 = metadataCache;
                            $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)$this$map$iv);
                            $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)$this$mapTo$iv$iv);
                            $continuation.L$5 = destination$iv$iv;
                            $continuation.L$6 = var9_12;
                            $continuation.L$7 = SpillingKt.nullOutSpilledVariable(item$iv$iv /* !! */ );
                            $continuation.L$8 = entry;
                            $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)documentPath);
                            $continuation.L$10 = $this$getOrPut$iv;
                            $continuation.L$11 = key$iv;
                            $continuation.L$12 = SpillingKt.nullOutSpilledVariable((Object)value$iv);
                            $continuation.L$13 = var21_24;
                            $continuation.I$0 = $i$f$map;
                            $continuation.I$1 = $i$f$mapTo;
                            $continuation.I$2 = $i$a$-map-UtilsKt$identifyMostConciseKinds$2;
                            $continuation.I$3 = $i$f$getOrPut;
                            $continuation.I$4 = $i$a$-getOrPut-UtilsKt$identifyMostConciseKinds$2$metadata$1;
                            $continuation.label = 1;
                            v0 = FlowKt.toList$default(storage.getMetadataEntriesByFilePath(documentPath), null, (Continuation)$continuation, (int)1, null);
                            if (v0 == var24_5) {
                                return var24_5;
                            }
                            ** GOTO lbl78
                        }
                        break block8;
                    }
                    case 1: {
                        $i$a$-getOrPut-UtilsKt$identifyMostConciseKinds$2$metadata$1 = $continuation.I$4;
                        $i$f$getOrPut = $continuation.I$3;
                        $i$a$-map-UtilsKt$identifyMostConciseKinds$2 = $continuation.I$2;
                        $i$f$mapTo = $continuation.I$1;
                        $i$f$map = $continuation.I$0;
                        var21_24 = (Collection)$continuation.L$13;
                        value$iv = $continuation.L$12;
                        key$iv = (String)$continuation.L$11;
                        $this$getOrPut$iv = (Map)$continuation.L$10;
                        documentPath = (String)$continuation.L$9;
                        entry = (ProvenanceEntry.DocumentChangeBase)$continuation.L$8;
                        item$iv$iv /* !! */  = $continuation.L$7;
                        var9_12 = (Iterator)$continuation.L$6;
                        destination$iv$iv = (Collection)$continuation.L$5;
                        $this$mapTo$iv$iv = (Iterable)$continuation.L$4;
                        $this$map$iv = (Iterable)$continuation.L$3;
                        metadataCache = (Map)$continuation.L$2;
                        storage = (ProvenanceStorage)$continuation.L$1;
                        $this$identifyMostConciseKinds = (List)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl78:
                        // 2 sources

                        answer$iv = (List)v0;
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        v1 = answer$iv;
                        break block9;
                    }
                }
                v1 = value$iv;
            }
            metadata = (List)v1;
            conciseKind = UtilsKt.identifyMostConciseKind(entry, metadata);
            var21_24.add(UtilsKt.withKind(entry, conciseKind));
            ** GOTO lbl19
        }
        return (List)destination$iv$iv;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final ProvenanceEntry.DocumentChangeBase withKind(ProvenanceEntry.DocumentChangeBase $this$withKind, DocumentChangesKind newKind) {
        ProvenanceEntry.DocumentChangeBase documentChangeBase;
        ProvenanceEntry.DocumentChangeBase $this$withKind_u24lambda_u240 = $this$withKind;
        boolean bl = false;
        ProvenanceEntry.DocumentChangeBase documentChangeBase2 = $this$withKind_u24lambda_u240;
        if (documentChangeBase2 instanceof ProvenanceEntry.DocumentChange) {
            documentChangeBase = new ProvenanceEntry.DocumentChange($this$withKind_u24lambda_u240.getDocumentPath(), ((ProvenanceEntry.DocumentChange)$this$withKind_u24lambda_u240).getDiff(), ((ProvenanceEntry.DocumentChange)$this$withKind_u24lambda_u240).getDurationMs(), $this$withKind_u24lambda_u240.getTimestamp(), newKind, $this$withKind_u24lambda_u240.getOldContentHash(), $this$withKind_u24lambda_u240.getNewContentHash());
        } else if (documentChangeBase2 instanceof ProvenanceEntry.ExternalDocumentChange) {
            documentChangeBase = new ProvenanceEntry.ExternalDocumentChange($this$withKind_u24lambda_u240.getDocumentPath(), ((ProvenanceEntry.ExternalDocumentChange)$this$withKind_u24lambda_u240).getOldContentId(), $this$withKind_u24lambda_u240.getTimestamp(), $this$withKind_u24lambda_u240.getOldContentHash(), $this$withKind_u24lambda_u240.getNewContentHash(), newKind);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return documentChangeBase;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ProvenanceEntry.SingleDocumentChange> computeDocumentChanges(@NotNull CharSequence oldContent, @NotNull CharSequence newContent) {
        void $this$fold$iv;
        void $this$mapNotNullTo$iv$iv;
        Pair pair;
        Pair pair2;
        Intrinsics.checkNotNullParameter((Object)oldContent, (String)"oldContent");
        Intrinsics.checkNotNullParameter((Object)newContent, (String)"newContent");
        if (!StringsKt.endsWith$default((CharSequence)oldContent, (char)'\n', (boolean)false, (int)2, null)) {
            ProvenanceEntry.SingleDocumentChange change = new ProvenanceEntry.SingleDocumentChange(oldContent.length(), 0, "\n");
            pair2 = TuplesKt.to((Object)change, (Object)(oldContent + "\n"));
        } else {
            pair2 = TuplesKt.to(null, (Object)oldContent);
        }
        Pair pair3 = pair2;
        ProvenanceEntry.SingleDocumentChange addEndLine = (ProvenanceEntry.SingleDocumentChange)pair3.component1();
        CharSequence oldContentToCompare = (CharSequence)pair3.component2();
        if (!StringsKt.endsWith$default((CharSequence)newContent, (char)'\n', (boolean)false, (int)2, null)) {
            ProvenanceEntry.SingleDocumentChange change = new ProvenanceEntry.SingleDocumentChange(newContent.length(), 1, "");
            pair = TuplesKt.to((Object)change, (Object)(newContent + "\n"));
        } else {
            pair = TuplesKt.to(null, (Object)newContent);
        }
        Pair pair4 = pair;
        ProvenanceEntry.SingleDocumentChange removeEndLine = (ProvenanceEntry.SingleDocumentChange)pair4.component1();
        CharSequence newContentToCompare = (CharSequence)pair4.component2();
        List list = ComparisonManager.getInstance().compareLines(oldContentToCompare, newContentToCompare, ComparisonPolicy.DEFAULT, (ProgressIndicator)new EmptyProgressIndicator());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"compareLines(...)");
        List diff = list;
        int delta = 0;
        Iterable $this$mapNotNull$iv = diff;
        boolean $i$f$mapNotNull22 = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            ProvenanceEntry.SingleDocumentChange singleDocumentChange;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            LineFragment fragment = (LineFragment)element$iv$iv;
            boolean bl2 = false;
            int oldLength = fragment.getEndOffset1() - fragment.getStartOffset1();
            int newLength = fragment.getEndOffset2() - fragment.getStartOffset2();
            if (oldLength == 0 && newLength == 0) {
                singleDocumentChange = null;
            } else {
                CharSequence newFragment = newContentToCompare.subSequence(fragment.getStartOffset2(), fragment.getEndOffset2());
                ProvenanceEntry.SingleDocumentChange singleChange = new ProvenanceEntry.SingleDocumentChange(fragment.getStartOffset1() + delta, oldLength, newFragment);
                delta += newFragment.length() - oldLength;
                singleDocumentChange = singleChange;
            }
            if (singleDocumentChange == null) continue;
            ProvenanceEntry.SingleDocumentChange it$iv$iv = singleDocumentChange;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List changes = (List)destination$iv$iv;
        List $this$computeDocumentChanges_u24lambda_u241 = $i$f$mapNotNull22 = CollectionsKt.createListBuilder();
        boolean bl = false;
        UtilKt.addIfNotNull((List)$this$computeDocumentChanges_u24lambda_u241, (Object)addEndLine);
        $this$computeDocumentChanges_u24lambda_u241.addAll(changes);
        UtilKt.addIfNotNull((List)$this$computeDocumentChanges_u24lambda_u241, (Object)removeEndLine);
        List allChanges = CollectionsKt.build((List)$i$f$mapNotNull22);
        Iterable $i$f$mapNotNull22 = allChanges;
        List<ProvenanceEntry.SingleDocumentChange> initial$iv = CollectionsKt.emptyList();
        boolean $i$f$fold = false;
        List<ProvenanceEntry.SingleDocumentChange> accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void change;
            object = (ProvenanceEntry.SingleDocumentChange)element$iv;
            List<ProvenanceEntry.SingleDocumentChange> acc = accumulator$iv;
            boolean bl4 = false;
            accumulator$iv = DocumentChangesKt.addChange(acc, (ProvenanceEntry.SingleDocumentChange)change);
        }
        return accumulator$iv;
    }

    private static final ContentHasher hasher$lambda$0() {
        return new ContentHasher();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DocumentChangesKind.values().length];
            try {
                nArray[DocumentChangesKind.UNDO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

