/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.lang.lexer;

import com.intellij.jsp.psi.BaseJspSyntaxElementType;
import com.intellij.jsp.psi.JspSyntaxTokenType;
import com.intellij.jsp.psi.impl.parsing.JspLexer;
import com.intellij.platform.syntax.SyntaxElementType;
import com.intellij.platform.syntax.lexer.Lexer;
import com.intellij.platform.syntax.lexer.LexerPosition;
import com.intellij.platform.syntax.util.lexer.LexerBase;
import com.intellij.platform.syntax.util.lexer.PrefixSuffixStripperLexer;
import com.intellij.psi.FileViewProvider;
import java.util.LinkedList;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

public class JspHighlightingLexer
extends LexerBase {
    private final JspLexer myJspLexer = new JspLexer(true);
    private final PrefixSuffixStripperLexer myScriptletLexer = new PrefixSuffixStripperLexer("<%", JspSyntaxTokenType.JSP_SCRIPTLET_START, "%>", JspSyntaxTokenType.JSP_SCRIPTLET_END, BaseJspSyntaxElementType.JSP_SCRIPTLET);
    private final PrefixSuffixStripperLexer myExpressionLexer = new PrefixSuffixStripperLexer("<%=", JspSyntaxTokenType.JSP_EXPRESSION_START, "%>", JspSyntaxTokenType.JSP_EXPRESSION_END, BaseJspSyntaxElementType.JSP_EXPRESSION);
    private final PrefixSuffixStripperLexer myDeclarationLexer = new PrefixSuffixStripperLexer("<%!", JspSyntaxTokenType.JSP_DECLARATION_START, "%>", JspSyntaxTokenType.JSP_DECLARATION_END, BaseJspSyntaxElementType.JSP_DECLARATION);
    private int myBufferEnd;
    private int myTokenStart;
    private int myTokenEnd;
    private SyntaxElementType myTokenType;
    private Queue<Token> myTokenQueue;

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            JspHighlightingLexer.$$$reportNull$$$0(0);
        }
        this.myJspLexer.start(buffer, startOffset, endOffset, initialState & 0xF);
        this.myTokenQueue = new LinkedList<Token>();
        this.myTokenStart = this.myTokenEnd = startOffset;
        this.myTokenType = null;
        this.myBufferEnd = endOffset;
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myJspLexer.getBufferSequence();
        if (charSequence == null) {
            JspHighlightingLexer.$$$reportNull$$$0(1);
        }
        return charSequence;
    }

    public SyntaxElementType getTokenType() {
        this.locateToken();
        return this.myTokenType;
    }

    public int getTokenStart() {
        this.locateToken();
        return this.myTokenStart;
    }

    public int getTokenEnd() {
        this.locateToken();
        return this.myTokenEnd;
    }

    public int getState() {
        int jspState = this.myJspLexer.getState();
        assert (jspState == (jspState & 0xF));
        return jspState | this.myTokenQueue.size() << 4;
    }

    public int getBufferEnd() {
        return this.myBufferEnd;
    }

    public void advance() {
        this.myTokenType = null;
        if (this.myTokenQueue.poll() == null) {
            this.myJspLexer.advance();
        }
    }

    @NotNull
    public LexerPosition getCurrentPosition() {
        return new MyPosition(this.myTokenStart, new MyState(new LinkedList<Token>(this.myTokenQueue), this.myJspLexer.position()));
    }

    public void restore(@NotNull LexerPosition position) {
        if (position == null) {
            JspHighlightingLexer.$$$reportNull$$$0(2);
        }
        MyPosition pos = (MyPosition)position;
        this.myTokenType = null;
        this.myTokenStart = this.myTokenEnd = pos.getOffset();
        this.myJspLexer.start(this.myJspLexer.getBufferSequence(), pos.state.jspState.start, this.myBufferEnd, pos.state.jspState.state);
        this.myJspLexer.restore(pos.state.jspState);
        this.myTokenQueue = pos.state.queue;
    }

    private void locateToken() {
        if (this.myTokenType != null) {
            return;
        }
        this.myTokenStart = this.myTokenEnd;
        Token queuedToken = this.myTokenQueue.peek();
        if (queuedToken != null) {
            this.myTokenType = queuedToken.tokenType;
            this.myTokenEnd = queuedToken.tokenEnd;
            return;
        }
        SyntaxElementType jsp = this.myJspLexer.getTokenType();
        if (jsp == BaseJspSyntaxElementType.JSP_SCRIPTLET) {
            this.fedQueueFromLexer((Lexer)this.myScriptletLexer);
        } else if (jsp == BaseJspSyntaxElementType.JSP_EXPRESSION) {
            this.fedQueueFromLexer((Lexer)this.myExpressionLexer);
        } else if (jsp == BaseJspSyntaxElementType.JSP_DECLARATION) {
            this.fedQueueFromLexer((Lexer)this.myDeclarationLexer);
        } else {
            this.myTokenType = jsp;
            this.myTokenEnd = this.myJspLexer.getTokenEnd();
        }
    }

    public boolean isInsideSQAttributeValue() {
        return this.myJspLexer.getAfterState() == 4;
    }

    public boolean isInsideDQAttributeValue() {
        return this.myJspLexer.getAfterState() == 5;
    }

    private void fedQueueFromLexer(Lexer lexer) {
        SyntaxElementType type;
        lexer.start(this.myJspLexer.getBufferSequence(), this.myJspLexer.getTokenStart(), this.myJspLexer.getTokenEnd());
        this.myJspLexer.advance();
        while ((type = lexer.getTokenType()) != null) {
            Token token = new Token(lexer.getTokenEnd(), lexer.getTokenStart(), type);
            this.myTokenQueue.offer(token);
            lexer.advance();
        }
        this.locateToken();
    }

    public void setFile(FileViewProvider file) {
        this.myJspLexer.setFile(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsp/lang/lexer/JspHighlightingLexer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsp/lang/lexer/JspHighlightingLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "restore";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class MyPosition
    implements LexerPosition {
        public final int start;
        public final MyState state;

        MyPosition(int start, MyState state) {
            this.start = start;
            this.state = state;
        }

        public int getOffset() {
            return this.start;
        }

        public int getState() {
            return 0;
        }
    }

    private static class MyState {
        public final Queue<Token> queue;
        public final JspLexer.Position jspState;

        MyState(Queue<Token> queue, JspLexer.Position jspState) {
            this.queue = queue;
            this.jspState = jspState;
        }
    }

    private static class Token {
        public final int tokenStart;
        public final int tokenEnd;
        public final SyntaxElementType tokenType;

        Token(int tokenEnd, int tokenStart, SyntaxElementType tokenType) {
            this.tokenEnd = tokenEnd;
            this.tokenStart = tokenStart;
            this.tokenType = tokenType;
        }
    }
}

