/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.domains;

import com.intellij.rml.dfa.impl.domains.DomainType;
import com.intellij.rml.dfa.impl.domains.DomainTypeManager;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;

public class Domain
implements Comparable<Domain>,
Serializable {
    private static final long serialVersionUID = -5412885771096812270L;
    private final DomainType type;
    private final int firstVar;

    Domain(DomainType type, int firstVar) {
        this.type = type;
        this.firstVar = firstVar;
    }

    public DomainType getType() {
        return this.type;
    }

    public int getFirstVar() {
        return this.firstVar;
    }

    @Override
    public int compareTo(Domain domain) {
        return Integer.compare(this.firstVar, domain.firstVar);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Domain)) {
            return false;
        }
        Domain domain = (Domain)obj;
        return this.firstVar == domain.firstVar && this.type.equals(domain.type);
    }

    public int hashCode() {
        return this.firstVar;
    }

    public String toString() {
        return this.type.getName() + ":" + this.firstVar;
    }

    public void save(DataOutput stream) throws IOException {
        stream.writeInt(this.type.getIndex());
        stream.writeInt(this.firstVar);
    }

    public static Domain load(DomainTypeManager typeManager, DataInput stream) throws IOException, ClassNotFoundException {
        return new Domain(typeManager.getDomainType(stream.readInt()), stream.readInt());
    }
}

