SELECT dt.*,
       d.Name as Detail_Name,
       nvl(d."Form", -1) as Detail_Form
FROM Accountant.Master_Table mt
     JOIN Accountant.Detail_Table dt ON mt.id = dt.master_id
     LEFT OUTER JOIN Goods.Dictionary d ON dt.detail_id = d.id
ORDER by dt.Display_Order
;


SELECT T.Entity_Id,
       T."Name"       Entity_Name,
       T."Note"       "Entity Remarks",
       V."References" Other_References,
       V.Status       The_Status
FROM Main_Table T,
     Special_View V
WHERE T.Entity_Id = V.Ref_Id
ORDER by Entity_Name, The_Status desc
;


select O.Id            as Org_Id,
       nvl(O."Form",0) as Org_Form,
       O.Name          as Org_Name,
       O.Note          as Org_Note,
       P.Id            as Per_Id,
       P.Full_Name     as Per_Full_Name,
       P.Note          as Per_Note,
       C.Priority      as Contact_Priority
from Faces.Org     O,
     Faces.Contact C,
     Faces.Person  P
where O.Id = C.Org_Id
  and C.Per_Id = P.Id
order by O.Name, C.Priority, P.Full_Name
;
