/*
 * Decompiled with CFR 0.152.
 */
package uk.co.ben_gibson.git.link;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import uk.co.ben_gibson.git.link.Context;
import uk.co.ben_gibson.git.link.ContextCommit;
import uk.co.ben_gibson.git.link.ContextCurrentFile;
import uk.co.ben_gibson.git.link.ContextFileAtCommit;
import uk.co.ben_gibson.git.link.GitLinkBundle;
import uk.co.ben_gibson.git.link.GitLinkRunnerKt;
import uk.co.ben_gibson.git.link.pipeline.Pipeline;
import uk.co.ben_gibson.git.link.ui.notification.Notification;
import uk.co.ben_gibson.git.link.ui.notification.NotifierKt;
import uk.co.ben_gibson.url.URL;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u001a\u0016\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a,\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u000bH\u0002\u00a8\u0006\r"}, d2={"copyToClipBoard", "", "project", "Lcom/intellij/openapi/project/Project;", "context", "Luk/co/ben_gibson/git/link/Context;", "asMarkdown", "", "openInBrowser", "processGitLink", "handle", "Lkotlin/Function1;", "Luk/co/ben_gibson/url/URL;", "GitLink"})
@SourceDebugExtension(value={"SMAP\nGitLinkRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLinkRunner.kt\nuk/co/ben_gibson/git/link/GitLinkRunnerKt\n+ 2 progress.kt\ncom/intellij/openapi/progress/ProgressKt\n*L\n1#1,48:1\n46#2,6:49\n*S KotlinDebug\n*F\n+ 1 GitLinkRunner.kt\nuk/co/ben_gibson/git/link/GitLinkRunnerKt\n*L\n43#1:49,6\n*E\n"})
public final class GitLinkRunnerKt {
    public static final void openInBrowser(@NotNull Project project, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        GitLinkRunnerKt.processGitLink(project, context, (Function1<? super URL, Unit>)((Function1)openInBrowser.1.INSTANCE));
    }

    public static final void copyToClipBoard(@NotNull Project project, @NotNull Context context, boolean asMarkdown) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        GitLinkRunnerKt.processGitLink(project, context, (Function1<? super URL, Unit>)((Function1)new Function1<URL, Unit>(asMarkdown, context, project){
            final /* synthetic */ boolean $asMarkdown;
            final /* synthetic */ Context $context;
            final /* synthetic */ Project $project;
            {
                this.$asMarkdown = $asMarkdown;
                this.$context = $context;
                this.$project = $project;
                super(1);
            }

            public final void invoke(@NotNull URL it) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (this.$asMarkdown) {
                    String string;
                    Context context = this.$context;
                    if (context instanceof ContextCommit) {
                        string = ((ContextCommit)this.$context).getCommit().getShortHash();
                    } else if (context instanceof ContextCurrentFile) {
                        String string2 = this.$context.getFile().getName();
                        string = string2;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                    } else if (context instanceof ContextFileAtCommit) {
                        String string3 = this.$context.getFile().getName();
                        string = string3;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    String label = string;
                    object = "[" + label + "](" + it + ")";
                } else {
                    object = it.toString();
                }
                String url = object;
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(url), null);
                NotifierKt.sendNotification(Notification.Companion.linkCopied(it), this.$project);
            }
        }));
    }

    public static /* synthetic */ void copyToClipBoard$default(Project project, Context context, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        GitLinkRunnerKt.copyToClipBoard(project, context, bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final void processGitLink(Project project, Context context, Function1<? super URL, Unit> handle) {
        void title$iv;
        String string = GitLinkBundle.message("name", new Object[0]);
        boolean cancellable$iv = false;
        boolean $i$f$runBackgroundableTask = false;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, (String)title$iv, cancellable$iv, project, context, handle){
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ Context $context$inlined;
            final /* synthetic */ Function1 $handle$inlined;
            {
                this.$project$inlined = project;
                this.$context$inlined = context;
                this.$handle$inlined = function1;
                super($project, $title, $cancellable);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    ProgressIndicator it = indicator;
                    boolean bl = false;
                    ComponentManager $this$service$iv = (ComponentManager)this.$project$inlined;
                    boolean $i$f$service = false;
                    Class<Pipeline> serviceClass$iv = Pipeline.class;
                    Object object = $this$service$iv.getService(serviceClass$iv);
                    if (object == null) {
                        throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
                    }
                    Pipeline pipeline = (Pipeline)object;
                    URL uRL = pipeline.accept(this.$context$inlined);
                    if (uRL == null) break block1;
                    this.$handle$inlined.invoke((Object)uRL);
                }
            }
        });
    }
}

