/*
 * Decompiled with CFR 0.152.
 */
package uk.co.ben_gibson.git.link.ui.settings;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.BoundConfigurable;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import uk.co.ben_gibson.git.link.GitLinkBundle;
import uk.co.ben_gibson.git.link.platform.Platform;
import uk.co.ben_gibson.git.link.platform.PlatformRepository;
import uk.co.ben_gibson.git.link.settings.ApplicationSettings;
import uk.co.ben_gibson.git.link.ui.components.PlatformCellRenderer;
import uk.co.ben_gibson.git.link.ui.settings.DomainRegistrySettings;
import uk.co.ben_gibson.git.link.ui.settings.RegisterDomainDialog;
import uk.co.ben_gibson.url.Host;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u000e\b\u0002\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001eH\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0018H\u0002J\b\u0010\"\u001a\u00020\u001bH\u0016J\b\u0010#\u001a\u00020\u0018H\u0016J\u0010\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u0012H\u0002J\b\u0010&\u001a\u00020\u0018H\u0002J\b\u0010'\u001a\u00020\u0018H\u0016R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00060\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00120\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Luk/co/ben_gibson/git/link/ui/settings/DomainRegistrySettings;", "Lcom/intellij/openapi/options/BoundConfigurable;", "Luk/co/ben_gibson/git/link/settings/ApplicationSettings$ChangeListener;", "()V", "domainRegistry", "", "", "", "domainsTable", "Lcom/intellij/ui/table/TableView;", "kotlin.jvm.PlatformType", "domainsTableContainer", "Ljavax/swing/JPanel;", "Lorg/jetbrains/annotations/NotNull;", "domainsTableModel", "Lcom/intellij/util/ui/ListTableModel;", "platformComboBoxModel", "Lcom/intellij/ui/CollectionComboBoxModel;", "Luk/co/ben_gibson/git/link/platform/Platform;", "platforms", "Luk/co/ben_gibson/git/link/platform/PlatformRepository;", "settings", "Luk/co/ben_gibson/git/link/settings/ApplicationSettings;", "addDomain", "", "apply", "canModifyDomain", "", "createDomainsTableModel", "domains", "", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "editDomain", "isModified", "onChange", "refreshDomainsTable", "platform", "removeDomain", "reset", "GitLink"})
@SourceDebugExtension(value={"SMAP\nDomainRegistrySettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DomainRegistrySettings.kt\nuk/co/ben_gibson/git/link/ui/settings/DomainRegistrySettings\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,191:1\n43#2,3:192\n43#2,3:195\n43#2,3:198\n1549#3:201\n1620#3,3:202\n1549#3:205\n1620#3,3:206\n1#4:209\n*S KotlinDebug\n*F\n+ 1 DomainRegistrySettings.kt\nuk/co/ben_gibson/git/link/ui/settings/DomainRegistrySettings\n*L\n28#1:192,3\n29#1:195,3\n51#1:198,3\n80#1:201\n80#1:202,3\n121#1:205\n121#1:206,3\n*E\n"})
public final class DomainRegistrySettings
extends BoundConfigurable
implements ApplicationSettings.ChangeListener {
    @NotNull
    private final ApplicationSettings settings;
    @NotNull
    private final PlatformRepository platforms;
    @NotNull
    private Map<String, ? extends Set<String>> domainRegistry;
    @NotNull
    private final CollectionComboBoxModel<Platform> platformComboBoxModel;
    @NotNull
    private final ListTableModel<String> domainsTableModel;
    @NotNull
    private final TableView<String> domainsTable;
    @NotNull
    private final JPanel domainsTableContainer;

    /*
     * WARNING - void declaration
     */
    public DomainRegistrySettings() {
        super(GitLinkBundle.message("settings.domain-registry.group.title", new Object[0]), null, 2, null);
        void $this$domainsTable_u24lambda_u240;
        boolean $i$f$service = false;
        Class serviceClass$iv = ApplicationSettings.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        this.settings = (ApplicationSettings)object;
        $i$f$service = false;
        serviceClass$iv = PlatformRepository.class;
        object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        this.platforms = (PlatformRepository)object;
        this.domainRegistry = this.settings.getCustomHostDomains();
        this.platformComboBoxModel = new CollectionComboBoxModel(CollectionsKt.toList((Iterable)this.platforms.getAll()));
        this.domainsTableModel = DomainRegistrySettings.createDomainsTableModel$default(this, null, 1, null);
        TableView $i$f$service2 = new TableView(this.domainsTableModel);
        serviceClass$iv = $i$f$service2;
        DomainRegistrySettings domainRegistrySettings = this;
        boolean bl = false;
        $this$domainsTable_u24lambda_u240.setShowColumns(true);
        $this$domainsTable_u24lambda_u240.setSelectionMode(0);
        $this$domainsTable_u24lambda_u240.getEmptyText().setText(GitLinkBundle.message("settings.domain-registry.table.empty", new Object[0]));
        domainRegistrySettings.domainsTable = $i$f$service2;
        JPanel jPanel = ToolbarDecorator.createDecorator((JTable)((JTable)this.domainsTable)).setAddAction(arg_0 -> DomainRegistrySettings.domainsTableContainer$lambda$1(this, arg_0)).setEditAction(arg_0 -> DomainRegistrySettings.domainsTableContainer$lambda$2(this, arg_0)).setRemoveAction(arg_0 -> DomainRegistrySettings.domainsTableContainer$lambda$3(this, arg_0)).setEditActionUpdater(arg_0 -> DomainRegistrySettings.domainsTableContainer$lambda$4(this, arg_0)).setRemoveActionUpdater(arg_0 -> DomainRegistrySettings.domainsTableContainer$lambda$5(this, arg_0)).createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
        this.domainsTableContainer = jPanel;
        $i$f$service = false;
        serviceClass$iv = ApplicationSettings.class;
        Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object2 == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        ((ApplicationSettings)object2).registerListener(this);
    }

    @NotNull
    public DialogPanel createPanel() {
        return BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ DomainRegistrySettings this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                $this$panel.row(GitLinkBundle.message("settings.general.field.platform.label", new Object[0]), (Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ DomainRegistrySettings this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        ((ComboBox)ComboBoxKt.bindItem((Cell)$this$row.comboBox((ComboBoxModel)DomainRegistrySettings.access$getPlatformComboBoxModel$p(this.this$0), (ListCellRenderer)((Object)new PlatformCellRenderer())), (Function0)((Function0)new Function0<Platform>(this.this$0){
                            final /* synthetic */ DomainRegistrySettings this$0;
                            {
                                this.this$0 = $receiver;
                                super(0);
                            }

                            @Nullable
                            public final Platform invoke() {
                                return (Platform)CollectionsKt.first((Iterable)DomainRegistrySettings.access$getPlatforms$p(this.this$0).getAll());
                            }
                        }), (Function1)createPanel.2.INSTANCE).getComponent()).addItemListener(arg_0 -> createPanel.1.invoke$lambda$0(this.this$0, arg_0));
                    }

                    private static final void invoke$lambda$0(DomainRegistrySettings this$0, ItemEvent it) {
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                        if (it.getStateChange() == 1) {
                            Object[] objectArray = it.getItemSelectable().getSelectedObjects();
                            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getSelectedObjects(...)");
                            Object object = ArraysKt.first((Object[])objectArray);
                            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type uk.co.ben_gibson.git.link.platform.Platform");
                            Platform selectedPlatform = (Platform)object;
                            DomainRegistrySettings.access$refreshDomainsTable(this$0, selectedPlatform);
                        }
                    }
                });
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ DomainRegistrySettings this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)DomainRegistrySettings.access$getDomainsTableContainer$p(this.this$0)).align(Align.FILL);
                    }
                }), (int)1, null);
                Panel.row$default((Panel)$this$panel, null, (Function1)createPanel.3.INSTANCE, (int)1, null);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean canModifyDomain() {
        void $this$mapTo$iv$iv;
        Platform platform = (Platform)this.platformComboBoxModel.getSelectedItem();
        if (platform == null) {
            return false;
        }
        Platform platform2 = platform;
        Iterable $this$map$iv = platform2.getDomains();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Host host = (Host)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toString());
        }
        return !CollectionsKt.contains((Iterable)((List)destination$iv$iv), (Object)this.domainsTable.getSelectedObject());
    }

    private final void addDomain() {
        Platform platform = (Platform)this.platformComboBoxModel.getSelected();
        if (platform == null) {
            return;
        }
        Platform platform2 = platform;
        RegisterDomainDialog dialog = new RegisterDomainDialog(null, this.domainRegistry, this.platforms, 1, null);
        if (dialog.showAndGet()) {
            String string = platform2.getId().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            Set domains = this.domainRegistry.getOrDefault(string, SetsKt.emptySet());
            this.domainRegistry = MapsKt.plus(this.domainRegistry, (Pair)new Pair((Object)platform2.getId().toString(), (Object)SetsKt.plus((Set)domains, (Object)dialog.getDomain())));
            this.refreshDomainsTable(platform2);
        }
    }

    private final void removeDomain() {
        Platform platform = (Platform)this.platformComboBoxModel.getSelected();
        if (platform == null) {
            return;
        }
        Platform platform2 = platform;
        String string = (String)this.domainsTable.getSelectedObject();
        if (string == null) {
            return;
        }
        String remove = string;
        String string2 = platform2.getId().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        Set domains = this.domainRegistry.getOrDefault(string2, SetsKt.emptySet());
        this.domainRegistry = MapsKt.plus(this.domainRegistry, (Pair)new Pair((Object)platform2.getId().toString(), (Object)SetsKt.minus((Set)domains, (Object)remove)));
        this.refreshDomainsTable(platform2);
    }

    private final void editDomain() {
        Platform platform = (Platform)this.platformComboBoxModel.getSelected();
        if (platform == null) {
            return;
        }
        Platform platform2 = platform;
        String string = (String)this.domainsTable.getSelectedObject();
        if (string == null) {
            return;
        }
        String domain = string;
        RegisterDomainDialog dialog = new RegisterDomainDialog(domain, this.domainRegistry, this.platforms);
        if (dialog.showAndGet()) {
            String string2 = platform2.getId().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            Set existingUrls = this.domainRegistry.getOrDefault(string2, SetsKt.emptySet());
            this.domainRegistry = MapsKt.plus(this.domainRegistry, (Pair)new Pair((Object)platform2.getId().toString(), (Object)SetsKt.plus((Set)SetsKt.minus((Set)existingUrls, (Object)domain), (Object)dialog.getDomain())));
            this.refreshDomainsTable(platform2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void refreshDomainsTable(Platform platform) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = platform.getDomains();
        ListTableModel<String> listTableModel = this.domainsTableModel;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Host host = (Host)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toString());
        }
        Collection collection = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        String string = platform.getId().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        listTableModel.setItems(CollectionsKt.plus((Collection)collection, (Iterable)this.domainRegistry.getOrDefault(string, SetsKt.emptySet())));
    }

    private final ListTableModel<String> createDomainsTableModel(List<String> domains) {
        createDomainsTableModel.1[] nullArray = new createDomainsTableModel.1[1];
        String string = GitLinkBundle.message("settings.auto-detect.table.column.domain", new Object[0]);
        nullArray[0] = new ColumnInfo<String, String>(string){

            @NotNull
            public String valueOf(@NotNull String domain) {
                Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
                return domain;
            }
        };
        return new ListTableModel((ColumnInfo[])nullArray, domains);
    }

    static /* synthetic */ ListTableModel createDomainsTableModel$default(DomainRegistrySettings domainRegistrySettings, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        return domainRegistrySettings.createDomainsTableModel(list);
    }

    public void reset() {
        super.reset();
        this.domainRegistry = this.settings.getCustomHostDomains();
        Platform platform = (Platform)this.platformComboBoxModel.getSelected();
        if (platform == null) {
            return;
        }
        Platform platform2 = platform;
        this.refreshDomainsTable(platform2);
    }

    public boolean isModified() {
        return super.isModified() || !Intrinsics.areEqual(this.domainRegistry, this.settings.getCustomHostDomains());
    }

    public void apply() {
        super.apply();
        this.settings.setCustomHostDomains(this.domainRegistry);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onChange() {
        Platform platform;
        Object object = this.platformComboBoxModel.getSelectedItem();
        Platform current = object instanceof Platform ? (Platform)object : null;
        this.platformComboBoxModel.removeAll();
        this.platformComboBoxModel.add(CollectionsKt.toList((Iterable)this.platforms.getAll()));
        CollectionComboBoxModel<Platform> collectionComboBoxModel = this.platformComboBoxModel;
        Platform platform2 = current;
        if (platform2 != null) {
            void it;
            Platform platform3 = platform2;
            CollectionComboBoxModel<Platform> collectionComboBoxModel2 = collectionComboBoxModel;
            boolean bl = false;
            platform = this.platforms.getById(it.getId());
            collectionComboBoxModel = collectionComboBoxModel2;
        } else {
            platform = null;
        }
        collectionComboBoxModel.setSelectedItem(platform);
    }

    private static final void domainsTableContainer$lambda$1(DomainRegistrySettings this$0, AnActionButton it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.addDomain();
    }

    private static final void domainsTableContainer$lambda$2(DomainRegistrySettings this$0, AnActionButton it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.editDomain();
    }

    private static final void domainsTableContainer$lambda$3(DomainRegistrySettings this$0, AnActionButton it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.removeDomain();
    }

    private static final boolean domainsTableContainer$lambda$4(DomainRegistrySettings this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.canModifyDomain();
    }

    private static final boolean domainsTableContainer$lambda$5(DomainRegistrySettings this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.canModifyDomain();
    }

    public static final /* synthetic */ CollectionComboBoxModel access$getPlatformComboBoxModel$p(DomainRegistrySettings $this) {
        return $this.platformComboBoxModel;
    }

    public static final /* synthetic */ PlatformRepository access$getPlatforms$p(DomainRegistrySettings $this) {
        return $this.platforms;
    }

    public static final /* synthetic */ void access$refreshDomainsTable(DomainRegistrySettings $this, Platform platform) {
        $this.refreshDomainsTable(platform);
    }

    public static final /* synthetic */ JPanel access$getDomainsTableContainer$p(DomainRegistrySettings $this) {
        return $this.domainsTableContainer;
    }
}

