/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.extension.highlightedyank;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.jetbrains.rd.util.CollectionExKt;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.common.ModeChangeListener;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.common.VimYankListener;
import com.maddyhome.idea.vim.extension.VimExtension;
import com.maddyhome.idea.vim.extension.highlightedyank.VimHighlightedYankKt;
import com.maddyhome.idea.vim.helper.MessageHelper;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import com.maddyhome.idea.vim.state.mode.Mode;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimString;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0002J\b\u0010\u000f\u001a\u00020\rH\u0016J\u001c\u0010\u0010\u001a\u00020\r2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012H\u0016J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\rH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/maddyhome/idea/vim/extension/highlightedyank/VimHighlightedYank;", "Lcom/maddyhome/idea/vim/extension/VimExtension;", "Lcom/maddyhome/idea/vim/common/VimYankListener;", "Lcom/maddyhome/idea/vim/common/ModeChangeListener;", "<init>", "()V", "highlightHandler", "Lcom/maddyhome/idea/vim/extension/highlightedyank/VimHighlightedYank$HighlightHandler;", "initialised", "", "getName", "", "init", "", "registerIdeaVimDisabledCallback", "dispose", "yankPerformed", "caretToRange", "", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "Lcom/maddyhome/idea/vim/common/TextRange;", "modeChanged", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "oldMode", "Lcom/maddyhome/idea/vim/state/mode/Mode;", "ensureInitialised", "HighlightHandler", "IdeaVIM"})
public final class VimHighlightedYank
implements VimExtension,
VimYankListener,
ModeChangeListener {
    @NotNull
    private final HighlightHandler highlightHandler = new HighlightHandler();
    private boolean initialised;

    @Override
    @NotNull
    public String getName() {
        return "highlightedyank";
    }

    @Override
    public void init() {
        VimInjectorKt.getInjector().getListenersNotifier().getModeChangeListeners().add(this);
        VimInjectorKt.getInjector().getListenersNotifier().getYankListeners().add(this);
        this.registerIdeaVimDisabledCallback();
        this.initialised = true;
    }

    private final void registerIdeaVimDisabledCallback() {
        Disposer.register((Disposable)VimPlugin.getInstance().onOffDisposable, () -> VimHighlightedYank.registerIdeaVimDisabledCallback$lambda$0(this));
    }

    @Override
    public void dispose() {
        VimInjectorKt.getInjector().getListenersNotifier().getModeChangeListeners().remove(this);
        VimInjectorKt.getInjector().getListenersNotifier().getYankListeners().remove(this);
        this.highlightHandler.clearYankHighlighters();
        this.initialised = false;
    }

    public void yankPerformed(@NotNull Map<ImmutableVimCaret, TextRange> caretToRange) {
        Intrinsics.checkNotNullParameter(caretToRange, (String)"caretToRange");
        this.ensureInitialised();
        this.highlightHandler.highlightYankRange(caretToRange);
    }

    public void modeChanged(@NotNull VimEditor editor, @NotNull Mode oldMode) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)oldMode, (String)"oldMode");
        if (!(editor.getMode() instanceof Mode.INSERT)) {
            return;
        }
        this.ensureInitialised();
        this.highlightHandler.clearYankHighlighters();
    }

    private final void ensureInitialised() {
        if (!this.initialised) {
            this.registerIdeaVimDisabledCallback();
            this.initialised = true;
        }
    }

    private static final void registerIdeaVimDisabledCallback$lambda$0(VimHighlightedYank this$0) {
        this$0.highlightHandler.clearYankHighlighters();
        this$0.initialised = false;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eJ\u0006\u0010\u0011\u001a\u00020\fJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0002J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0002JF\u0010\u001d\u001a\u0002H\u001e\"\u0004\b\u0000\u0010\u001e2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u0002H\u001e2!\u0010!\u001a\u001d\u0012\u0013\u0012\u00110#\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(&\u0012\u0004\u0012\u0002H\u001e0\"H\u0002\u00a2\u0006\u0002\u0010'R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/maddyhome/idea/vim/extension/highlightedyank/VimHighlightedYank$HighlightHandler;", "", "<init>", "()V", "alarm", "Lcom/intellij/util/Alarm;", "lastEditor", "Lcom/intellij/openapi/editor/Editor;", "highlighters", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "highlightYankRange", "", "caretToRange", "", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "Lcom/maddyhome/idea/vim/common/TextRange;", "clearYankHighlighters", "getHighlightTextAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "editor", "extractUsersHighlightDuration", "", "extractUsersHighlightColor", "Ljava/awt/Color;", "extractUserHighlightForegroundColor", "parseRgbaColor", "colorString", "", "extractVariable", "T", "variable", "default", "extractFun", "Lkotlin/Function1;", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;", "Lkotlin/ParameterName;", "name", "value", "(Ljava/lang/String;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "IdeaVIM"})
    @SourceDebugExtension(value={"SMAP\nVimHighlightedYank.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimHighlightedYank.kt\ncom/maddyhome/idea/vim/extension/highlightedyank/VimHighlightedYank$HighlightHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,292:1\n1869#2,2:293\n1563#2:301\n1634#2,3:302\n1761#2,3:305\n434#3:295\n507#3,5:296\n*S KotlinDebug\n*F\n+ 1 VimHighlightedYank.kt\ncom/maddyhome/idea/vim/extension/highlightedyank/VimHighlightedYank$HighlightHandler\n*L\n189#1:293,2\n261#1:301\n261#1:302,3\n263#1:305,3\n259#1:295\n259#1:296,5\n*E\n"})
    private static final class HighlightHandler {
        @NotNull
        private final Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        @Nullable
        private Editor lastEditor;
        @NotNull
        private final Set<RangeHighlighter> highlighters = new LinkedHashSet();

        public final void highlightYankRange(@NotNull Map<ImmutableVimCaret, TextRange> caretToRange) {
            Editor editor;
            Intrinsics.checkNotNullParameter(caretToRange, (String)"caretToRange");
            this.clearYankHighlighters();
            this.lastEditor = editor = IjVimEditorKt.getIj(((ImmutableVimCaret)CollectionExKt.first(caretToRange).getKey()).getEditor());
            TextAttributes attributes = this.getHighlightTextAttributes(editor);
            for (TextRange range : caretToRange.values()) {
                int n = range.size();
                for (int i = 0; i < n; ++i) {
                    RangeHighlighter highlighter;
                    Intrinsics.checkNotNullExpressionValue((Object)editor.getMarkupModel().addRangeHighlighter(range.getStartOffsets()[i], range.getEndOffsets()[i], 6000, attributes, HighlighterTargetArea.EXACT_RANGE), (String)"addRangeHighlighter(...)");
                    this.highlighters.add(highlighter);
                }
            }
            int timeout = this.extractUsersHighlightDuration();
            if (timeout >= 0) {
                this.alarm.addRequest(() -> HighlightHandler.highlightYankRange$lambda$0(this), timeout, ModalityState.any());
            }
        }

        public final void clearYankHighlighters() {
            this.alarm.cancelAllRequests();
            Editor editor = this.lastEditor;
            if (editor != null) {
                Editor editor2 = editor;
                boolean bl = false;
                if (!editor2.isDisposed()) {
                    Iterable $this$forEach$iv = this.highlighters;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        RangeHighlighter highlighter = (RangeHighlighter)element$iv;
                        boolean bl2 = false;
                        editor2.getMarkupModel().removeHighlighter(highlighter);
                    }
                }
            }
            this.lastEditor = null;
            this.highlighters.clear();
        }

        private final TextAttributes getHighlightTextAttributes(Editor editor) {
            return new TextAttributes(this.extractUserHighlightForegroundColor(), this.extractUsersHighlightColor(), editor.getColorsScheme().getColor(EditorColors.CARET_COLOR), EffectType.SEARCH_MATCH, 0);
        }

        private final int extractUsersHighlightDuration() {
            return ((Number)this.extractVariable(VimHighlightedYankKt.access$getHIGHLIGHT_DURATION_VARIABLE_NAME$p(), 300, HighlightHandler::extractUsersHighlightDuration$lambda$0)).intValue();
        }

        private final Color extractUsersHighlightColor() {
            String value;
            VimDataType vimDataType = VimPlugin.getVariableService().getGlobalVariableValue(VimHighlightedYankKt.access$getHIGHLIGHT_COLOR_VARIABLE_NAME$p());
            String string = vimDataType != null && (vimDataType = vimDataType.toVimString()) != null ? vimDataType.getValue() : (value = null);
            if (value != null) {
                Color color;
                try {
                    color = this.parseRgbaColor(value);
                }
                catch (Exception e) {
                    Object[] objectArray = new Object[2];
                    objectArray[0] = "g:" + VimHighlightedYankKt.access$getHIGHLIGHT_COLOR_VARIABLE_NAME$p();
                    String string2 = e.getMessage();
                    if (string2 == null) {
                        string2 = "";
                    }
                    objectArray[1] = string2;
                    String message = MessageHelper.message("highlightedyank.error.invalid.value.of.0.1", objectArray);
                    VimPlugin.showMessage(message);
                    color = VimHighlightedYankKt.access$getDefaultHighlightTextColor();
                }
                return color;
            }
            return VimHighlightedYankKt.access$getDefaultHighlightTextColor();
        }

        private final Color extractUserHighlightForegroundColor() {
            String string;
            VimString vimString;
            Object object = VimPlugin.getVariableService().getGlobalVariableValue(VimHighlightedYankKt.access$getHIGHLIGHT_FOREGROUND_COLOR_VARIABLE_NAME$p());
            if (object == null || (vimString = object.toVimString()) == null || (string = vimString.getValue()) == null) {
                return null;
            }
            String value = string;
            try {
                object = this.parseRgbaColor(value);
            }
            catch (Exception e) {
                Object[] objectArray = new Object[2];
                objectArray[0] = "g:" + VimHighlightedYankKt.access$getHIGHLIGHT_FOREGROUND_COLOR_VARIABLE_NAME$p();
                String string2 = e.getMessage();
                if (string2 == null) {
                    string2 = "";
                }
                objectArray[1] = string2;
                String message = MessageHelper.message("highlightedyank.error.invalid.value.of.0.1", objectArray);
                VimPlugin.showMessage(message);
                object = null;
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        private final Color parseRgbaColor(String colorString) {
            List rgba;
            block11: {
                block10: {
                    boolean bl;
                    block9: {
                        void $this$mapTo$iv$iv;
                        Iterable $this$filterTo$iv$iv;
                        String string = colorString.substring(4);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        Object $this$filter$iv = string;
                        boolean $i$f$filter = false;
                        CharSequence charSequence = (CharSequence)$this$filter$iv;
                        Object destination$iv$iv = new StringBuilder();
                        boolean $i$f$filterTo = false;
                        int n = $this$filterTo$iv$iv.length();
                        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                            char element$iv$iv;
                            char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                            boolean bl2 = false;
                            if (!(it != '(' && it != ')' && !CharsKt.isWhitespace((char)it))) continue;
                            destination$iv$iv.append(element$iv$iv);
                        }
                        $this$filter$iv = new char[1];
                        $this$filter$iv[0] = 44;
                        Iterable $this$map$iv = StringsKt.split$default((CharSequence)((StringBuilder)destination$iv$iv).toString(), (char[])$this$filter$iv, (boolean)false, (int)0, (int)6, null);
                        boolean $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            String element$iv$iv = (String)item$iv$iv;
                            Object object = destination$iv$iv;
                            boolean bl3 = false;
                            object.add(Integer.parseInt((String)it));
                        }
                        rgba = (List)destination$iv$iv;
                        if (rgba.size() != 4) break block10;
                        Iterable $this$any$iv = rgba;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                int it = ((Number)element$iv).intValue();
                                boolean bl4 = false;
                                if (!(it < 0 || it > 255)) continue;
                                bl = true;
                                break block9;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) break block11;
                }
                throw new IllegalArgumentException("Invalid RGBA values. Each component must be between 0 and 255");
            }
            return new Color(((Number)rgba.get(0)).intValue(), ((Number)rgba.get(1)).intValue(), ((Number)rgba.get(2)).intValue(), ((Number)rgba.get(3)).intValue());
        }

        private final <T> T extractVariable(String variable, T t, Function1<? super VimDataType, ? extends T> extractFun) {
            VimDataType value = VimPlugin.getVariableService().getGlobalVariableValue(variable);
            if (value != null) {
                Object object;
                try {
                    object = extractFun.invoke((Object)value);
                }
                catch (Exception e) {
                    Object[] objectArray = new Object[2];
                    objectArray[0] = "g:" + variable;
                    String string = e.getMessage();
                    if (string == null) {
                        string = "";
                    }
                    objectArray[1] = string;
                    String message = MessageHelper.message("highlightedyank.error.invalid.value.of.0.1", objectArray);
                    VimPlugin.showMessage(message);
                    object = t;
                }
                return (T)object;
            }
            return t;
        }

        private static final void highlightYankRange$lambda$0(HighlightHandler this$0) {
            this$0.clearYankHighlighters();
        }

        private static final int extractUsersHighlightDuration$lambda$0(VimDataType it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it instanceof VimString ? Integer.parseInt(((VimString)it).getValue()) : it.toVimNumber().getValue();
        }
    }
}

