/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.group;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.VisualPosition;
import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjector;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimMotionGroup;
import com.maddyhome.idea.vim.api.VimScrollGroup;
import com.maddyhome.idea.vim.group.MotionGroup;
import com.maddyhome.idea.vim.helper.EditorHelper;
import com.maddyhome.idea.vim.helper.ScrollHelperKt;
import com.maddyhome.idea.vim.helper.ScrollViewHelper;
import com.maddyhome.idea.vim.helper.StrictMode;
import com.maddyhome.idea.vim.newapi.IjVimCaretKt;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import com.maddyhome.idea.vim.options.EffectiveOptionValueChangeListener;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 #2\u00020\u0001:\u0003!\"#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u000f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\tH\u0016J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\rH\u0016J \u0010\u0015\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\tH\u0016J \u0010\u0017\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\tH\u0016J \u0010\u0018\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\tH\u0016J(\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u0018\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\rH\u0016J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u0007H\u0016J\u0010\u0010 \u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006$"}, d2={"Lcom/maddyhome/idea/vim/group/ScrollGroup;", "Lcom/maddyhome/idea/vim/api/VimScrollGroup;", "<init>", "()V", "scrollCaretIntoView", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "scrollFullPage", "", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "pages", "", "scrollFullPageDown", "scrollFullPageUp", "scrollHalfPage", "rawCount", "down", "scrollLines", "lines", "scrollCurrentLineToDisplayTop", "start", "scrollCurrentLineToDisplayMiddle", "scrollCurrentLineToDisplayBottom", "scrollLineToScreenLocation", "screenLocation", "Lcom/maddyhome/idea/vim/group/ScrollGroup$ScreenLocation;", "scrollColumns", "columns", "scrollCaretColumnToDisplayLeftEdge", "vimEditor", "scrollCaretColumnToDisplayRightEdge", "ScreenLocation", "ScrollOptionsChangeListener", "Companion", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nScrollGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScrollGroup.kt\ncom/maddyhome/idea/vim/group/ScrollGroup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,294:1\n1#2:295\n*E\n"})
public final class ScrollGroup
implements VimScrollGroup {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void scrollCaretIntoView(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        ScrollViewHelper.scrollCaretIntoView(IjVimEditorKt.getIj(editor));
    }

    public boolean scrollFullPage(@NotNull VimEditor editor, @NotNull VimCaret caret, int pages) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        StrictMode.INSTANCE.assertTrue(pages != 0, "pages != 0");
        return pages > 0 ? this.scrollFullPageDown(editor, caret, pages) : this.scrollFullPageUp(editor, caret, Math.abs(pages));
    }

    private final boolean scrollFullPageDown(VimEditor editor, VimCaret caret, int pages) {
        Editor ijEditor = IjVimEditorKt.getIj(editor);
        Pair<Boolean, Integer> result = EditorHelper.scrollFullPageDown(ijEditor, pages);
        int scrollOffset = ScrollHelperKt.getNormalizedScrollOffset(ijEditor);
        int topVisualLine = EditorHelper.getVisualLineAtTopOfScreen(ijEditor);
        Integer caretVisualLine = (Integer)result.getSecond();
        if (caretVisualLine < topVisualLine + scrollOffset) {
            caretVisualLine = EngineEditorHelperKt.normalizeVisualLine((VimEditor)editor, (int)(caretVisualLine + scrollOffset));
        }
        Integer n = caretVisualLine;
        int n2 = IjVimCaretKt.getIj((VimCaret)caret).getVisualPosition().line;
        if (n == null || n != n2) {
            VimMotionGroup vimMotionGroup = VimInjectorKt.getInjector().getMotion();
            Integer n3 = caretVisualLine;
            Intrinsics.checkNotNull((Object)n3);
            int offset = vimMotionGroup.moveCaretToLineWithStartOfLineOption(editor, EngineEditorHelperKt.visualLineToBufferLine((VimEditor)editor, (int)((Number)n3).intValue()), (ImmutableVimCaret)caret);
            caret.moveToOffset(offset);
            Object object = result.getFirst();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-first>(...)");
            return (Boolean)object;
        }
        return false;
    }

    private final boolean scrollFullPageUp(VimEditor editor, VimCaret caret, int pages) {
        Editor ijEditor = IjVimEditorKt.getIj(editor);
        Pair<Boolean, Integer> result = EditorHelper.scrollFullPageUp(ijEditor, pages);
        int scrollOffset = ScrollHelperKt.getNormalizedScrollOffset(ijEditor);
        int bottomVisualLine = EditorHelper.getVisualLineAtBottomOfScreen(ijEditor);
        Integer caretVisualLine = (Integer)result.getSecond();
        if (caretVisualLine > bottomVisualLine - scrollOffset) {
            caretVisualLine = EngineEditorHelperKt.normalizeVisualLine((VimEditor)editor, (int)(caretVisualLine - scrollOffset));
        }
        Integer n = caretVisualLine;
        int n2 = IjVimCaretKt.getIj((VimCaret)caret).getVisualPosition().line;
        if (n == null || n != n2) {
            Integer n3 = caretVisualLine;
            n2 = -1;
            if (n3 == null || n3 != n2) {
                VimMotionGroup vimMotionGroup = VimInjectorKt.getInjector().getMotion();
                Integer n4 = caretVisualLine;
                Intrinsics.checkNotNull((Object)n4);
                int offset = vimMotionGroup.moveCaretToLineWithStartOfLineOption(editor, EngineEditorHelperKt.visualLineToBufferLine((VimEditor)editor, (int)((Number)n4).intValue()), (ImmutableVimCaret)caret);
                caret.moveToOffset(offset);
                Object object = result.getFirst();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-first>(...)");
                return (Boolean)object;
            }
        }
        Integer n5 = caretVisualLine;
        n2 = EngineEditorHelperKt.getVisualLineCount((VimEditor)editor) - 2;
        return n5 != null && n5 == n2;
    }

    public boolean scrollHalfPage(@NotNull VimEditor editor, @NotNull VimCaret caret, int rawCount, boolean down) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Editor ijEditor = IjVimEditorKt.getIj(editor);
        CaretModel caretModel = ijEditor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        CaretModel caretModel2 = caretModel;
        int currentLogicalLine = caretModel2.getLogicalPosition().line;
        if (!down && currentLogicalLine <= 0 || down && currentLogicalLine >= editor.lineCount() - 1) {
            return false;
        }
        Rectangle rectangle = EditorHelper.getVisibleArea(ijEditor);
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
        Rectangle visibleArea = rectangle;
        int targetCaretVisualLine = 0;
        targetCaretVisualLine = ScrollGroup.Companion.getScrollScreenTargetCaretVisualLine(ijEditor, rawCount, down);
        int yInitialCaret = ijEditor.visualLineToY(caretModel2.getVisualPosition().line);
        int yTargetVisualLine = ijEditor.visualLineToY(targetCaretVisualLine);
        if (Math.abs(yTargetVisualLine - yInitialCaret) > visibleArea.height) {
            int yPrevious = visibleArea.y;
            boolean moved = false;
            if (down) {
                targetCaretVisualLine = EditorHelper.getVisualLineAtBottomOfScreen(ijEditor) + 1;
                moved = EditorHelper.scrollVisualLineToTopOfScreen(ijEditor, targetCaretVisualLine);
            } else {
                targetCaretVisualLine = EditorHelper.getVisualLineAtTopOfScreen(ijEditor) - 1;
                moved = EditorHelper.scrollVisualLineToBottomOfScreen(ijEditor, targetCaretVisualLine);
            }
            if (moved) {
                Rectangle newArea = EditorHelper.getVisibleArea(ijEditor);
                boolean bl = false;
                targetCaretVisualLine = ijEditor.yToVisualLine(yInitialCaret + newArea.y - yPrevious);
            }
        } else {
            EditorHelper.scrollVisualLineToCaretLocation(ijEditor, targetCaretVisualLine);
            int scrollOffset = ScrollHelperKt.getNormalizedScrollOffset(ijEditor);
            int visualTop = EditorHelper.getVisualLineAtTopOfScreen(ijEditor) + (down ? scrollOffset : 0);
            int visualBottom = EditorHelper.getVisualLineAtBottomOfScreen(ijEditor) - (down ? 0 : scrollOffset);
            targetCaretVisualLine = RangesKt.coerceIn((int)targetCaretVisualLine, (int)visualTop, (int)visualBottom);
        }
        int logicalLine = EngineEditorHelperKt.visualLineToBufferLine((VimEditor)editor, (int)targetCaretVisualLine);
        int caretOffset = VimInjectorKt.getInjector().getMotion().moveCaretToLineWithStartOfLineOption(editor, logicalLine, (ImmutableVimCaret)caret);
        caret.moveToOffset(caretOffset);
        return true;
    }

    public boolean scrollLines(@NotNull VimEditor editor, int lines) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        boolean bl2 = bl = lines != 0;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-ScrollGroup$scrollLines$22 = false;
            String $i$a$-assert-ScrollGroup$scrollLines$22 = "lines cannot be 0";
            throw new AssertionError((Object)$i$a$-assert-ScrollGroup$scrollLines$22);
        }
        Editor ijEditor = IjVimEditorKt.getIj(editor);
        if (lines > 0) {
            int visualLine = EditorHelper.getVisualLineAtTopOfScreen(ijEditor);
            v1 = EditorHelper.scrollVisualLineToTopOfScreen(ijEditor, visualLine + lines);
        } else {
            int visualLine = EditorHelper.getNonNormalizedVisualLineAtBottomOfScreen(ijEditor);
            v1 = EditorHelper.scrollVisualLineToBottomOfScreen(ijEditor, visualLine + lines);
        }
        MotionGroup.Companion.moveCaretToView(ijEditor);
        return true;
    }

    public boolean scrollCurrentLineToDisplayTop(@NotNull VimEditor editor, int rawCount, boolean start2) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.scrollLineToScreenLocation(editor, ScreenLocation.TOP, rawCount, start2);
        return true;
    }

    public boolean scrollCurrentLineToDisplayMiddle(@NotNull VimEditor editor, int rawCount, boolean start2) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.scrollLineToScreenLocation(editor, ScreenLocation.MIDDLE, rawCount, start2);
        return true;
    }

    public boolean scrollCurrentLineToDisplayBottom(@NotNull VimEditor editor, int rawCount, boolean start2) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.scrollLineToScreenLocation(editor, ScreenLocation.BOTTOM, rawCount, start2);
        return true;
    }

    private final void scrollLineToScreenLocation(VimEditor editor, ScreenLocation screenLocation, int rawCount, boolean start2) {
        int scrollOffset = ScrollHelperKt.getNormalizedScrollOffset(IjVimEditorKt.getIj(editor));
        int visualLine = rawCount == 0 ? editor.primaryCaret().getVisualPosition().getLine() : editor.bufferLineToVisualLine(EngineEditorHelperKt.normalizeLine((VimEditor)editor, (int)(rawCount - 1)));
        switch (WhenMappings.$EnumSwitchMapping$0[screenLocation.ordinal()]) {
            case 1: {
                EditorHelper.scrollVisualLineToTopOfScreen(IjVimEditorKt.getIj(editor), visualLine - scrollOffset);
                break;
            }
            case 2: {
                EditorHelper.scrollVisualLineToMiddleOfScreen(IjVimEditorKt.getIj(editor), visualLine, true);
                break;
            }
            case 3: {
                EditorHelper.scrollVisualLineToBottomOfScreen(IjVimEditorKt.getIj(editor), EngineEditorHelperKt.normalizeVisualLine((VimEditor)editor, (int)(visualLine + scrollOffset)));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (visualLine != editor.primaryCaret().getVisualPosition().getLine() || start2) {
            VimMotionGroup $this$scrollLineToScreenLocation_u24lambda_u240 = VimInjectorKt.getInjector().getMotion();
            boolean bl = false;
            int offset = start2 ? $this$scrollLineToScreenLocation_u24lambda_u240.moveCaretToLineStartSkipLeading(editor, EngineEditorHelperKt.visualLineToBufferLine((VimEditor)editor, (int)visualLine)) : $this$scrollLineToScreenLocation_u24lambda_u240.moveCaretToLineWithSameColumn(editor, EngineEditorHelperKt.visualLineToBufferLine((VimEditor)editor, (int)visualLine), (ImmutableVimCaret)editor.primaryCaret());
            editor.primaryCaret().moveToOffset(offset);
        }
    }

    public boolean scrollColumns(@NotNull VimEditor editor, int columns) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Editor ijEditor = IjVimEditorKt.getIj(editor);
        VisualPosition visualPosition = ijEditor.getCaretModel().getVisualPosition();
        Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"getVisualPosition(...)");
        VisualPosition caretVisualPosition = visualPosition;
        if (columns > 0) {
            int visualColumn = EditorHelper.normalizeVisualColumn(ijEditor, caretVisualPosition.line, EditorHelper.getVisualColumnAtLeftOfDisplay(ijEditor, caretVisualPosition.line) + columns, false);
            Inlay inlay = ijEditor.getInlayModel().getInlineElementAt(new VisualPosition(caretVisualPosition.line, visualColumn - 1));
            if (inlay != null && !inlay.isRelatedToPrecedingText()) {
                ++visualColumn;
            }
            EditorHelper.scrollColumnToLeftOfScreen(ijEditor, caretVisualPosition.line, visualColumn);
        } else {
            int visualColumn = EditorHelper.getVisualColumnAtRightOfDisplay(ijEditor, caretVisualPosition.line) + columns;
            EditorHelper.scrollColumnToRightOfScreen(ijEditor, caretVisualPosition.line, visualColumn);
        }
        MotionGroup.Companion.moveCaretToView(ijEditor);
        return true;
    }

    public boolean scrollCaretColumnToDisplayLeftEdge(@NotNull VimEditor vimEditor) {
        Intrinsics.checkNotNullParameter((Object)vimEditor, (String)"vimEditor");
        Editor editor = IjVimEditorKt.getIj(vimEditor);
        VisualPosition visualPosition = editor.getCaretModel().getVisualPosition();
        Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"getVisualPosition(...)");
        VisualPosition caretVisualPosition = visualPosition;
        int scrollOffset = ScrollHelperKt.getNormalizedSideScrollOffset(editor);
        int column = Math.max(0, caretVisualPosition.column - scrollOffset);
        EditorHelper.scrollColumnToLeftOfScreen(editor, caretVisualPosition.line, column);
        return true;
    }

    public boolean scrollCaretColumnToDisplayRightEdge(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Editor ijEditor = IjVimEditorKt.getIj(editor);
        VisualPosition visualPosition = ijEditor.getCaretModel().getVisualPosition();
        Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"getVisualPosition(...)");
        VisualPosition caretVisualPosition = visualPosition;
        int scrollOffset = ScrollHelperKt.getNormalizedSideScrollOffset(ijEditor);
        int column = EditorHelper.normalizeVisualColumn(ijEditor, caretVisualPosition.line, caretVisualPosition.column + scrollOffset, false);
        EditorHelper.scrollColumnToRightOfScreen(ijEditor, caretVisualPosition.line, column);
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0005H\u0002\u00a8\u0006\r"}, d2={"Lcom/maddyhome/idea/vim/group/ScrollGroup$Companion;", "", "<init>", "()V", "getScrollScreenTargetCaretVisualLine", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "rawCount", "down", "", "getScrollOption", "Lcom/maddyhome/idea/vim/api/VimEditor;", "IdeaVIM"})
    public static final class Companion {
        private Companion() {
        }

        private final int getScrollScreenTargetCaretVisualLine(Editor editor, int rawCount, boolean down) {
            int n;
            Rectangle rectangle = EditorHelper.getVisibleArea(editor);
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
            Rectangle visibleArea = rectangle;
            int caretVisualLine = editor.getCaretModel().getVisualPosition().line;
            int scrollOption = this.getScrollOption(IjVimEditorKt.getVim(editor), rawCount);
            if (scrollOption == 0) {
                int offset = down ? visibleArea.height / 2 : editor.getLineHeight() - visibleArea.height / 2;
                n = editor.yToVisualLine(editor.visualLineToY(caretVisualLine) + offset);
            } else {
                n = down ? caretVisualLine + scrollOption : caretVisualLine - scrollOption;
            }
            int targetCaretVisualLine = n;
            return EngineEditorHelperKt.normalizeVisualLine((VimEditor)IjVimEditorKt.getVim(editor), (int)targetCaretVisualLine);
        }

        private final int getScrollOption(VimEditor editor, int rawCount) {
            if (rawCount == 0) {
                return VimInjectorKt.options((VimInjector)VimInjectorKt.getInjector(), (VimEditor)editor).getScroll();
            }
            VimInjectorKt.options((VimInjector)VimInjectorKt.getInjector(), (VimEditor)editor).setScroll(rawCount);
            return rawCount;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/maddyhome/idea/vim/group/ScrollGroup$ScreenLocation;", "", "<init>", "(Ljava/lang/String;I)V", "TOP", "MIDDLE", "BOTTOM", "IdeaVIM"})
    private static final class ScreenLocation
    extends Enum<ScreenLocation> {
        public static final /* enum */ ScreenLocation TOP = new ScreenLocation();
        public static final /* enum */ ScreenLocation MIDDLE = new ScreenLocation();
        public static final /* enum */ ScreenLocation BOTTOM = new ScreenLocation();
        private static final /* synthetic */ ScreenLocation[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ScreenLocation[] values() {
            return (ScreenLocation[])$VALUES.clone();
        }

        public static ScreenLocation valueOf(String value) {
            return Enum.valueOf(ScreenLocation.class, value);
        }

        @NotNull
        public static EnumEntries<ScreenLocation> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = screenLocationArray = new ScreenLocation[]{ScreenLocation.TOP, ScreenLocation.MIDDLE, ScreenLocation.BOTTOM};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/maddyhome/idea/vim/group/ScrollGroup$ScrollOptionsChangeListener;", "Lcom/maddyhome/idea/vim/options/EffectiveOptionValueChangeListener;", "<init>", "()V", "onEffectiveValueChanged", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "IdeaVIM"})
    @SourceDebugExtension(value={"SMAP\nScrollGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScrollGroup.kt\ncom/maddyhome/idea/vim/group/ScrollGroup$ScrollOptionsChangeListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,294:1\n1#2:295\n*E\n"})
    public static final class ScrollOptionsChangeListener
    implements EffectiveOptionValueChangeListener {
        @NotNull
        public static final ScrollOptionsChangeListener INSTANCE = new ScrollOptionsChangeListener();

        private ScrollOptionsChangeListener() {
        }

        public void onEffectiveValueChanged(@NotNull VimEditor editor) {
            Editor editor2;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Editor $this$onEffectiveValueChanged_u24lambda_u240 = editor2 = IjVimEditorKt.getIj(editor);
            boolean bl = false;
            ScrollViewHelper.scrollCaretIntoView($this$onEffectiveValueChanged_u24lambda_u240);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ScreenLocation.values().length];
            try {
                nArray[ScreenLocation.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScreenLocation.MIDDLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScreenLocation.BOTTOM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

