/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.helper;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.maddyhome.idea.vim.api.EngineEditorHelperBase;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimRangeMarker;
import com.maddyhome.idea.vim.api.VimVisualPosition;
import com.maddyhome.idea.vim.helper.EditorHelper;
import com.maddyhome.idea.vim.helper.InlayHelperKt;
import com.maddyhome.idea.vim.newapi.ExecuteExtensionKt;
import com.maddyhome.idea.vim.newapi.IjVimEditor;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001c\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J\u0018\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J(\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001eH\u0016\u00a8\u0006\u001f"}, d2={"Lcom/maddyhome/idea/vim/helper/IjEditorHelper;", "Lcom/maddyhome/idea/vim/api/EngineEditorHelperBase;", "<init>", "()V", "amountOfInlaysBeforeVisualPosition", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "pos", "Lcom/maddyhome/idea/vim/api/VimVisualPosition;", "getVisualLineAtTopOfScreen", "getApproximateScreenWidth", "getApproximateOutputPanelWidth", "handleWithReadonlyFragmentModificationHandler", "", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getVisualLineAtBottomOfScreen", "inlayAwareOffsetToVisualPosition", "offset", "createRangeMarker", "Lcom/maddyhome/idea/vim/api/VimRangeMarker;", "startOffset", "endOffset", "getVisualLineLength", "visualLine", "normalizeVisualColumn", "col", "allowEnd", "", "IdeaVIM"})
public final class IjEditorHelper
extends EngineEditorHelperBase {
    public int amountOfInlaysBeforeVisualPosition(@NotNull VimEditor editor, @NotNull VimVisualPosition pos) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (!(pos.getLine() >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(pos.getColumn() >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        VisualPosition visualPosition = new VisualPosition(pos.getLine(), pos.getColumn(), pos.getLeansRight());
        return InlayHelperKt.amountOfInlaysBeforeVisualPosition(((IjVimEditor)editor).getEditor(), visualPosition);
    }

    public int getVisualLineAtTopOfScreen(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return EditorHelper.getVisualLineAtTopOfScreen(IjVimEditorKt.getIj(editor));
    }

    public int getApproximateScreenWidth(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return EditorHelper.getApproximateScreenWidth(IjVimEditorKt.getIj(editor));
    }

    public int getApproximateOutputPanelWidth(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return EditorHelper.getApproximateOutputPanelWidth(IjVimEditorKt.getIj(editor));
    }

    public void handleWithReadonlyFragmentModificationHandler(@NotNull VimEditor editor, @NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(IjVimEditorKt.getIj(editor).getDocument()).handle((ReadOnlyFragmentModificationException)exception);
    }

    public int getVisualLineAtBottomOfScreen(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return EditorHelper.getVisualLineAtBottomOfScreen(IjVimEditorKt.getIj(editor));
    }

    @NotNull
    public VimVisualPosition inlayAwareOffsetToVisualPosition(@NotNull VimEditor editor, int offset) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        VisualPosition visualPosition = EditorUtil.inlayAwareOffsetToVisualPosition((Editor)IjVimEditorKt.getIj(editor), (int)offset);
        Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"inlayAwareOffsetToVisualPosition(...)");
        return ExecuteExtensionKt.getVim(visualPosition);
    }

    @NotNull
    public VimRangeMarker createRangeMarker(@NotNull VimEditor editor, int startOffset, int endOffset) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        RangeMarker rangeMarker = IjVimEditorKt.getIj(editor).getDocument().createRangeMarker(startOffset, endOffset);
        Intrinsics.checkNotNullExpressionValue((Object)rangeMarker, (String)"createRangeMarker(...)");
        RangeMarker ijRangeMarker = rangeMarker;
        return new VimRangeMarker(ijRangeMarker){
            final /* synthetic */ RangeMarker $ijRangeMarker;
            {
                this.$ijRangeMarker = $ijRangeMarker;
            }

            public int getStartOffset() {
                return this.$ijRangeMarker.getStartOffset();
            }

            public int getEndOffset() {
                return this.$ijRangeMarker.getEndOffset();
            }

            public boolean isValid() {
                return this.$ijRangeMarker.isValid();
            }

            public void dispose() {
                this.$ijRangeMarker.dispose();
            }
        };
    }

    public int getVisualLineLength(@NotNull VimEditor editor, int visualLine) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return EditorHelper.getVisualLineLength(IjVimEditorKt.getIj(editor), visualLine);
    }

    public int normalizeVisualColumn(@NotNull VimEditor editor, int visualLine, int col, boolean allowEnd) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return EditorHelper.normalizeVisualColumn(IjVimEditorKt.getIj(editor), visualLine, col, allowEnd);
    }
}

