/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.listener;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.LookupManagerListener;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.actions.ChooseItemAction;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManagerListener;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.find.FindModelListener;
import com.intellij.ide.actions.ApplyIntentionAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.AnActionWrapper;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.impl.ProxyShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actions.EnterAction;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.VimPlugin;
import com.maddyhome.idea.vim.action.VimShortcutKeyAction;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjector;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.group.ChangeGroup;
import com.maddyhome.idea.vim.group.NotificationService;
import com.maddyhome.idea.vim.group.RegisterGroup;
import com.maddyhome.idea.vim.helper.CommandStateHelper;
import com.maddyhome.idea.vim.helper.EditorHelperRt;
import com.maddyhome.idea.vim.helper.EngineModeExtensionsKt;
import com.maddyhome.idea.vim.helper.ModeHelper;
import com.maddyhome.idea.vim.listener.IdeaSpecifics;
import com.maddyhome.idea.vim.newapi.IjEditorExecutionContextKt;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import com.maddyhome.idea.vim.newapi.IjVimInjectorKt;
import com.maddyhome.idea.vim.state.mode.Mode;
import com.maddyhome.idea.vim.undo.VimTimestampBasedUndoService;
import com.maddyhome.idea.vim.undo.VimUndoRedo;
import com.maddyhome.idea.vim.vimscript.model.options.helpers.IdeaRefactorModeHelper;
import com.maddyhome.idea.vim.vimscript.model.options.helpers.IdeaRefactorModeHelperKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0004\u0004\u0005\u0006\u0007B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\b"}, d2={"Lcom/maddyhome/idea/vim/listener/IdeaSpecifics;", "", "<init>", "()V", "VimActionListener", "VimTemplateManagerListener", "LookupTopicListener", "VimFindModelListener", "IdeaVIM"})
public final class IdeaSpecifics {
    @NotNull
    public static final IdeaSpecifics INSTANCE = new IdeaSpecifics();

    private IdeaSpecifics() {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/maddyhome/idea/vim/listener/IdeaSpecifics$LookupTopicListener;", "Lcom/intellij/codeInsight/lookup/LookupManagerListener;", "<init>", "()V", "activeLookupChanged", "", "oldLookup", "Lcom/intellij/codeInsight/lookup/Lookup;", "newLookup", "IdeaVIM"})
    public static final class LookupTopicListener
    implements LookupManagerListener {
        public void activeLookupChanged(@Nullable Lookup oldLookup, @Nullable Lookup newLookup) {
            if (VimPlugin.isNotEnabled()) {
                return;
            }
            if (oldLookup == null && newLookup instanceof LookupImpl) {
                Editor editor = ((LookupImpl)newLookup).getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                if (EditorHelperRt.isIdeaVimDisabledHere(editor)) {
                    return;
                }
                VimPlugin.getKey().registerShortcutsForLookup((LookupImpl)newLookup);
            }
            if (oldLookup != null && newLookup == null) {
                Editor editor = oldLookup.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                Editor editor2 = editor;
                if (EditorHelperRt.isIdeaVimDisabledHere(editor2)) {
                    return;
                }
                KeyHandler.Companion.getInstance().partialReset(IjVimEditorKt.getVim(editor2));
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/maddyhome/idea/vim/listener/IdeaSpecifics$VimActionListener;", "Lcom/intellij/openapi/actionSystem/ex/AnActionListener;", "<init>", "()V", "surrounderItems", "", "", "surrounderAction", "editor", "Lcom/intellij/openapi/editor/Editor;", "completionData", "Lcom/maddyhome/idea/vim/listener/IdeaSpecifics$VimActionListener$CompletionData;", "beforeActionPerformed", "", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "afterActionPerformed", "result", "Lcom/intellij/openapi/actionSystem/AnActionResult;", "CompletionData", "IdeaVIM"})
    @SourceDebugExtension(value={"SMAP\nIdeaSpecifics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeaSpecifics.kt\ncom/maddyhome/idea/vim/listener/IdeaSpecifics$VimActionListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,381:1\n1869#2,2:382\n1761#2,3:390\n10468#3:384\n10890#3,5:385\n*S KotlinDebug\n*F\n+ 1 IdeaSpecifics.kt\ncom/maddyhome/idea/vim/listener/IdeaSpecifics$VimActionListener\n*L\n87#1:382,2\n162#1:390,3\n102#1:384\n102#1:385,5\n*E\n"})
    public static final class VimActionListener
    implements AnActionListener {
        @NonNls
        @NotNull
        private final List<String> surrounderItems;
        @NotNull
        private final String surrounderAction;
        @Nullable
        private Editor editor;
        @Nullable
        private CompletionData completionData;

        public VimActionListener() {
            Object[] objectArray = new String[]{"if", "if / else", "for"};
            this.surrounderItems = CollectionsKt.listOf((Object[])objectArray);
            this.surrounderAction = "com.intellij.codeInsight.generation.surroundWith.SurroundWithHandler$InvokeSurrounderAction";
        }

        /*
         * WARNING - void declaration
         */
        public void beforeActionPerformed(@NotNull AnAction action, @NotNull AnActionEvent event) {
            VimCaret it;
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (VimPlugin.isNotEnabled()) {
                return;
            }
            Editor hostEditor = (Editor)event.getDataContext().getData(CommonDataKeys.HOST_EDITOR);
            if (hostEditor != null) {
                this.editor = hostEditor;
            }
            AnActionWrapper anActionWrapper = action instanceof AnActionWrapper ? (AnActionWrapper)action : null;
            boolean isVimAction = (anActionWrapper != null ? anActionWrapper.getDelegate() : null) instanceof VimShortcutKeyAction;
            if (!isVimAction && Intrinsics.areEqual((Object)VimInjectorKt.getInjector().getVimState().getMode(), (Object)Mode.INSERT.INSTANCE) && !(action instanceof EnterAction)) {
                VimUndoRedo vimUndoRedo = VimInjectorKt.getInjector().getUndo();
                Intrinsics.checkNotNull((Object)vimUndoRedo, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.undo.VimTimestampBasedUndoService");
                VimTimestampBasedUndoService undoService = (VimTimestampBasedUndoService)vimUndoRedo;
                long nanoTime = System.nanoTime();
                Object object = this.editor;
                if (object != null && (object = IjVimEditorKt.getVim(object)) != null && (object = object.nativeCarets()) != null) {
                    Iterable $this$forEach$iv = (Iterable)object;
                    int $i$f$forEach = 0;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (VimCaret)element$iv;
                        boolean bl = false;
                        undoService.endInsertSequence(it, it.getOffset(), nanoTime);
                    }
                }
            }
            if (!isVimAction && IjVimInjectorKt.globalIjOptions(VimInjectorKt.getInjector()).getTrackactionids() && !(action instanceof NotificationService.ActionIdNotifier.CopyActionId) && !(action instanceof NotificationService.ActionIdNotifier.StopTracking)) {
                List list;
                String id;
                String string = ActionManager.getInstance().getId(action);
                if (string == null) {
                    ShortcutSet shortcutSet = action.getShortcutSet();
                    ProxyShortcutSet proxyShortcutSet = shortcutSet instanceof ProxyShortcutSet ? (ProxyShortcutSet)shortcutSet : null;
                    string = proxyShortcutSet != null ? proxyShortcutSet.getActionId() : null;
                }
                if ((id = string) == null) {
                    void $this$flatMapTo$iv$iv;
                    Shortcut[] shortcutArray = action.getShortcutSet().getShortcuts();
                    Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"getShortcuts(...)");
                    Object[] $this$flatMap$iv = shortcutArray;
                    boolean $i$f$flatMap = false;
                    Object[] objectArray = $this$flatMap$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$flatMapTo = false;
                    for (void element$iv$iv : $this$flatMapTo$iv$iv) {
                        it = (Shortcut)element$iv$iv;
                        boolean bl = false;
                        List list2 = KeymapManager.getInstance().getActiveKeymap().getActionIdList((Shortcut)it);
                        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getActionIdList(...)");
                        Iterable list$iv$iv = list2;
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                } else {
                    list = CollectionsKt.emptyList();
                }
                List candidates = list;
                String intentionName = action instanceof ApplyIntentionAction ? ((ApplyIntentionAction)action).getName() : null;
                VimPlugin.getNotifications((Project)event.getDataContext().getData(CommonDataKeys.PROJECT)).notifyActionId(id, candidates, intentionName);
            }
            if (hostEditor != null && action instanceof ChooseItemAction && VimInjectorKt.getInjector().getRegisterGroup().isRecording()) {
                LookupElement lookupItem;
                LookupEx lookup;
                LookupEx lookupEx = lookup = LookupManager.getActiveLookup((Editor)hostEditor);
                Object object = lookupItem = lookupEx != null ? lookupEx.getCurrentItem() : null;
                if (lookup instanceof LookupImpl && lookupItem != null) {
                    RangeMarker rangeMarker;
                    int caretOffset = hostEditor.getCaretModel().getPrimaryCaret().getOffset();
                    int completionPrefixLength = ((LookupImpl)lookup).itemMatcher(lookupItem).getPrefix().length() + ((LookupImpl)lookup).getAdditionalPrefix().length();
                    int completionStartOffset = caretOffset - completionPrefixLength;
                    int documentLength = hostEditor.getDocument().getTextLength();
                    int charsToRemove = caretOffset - completionStartOffset;
                    RegisterGroup registerGroup = VimPlugin.getRegister();
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)registerGroup), (String)"getRegister(...)");
                    RegisterGroup register = registerGroup;
                    if (charsToRemove > 0) {
                        KeyStroke backSpaceKey = KeyStroke.getKeyStroke(8, 0);
                        int n = 0;
                        while (n < charsToRemove) {
                            int it2 = n++;
                            boolean bl = false;
                            Intrinsics.checkNotNull((Object)backSpaceKey);
                            register.recordKeyStroke(backSpaceKey);
                        }
                    }
                    RangeMarker $this$beforeActionPerformed_u24lambda_u243 = rangeMarker = hostEditor.getDocument().createRangeMarker(completionStartOffset, completionStartOffset);
                    boolean bl = false;
                    $this$beforeActionPerformed_u24lambda_u243.setGreedyToLeft(true);
                    RangeMarker rangeMarker2 = rangeMarker;
                    Intrinsics.checkNotNullExpressionValue((Object)rangeMarker2, (String)"apply(...)");
                    RangeMarker completionStartMarker = rangeMarker2;
                    this.completionData = new CompletionData(completionStartMarker, completionStartOffset, caretOffset, documentLength - charsToRemove);
                }
            }
        }

        public void afterActionPerformed(@NotNull AnAction action, @NotNull AnActionEvent event, @NotNull AnActionResult result) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            if (VimPlugin.isNotEnabled()) {
                return;
            }
            Editor editor = this.editor;
            if (editor != null && action instanceof ChooseItemAction && VimInjectorKt.getInjector().getRegisterGroup().isRecording()) {
                CompletionData completionData = this.completionData;
                if (completionData != null) {
                    RegisterGroup registerGroup = VimPlugin.getRegister();
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)registerGroup), (String)"getRegister(...)");
                    completionData.recordCompletion(editor, registerGroup);
                }
            }
            if (Intrinsics.areEqual((Object)this.surrounderAction, (Object)action.getClass().getName())) {
                boolean bl;
                block10: {
                    Iterable $this$any$iv = this.surrounderItems;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            String string = action.getTemplatePresentation().getText();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                            if (!StringsKt.endsWith$default((String)string, (String)it, (boolean)false, (int)2, null)) continue;
                            bl = true;
                            break block10;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    Editor editor2 = editor;
                    if (editor2 != null) {
                        Editor it = editor2;
                        boolean bl3 = false;
                        IjVimEditorKt.getVim(it).setMode((Mode)new Mode.NORMAL(null, 1, null));
                        ChangeGroup changeGroup = VimPlugin.getChange();
                        VimEditor vimEditor = IjVimEditorKt.getVim(it);
                        DataContext dataContext = event.getDataContext();
                        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
                        changeGroup.insertBeforeCaret(vimEditor, IjEditorExecutionContextKt.getVim(dataContext));
                        KeyHandler.Companion.getInstance().reset(IjVimEditorKt.getVim(it));
                    }
                }
            }
            this.editor = null;
            CompletionData completionData = this.completionData;
            if (completionData != null) {
                completionData.dispose();
            }
            this.completionData = null;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0011J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J1\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\""}, d2={"Lcom/maddyhome/idea/vim/listener/IdeaSpecifics$VimActionListener$CompletionData;", "", "completionStartMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "originalStartOffset", "", "originalCaretOffset", "originalDocumentLength", "<init>", "(Lcom/intellij/openapi/editor/RangeMarker;III)V", "getCompletionStartMarker", "()Lcom/intellij/openapi/editor/RangeMarker;", "getOriginalStartOffset", "()I", "getOriginalCaretOffset", "getOriginalDocumentLength", "recordCompletion", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "register", "Lcom/maddyhome/idea/vim/group/RegisterGroup;", "dispose", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "IdeaVIM"})
        private static final class CompletionData {
            @NotNull
            private final RangeMarker completionStartMarker;
            private final int originalStartOffset;
            private final int originalCaretOffset;
            private final int originalDocumentLength;

            public CompletionData(@NotNull RangeMarker completionStartMarker, int originalStartOffset, int originalCaretOffset, int originalDocumentLength) {
                Intrinsics.checkNotNullParameter((Object)completionStartMarker, (String)"completionStartMarker");
                this.completionStartMarker = completionStartMarker;
                this.originalStartOffset = originalStartOffset;
                this.originalCaretOffset = originalCaretOffset;
                this.originalDocumentLength = originalDocumentLength;
            }

            @NotNull
            public final RangeMarker getCompletionStartMarker() {
                return this.completionStartMarker;
            }

            public final int getOriginalStartOffset() {
                return this.originalStartOffset;
            }

            public final int getOriginalCaretOffset() {
                return this.originalCaretOffset;
            }

            public final int getOriginalDocumentLength() {
                return this.originalDocumentLength;
            }

            public final void recordCompletion(@NotNull Editor editor, @NotNull RegisterGroup register) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)((Object)register), (String)"register");
                if (!this.completionStartMarker.isValid()) {
                    return;
                }
                int completionStartOffset = this.completionStartMarker.getStartOffset();
                int caretOffset = editor.getCaretModel().getPrimaryCaret().getOffset();
                int completedCharCount = editor.getDocument().getTextLength() - this.originalDocumentLength - (completionStartOffset - this.originalStartOffset);
                int completionEndOffset = completionStartOffset + completedCharCount;
                String string = editor.getDocument().getText(new TextRange(completionStartOffset, completionEndOffset));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String completedText = string;
                register.recordText(completedText);
                int caretShift = completedCharCount - (caretOffset - completionStartOffset);
                if (caretShift > 0) {
                    KeyStroke leftArrowKey = KeyStroke.getKeyStroke(37, 0);
                    int n = 0;
                    while (n < caretShift) {
                        int it = n++;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)leftArrowKey);
                        register.recordKeyStroke(leftArrowKey);
                    }
                }
            }

            public final void dispose() {
                this.completionStartMarker.dispose();
            }

            @NotNull
            public final RangeMarker component1() {
                return this.completionStartMarker;
            }

            public final int component2() {
                return this.originalStartOffset;
            }

            public final int component3() {
                return this.originalCaretOffset;
            }

            public final int component4() {
                return this.originalDocumentLength;
            }

            @NotNull
            public final CompletionData copy(@NotNull RangeMarker completionStartMarker, int originalStartOffset, int originalCaretOffset, int originalDocumentLength) {
                Intrinsics.checkNotNullParameter((Object)completionStartMarker, (String)"completionStartMarker");
                return new CompletionData(completionStartMarker, originalStartOffset, originalCaretOffset, originalDocumentLength);
            }

            public static /* synthetic */ CompletionData copy$default(CompletionData completionData, RangeMarker rangeMarker, int n, int n2, int n3, int n4, Object object) {
                if ((n4 & 1) != 0) {
                    rangeMarker = completionData.completionStartMarker;
                }
                if ((n4 & 2) != 0) {
                    n = completionData.originalStartOffset;
                }
                if ((n4 & 4) != 0) {
                    n2 = completionData.originalCaretOffset;
                }
                if ((n4 & 8) != 0) {
                    n3 = completionData.originalDocumentLength;
                }
                return completionData.copy(rangeMarker, n, n2, n3);
            }

            @NotNull
            public String toString() {
                return "CompletionData(completionStartMarker=" + this.completionStartMarker + ", originalStartOffset=" + this.originalStartOffset + ", originalCaretOffset=" + this.originalCaretOffset + ", originalDocumentLength=" + this.originalDocumentLength + ")";
            }

            public int hashCode() {
                int result = this.completionStartMarker.hashCode();
                result = result * 31 + Integer.hashCode(this.originalStartOffset);
                result = result * 31 + Integer.hashCode(this.originalCaretOffset);
                result = result * 31 + Integer.hashCode(this.originalDocumentLength);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CompletionData)) {
                    return false;
                }
                CompletionData completionData = (CompletionData)other;
                if (!Intrinsics.areEqual((Object)this.completionStartMarker, (Object)completionData.completionStartMarker)) {
                    return false;
                }
                if (this.originalStartOffset != completionData.originalStartOffset) {
                    return false;
                }
                if (this.originalCaretOffset != completionData.originalCaretOffset) {
                    return false;
                }
                return this.originalDocumentLength == completionData.originalDocumentLength;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/maddyhome/idea/vim/listener/IdeaSpecifics$VimFindModelListener;", "Lcom/intellij/find/FindModelListener;", "<init>", "()V", "findNextModelChanged", "", "IdeaVIM"})
    public static final class VimFindModelListener
    implements FindModelListener {
        public void findNextModelChanged() {
            if (VimPlugin.isNotEnabled()) {
                return;
            }
            VimPlugin.getSearch().clearSearchHighlight();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/maddyhome/idea/vim/listener/IdeaSpecifics$VimTemplateManagerListener;", "Lcom/intellij/codeInsight/template/TemplateManagerListener;", "<init>", "()V", "templateStarted", "", "state", "Lcom/intellij/codeInsight/template/impl/TemplateState;", "IdeaVIM"})
    public static final class VimTemplateManagerListener
    implements TemplateManagerListener {
        public void templateStarted(@NotNull TemplateState state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            if (VimPlugin.isNotEnabled()) {
                return;
            }
            Editor editor = state.getEditor();
            if (editor == null) {
                return;
            }
            Editor editor2 = editor;
            state.addTemplateStateListener((TemplateEditingListener)new TemplateEditingAdapter(editor2){
                final /* synthetic */ Editor $editor;
                {
                    this.$editor = $editor;
                }

                public void currentVariableChanged(TemplateState templateState, Template template, int oldIndex, int newIndex) {
                    Intrinsics.checkNotNullParameter((Object)templateState, (String)"templateState");
                    VimEditor vimEditor = IjVimEditorKt.getVim(this.$editor);
                    if (IdeaRefactorModeHelperKt.isIdeaRefactorModeKeep(vimEditor)) {
                        Editor editor = templateState.getEditor();
                        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                        IdeaRefactorModeHelper.INSTANCE.correctEditorSelection(editor);
                    } else {
                        if (this.$editor.getSelectionModel().hasSelection() && !IdeaRefactorModeHelperKt.isIdeaRefactorModeSelect(IjVimEditorKt.getVim(this.$editor))) {
                            TextRange textRange = templateState.getCurrentVariableRange();
                            boolean bl = textRange != null ? textRange.getEndOffset() == this.$editor.getCaretModel().getOffset() : false;
                            if (bl && !StringsKt.contains$default((CharSequence)VimInjectorKt.options((VimInjector)VimInjectorKt.getInjector(), (VimEditor)vimEditor).getSelection(), (CharSequence)"exclusive", (boolean)false, (int)2, null)) {
                                vimEditor.primaryCaret().moveToInlayAwareOffset(RangesKt.coerceAtLeast((int)(this.$editor.getSelectionModel().getSelectionEnd() - 1), (int)this.$editor.getSelectionModel().getSelectionStart()));
                            }
                        }
                        if (newIndex == -1 && templateStarted.1.currentVariableChanged$myIsInline(template) && IdeaRefactorModeHelperKt.isIdeaRefactorModeSelect(vimEditor)) {
                            if (!(vimEditor.getMode() instanceof Mode.NORMAL)) {
                                templateStarted.1.currentVariableChanged$exitMode(vimEditor);
                                vimEditor.setMode((Mode)new Mode.NORMAL(null, 1, null));
                            }
                        } else if (!this.$editor.getSelectionModel().hasSelection() && !CommandStateHelper.getHasVisualSelection(vimEditor.getMode()) || newIndex == -1) {
                            if (IdeaRefactorModeHelperKt.isIdeaRefactorModeSelect(vimEditor)) {
                                if (!(vimEditor.getMode() instanceof Mode.INSERT)) {
                                    templateStarted.1.currentVariableChanged$exitMode(vimEditor);
                                    VimInjectorKt.getInjector().getApplication().runReadAction(() -> templateStarted.1.currentVariableChanged$lambda$0(this.$editor));
                                }
                            } else {
                                vimEditor.setMode((Mode)new Mode.NORMAL(null, 1, null));
                            }
                        }
                    }
                }

                private static final void currentVariableChanged$exitMode(VimEditor $this$currentVariableChanged_u24exitMode) {
                    block1: {
                        Mode mode2;
                        block2: {
                            block0: {
                                mode2 = $this$currentVariableChanged_u24exitMode.getMode();
                                if (!(mode2 instanceof Mode.SELECT)) break block0;
                                ModeHelper.exitSelectMode($this$currentVariableChanged_u24exitMode, false);
                                break block1;
                            }
                            if (!(mode2 instanceof Mode.VISUAL)) break block2;
                            EngineModeExtensionsKt.exitVisualMode((VimEditor)$this$currentVariableChanged_u24exitMode);
                            break block1;
                        }
                        if (!(mode2 instanceof Mode.INSERT)) break block1;
                        $this$currentVariableChanged_u24exitMode.exitInsertMode(VimInjectorKt.getInjector().getExecutionContextManager().getEditorExecutionContext($this$currentVariableChanged_u24exitMode));
                    }
                }

                private static final boolean currentVariableChanged$myIsInline(Template $this$currentVariableChanged_u24myIsInline) {
                    return $this$currentVariableChanged_u24myIsInline instanceof TemplateImpl && ((TemplateImpl)$this$currentVariableChanged_u24myIsInline).isInline();
                }

                private static final Unit currentVariableChanged$lambda$0(Editor $editor) {
                    ExecutionContext context = VimInjectorKt.getInjector().getExecutionContextManager().getEditorExecutionContext(IjVimEditorKt.getVim($editor));
                    VimPlugin.getChange().insertBeforeCaret(IjVimEditorKt.getVim($editor), context);
                    return Unit.INSTANCE;
                }
            });
        }
    }
}

