/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.newapi;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.maddyhome.idea.vim.api.VimDocument;
import com.maddyhome.idea.vim.common.ChangesListener;
import com.maddyhome.idea.vim.common.LiveRange;
import com.maddyhome.idea.vim.newapi.IjLiveRangeKt;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/maddyhome/idea/vim/newapi/IjVimDocument;", "Lcom/maddyhome/idea/vim/api/VimDocument;", "document", "Lcom/intellij/openapi/editor/Document;", "<init>", "(Lcom/intellij/openapi/editor/Document;)V", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "changeListenersMap", "", "Lcom/maddyhome/idea/vim/common/ChangesListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "addChangeListener", "", "listener", "removeChangeListener", "getOffsetGuard", "Lcom/maddyhome/idea/vim/common/LiveRange;", "offset", "", "IdeaVIM"})
public final class IjVimDocument
implements VimDocument {
    @NotNull
    private final Document document;
    @NotNull
    private final Map<ChangesListener, DocumentListener> changeListenersMap;

    public IjVimDocument(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.document = document;
        this.changeListenersMap = new LinkedHashMap();
    }

    @NotNull
    public final Document getDocument() {
        return this.document;
    }

    public void addChangeListener(@NotNull ChangesListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        DocumentListener nativeListener2 = new DocumentListener(listener2){
            final /* synthetic */ ChangesListener $listener;
            {
                this.$listener = $listener;
            }

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$listener.documentChanged(new ChangesListener.Change(((Object)event.getOldFragment()).toString(), ((Object)event.getNewFragment()).toString(), event.getOffset()));
            }
        };
        this.changeListenersMap.put(listener2, nativeListener2);
        this.document.addDocumentListener(nativeListener2);
    }

    public void removeChangeListener(@NotNull ChangesListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        DocumentListener documentListener = this.changeListenersMap.remove(listener2);
        if (documentListener == null) {
            throw new IllegalStateException("Existing listener expected".toString());
        }
        DocumentListener nativeListener2 = documentListener;
        this.document.removeDocumentListener(nativeListener2);
    }

    @Nullable
    public LiveRange getOffsetGuard(int offset) {
        RangeMarker rangeMarker = this.document.getOffsetGuard(offset);
        return rangeMarker != null ? IjLiveRangeKt.getVim(rangeMarker) : null;
    }
}

