/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.newapi;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjector;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimMessagesBase;
import com.maddyhome.idea.vim.helper.EngineMessageHelper;
import com.maddyhome.idea.vim.newapi.IjVimEditorKt;
import com.maddyhome.idea.vim.ui.ShowCmd;
import java.awt.Toolkit;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010\u0010\u001a\u00020\fH\u0016J\b\u0010\u0011\u001a\u00020\fH\u0016J\b\u0010\u0012\u001a\u00020\fH\u0016J\b\u0010\u0013\u001a\u00020\u0007H\u0016J)\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\"\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/maddyhome/idea/vim/newapi/IjVimMessages;", "Lcom/maddyhome/idea/vim/api/VimMessagesBase;", "<init>", "()V", "message", "", "error", "", "lastBeepTimeMillis", "", "allowClearStatusBarMessage", "showStatusBarMessage", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "getStatusBarMessage", "clearStatusBarMessage", "indicateError", "clearError", "isError", "key", "params", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "updateStatusBar", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nIjVimMessages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IjVimMessages.kt\ncom/maddyhome/idea/vim/newapi/IjVimMessages\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,109:1\n13805#2,2:110\n13805#2,2:112\n*S KotlinDebug\n*F\n+ 1 IjVimMessages.kt\ncom/maddyhome/idea/vim/newapi/IjVimMessages\n*L\n46#1:110,2\n72#1:112,2\n*E\n"})
public final class IjVimMessages
extends VimMessagesBase {
    @Nullable
    private String message;
    private boolean error;
    private long lastBeepTimeMillis;
    private boolean allowClearStatusBarMessage = true;

    public void showStatusBarMessage(@Nullable VimEditor editor, @Nullable String message) {
        Project project;
        this.message = message;
        VimEditor vimEditor = editor;
        Project project2 = vimEditor != null && (vimEditor = IjVimEditorKt.getIj(vimEditor)) != null ? vimEditor.getProject() : (project = null);
        if (project != null) {
            IjVimMessages.showStatusBarMessage$setStatusBarMessage(project, message);
        } else {
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            Object[] $this$forEach$iv = projectArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Project it = (Project)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                IjVimMessages.showStatusBarMessage$setStatusBarMessage(it, message);
            }
        }
        this.allowClearStatusBarMessage = false;
        ApplicationManager.getApplication().invokeLater(() -> IjVimMessages.showStatusBarMessage$lambda$2(this));
    }

    @Nullable
    public String getStatusBarMessage() {
        return this.message;
    }

    public void clearStatusBarMessage() {
        String currentMessage = this.message;
        CharSequence charSequence = currentMessage;
        if (charSequence == null || charSequence.length() == 0) {
            return;
        }
        if (!this.allowClearStatusBarMessage) {
            return;
        }
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        Object[] $this$forEach$iv = projectArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StatusBar statusBar;
            Project project = (Project)element$iv;
            boolean bl = false;
            if (WindowManager.getInstance().getStatusBar(project) == null) continue;
            boolean bl2 = false;
            String string = statusBar.getInfo();
            boolean bl3 = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)currentMessage, (boolean)false, (int)2, null) : false;
            if (!bl3) continue;
            statusBar.setInfo("");
        }
        this.message = null;
    }

    public void indicateError() {
        long currentTimeMillis;
        this.error = true;
        if (!ApplicationManager.getApplication().isUnitTestMode() && !VimInjectorKt.globalOptions((VimInjector)VimInjectorKt.getInjector()).getVisualbell() && (currentTimeMillis = System.currentTimeMillis()) - this.lastBeepTimeMillis > 500L) {
            Toolkit.getDefaultToolkit().beep();
            this.lastBeepTimeMillis = currentTimeMillis;
        }
    }

    public void clearError() {
        this.error = false;
    }

    public boolean isError() {
        return this.error;
    }

    @NotNull
    public String message(@NotNull String key, Object ... params) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return EngineMessageHelper.message((String)key, (Object[])Arrays.copyOf(params, params.length));
    }

    public void updateStatusBar(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        ShowCmd.INSTANCE.update();
    }

    private static final void showStatusBarMessage$setStatusBarMessage(Project project, String message) {
        block0: {
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
            if (statusBar == null) break block0;
            StatusBar it = statusBar;
            boolean bl = false;
            CharSequence charSequence = message;
            it.setInfo((String)(charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? "" : "Vim - " + message));
        }
    }

    private static final void showStatusBarMessage$lambda$2(IjVimMessages this$0) {
        this$0.allowClearStatusBarMessage = true;
    }
}

