/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.io.FileUtil;
import com.maddyhome.idea.vim.api.VimrcFileState;
import com.maddyhome.idea.vim.vimscript.model.Script;
import com.maddyhome.idea.vim.vimscript.parser.VimscriptParser;
import java.nio.file.Path;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0016\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nJ\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u0012H\u0007J\u0014\u0010\u001d\u001a\u00020\u00122\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\u0014\u0010\u001f\u001a\u00020\u00122\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR*\u0010\u000f\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u0010j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0011`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/maddyhome/idea/vim/ui/VimRcFileState;", "Lcom/maddyhome/idea/vim/api/VimrcFileState;", "<init>", "()V", "state", "", "Ljava/lang/Integer;", "modificationStamp", "", "filePath", "", "getFilePath", "()Ljava/lang/String;", "setFilePath", "(Ljava/lang/String;)V", "saveStateListeners", "Ljava/util/ArrayList;", "Lkotlin/Function0;", "", "Lkotlin/collections/ArrayList;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "saveFileState", "text", "equalTo", "", "document", "Lcom/intellij/openapi/editor/Document;", "clear", "whenFileStateSaved", "action", "unregisterStateListener", "IdeaVIM"})
@SourceDebugExtension(value={"SMAP\nReloadVimRc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReloadVimRc.kt\ncom/maddyhome/idea/vim/ui/VimRcFileState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,180:1\n1869#2,2:181\n1#3:183\n13#4:184\n*S KotlinDebug\n*F\n+ 1 ReloadVimRc.kt\ncom/maddyhome/idea/vim/ui/VimRcFileState\n*L\n67#1:181,2\n61#1:184\n*E\n"})
public final class VimRcFileState
implements VimrcFileState {
    @NotNull
    public static final VimRcFileState INSTANCE = new VimRcFileState();
    @Nullable
    private static Integer state;
    private static long modificationStamp;
    @Nullable
    private static String filePath;
    @NotNull
    private static final ArrayList<Function0<Unit>> saveStateListeners;
    @NotNull
    private static final Logger LOG;

    private VimRcFileState() {
    }

    @Nullable
    public String getFilePath() {
        return filePath;
    }

    public void setFilePath(@Nullable String string) {
        filePath = string;
    }

    public final void saveFileState(@NotNull String filePath, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.setFilePath(FileUtil.toSystemDependentName((String)filePath));
        Script script = VimscriptParser.INSTANCE.parse(text);
        state = script.hashCode();
        Iterable $this$forEach$iv = saveStateListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    public void saveFileState(@NotNull String filePath) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Path it = Path.of(filePath, new String[0]);
        boolean bl = false;
        try {
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            object = Result.constructor-impl((Object)PathsKt.readText$default((Path)it, null, (int)1, null));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable throwable2;
            Throwable it2 = throwable2 = throwable;
            boolean bl3 = false;
            LOG.error(it2);
        }
        String string = (String)(Result.isFailure-impl((Object)object) ? null : object);
        String string2 = string;
        if (string == null) {
            string2 = "";
        }
        String ideaVimRcText = string2;
        this.saveFileState(filePath, ideaVimRcText);
    }

    public final boolean equalTo(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        long fileModificationStamp = document.getModificationStamp();
        if (fileModificationStamp == modificationStamp) {
            return true;
        }
        String documentString = ((Object)document.getCharsSequence()).toString();
        Script script = VimscriptParser.INSTANCE.parse(documentString);
        Integer n = state;
        if (n == null || script.hashCode() != n.intValue()) {
            return false;
        }
        modificationStamp = fileModificationStamp;
        return true;
    }

    @TestOnly
    public final void clear() {
        state = null;
        modificationStamp = 0L;
        this.setFilePath(null);
    }

    public final void whenFileStateSaved(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        if (this.getFilePath() != null) {
            action.invoke();
        }
        saveStateListeners.add(action);
    }

    public final void unregisterStateListener(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        saveStateListeners.remove(action);
    }

    static {
        saveStateListeners = new ArrayList();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(VimRcFileState.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

