/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.api;

import com.maddyhome.idea.vim.api.VimPathExpansion;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/maddyhome/idea/vim/api/VimPathExpansionImpl;", "Lcom/maddyhome/idea/vim/api/VimPathExpansion;", "<init>", "()V", "expandPath", "", "path", "expandForOption", "value", "doExpand", "input", "expandToEmptyIfNotFound", "", "expandTilde", "expandEnvironmentVariables", "text", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nVimPathExpansionImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimPathExpansionImpl.kt\ncom/maddyhome/idea/vim/api/VimPathExpansionImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1#2:107\n*E\n"})
public final class VimPathExpansionImpl
implements VimPathExpansion {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex ENV_VAR_REGEX = new Regex("(\\\\?)\\$(?:([A-Za-z_][A-Za-z0-9_]*)|(?:\\{([A-Za-z_][A-Za-z0-9_]*)\\}))");

    @Override
    @NotNull
    public String expandPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.doExpand(path, true);
    }

    @Override
    @NotNull
    public String expandForOption(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.doExpand(value, false);
    }

    private final String doExpand(String input, boolean expandToEmptyIfNotFound) {
        String expanded = input;
        expanded = this.expandTilde(expanded);
        expanded = this.expandEnvironmentVariables(expanded, expandToEmptyIfNotFound);
        return expanded;
    }

    private final String expandTilde(String path) {
        String home;
        if ((Intrinsics.areEqual((Object)path, (Object)"~") || StringsKt.startsWith$default((String)path, (String)"~/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)path, (String)"~\\", (boolean)false, (int)2, null)) && (home = System.getProperty("user.home")) != null) {
            String string = path.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return home + string;
        }
        return path;
    }

    private final String expandEnvironmentVariables(String text, boolean expandToEmptyIfNotFound) {
        return ENV_VAR_REGEX.replace((CharSequence)text, arg_0 -> VimPathExpansionImpl.expandEnvironmentVariables$lambda$0(expandToEmptyIfNotFound, arg_0));
    }

    private static final CharSequence expandEnvironmentVariables$lambda$0(boolean $expandToEmptyIfNotFound, MatchResult matchResult) {
        CharSequence charSequence;
        CharSequence charSequence2;
        Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
        String escaped = (String)matchResult.getGroupValues().get(1);
        CharSequence charSequence3 = (CharSequence)matchResult.getGroupValues().get(2);
        if (charSequence3.length() == 0) {
            boolean bl = false;
            charSequence2 = (String)matchResult.getGroupValues().get(3);
        } else {
            charSequence2 = charSequence3;
        }
        String varName = (String)charSequence2;
        if (((CharSequence)escaped).length() > 0) {
            String string = matchResult.getValue().substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            charSequence = string;
        } else {
            String value = System.getenv(varName);
            charSequence = value != null ? value : ($expandToEmptyIfNotFound ? "" : matchResult.getValue());
        }
        return charSequence;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/maddyhome/idea/vim/api/VimPathExpansionImpl$Companion;", "", "<init>", "()V", "ENV_VAR_REGEX", "Lkotlin/text/Regex;", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

