/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.api;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimrcFileState;
import com.maddyhome.idea.vim.api.VimscriptExecutor;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.ex.FinishException;
import com.maddyhome.idea.vim.history.VimHistory;
import com.maddyhome.idea.vim.register.Register;
import com.maddyhome.idea.vim.vimscript.model.CommandLineVimLContext;
import com.maddyhome.idea.vim.vimscript.model.Executable;
import com.maddyhome.idea.vim.vimscript.model.ExecutionResult;
import com.maddyhome.idea.vim.vimscript.model.Script;
import com.maddyhome.idea.vim.vimscript.model.VimLContext;
import com.maddyhome.idea.vim.vimscript.model.commands.Command;
import com.maddyhome.idea.vim.vimscript.model.commands.RepeatCommand;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH$J(\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0016J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH$J\u0018\u0010\"\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000b\u00a8\u0006#"}, d2={"Lcom/maddyhome/idea/vim/api/VimScriptExecutorBase;", "Lcom/maddyhome/idea/vim/api/VimscriptExecutor;", "<init>", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "executingVimscript", "", "getExecutingVimscript", "()Z", "setExecutingVimscript", "(Z)V", "executingIdeaVimRcConfiguration", "getExecutingIdeaVimRcConfiguration", "setExecutingIdeaVimRcConfiguration", "execute", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "script", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "skipHistory", "indicateErrors", "vimContext", "Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "enableDelayedExtensions", "", "executeFile", "file", "Ljava/io/File;", "fileIsIdeaVimRcConfig", "ensureFileIsSaved", "executeLastCommand", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nVimScriptExecutorBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimScriptExecutorBase.kt\ncom/maddyhome/idea/vim/api/VimScriptExecutorBase\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,131:1\n39#2:132\n1869#3,2:133\n*S KotlinDebug\n*F\n+ 1 VimScriptExecutorBase.kt\ncom/maddyhome/idea/vim/api/VimScriptExecutorBase\n*L\n25#1:132\n43#1:133,2\n*E\n"})
public abstract class VimScriptExecutorBase
implements VimscriptExecutor {
    @NotNull
    private final VimLogger logger;
    private boolean executingVimscript;
    private boolean executingIdeaVimRcConfiguration;

    public VimScriptExecutorBase() {
        boolean $i$f$vimLogger = false;
        this.logger = VimInjectorKt.getInjector().getLogger(VimScriptExecutorBase.class);
    }

    @Override
    public boolean getExecutingVimscript() {
        return this.executingVimscript;
    }

    @Override
    public void setExecutingVimscript(boolean bl) {
        this.executingVimscript = bl;
    }

    @Override
    public boolean getExecutingIdeaVimRcConfiguration() {
        return this.executingIdeaVimRcConfiguration;
    }

    @Override
    public void setExecutingIdeaVimRcConfiguration(boolean bl) {
        this.executingIdeaVimRcConfiguration = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ExecutionResult execute(@NotNull String script, @NotNull VimEditor editor, @NotNull ExecutionContext context, boolean skipHistory, boolean indicateErrors, @Nullable VimLContext vimContext) throws ExException {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            VimInjectorKt.getInjector().getVimscriptExecutor().setExecutingVimscript(true);
            ExecutionResult finalResult = ExecutionResult.Success.INSTANCE;
            Script myScript = VimInjectorKt.getInjector().getVimscriptParser().parse(script);
            Iterable $this$forEach$iv = myScript.getUnits();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Executable it = (Executable)element$iv;
                boolean bl = false;
                VimLContext vimLContext = vimContext;
                if (vimLContext == null) {
                    vimLContext = myScript;
                }
                it.setVimContext(vimLContext);
            }
            if (!skipHistory) {
                VimInjectorKt.getInjector().getHistoryGroup().addEntry(VimHistory.Type.Command.INSTANCE, script);
            }
            for (Executable unit : myScript.getUnits()) {
                try {
                    ExecutionResult result = unit.execute(editor, context);
                    if (!(result instanceof ExecutionResult.Error)) continue;
                    finalResult = ExecutionResult.Error.INSTANCE;
                    if (!indicateErrors) continue;
                    VimInjectorKt.getInjector().getMessages().indicateError();
                }
                catch (ExException e) {
                    if (e instanceof FinishException) break;
                    finalResult = ExecutionResult.Error.INSTANCE;
                    if (indicateErrors) {
                        VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, e.getMessage());
                        VimInjectorKt.getInjector().getMessages().indicateError();
                        continue;
                    }
                    this.logger.warn("Failed while executing " + unit + ". " + e.getMessage());
                }
                catch (NotImplementedError e) {
                    if (!indicateErrors) continue;
                    VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, "Not implemented yet :(");
                    VimInjectorKt.getInjector().getMessages().indicateError();
                }
                catch (Exception e) {
                    this.logger.warn(e.toString());
                    if (!VimInjectorKt.getInjector().getApplication().isUnitTest()) continue;
                    throw e;
                }
            }
            if (!skipHistory && myScript.getUnits().size() == 1 && myScript.getUnits().get(0) instanceof Command && !(myScript.getUnits().get(0) instanceof RepeatCommand)) {
                VimInjectorKt.getInjector().getRegisterGroup().storeTextSpecial(':', script);
            }
            ExecutionResult executionResult = finalResult;
            return executionResult;
        }
        finally {
            VimInjectorKt.getInjector().getVimscriptExecutor().setExecutingVimscript(false);
            this.enableDelayedExtensions();
        }
    }

    protected abstract void enableDelayedExtensions();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeFile(@NotNull File file, @NotNull VimEditor editor, boolean fileIsIdeaVimRcConfig, boolean indicateErrors) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        ExecutionContext context = VimInjectorKt.getInjector().getExecutionContextManager().getEditorExecutionContext(editor);
        try {
            if (fileIsIdeaVimRcConfig) {
                VimInjectorKt.getInjector().getVimscriptExecutor().setExecutingIdeaVimRcConfiguration(true);
            }
            this.ensureFileIsSaved(file);
            VimscriptExecutor.execute$default(this, FilesKt.readText$default((File)file, null, (int)1, null), editor, context, true, indicateErrors, null, 32, null);
        }
        catch (IOException e) {
            if (indicateErrors) {
                VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, "Cannot read file \"" + file.getPath() + "\": " + e.getMessage());
                VimInjectorKt.getInjector().getMessages().indicateError();
            } else {
                this.logger.warn("Failed to read file " + file.getPath() + ": " + e.getMessage());
            }
        }
        finally {
            if (fileIsIdeaVimRcConfig) {
                VimrcFileState vimrcFileState = VimInjectorKt.getInjector().getVimrcFileState();
                String string = file.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
                vimrcFileState.saveFileState(string);
                VimInjectorKt.getInjector().getVimscriptExecutor().setExecutingIdeaVimRcConfiguration(false);
            }
        }
    }

    protected abstract void ensureFileIsSaved(@NotNull File var1);

    @Override
    public boolean executeLastCommand(@NotNull VimEditor editor, @NotNull ExecutionContext context) throws ExException {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Register register = VimInjectorKt.getInjector().getRegisterGroup().getRegister(editor, context, ':');
        if (register == null) {
            return false;
        }
        Register reg = register;
        String string = reg.getText();
        if (string == null) {
            return false;
        }
        String text = string;
        this.execute(text, editor, context, false, true, CommandLineVimLContext.INSTANCE);
        return true;
    }
}

