/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.api;

import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimSearchHelper;
import com.maddyhome.idea.vim.common.Direction;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.helper.CharacterHelper;
import com.maddyhome.idea.vim.helper.SearchOptions;
import com.maddyhome.idea.vim.options.helpers.KeywordOptionHelper;
import com.maddyhome.idea.vim.regexp.VimRegex;
import com.maddyhome.idea.vim.regexp.VimRegexException;
import com.maddyhome.idea.vim.regexp.VimRegexOptions;
import com.maddyhome.idea.vim.regexp.match.VimMatchResult;
import com.maddyhome.idea.vim.state.mode.EditorExtensionsKt;
import com.maddyhome.idea.vim.state.mode.Mode;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0013\b&\u0018\u0000 \u008c\u00012\u00020\u0001:\u0002\u008c\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0016J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0016J(\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\nH\u0016J(\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\nH\u0016J\"\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\"\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J \u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J \u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J \u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J(\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0015H\u0016J0\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0015H\u0016J0\u0010 \u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u0015H\u0016J<\u0010\"\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u000e\u0010&\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010'H\u0016J>\u0010)\u001a\u00020*2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00052\f\u0010.\u001a\b\u0012\u0004\u0012\u00020/0'2\u0006\u00100\u001a\u00020\u00152\u0006\u00101\u001a\u00020\u0015H\u0002J>\u00102\u001a\u00020*2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00052\f\u0010.\u001a\b\u0012\u0004\u0012\u00020/0'2\u0006\u00100\u001a\u00020\u00152\u0006\u00101\u001a\u00020\u0015H\u0002J6\u00103\u001a\b\u0012\u0004\u0012\u00020\u0013042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010#\u001a\u00020$2\u0006\u00105\u001a\u00020\u00052\u0006\u00106\u001a\u00020\u00052\u0006\u00107\u001a\u00020\u0015H\u0016J2\u00108\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00152\b\b\u0002\u0010:\u001a\u00020\u0015H\u0002J2\u0010;\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00152\b\b\u0002\u0010<\u001a\u00020\u0015H\u0002J8\u0010=\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00152\u0006\u0010>\u001a\u00020\u0015H\u0002J2\u0010?\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00152\b\b\u0002\u0010@\u001a\u00020\u0015H\u0002J\u0018\u0010A\u001a\u00020\u00152\u0006\u00109\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J8\u0010B\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00109\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010C\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020D2\u0006\u0010E\u001a\u00020\u0015H\u0002J\u0010\u0010F\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\u0018\u0010G\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J'\u0010H\u001a\u0004\u0018\u00010\u00052\u0006\u00109\u001a\u00020\u00192\u0006\u0010-\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010IJ'\u0010J\u001a\u0004\u0018\u00010\u00052\u0006\u00109\u001a\u00020\u00192\u0006\u0010K\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010IJ'\u0010L\u001a\u0004\u0018\u00010\u00052\u0006\u00109\u001a\u00020\u00192\u0006\u0010-\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010IJ'\u0010M\u001a\u0004\u0018\u00010\u00052\u0006\u00109\u001a\u00020\u00192\u0006\u0010K\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010IJ/\u0010N\u001a\u0004\u0018\u00010\u00052\u0006\u00109\u001a\u00020\u00192\u0006\u0010-\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020OH\u0002\u00a2\u0006\u0002\u0010PJ/\u0010Q\u001a\u0004\u0018\u00010\u00052\u0006\u00109\u001a\u00020\u00192\u0006\u0010-\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020OH\u0002\u00a2\u0006\u0002\u0010PJ'\u0010N\u001a\u0004\u0018\u00010\u00052\u0006\u00109\u001a\u00020\u00192\u0006\u0010-\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020OH\u0002\u00a2\u0006\u0002\u0010RJ'\u0010Q\u001a\u0004\u0018\u00010\u00052\u0006\u00109\u001a\u00020\u00192\u0006\u0010-\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020OH\u0002\u00a2\u0006\u0002\u0010RJ*\u0010S\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010T\u001a\u00020\n2\u0006\u0010U\u001a\u00020\u0015H\u0016J*\u0010S\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010T\u001a\u00020\n2\u0006\u0010U\u001a\u00020\u0015H\u0016J.\u0010V\u001a\u00020\u0005*\u00020\u00192\u0006\u0010W\u001a\u00020\n2\u0006\u0010X\u001a\u00020\u00052\u0006\u0010Y\u001a\u00020\u00152\b\b\u0002\u0010Z\u001a\u00020\u0015H\u0002J5\u0010[\u001a\u0004\u0018\u00010\u0005*\u00020\u00192\u0006\u0010W\u001a\u00020\n2\u0006\u0010-\u001a\u00020\u00052\u0006\u0010Y\u001a\u00020\u00152\b\b\u0002\u0010Z\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\\J5\u0010]\u001a\u0004\u0018\u00010\u0005*\u00020\u00192\u0006\u0010W\u001a\u00020\n2\u0006\u0010K\u001a\u00020\u00052\u0006\u0010Y\u001a\u00020\u00152\b\b\u0002\u0010Z\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\\J?\u0010^\u001a\u0004\u0018\u00010\u00052\u0006\u0010_\u001a\u00020\u00192\u0006\u0010W\u001a\u00020\n2\u0006\u0010-\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020O2\u0006\u0010Y\u001a\u00020\u00152\u0006\u0010Z\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010`J \u0010a\u001a\u00020\u00152\u0006\u00109\u001a\u00020\u00192\u0006\u0010b\u001a\u00020\u00052\u0006\u0010T\u001a\u00020\nH\u0002JT\u0010c\u001a!\u0018\u00010\u0005\u00a2\u0006\u001a\bd\u0012\b\be\u0012\u0004\b\u0004\u0010\u0000\u0012\f\bf\u0012\b\b\u0004\u0010\u00fe\u00ff\u00ff\u00ff\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010g\u001a\u00020\u00152\u0006\u0010h\u001a\u00020\u0015H\u0017\u00a2\u0006\u0002\u0010iJT\u0010c\u001a!\u0018\u00010\u0005\u00a2\u0006\u001a\bd\u0012\b\be\u0012\u0004\b\u0004\u0010\u0000\u0012\f\bf\u0012\b\b\u0004\u0010\u00fe\u00ff\u00ff\u00ff\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010g\u001a\u00020\u00152\u0006\u0010h\u001a\u00020\u0015H\u0017\u00a2\u0006\u0002\u0010jJT\u0010k\u001a!\u0018\u00010\u0005\u00a2\u0006\u001a\bd\u0012\b\be\u0012\u0004\b\u0004\u0010\u0000\u0012\f\bf\u0012\b\b\u0004\u0010\u00fe\u00ff\u00ff\u00ff\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010g\u001a\u00020\u00152\u0006\u0010h\u001a\u00020\u0015H\u0017\u00a2\u0006\u0002\u0010iJT\u0010k\u001a!\u0018\u00010\u0005\u00a2\u0006\u001a\bd\u0012\b\be\u0012\u0004\b\u0004\u0010\u0000\u0012\f\bf\u0012\b\b\u0004\u0010\u00fe\u00ff\u00ff\u00ff\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010g\u001a\u00020\u00152\u0006\u0010h\u001a\u00020\u0015H\u0017\u00a2\u0006\u0002\u0010jJ\\\u0010l\u001a!\u0018\u00010\u0005\u00a2\u0006\u001a\bd\u0012\b\be\u0012\u0004\b\u0004\u0010\u0000\u0012\f\bf\u0012\b\b\u0004\u0010\u00fe\u00ff\u00ff\u00ff\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00109\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010m\u001a\u00020\u00052\u0006\u0010n\u001a\u00020O2\u0006\u0010g\u001a\u00020\u0015H\u0003\u00a2\u0006\u0002\u0010oJ\\\u0010p\u001a!\u0018\u00010\u0005\u00a2\u0006\u001a\bd\u0012\b\be\u0012\u0004\b\u0004\u0010\u0000\u0012\f\bf\u0012\b\b\u0004\u0010\u00fe\u00ff\u00ff\u00ff\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00109\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010m\u001a\u00020\u00052\u0006\u0010n\u001a\u00020O2\u0006\u0010g\u001a\u00020\u0015H\u0003\u00a2\u0006\u0002\u0010oJ]\u0010q\u001a\u001f0\u0005\u00a2\u0006\u001a\bd\u0012\b\be\u0012\u0004\b\u0004\u0010\u0000\u0012\f\bf\u0012\b\b\u0004\u0010\u00fe\u00ff\u00ff\u00ff\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00109\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010m\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010U\u001a\u00020\u00152\u0006\u0010r\u001a\u00020\u0015H\u0003J(\u0010s\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010U\u001a\u00020\u0015H\u0017JL\u0010t\u001a!\u0018\u00010\u0005\u00a2\u0006\u001a\bd\u0012\b\be\u0012\u0004\b\u0004\u0010\u0000\u0012\f\bf\u0012\b\b\u0004\u0010\u00fe\u00ff\u00ff\u00ff\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010u\u001a\u00020\u0015H\u0017\u00a2\u0006\u0002\u0010vJL\u0010t\u001a!\u0018\u00010\u0005\u00a2\u0006\u001a\bd\u0012\b\be\u0012\u0004\b\u0004\u0010\u0000\u0012\f\bf\u0012\b\b\u0004\u0010\u00fe\u00ff\u00ff\u00ff\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010u\u001a\u00020\u0015H\u0017\u00a2\u0006\u0002\u0010wJE\u0010t\u001a\u001f0\u0005\u00a2\u0006\u001a\bd\u0012\b\be\u0012\u0004\b\u0004\u0010\u0000\u0012\f\bf\u0012\b\b\u0004\u0010\u00fe\u00ff\u00ff\u00ff\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020O2\u0006\u0010u\u001a\u00020\u0015H\u0003J*\u0010x\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010U\u001a\u00020\u0015H\u0017J*\u0010x\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010U\u001a\u00020\u0015H\u0017J.\u0010y\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010z2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0003J.\u0010{\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010z2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002J=\u0010|\u001a\u001f0\u0005\u00a2\u0006\u001a\bd\u0012\b\be\u0012\u0004\b\u0004\u0010\u0000\u0012\f\bf\u0012\b\b\u0004\u0010\u00fe\u00ff\u00ff\u00ff\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020OH\u0003JL\u0010}\u001a!\u0018\u00010\u0005\u00a2\u0006\u001a\bd\u0012\b\be\u0012\u0004\b\u0004\u0010\u0000\u0012\f\bf\u0012\b\b\u0004\u0010\u00fe\u00ff\u00ff\u00ff\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010u\u001a\u00020\u0015H\u0003\u00a2\u0006\u0002\u0010vJL\u0010}\u001a!\u0018\u00010\u0005\u00a2\u0006\u001a\bd\u0012\b\be\u0012\u0004\b\u0004\u0010\u0000\u0012\f\bf\u0012\b\b\u0004\u0010\u00fe\u00ff\u00ff\u00ff\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020O2\u0006\u0010u\u001a\u00020\u0015H\u0003\u00a2\u0006\u0002\u0010~JE\u0010\u007f\u001a\u001f0\u0005\u00a2\u0006\u001a\bd\u0012\b\be\u0012\u0004\b\u0004\u0010\u0000\u0012\f\bf\u0012\b\b\u0004\u0010\u00fe\u00ff\u00ff\u00ff\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020O2\u0006\u0010u\u001a\u00020\u0015H\u0003J1\u0010\u0080\u0001\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010U\u001a\u00020\u00152\u0006\u0010E\u001a\u00020\u0015H\u0016J+\u0010\u0081\u0001\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010U\u001a\u00020\u0015H\u0016J$\u0010\u0082\u0001\u001a\u00020\u00052\u0007\u0010\u0083\u0001\u001a\u00020\u00192\u0007\u0010\u0084\u0001\u001a\u00020\u00052\u0007\u0010\u0085\u0001\u001a\u00020\u0005H\u0002J#\u0010\u0086\u0001\u001a\u00020\u00152\u0007\u0010\u0087\u0001\u001a\u00020\u00192\u0006\u0010b\u001a\u00020\u00052\u0007\u0010\u0088\u0001\u001a\u00020\u0015H\u0002J%\u0010\u0089\u0001\u001a\u0004\u0018\u00010\u00132\u0007\u0010\u0087\u0001\u001a\u00020\u00192\u0006\u0010b\u001a\u00020\u00052\u0007\u0010\u008a\u0001\u001a\u00020$H\u0002J0\u0010\u008b\u0001\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020$\u0018\u00010z2\u0007\u0010\u0087\u0001\u001a\u00020\u00192\u0006\u0010b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002\u00a8\u0006\u008d\u0001"}, d2={"Lcom/maddyhome/idea/vim/api/VimSearchHelperBase;", "Lcom/maddyhome/idea/vim/api/VimSearchHelper;", "<init>", "()V", "findSection", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "line", "type", "", "direction", "count", "caret", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "findNextCharacterOnLine", "offset", "ch", "findWordAtOrFollowingCursor", "Lcom/maddyhome/idea/vim/common/TextRange;", "isBigWord", "", "findFilenameAtOrFollowingCursor", "moveForwardsToStartOfFilename", "text", "", "start", "moveBackwardsToStartOfFilename", "moveForwardsToEndOfFilename", "findNextWord", "searchFrom", "bigWord", "findNextWordEnd", "stopOnEmptyLine", "findPattern", "pattern", "", "startOffset", "searchOptions", "Ljava/util/EnumSet;", "Lcom/maddyhome/idea/vim/helper/SearchOptions;", "findNextWithWrapscan", "Lcom/maddyhome/idea/vim/regexp/match/VimMatchResult;", "regex", "Lcom/maddyhome/idea/vim/regexp/VimRegex;", "startIndex", "options", "Lcom/maddyhome/idea/vim/regexp/VimRegexOptions;", "wrapscan", "showMessages", "findPreviousWithWrapscan", "findAll", "", "startLine", "endLine", "ignoreCase", "findNextWordOne", "chars", "stopAtEndOfLine", "findPreviousWordOne", "allowMoveFromWordStart", "findNextWordEndOne", "allowMoveFromWordEnd", "findPreviousWordEndOne", "stopAtEndOfPreviousLine", "isEmptyLine", "skipWhileCharacterType", "step", "Lcom/maddyhome/idea/vim/helper/CharacterHelper$CharacterType;", "isBig", "skipOneCharacterBack", "skipOneCharacterBackOnCurrentLine", "findNextCamelStart", "(Ljava/lang/CharSequence;II)Ljava/lang/Integer;", "findPreviousCamelStart", "endIndex", "findNextCamelEnd", "findPreviousCamelEnd", "findCamelStart", "Lcom/maddyhome/idea/vim/common/Direction;", "(Ljava/lang/CharSequence;IILcom/maddyhome/idea/vim/common/Direction;)Ljava/lang/Integer;", "findCamelEnd", "(Ljava/lang/CharSequence;ILcom/maddyhome/idea/vim/common/Direction;)Ljava/lang/Integer;", "findBlockQuoteInLineRange", "quote", "isOuter", "occurrencesBeforeOffset", "char", "endOffset", "currentLineOnly", "searchEscaped", "indexOfNext", "(Ljava/lang/CharSequence;CIZZ)Ljava/lang/Integer;", "indexOfPrevious", "findCharacterPosition", "charSequence", "(Ljava/lang/CharSequence;CILcom/maddyhome/idea/vim/common/Direction;ZZ)Ljava/lang/Integer;", "isQuoteWithoutEscape", "position", "findNextSentenceStart", "Lorg/jetbrains/annotations/Range;", "from", "to", "countCurrent", "requireAll", "(Lcom/maddyhome/idea/vim/api/VimEditor;IIZZ)Ljava/lang/Integer;", "(Lcom/maddyhome/idea/vim/api/VimEditor;Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;IZZ)Ljava/lang/Integer;", "findNextSentenceEnd", "findSentenceStart", "max", "dir", "(Lcom/maddyhome/idea/vim/api/VimEditor;Ljava/lang/CharSequence;IILcom/maddyhome/idea/vim/common/Direction;Z)Ljava/lang/Integer;", "findSentenceEnd", "findSentenceRangeEnd", "oneway", "findSentenceRange", "findNextParagraph", "allowBlanks", "(Lcom/maddyhome/idea/vim/api/VimEditor;IIZ)Ljava/lang/Integer;", "(Lcom/maddyhome/idea/vim/api/VimEditor;Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;IZ)Ljava/lang/Integer;", "findParagraphRange", "findOuterParagraphRange", "Lkotlin/Pair;", "findInnerParagraphRange", "findLastEmptyLine", "findNextParagraphLine", "(Lcom/maddyhome/idea/vim/api/VimEditor;ILcom/maddyhome/idea/vim/common/Direction;Z)Ljava/lang/Integer;", "skipEmptyLines", "findWordObject", "findBlockTagRange", "ignoreWhitespaceAtLineStart", "seq", "lineStart", "pos", "isInHTMLTag", "sequence", "isEndtag", "findUnmatchedOpeningTag", "tagName", "findUnmatchedClosingTag", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nVimSearchHelperBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimSearchHelperBase.kt\ncom/maddyhome/idea/vim/api/VimSearchHelperBase\n+ 2 EngineHelper.kt\ncom/maddyhome/idea/vim/helper/EngineHelperKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,1994:1\n57#2,2:1995\n19#2:1997\n59#2,2:1998\n61#2:2002\n57#2,2:2004\n19#2:2006\n59#2,2:2007\n61#2:2011\n37#3,2:2000\n37#3,2:2009\n1#4:2003\n1563#5:2012\n1634#5,3:2013\n39#6:2016\n*S KotlinDebug\n*F\n+ 1 VimSearchHelperBase.kt\ncom/maddyhome/idea/vim/api/VimSearchHelperBase\n*L\n274#1:1995,2\n274#1:1997\n274#1:1998,2\n274#1:2002\n387#1:2004,2\n387#1:2006\n387#1:2007,2\n387#1:2011\n274#1:2000,2\n387#1:2009,2\n401#1:2012\n401#1:2013,3\n37#1:2016\n*E\n"})
public abstract class VimSearchHelperBase
implements VimSearchHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final VimLogger logger;

    @Override
    public int findSection(@NotNull VimEditor editor, int line, char type, int direction, int count) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        CharSequence documentText = editor.text();
        int currentLine = line + direction;
        int resultOffset = -1;
        int remainingTargets = count;
        while (true) {
            char currentChar;
            boolean bl = 1 <= currentLine ? currentLine < editor.lineCount() : false;
            if (!bl || remainingTargets <= 0) break;
            int lineStartOffset = editor.getLineStartOffset(currentLine);
            if (lineStartOffset < documentText.length() && ((currentChar = documentText.charAt(lineStartOffset)) == type || currentChar == '\f')) {
                resultOffset = lineStartOffset;
                --remainingTargets;
            }
            currentLine += direction;
        }
        if (resultOffset == -1) {
            resultOffset = direction < 0 ? 0 : documentText.length() - 1;
        }
        return resultOffset;
    }

    @Override
    public int findSection(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, char type, int direction, int count) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        int line = caret.getBufferPosition().getLine();
        return this.findSection(editor, line, type, direction, count);
    }

    @Override
    public int findNextCharacterOnLine(@NotNull VimEditor editor, int offset, int count, char ch) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        int line = editor.offsetToBufferPosition(offset).getLine();
        int start = editor.getLineStartOffset(line);
        int end = EngineEditorHelperKt.getLineEndOffset(editor, line, true);
        CharSequence chars = editor.text();
        int found = 0;
        int step = count >= 0 ? 1 : -1;
        int pos = offset + step;
        while (true) {
            boolean bl = start <= pos ? pos < end : false;
            if (!bl || pos >= chars.length() || chars.charAt(pos) == ch && ++found == Math.abs(count)) break;
            pos += step;
        }
        return found == Math.abs(count) ? pos : -1;
    }

    @Override
    public int findNextCharacterOnLine(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, int count, char ch) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        int offset = caret.getOffset();
        return this.findNextCharacterOnLine(editor, offset, count, ch);
    }

    @Override
    @Nullable
    public TextRange findWordAtOrFollowingCursor(@NotNull VimEditor editor, int offset, boolean isBigWord) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        CharSequence chars = editor.text();
        int line = editor.offsetToBufferPosition(offset).getLine();
        int stop = EngineEditorHelperKt.getLineEndOffset(editor, line, true);
        int pos = offset;
        if (chars.length() == 0 || chars.length() <= pos) {
            return null;
        }
        int start = pos;
        CharacterHelper.CharacterType[] characterTypeArray = new CharacterHelper.CharacterType[]{CharacterHelper.CharacterType.KEYWORD, CharacterHelper.CharacterType.PUNCTUATION};
        CharacterHelper.CharacterType[] types = characterTypeArray;
        for (int i = 0; i < 2; ++i) {
            start = pos;
            CharacterHelper.CharacterType type = CharacterHelper.charType(editor, chars.charAt(start), isBigWord);
            if (type == types[i]) {
                while (start > 0 && CharacterHelper.charType(editor, chars.charAt(start - 1), isBigWord) == types[i]) {
                    --start;
                }
            } else {
                while (start < stop && CharacterHelper.charType(editor, chars.charAt(start), isBigWord) != types[i]) {
                    ++start;
                }
            }
            if (start != stop) break;
        }
        if (start == stop) {
            return null;
        }
        int end = start < stop && (start >= chars.length() - 1 || CharacterHelper.charType(editor, chars.charAt(start + 1), isBigWord) != CharacterHelper.CharacterType.KEYWORD) ? start + 1 : VimInjectorKt.getInjector().getSearchHelper().findNextWordEnd(editor, start, 1, isBigWord, false) + 1;
        return new TextRange(start, end);
    }

    @Override
    @Nullable
    public TextRange findWordAtOrFollowingCursor(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, boolean isBigWord) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        int offset = caret.getOffset();
        return this.findWordAtOrFollowingCursor(editor, offset, isBigWord);
    }

    @Override
    @Nullable
    public TextRange findFilenameAtOrFollowingCursor(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        return this.findFilenameAtOrFollowingCursor(editor, caret.getOffset());
    }

    @Override
    @Nullable
    public TextRange findFilenameAtOrFollowingCursor(@NotNull VimEditor editor, int offset) {
        int start;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        CharSequence text = editor.text();
        if (text.length() == 0) {
            return null;
        }
        int n = start = !KeywordOptionHelper.INSTANCE.isFilename(editor, text.charAt(offset)) ? this.moveForwardsToStartOfFilename(editor, text, offset) : this.moveBackwardsToStartOfFilename(editor, text, offset);
        if (start == -1) {
            return null;
        }
        int end = this.moveForwardsToEndOfFilename(editor, text, start);
        if (end == -1) {
            return null;
        }
        return new TextRange(start, end);
    }

    private final int moveForwardsToStartOfFilename(VimEditor editor, CharSequence text, int start) {
        int offset;
        for (offset = start; offset < text.length() && !KeywordOptionHelper.INSTANCE.isFilename(editor, text.charAt(offset)); ++offset) {
            if (text.charAt(offset) != '\n') continue;
            return -1;
        }
        if (offset == text.length()) {
            return -1;
        }
        return offset;
    }

    private final int moveBackwardsToStartOfFilename(VimEditor editor, CharSequence text, int start) {
        int offset;
        for (offset = start; offset > 0 && KeywordOptionHelper.INSTANCE.isFilename(editor, text.charAt(offset - 1)); --offset) {
            if (text.charAt(offset - 1) != '\n') continue;
            return -1;
        }
        return offset;
    }

    private final int moveForwardsToEndOfFilename(VimEditor editor, CharSequence text, int start) {
        int offset;
        for (offset = start; offset < text.length() && text.charAt(offset) != '\n' && KeywordOptionHelper.INSTANCE.isFilename(editor, text.charAt(offset)); ++offset) {
        }
        return offset - 1;
    }

    @Override
    public int findNextWord(@NotNull VimEditor editor, int searchFrom, int count, boolean bigWord) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return this.findNextWord(editor.text(), editor, searchFrom, count, bigWord);
    }

    @Override
    public int findNextWord(@NotNull CharSequence text, @NotNull VimEditor editor, int searchFrom, int count, boolean bigWord) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        int pos = 0;
        pos = searchFrom;
        int n = Math.abs(count);
        for (int i = 0; i < n; ++i) {
            int it = i;
            boolean bl = false;
            int n2 = pos = count > 0 ? VimSearchHelperBase.findNextWordOne$default(this, text, editor, pos, bigWord, false, 16, null) : VimSearchHelperBase.findPreviousWordOne$default(this, text, editor, pos, bigWord, false, 16, null);
            if (pos < text.length()) continue;
            return pos;
        }
        return pos;
    }

    @Override
    public int findNextWordEnd(@NotNull VimEditor editor, int searchFrom, int count, boolean bigWord, boolean stopOnEmptyLine) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        CharSequence text = editor.text();
        int pos = 0;
        pos = searchFrom;
        int n = Math.abs(count);
        for (int i = 0; i < n; ++i) {
            int it = i;
            boolean bl = false;
            pos = count > 0 ? this.findNextWordEndOne(text, editor, pos, bigWord, stopOnEmptyLine, true) : RangesKt.coerceAtLeast((int)VimSearchHelperBase.findPreviousWordEndOne$default(this, text, editor, pos, bigWord, false, 16, null), (int)0);
        }
        return pos;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public TextRange findPattern(@NotNull VimEditor editor, @Nullable String pattern, int startOffset, int count, @Nullable EnumSet<SearchOptions> searchOptions) {
        VimMatchResult result;
        Object[] objectArray;
        Object $this$toTypedArray$iv$iv;
        EnumSet<Object> enumSet;
        void value$iv;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        CharSequence charSequence = pattern;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        EnumSet<SearchOptions> enumSet2 = searchOptions;
        Intrinsics.checkNotNull(enumSet2);
        Direction dir = enumSet2.contains((Object)SearchOptions.BACKWARDS) ? Direction.BACKWARDS : Direction.FORWARDS;
        Enum[] enumArray = new VimRegexOptions[0];
        boolean $i$f$enumSetOf = false;
        switch (((void)value$iv).length) {
            case 0: {
                boolean $i$f$noneOfEnum = false;
                EnumSet<VimRegexOptions> enumSet3 = EnumSet.noneOf(VimRegexOptions.class);
                enumSet = enumSet3;
                Intrinsics.checkNotNullExpressionValue(enumSet3, (String)"noneOf(...)");
                break;
            }
            case 1: {
                EnumSet<void> enumSet4 = EnumSet.of(value$iv[0]);
                enumSet = enumSet4;
                Intrinsics.checkNotNullExpressionValue(enumSet4, (String)"of(...)");
                break;
            }
            default: {
                $this$toTypedArray$iv$iv = ArraysKt.slice((Object[])value$iv, (IntRange)new IntRange(1, ArraysKt.getLastIndex((Object[])value$iv)));
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
                objectArray = thisCollection$iv$iv.toArray(new VimRegexOptions[0]);
                EnumSet<Enum[]> enumSet5 = EnumSet.of(value$iv[0], Arrays.copyOf(objectArray, objectArray.length));
                enumSet = enumSet5;
                Intrinsics.checkNotNullExpressionValue(enumSet5, (String)"of(...)");
            }
        }
        EnumSet<Object> options = enumSet;
        if (VimInjectorKt.globalOptions(VimInjectorKt.getInjector()).getSmartcase() && !searchOptions.contains((Object)SearchOptions.IGNORE_SMARTCASE)) {
            options.add((Object)VimRegexOptions.SMART_CASE);
        }
        if (VimInjectorKt.globalOptions(VimInjectorKt.getInjector()).getIgnorecase()) {
            options.add((Object)VimRegexOptions.IGNORE_CASE);
        }
        if (searchOptions.contains((Object)SearchOptions.WANT_ENDPOS)) {
            options.add((Object)VimRegexOptions.WANT_END_POSITION);
            options.add((Object)VimRegexOptions.CAN_MATCH_START_LOCATION);
        }
        boolean wrap = searchOptions.contains((Object)SearchOptions.WRAP);
        boolean showMessages = searchOptions.contains((Object)SearchOptions.SHOW_MESSAGES);
        try {
            $this$toTypedArray$iv$iv = new VimRegex(pattern);
        }
        catch (VimRegexException e) {
            VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, e.getMessage());
            return null;
        }
        Object regex = $this$toTypedArray$iv$iv;
        VimMatchResult vimMatchResult = result = dir == Direction.FORWARDS ? this.findNextWithWrapscan(editor, (VimRegex)regex, startOffset, options, wrap, showMessages) : this.findPreviousWithWrapscan(editor, (VimRegex)regex, startOffset, options, wrap, showMessages);
        if (result instanceof VimMatchResult.Failure) {
            if (wrap) {
                Object[] e = new Object[]{pattern};
                VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, VimInjectorKt.getInjector().getMessages().message("E486", e));
            } else if (dir == Direction.FORWARDS) {
                Object[] e = new Object[]{pattern};
                VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, VimInjectorKt.getInjector().getMessages().message("E385", e));
            } else {
                Object[] e = new Object[]{pattern};
                VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, VimInjectorKt.getInjector().getMessages().message("E384", e));
            }
            return null;
        }
        options.remove((Object)VimRegexOptions.CAN_MATCH_START_LOCATION);
        for (int i = 1; i < count; ++i) {
            VimMatchResult vimMatchResult2 = result;
            Intrinsics.checkNotNull((Object)vimMatchResult2, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.regexp.match.VimMatchResult.Success");
            int nextOffset = ((VimMatchResult.Success)vimMatchResult2).getRange().getStartOffset();
            VimMatchResult vimMatchResult3 = result = dir == Direction.FORWARDS ? this.findNextWithWrapscan(editor, (VimRegex)regex, nextOffset, options, wrap, showMessages) : this.findPreviousWithWrapscan(editor, (VimRegex)regex, nextOffset, options, wrap, showMessages);
            if (!(result instanceof VimMatchResult.Failure)) continue;
            if (searchOptions.contains((Object)SearchOptions.SHOW_MESSAGES)) {
                if (dir == Direction.FORWARDS) {
                    objectArray = new Object[]{pattern};
                    VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, VimInjectorKt.getInjector().getMessages().message("E385", objectArray));
                } else {
                    objectArray = new Object[]{pattern};
                    VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, VimInjectorKt.getInjector().getMessages().message("E384", objectArray));
                }
            }
            return null;
        }
        VimMatchResult vimMatchResult4 = result;
        Intrinsics.checkNotNull((Object)vimMatchResult4, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.regexp.match.VimMatchResult.Success");
        return ((VimMatchResult.Success)vimMatchResult4).getRange();
    }

    private final VimMatchResult findNextWithWrapscan(VimEditor editor, VimRegex regex, int startIndex, EnumSet<VimRegexOptions> options, boolean wrapscan, boolean showMessages) {
        VimMatchResult result = regex.findNext(editor, startIndex, options);
        if (result instanceof VimMatchResult.Failure && wrapscan) {
            Object object;
            if (showMessages) {
                VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, VimInjectorKt.getInjector().getMessages().message("message.search.hit.bottom", new Object[0]));
            }
            Object it = object = options.clone();
            boolean bl = false;
            ((AbstractCollection)it).add(VimRegexOptions.CAN_MATCH_START_LOCATION);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            Object newOptions = object2;
            return regex.findNext(editor, 0, (EnumSet<VimRegexOptions>)newOptions);
        }
        return result;
    }

    private final VimMatchResult findPreviousWithWrapscan(VimEditor editor, VimRegex regex, int startIndex, EnumSet<VimRegexOptions> options, boolean wrapscan, boolean showMessages) {
        VimMatchResult result = regex.findPrevious(editor, startIndex, options);
        if (result instanceof VimMatchResult.Failure && wrapscan) {
            if (showMessages) {
                VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, VimInjectorKt.getInjector().getMessages().message("message.search.hit.top", new Object[0]));
            }
            return regex.findPrevious(editor, (int)editor.fileSize() - 1, options);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<TextRange> findAll(@NotNull VimEditor editor, @NotNull String pattern, int startLine, int endLine, boolean ignoreCase) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object $i$f$enumSetOf2;
        Collection $this$toTypedArray$iv$iv;
        EnumSet<Object> enumSet;
        void value$iv;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Enum[] enumArray = new VimRegexOptions[0];
        boolean $i$f$enumSetOf2 = false;
        switch (((void)value$iv).length) {
            case 0: {
                boolean $i$f$noneOfEnum = false;
                EnumSet<VimRegexOptions> enumSet2 = EnumSet.noneOf(VimRegexOptions.class);
                enumSet = enumSet2;
                Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"noneOf(...)");
                break;
            }
            case 1: {
                EnumSet<void> enumSet3 = EnumSet.of(value$iv[0]);
                enumSet = enumSet3;
                Intrinsics.checkNotNullExpressionValue(enumSet3, (String)"of(...)");
                break;
            }
            default: {
                $this$toTypedArray$iv$iv = ArraysKt.slice((Object[])value$iv, (IntRange)new IntRange(1, ArraysKt.getLastIndex((Object[])value$iv)));
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
                Enum[] enumArray2 = thisCollection$iv$iv.toArray(new VimRegexOptions[0]);
                EnumSet<Enum[]> enumSet4 = EnumSet.of(value$iv[0], Arrays.copyOf(enumArray2, enumArray2.length));
                enumSet = enumSet4;
                Intrinsics.checkNotNullExpressionValue(enumSet4, (String)"of(...)");
            }
        }
        EnumSet<Object> options = enumSet;
        if (VimInjectorKt.globalOptions(VimInjectorKt.getInjector()).getSmartcase()) {
            options.add((Object)VimRegexOptions.SMART_CASE);
        }
        if (VimInjectorKt.globalOptions(VimInjectorKt.getInjector()).getIgnorecase()) {
            options.add((Object)VimRegexOptions.IGNORE_CASE);
        }
        try {
            $i$f$enumSetOf2 = new VimRegex(pattern);
        }
        catch (VimRegexException e) {
            VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, e.getMessage());
            return CollectionsKt.emptyList();
        }
        VimRegex regex = $i$f$enumSetOf2;
        $i$f$enumSetOf2 = regex.findAll(editor, editor.getLineStartOffset(startLine), editor.getLineEndOffset(endLine == -1 ? editor.lineCount() - 1 : endLine) + 1, options);
        boolean $i$f$map = false;
        $this$toTypedArray$iv$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VimMatchResult.Success success = (VimMatchResult.Success)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getRange());
        }
        return (List)destination$iv$iv;
    }

    private final int findNextWordOne(CharSequence chars, VimEditor editor, int start, boolean bigWord, boolean stopAtEndOfLine) {
        int pos = start;
        if (pos >= chars.length()) {
            return chars.length();
        }
        CharacterHelper.CharacterType startingCharType = CharacterHelper.charType(editor, chars.charAt(start), bigWord);
        if (++pos < chars.length() && startingCharType != CharacterHelper.CharacterType.WHITESPACE) {
            pos = this.skipWhileCharacterType(editor, chars, pos, 1, startingCharType, bigWord);
        }
        while (pos < chars.length() && CharacterHelper.INSTANCE.isWhitespace(editor, chars.charAt(pos), bigWord)) {
            if (this.isEmptyLine(chars, pos) || chars.charAt(pos) == '\n' && stopAtEndOfLine) {
                return pos;
            }
            ++pos;
        }
        return RangesKt.coerceAtMost((int)pos, (int)chars.length());
    }

    static /* synthetic */ int findNextWordOne$default(VimSearchHelperBase vimSearchHelperBase, CharSequence charSequence, VimEditor vimEditor, int n, boolean bl, boolean bl2, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findNextWordOne");
        }
        if ((n2 & 0x10) != 0) {
            bl2 = false;
        }
        return vimSearchHelperBase.findNextWordOne(charSequence, vimEditor, n, bl, bl2);
    }

    private final int findPreviousWordOne(CharSequence chars, VimEditor editor, int start, boolean bigWord, boolean allowMoveFromWordStart) {
        if (chars.length() == 0) {
            return 0;
        }
        int pos = start;
        CharacterHelper.CharacterType startingCharType = CharacterHelper.charType(editor, chars.charAt(RangesKt.coerceAtMost((int)pos, (int)(chars.length() - 1))), bigWord);
        if (allowMoveFromWordStart || startingCharType == CharacterHelper.charType(editor, chars.charAt(--pos), bigWord) || CharacterHelper.INSTANCE.isWhitespace(editor, chars.charAt(pos), bigWord)) {
            while (pos >= 0 && CharacterHelper.INSTANCE.isWhitespace(editor, chars.charAt(pos), bigWord)) {
                if (this.isEmptyLine(chars, pos)) {
                    return pos;
                }
                --pos;
            }
            if (pos <= 0) {
                return 0;
            }
            pos = this.skipWhileCharacterType(editor, chars, pos, -1, CharacterHelper.charType(editor, chars.charAt(pos), bigWord), bigWord);
        }
        return RangesKt.coerceAtLeast((int)(pos + 1), (int)0);
    }

    static /* synthetic */ int findPreviousWordOne$default(VimSearchHelperBase vimSearchHelperBase, CharSequence charSequence, VimEditor vimEditor, int n, boolean bl, boolean bl2, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findPreviousWordOne");
        }
        if ((n2 & 0x10) != 0) {
            bl2 = true;
        }
        return vimSearchHelperBase.findPreviousWordOne(charSequence, vimEditor, n, bl, bl2);
    }

    private final int findNextWordEndOne(CharSequence chars, VimEditor editor, int start, boolean bigWord, boolean stopOnEmptyLine, boolean allowMoveFromWordEnd) {
        int pos = start;
        CharacterHelper.CharacterType startingCharType = CharacterHelper.charType(editor, chars.charAt(pos), bigWord);
        ++pos;
        if (allowMoveFromWordEnd || startingCharType == CharacterHelper.CharacterType.WHITESPACE) {
            while (pos < chars.length() && CharacterHelper.INSTANCE.isWhitespace(editor, chars.charAt(pos), bigWord)) {
                if (stopOnEmptyLine && this.isEmptyLine(chars, pos)) {
                    return pos;
                }
                ++pos;
            }
        }
        if (pos < chars.length() && !CharacterHelper.INSTANCE.isWhitespace(editor, chars.charAt(pos), bigWord)) {
            CharacterHelper.CharacterType wordCharType = CharacterHelper.charType(editor, chars.charAt(pos), bigWord);
            pos = this.skipWhileCharacterType(editor, chars, pos, 1, wordCharType, bigWord);
        }
        return RangesKt.coerceIn((int)(--pos), (int)0, (int)(chars.length() - 1));
    }

    private final int findPreviousWordEndOne(CharSequence chars, VimEditor editor, int start, boolean bigWord, boolean stopAtEndOfPreviousLine) {
        int pos = start;
        CharacterHelper.CharacterType startingCharType = CharacterHelper.charType(editor, chars.charAt(pos), bigWord);
        if (--pos >= 0 && startingCharType != CharacterHelper.CharacterType.WHITESPACE) {
            pos = this.skipWhileCharacterType(editor, chars, pos, -1, startingCharType, bigWord);
        }
        while (true) {
            boolean bl = 0 <= pos ? pos < chars.length() : false;
            if (!bl || !CharacterHelper.INSTANCE.isWhitespace(editor, chars.charAt(pos), bigWord)) break;
            if (this.isEmptyLine(chars, pos) || chars.charAt(pos) == '\n' && stopAtEndOfPreviousLine) {
                return pos;
            }
            --pos;
        }
        return pos;
    }

    static /* synthetic */ int findPreviousWordEndOne$default(VimSearchHelperBase vimSearchHelperBase, CharSequence charSequence, VimEditor vimEditor, int n, boolean bl, boolean bl2, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findPreviousWordEndOne");
        }
        if ((n2 & 0x10) != 0) {
            bl2 = false;
        }
        return vimSearchHelperBase.findPreviousWordEndOne(charSequence, vimEditor, n, bl, bl2);
    }

    private final boolean isEmptyLine(CharSequence chars, int offset) {
        return offset == 0 && chars.charAt(offset) == '\n' || chars.charAt(offset) == '\n' && chars.charAt(offset - 1) == '\n';
    }

    private final int skipWhileCharacterType(VimEditor editor, CharSequence chars, int start, int step, CharacterHelper.CharacterType type, boolean isBig) {
        int offset = start;
        while (true) {
            boolean bl = 0 <= offset ? offset < chars.length() : false;
            if (!bl || CharacterHelper.charType(editor, chars.charAt(offset), isBig) != type) break;
            offset += step;
        }
        return offset;
    }

    private final int skipOneCharacterBack(int offset) {
        return RangesKt.coerceAtLeast((int)(offset - 1), (int)0);
    }

    private final int skipOneCharacterBackOnCurrentLine(CharSequence chars, int offset) {
        return chars.charAt(offset - 1) != '\n' ? offset - 1 : offset;
    }

    @Override
    @Nullable
    public Integer findNextCamelStart(@NotNull CharSequence chars, int startIndex, int count) {
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        return this.findCamelStart(chars, startIndex, count, Direction.FORWARDS);
    }

    @Override
    @Nullable
    public Integer findPreviousCamelStart(@NotNull CharSequence chars, int endIndex, int count) {
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        return this.findCamelStart(chars, endIndex - 1, count, Direction.BACKWARDS);
    }

    @Override
    @Nullable
    public Integer findNextCamelEnd(@NotNull CharSequence chars, int startIndex, int count) {
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        return this.findCamelEnd(chars, startIndex, count, Direction.FORWARDS);
    }

    @Override
    @Nullable
    public Integer findPreviousCamelEnd(@NotNull CharSequence chars, int endIndex, int count) {
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        return this.findCamelEnd(chars, endIndex - 1, count, Direction.BACKWARDS);
    }

    private final Integer findCamelStart(CharSequence chars, int startIndex, int count, Direction direction) {
        boolean bl;
        boolean bl2 = bl = count >= 1;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        int offset = startIndex;
        for (int counter = 0; counter < count; ++counter) {
            int searchFrom = counter == 0 ? offset : offset + direction.toInt();
            Integer n = this.findCamelStart(chars, searchFrom, direction);
            if (n == null) {
                return null;
            }
            offset = n;
        }
        return offset;
    }

    private final Integer findCamelEnd(CharSequence chars, int startIndex, int count, Direction direction) {
        boolean bl;
        boolean bl2 = bl = count >= 1;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        int offset = startIndex;
        for (int counter = 0; counter < count; ++counter) {
            int searchFrom = counter == 0 ? offset : offset + direction.toInt();
            Integer n = this.findCamelEnd(chars, searchFrom, direction);
            if (n == null) {
                return null;
            }
            offset = n;
        }
        return offset;
    }

    private final Integer findCamelStart(CharSequence chars, int startIndex, Direction direction) {
        int pos = startIndex;
        int size = chars.length();
        if (pos < 0 || pos >= size) {
            return null;
        }
        while (true) {
            boolean bl = 0 <= pos ? pos < size : false;
            if (!bl) break;
            if (Character.isUpperCase(chars.charAt(pos)) ? pos == 0 || !Character.isUpperCase(chars.charAt(pos - 1)) || pos == size - 1 || Character.isLowerCase(chars.charAt(pos + 1)) : (Character.isLowerCase(chars.charAt(pos)) ? pos == 0 || !Character.isLetter(chars.charAt(pos - 1)) : Character.isDigit(chars.charAt(pos)) && (pos == 0 || !Character.isDigit(chars.charAt(pos - 1))))) {
                return pos;
            }
            pos += direction.toInt();
        }
        return null;
    }

    private final Integer findCamelEnd(CharSequence chars, int startIndex, Direction direction) {
        int pos = startIndex;
        int size = chars.length();
        if (pos < 0 || pos >= size) {
            return pos;
        }
        while (true) {
            boolean bl = 0 <= pos ? pos < size : false;
            if (!bl) break;
            if (Character.isUpperCase(chars.charAt(pos)) ? pos == size - 1 || !Character.isLetter(chars.charAt(pos + 1)) || Character.isUpperCase(chars.charAt(pos + 1)) && pos < size - 2 && Character.isLowerCase(chars.charAt(pos + 2)) : (Character.isLowerCase(chars.charAt(pos)) ? pos == size - 1 || !Character.isLowerCase(chars.charAt(pos + 1)) : Character.isDigit(chars.charAt(pos)) && (pos == size - 1 || !Character.isDigit(chars.charAt(pos + 1))))) {
                return pos;
            }
            pos += direction.toInt();
        }
        return null;
    }

    @Override
    @Nullable
    public TextRange findBlockQuoteInLineRange(@NotNull VimEditor editor, int offset, char quote, boolean isOuter) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        int leftQuote = 0;
        int rightQuote = 0;
        int caretOffset = offset;
        Integer n = VimSearchHelperBase.indexOfNext$default(this, editor.text(), quote, caretOffset, true, false, 8, null);
        if (n == null) {
            return null;
        }
        int quoteAfterCaret = n;
        Integer quoteBeforeCaret = VimSearchHelperBase.indexOfPrevious$default(this, editor.text(), quote, caretOffset, true, false, 8, null);
        int quotesBeforeCaret = VimSearchHelperBase.occurrencesBeforeOffset$default(this, editor.text(), quote, caretOffset, true, false, 8, null);
        if (caretOffset == quoteAfterCaret && quotesBeforeCaret % 2 == 0 || quoteBeforeCaret == null) {
            leftQuote = quoteAfterCaret;
            Integer n2 = VimSearchHelperBase.indexOfNext$default(this, editor.text(), quote, leftQuote + 1, true, false, 8, null);
            if (n2 == null) {
                return null;
            }
            rightQuote = n2;
        } else {
            leftQuote = quoteBeforeCaret;
            rightQuote = quoteAfterCaret;
        }
        if (!isOuter) {
            ++leftQuote;
            --rightQuote;
        } else {
            int trailingEnd;
            CharSequence text = editor.text();
            for (trailingEnd = rightQuote + 1; trailingEnd < text.length() && text.charAt(trailingEnd) == ' '; ++trailingEnd) {
            }
            if (trailingEnd > rightQuote + 1) {
                rightQuote = trailingEnd - 1;
            } else {
                int leadingStart;
                for (leadingStart = leftQuote; leadingStart > 0 && text.charAt(leadingStart - 1) == ' '; --leadingStart) {
                }
                if (leadingStart < leftQuote) {
                    leftQuote = leadingStart;
                }
            }
        }
        return new TextRange(leftQuote, rightQuote + 1);
    }

    @Override
    @Nullable
    public TextRange findBlockQuoteInLineRange(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, char quote, boolean isOuter) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        int offset = caret.getOffset();
        return this.findBlockQuoteInLineRange(editor, offset, quote, isOuter);
    }

    private final int occurrencesBeforeOffset(CharSequence $this$occurrencesBeforeOffset, char c, int endOffset, boolean currentLineOnly, boolean searchEscaped) {
        int counter = 0;
        int i = endOffset;
        while (i > 0 && $this$occurrencesBeforeOffset.charAt(i + Direction.BACKWARDS.toInt()) != '\n') {
            Integer n = this.indexOfPrevious($this$occurrencesBeforeOffset, c, i, currentLineOnly, searchEscaped);
            if (n == null) {
                break;
            }
            i = n;
            ++counter;
        }
        return counter;
    }

    static /* synthetic */ int occurrencesBeforeOffset$default(VimSearchHelperBase vimSearchHelperBase, CharSequence charSequence, char c, int n, boolean bl, boolean bl2, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: occurrencesBeforeOffset");
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        return vimSearchHelperBase.occurrencesBeforeOffset(charSequence, c, n, bl, bl2);
    }

    private final Integer indexOfNext(CharSequence $this$indexOfNext, char c, int startIndex, boolean currentLineOnly, boolean searchEscaped) {
        return this.findCharacterPosition($this$indexOfNext, c, startIndex, Direction.FORWARDS, currentLineOnly, searchEscaped);
    }

    static /* synthetic */ Integer indexOfNext$default(VimSearchHelperBase vimSearchHelperBase, CharSequence charSequence, char c, int n, boolean bl, boolean bl2, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: indexOfNext");
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        return vimSearchHelperBase.indexOfNext(charSequence, c, n, bl, bl2);
    }

    private final Integer indexOfPrevious(CharSequence $this$indexOfPrevious, char c, int endIndex, boolean currentLineOnly, boolean searchEscaped) {
        if (endIndex == 0 || currentLineOnly && $this$indexOfPrevious.charAt(endIndex - 1) == '\n') {
            return null;
        }
        return this.findCharacterPosition($this$indexOfPrevious, c, endIndex - 1, Direction.BACKWARDS, currentLineOnly, searchEscaped);
    }

    static /* synthetic */ Integer indexOfPrevious$default(VimSearchHelperBase vimSearchHelperBase, CharSequence charSequence, char c, int n, boolean bl, boolean bl2, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: indexOfPrevious");
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        return vimSearchHelperBase.indexOfPrevious(charSequence, c, n, bl, bl2);
    }

    private final Integer findCharacterPosition(CharSequence charSequence, char c, int startIndex, Direction direction, boolean currentLineOnly, boolean searchEscaped) {
        for (int pos = startIndex; !(pos < 0 || pos >= charSequence.length() || currentLineOnly && charSequence.charAt(pos) == '\n'); pos += direction.toInt()) {
            if (charSequence.charAt(pos) != c || pos != 0 && !searchEscaped && !this.isQuoteWithoutEscape(charSequence, pos, c)) continue;
            return pos;
        }
        return null;
    }

    private final boolean isQuoteWithoutEscape(CharSequence chars, int position, char quote) {
        int i = position;
        if (chars.charAt(i) != quote) {
            return false;
        }
        int backslashCounter = 0;
        while (i-- > 0 && chars.charAt(i) == '\\') {
            ++backslashCounter;
        }
        return backslashCounter % 2 == 0;
    }

    @Override
    @Contract(pure=true)
    @Nullable
    public Integer findNextSentenceStart(@NotNull VimEditor editor, int offset, int count, boolean countCurrent, boolean requireAll) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        int count2 = count;
        Direction dir = count2 > 0 ? Direction.FORWARDS : Direction.BACKWARDS;
        int total = count2 = Math.abs(count2);
        CharSequence chars = editor.text();
        int start = offset;
        int max = (int)editor.fileSize();
        Integer res = start;
        while (count2 > 0 && res != null && res >= 0 && res <= max - 1) {
            block10: {
                block9: {
                    Integer n = res = this.findSentenceStart(editor, chars, res, max, dir, countCurrent);
                    if (n != null && n == 0) break block9;
                    Integer n2 = res;
                    int n3 = max - 1;
                    if (n2 == null || n2 != n3) break block10;
                }
                --count2;
                break;
            }
            --count2;
        }
        if (!(res != null || requireAll && total != 1)) {
            res = dir == Direction.FORWARDS ? Integer.valueOf(max - 1) : Integer.valueOf(0);
        } else if (count2 > 0 && total > 1 && !requireAll) {
            res = dir == Direction.FORWARDS ? Integer.valueOf(max - 1) : Integer.valueOf(0);
        } else if (count2 > 0 && total > 1 && requireAll) {
            res = null;
        }
        return res;
    }

    @Override
    @Contract(pure=true)
    @Nullable
    public Integer findNextSentenceStart(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, int count, boolean countCurrent, boolean requireAll) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        int offset = caret.getOffset();
        return this.findNextSentenceStart(editor, offset, count, countCurrent, requireAll);
    }

    @Override
    @Contract(pure=true)
    @Nullable
    public Integer findNextSentenceEnd(@NotNull VimEditor editor, int offset, int count, boolean countCurrent, boolean requireAll) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        int count2 = count;
        Direction dir = count2 > 0 ? Direction.FORWARDS : Direction.BACKWARDS;
        int total = count2 = Math.abs(count2);
        CharSequence chars = editor.text();
        int start = offset;
        int max = (int)editor.fileSize();
        Integer res = start;
        while (count2 > 0 && res != null && res >= 0 && res <= max - 1) {
            block10: {
                block9: {
                    Integer n = res = this.findSentenceEnd(editor, chars, res, max, dir, countCurrent && count2 == total);
                    if (n != null && n == 0) break block9;
                    Integer n2 = res;
                    int n3 = max - 1;
                    if (n2 == null || n2 != n3) break block10;
                }
                --count2;
                break;
            }
            --count2;
        }
        if (!(res != null || requireAll && total != 1)) {
            res = dir == Direction.FORWARDS ? Integer.valueOf(max - 1) : Integer.valueOf(0);
        } else if (count2 > 0 && total > 1 && !requireAll) {
            res = dir == Direction.FORWARDS ? Integer.valueOf(max - 1) : Integer.valueOf(0);
        } else if (count2 > 0 && total > 1 && requireAll) {
            res = null;
        }
        return res;
    }

    @Override
    @Contract(pure=true)
    @Nullable
    public Integer findNextSentenceEnd(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, int count, boolean countCurrent, boolean requireAll) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        int offset = caret.getOffset();
        return this.findNextSentenceEnd(editor, offset, count, countCurrent, requireAll);
    }

    @Contract(pure=true)
    private final Integer findSentenceStart(VimEditor editor, CharSequence chars, int start, int max, Direction dir, boolean countCurrent) {
        Integer n;
        char ch;
        int lline = editor.offsetToBufferPosition(start).getLine();
        int np = this.findNextParagraph(editor, lline, dir, false);
        Integer end = null;
        Integer n2 = end = start < max && chars.charAt(start) == '\n' && !countCurrent ? this.findSentenceEnd(editor, chars, start, max, Direction.BACKWARDS, false) : this.findSentenceEnd(editor, chars, start, max, Direction.BACKWARDS, true);
        int n3 = start;
        if (n2 != null && n2 == n3 && countCurrent && chars.charAt(end) == '\n') {
            return end;
        }
        if (end != null && end >= 0) {
            int offset;
            for (offset = end + 1; offset < max && Character.isWhitespace(ch = chars.charAt(offset)); ++offset) {
            }
            if (dir == Direction.FORWARDS) {
                if (offset == start && countCurrent) {
                    return offset;
                }
                if (offset > start) {
                    return offset;
                }
            } else {
                if (offset == start && countCurrent) {
                    return offset;
                }
                if (offset < start) {
                    return offset;
                }
            }
        }
        if (dir == Direction.FORWARDS) {
            n = this.findSentenceEnd(editor, chars, start, max, dir, true);
        } else {
            Integer n4 = end;
            if (n4 != null) {
                int it = ((Number)n4).intValue();
                boolean bl = false;
                n = this.findSentenceEnd(editor, chars, it - 1, max, dir, countCurrent);
            } else {
                n = null;
            }
        }
        end = n;
        Integer res = null;
        if (!(end == null || end >= chars.length() || chars.charAt(end) == '\n' && countCurrent)) {
            res = end + 1;
            while (res < max && Character.isWhitespace(ch = chars.charAt(res))) {
                int n5 = res;
                res = n5 + 1;
            }
        }
        if (res != null && np >= 0) {
            if (dir == Direction.FORWARDS) {
                if (np < res || res < start) {
                    res = np;
                }
            } else if (np > res || res >= start && !countCurrent) {
                res = np;
            }
        } else if (res == null && np >= 0) {
            res = np;
        }
        return res;
    }

    @Contract(pure=true)
    private final Integer findSentenceEnd(VimEditor editor, CharSequence chars, int start, int max, Direction dir, boolean countCurrent) {
        if (dir == Direction.BACKWARDS && start <= 0 || dir == Direction.FORWARDS && start >= (int)editor.fileSize()) {
            return null;
        }
        int lline = editor.offsetToBufferPosition(start).getLine();
        int np = this.findNextParagraph(editor, lline, dir, false);
        Integer res = null;
        boolean found = false;
        for (int offset = start; offset >= 0 && offset < max && !found; offset += dir.toInt()) {
            int end;
            char ch = chars.charAt(offset);
            if (StringsKt.indexOf$default((CharSequence)".!?", (char)ch, (int)0, (boolean)false, (int)6, null) >= 0) {
                end = offset++;
                while (offset < max && StringsKt.indexOf$default((CharSequence)")]\"'", (char)(ch = chars.charAt(offset)), (int)0, (boolean)false, (int)6, null) != -1) {
                    ++offset;
                }
                if (offset >= max || Character.isWhitespace(ch)) {
                    if (offset - 1 == start && !countCurrent) {
                        offset = end;
                        continue;
                    }
                    res = offset - 1;
                    found = true;
                    continue;
                }
                offset = end;
                continue;
            }
            if (ch == '\n') {
                end = offset++;
                if (dir == Direction.FORWARDS) {
                    while (offset < max) {
                        ch = chars.charAt(offset);
                        if (ch != '\n') {
                            --offset;
                            break;
                        }
                        if (offset == np && (end - 1 != start || countCurrent)) break;
                        ++offset;
                    }
                    if (offset == np && (end - 1 != start || countCurrent)) {
                        res = end - 1;
                        found = true;
                    } else if (offset > end) {
                        res = offset;
                        np = res;
                        found = true;
                    } else if (offset == end && offset > 0 && chars.charAt(offset - 1) == '\n' && countCurrent) {
                        res = end;
                        np = res;
                        found = true;
                    }
                } else {
                    if (offset > 0) {
                        --offset;
                        while (offset > 0) {
                            ch = chars.charAt(offset);
                            if (ch != '\n') {
                                ++offset;
                                break;
                            }
                            --offset;
                        }
                    }
                    if (offset < end) {
                        res = end == start && countCurrent ? Integer.valueOf(end) : Integer.valueOf(offset - 1);
                        found = true;
                    }
                }
                offset = end;
                continue;
            }
            if (ch != '\f') continue;
            res = offset;
            found = true;
        }
        if (res != null && np >= 0) {
            if (dir == Direction.FORWARDS) {
                if (np < res || res < start) {
                    res = np;
                }
            } else if (np > res || res >= start && !countCurrent) {
                res = np;
            }
        }
        return res;
    }

    @Contract(pure=true)
    private final int findSentenceRangeEnd(VimEditor editor, CharSequence chars, int start, int max, int count, boolean isOuter, boolean oneway) {
        int n;
        int count2 = count;
        Direction dir = count2 > 0 ? Direction.FORWARDS : Direction.BACKWARDS;
        count2 = Math.abs(count2);
        boolean toggle = !isOuter;
        boolean findend = dir == Direction.BACKWARDS;
        int which = 0;
        Integer eprev = this.findSentenceEnd(editor, chars, start, max, Direction.BACKWARDS, true);
        Integer enext = this.findSentenceEnd(editor, chars, start, max, Direction.FORWARDS, true);
        Integer sprev = this.findSentenceStart(editor, chars, start, max, Direction.BACKWARDS, true);
        Integer snext = this.findSentenceStart(editor, chars, start, max, Direction.FORWARDS, true);
        if (Intrinsics.areEqual((Object)snext, (Object)eprev)) {
            if (dir == Direction.BACKWARDS && !oneway) {
                return start;
            }
            which = 0;
            if (oneway) {
                findend = dir == Direction.FORWARDS;
            } else if (dir == Direction.FORWARDS && start < max - 1 && !Character.isSpaceChar(chars.charAt(start + 1))) {
                findend = true;
            }
        } else {
            Integer n2 = snext;
            if (n2 != null && start == n2) {
                if (dir == Direction.BACKWARDS && !oneway) {
                    return start;
                }
                int n3 = which = dir == Direction.FORWARDS ? 1 : 0;
                if (dir == Direction.BACKWARDS && oneway) {
                    findend = false;
                }
            } else {
                Integer n4 = enext;
                if (n4 != null && start == n4) {
                    if (dir == Direction.FORWARDS && !oneway) {
                        return start;
                    }
                    which = 0;
                    if (dir == Direction.FORWARDS && oneway) {
                        findend = true;
                    }
                } else if ((sprev == null || start >= sprev) && (enext == null || start <= enext && snext != null && enext < snext)) {
                    which = dir == Direction.FORWARDS ? 1 : 0;
                } else {
                    int n5 = which = dir == Direction.FORWARDS ? 0 : 1;
                    if (dir == Direction.FORWARDS) {
                        if (oneway) {
                            if (snext != null && start < snext - 1) {
                                findend = true;
                            } else if (snext != null && start == snext - 1) {
                                ++count2;
                            }
                        } else {
                            findend = true;
                        }
                    } else if (oneway) {
                        if (eprev != null && start > eprev + 1) {
                            findend = false;
                        } else if (eprev != null && start == eprev + 1) {
                            ++count2;
                        }
                    } else {
                        findend = true;
                    }
                }
            }
        }
        Integer res = start;
        while (count2 > 0 && res >= 0 && res <= max - 1) {
            block43: {
                block42: {
                    Integer n6 = res = toggle && which % 2 == 1 || isOuter && findend ? this.findSentenceEnd(editor, chars, res, max, dir, false) : this.findSentenceStart(editor, chars, res, max, dir, false);
                    if (n6 != null && n6 == 0) break block42;
                    Integer n7 = res;
                    n = max - 1;
                    if ((n7 == null || n7 != n) && res != null) break block43;
                }
                --count2;
                break;
            }
            if (toggle) {
                if (which % 2 == 1 && dir == Direction.BACKWARDS) {
                    n = res;
                    res = n + 1;
                } else if (which % 2 == 0 && dir == Direction.FORWARDS) {
                    n = res;
                    res = n + -1;
                }
            }
            ++which;
            --count2;
        }
        if (res == null || count2 > 0) {
            res = dir == Direction.FORWARDS ? Integer.valueOf(max > 0 ? max - 1 : 0) : Integer.valueOf(0);
        } else if (isOuter && (dir == Direction.BACKWARDS && findend || dir == Direction.FORWARDS && !findend) && res != 0) {
            n = max - 1;
            if (res != n) {
                res = res - dir.toInt();
            }
        }
        if (chars.charAt(res) == '\n' && res > 0 && chars.charAt(res - 1) != '\n') {
            n = res;
            res = n + -1;
        }
        return res;
    }

    @Override
    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public TextRange findSentenceRange(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, int count, boolean isOuter) {
        TextRange textRange;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        CharSequence chars = editor.text();
        if (chars.length() == 0) {
            return new TextRange(0, 0);
        }
        int max = (int)editor.fileSize();
        int offset = caret.getOffset();
        int ssel = caret.getSelectionStart();
        int esel = caret.getSelectionEnd();
        if (Math.abs(esel - ssel) > 1) {
            int start = 0;
            int end = 0;
            if (offset == esel - 1) {
                start = ssel;
                end = this.findSentenceRangeEnd(editor, chars, offset, max, count, isOuter, true);
                textRange = new TextRange(start, end + 1);
            } else {
                end = esel - 1;
                start = this.findSentenceRangeEnd(editor, chars, offset, max, -count, isOuter, true);
                textRange = new TextRange(end, start + 1);
            }
        } else {
            int end = this.findSentenceRangeEnd(editor, chars, offset, max, count, isOuter, false);
            boolean space = isOuter;
            if (Character.isSpaceChar(chars.charAt(end))) {
                space = false;
            }
            int start = this.findSentenceRangeEnd(editor, chars, offset, max, -1, space, false);
            textRange = new TextRange(start, end + 1);
        }
        return textRange;
    }

    @Override
    @Contract(pure=true)
    @Nullable
    public Integer findNextParagraph(@NotNull VimEditor editor, int startLine, int count, boolean allowBlanks) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Integer n = this.findNextParagraphLine(editor, startLine, count, allowBlanks);
        if (n == null) {
            return null;
        }
        int line = n;
        int lineCount = editor.nativeLineCount();
        return line == lineCount - 1 ? Integer.valueOf(count > 0 ? (int)editor.fileSize() - 1 : 0) : Integer.valueOf(editor.getLineStartOffset(line));
    }

    @Override
    @Contract(pure=true)
    @Nullable
    public Integer findNextParagraph(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, int count, boolean allowBlanks) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        int startLine = caret.getBufferPosition().getLine();
        return this.findNextParagraph(editor, startLine, count, allowBlanks);
    }

    @Contract(pure=true)
    private final int findNextParagraph(VimEditor editor, int startLine, Direction direction, boolean allowBlanks) {
        Integer line = this.findNextParagraphLine(editor, startLine, direction, allowBlanks);
        return line == null ? (direction == Direction.FORWARDS ? (int)editor.fileSize() - 1 : 0) : editor.getLineStartOffset(line);
    }

    @Override
    @Contract(pure=true)
    @Nullable
    public TextRange findParagraphRange(@NotNull VimEditor editor, int line, int count, boolean isOuter) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (logger.isDebug()) {
            logger.debug("Starting paragraph range search on line " + line);
        }
        Pair<Integer, Integer> pair = isOuter ? this.findOuterParagraphRange(editor, line, count) : this.findInnerParagraphRange(editor, line, count);
        if (pair == null) {
            return null;
        }
        Pair<Integer, Integer> rangeInfo = pair;
        int startLine = ((Number)rangeInfo.getFirst()).intValue();
        int endLine = ((Number)rangeInfo.getSecond()).intValue();
        if (logger.isDebug()) {
            logger.debug("final start line= " + startLine);
            logger.debug("final end line= " + endLine);
        }
        int start = editor.getLineStartOffset(startLine);
        int end = editor.getLineStartOffset(endLine);
        return new TextRange(start, end + 1);
    }

    @Override
    @Contract(pure=true)
    @Nullable
    public TextRange findParagraphRange(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, int count, boolean isOuter) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        int line = caret.getBufferPosition().getLine();
        return this.findParagraphRange(editor, line, count, isOuter);
    }

    @Contract(pure=true)
    private final Pair<Integer, Integer> findOuterParagraphRange(VimEditor editor, int line, int count) {
        int n;
        boolean expandStart = false;
        boolean expandEnd = false;
        if (EngineEditorHelperKt.isLineEmpty(editor, line, true)) {
            n = line;
        } else {
            Integer n2 = this.findNextParagraphLine(editor, line, -1, true);
            if (n2 != null) {
                n = n2;
            } else {
                return null;
            }
        }
        int startLine = n;
        Integer n3 = this.findNextParagraphLine(editor, line, count, true);
        if (n3 == null) {
            return null;
        }
        int endLine = n3;
        if (EngineEditorHelperKt.isLineEmpty(editor, startLine, true) && EngineEditorHelperKt.isLineEmpty(editor, endLine, true)) {
            if (startLine == line) {
                --endLine;
                expandStart = true;
            } else {
                ++startLine;
                expandEnd = true;
            }
        } else if (!EngineEditorHelperKt.isLineEmpty(editor, endLine, true) && !EngineEditorHelperKt.isLineEmpty(editor, startLine, true) && startLine > 0) {
            --startLine;
            expandStart = true;
        } else {
            expandStart = EngineEditorHelperKt.isLineEmpty(editor, startLine, true);
            expandEnd = EngineEditorHelperKt.isLineEmpty(editor, endLine, true);
        }
        if (expandStart) {
            int n4 = startLine = EngineEditorHelperKt.isLineEmpty(editor, startLine, true) ? this.findLastEmptyLine(editor, startLine, Direction.BACKWARDS) : startLine;
        }
        if (expandEnd) {
            endLine = EngineEditorHelperKt.isLineEmpty(editor, endLine, true) ? this.findLastEmptyLine(editor, endLine, Direction.FORWARDS) : endLine;
        }
        return new Pair((Object)startLine, (Object)endLine);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Pair<Integer, Integer> findInnerParagraphRange(VimEditor editor, int line, int count) {
        int lineCount = editor.lineCount();
        int startLine = line;
        int endLine = 0;
        if (!EngineEditorHelperKt.isLineEmpty(editor, startLine, true)) {
            Integer n = this.findNextParagraphLine(editor, line, -1, true);
            if (n == null) {
                return null;
            }
            startLine = n;
            if (EngineEditorHelperKt.isLineEmpty(editor, startLine, true)) {
                ++startLine;
            }
            endLine = line;
        } else {
            endLine = line - 1;
        }
        int which = EngineEditorHelperKt.isLineEmpty(editor, startLine, true) ? 0 : 1;
        for (int i = 0; i < count; ++i) {
            if (which % 2 == 1) {
                int n;
                Integer nextParagraphLine = this.findNextParagraphLine(editor, endLine, Direction.FORWARDS, true);
                if (nextParagraphLine == null || nextParagraphLine == 0) {
                    if (i != count - 1) return null;
                    n = lineCount - 1;
                } else {
                    n = nextParagraphLine - 1;
                }
                endLine = n;
            } else {
                ++endLine;
            }
            ++which;
        }
        startLine = EngineEditorHelperKt.isLineEmpty(editor, startLine, true) ? this.findLastEmptyLine(editor, startLine, Direction.BACKWARDS) : startLine;
        endLine = EngineEditorHelperKt.isLineEmpty(editor, endLine, true) ? this.findLastEmptyLine(editor, endLine, Direction.FORWARDS) : endLine;
        return new Pair((Object)startLine, (Object)endLine);
    }

    @Contract(pure=true)
    private final int findLastEmptyLine(VimEditor editor, int line, Direction direction) {
        int n;
        if (!EngineEditorHelperKt.isLineEmpty(editor, line, true)) {
            logger.error("Method findLastEmptyLine was called for non-empty line");
            return line;
        }
        if (direction == Direction.BACKWARDS) {
            int previousNonEmptyLine = this.skipEmptyLines(editor, line, Direction.BACKWARDS, true);
            n = previousNonEmptyLine + 1;
        } else {
            int nextNonEmptyLine = this.skipEmptyLines(editor, line, Direction.FORWARDS, true);
            n = nextNonEmptyLine - 1;
        }
        return n;
    }

    @Contract(pure=true)
    private final Integer findNextParagraphLine(VimEditor editor, int startLine, int count, boolean allowBlanks) {
        int i;
        Integer line = startLine;
        int lineCount = editor.lineCount();
        Direction direction = count > 0 ? Direction.FORWARDS : Direction.BACKWARDS;
        for (i = Math.abs(count); i > 0 && line != null; --i) {
            line = this.findNextParagraphLine(editor, (int)line, direction, allowBlanks);
        }
        if (count != 0 && i == 0 && line == null) {
            line = direction == Direction.FORWARDS ? Integer.valueOf(lineCount - 1) : Integer.valueOf(0);
        }
        return line;
    }

    @Contract(pure=true)
    private final Integer findNextParagraphLine(VimEditor editor, int startLine, Direction direction, boolean allowBlanks) {
        int line = this.skipEmptyLines(editor, startLine, direction, allowBlanks);
        while (true) {
            boolean bl = 0 <= line ? line < editor.nativeLineCount() : false;
            if (!bl) break;
            if (EngineEditorHelperKt.isLineEmpty(editor, line, allowBlanks)) {
                return line;
            }
            line += direction.toInt();
        }
        return null;
    }

    @Contract(pure=true)
    private final int skipEmptyLines(VimEditor editor, int startLine, Direction direction, boolean allowBlanks) {
        int i = startLine;
        while (true) {
            boolean bl = 0 <= i ? i < editor.nativeLineCount() : false;
            if (!bl || !EngineEditorHelperKt.isLineEmpty(editor, i, allowBlanks)) break;
            i += direction.toInt();
        }
        return i;
    }

    @Override
    @NotNull
    public TextRange findWordObject(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, int count, boolean isOuter, boolean isBig) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        boolean hasSelection = EditorExtensionsKt.getInVisualMode(editor) && caret.getVimSelectionStart() != caret.getOffset();
        Direction direction = hasSelection && caret.getVimSelectionStart() > caret.getOffset() ? Direction.BACKWARDS : Direction.FORWARDS;
        int pos = caret.getOffset();
        CharSequence chars = editor.text();
        if (chars.length() == 0) {
            return new TextRange(0, 0);
        }
        if (chars.length() <= pos) {
            return new TextRange(chars.length() - 1, chars.length() - 1);
        }
        int start = 0;
        start = pos;
        int end = 0;
        end = start;
        int count2 = count;
        boolean shouldEndOnWhitespace = false;
        if (!hasSelection) {
            int n;
            CharacterHelper.CharacterType startingCharacterType = CharacterHelper.charType(editor, chars.charAt(pos), isBig);
            start = pos;
            if (!this.isEmptyLine(chars, start)) {
                int n2;
                while (start >= 0 && chars.charAt(start) != '\n' && CharacterHelper.charType(editor, chars.charAt(start), isBig) == startingCharacterType) {
                    n2 = start;
                    start = n2 + -1;
                }
                n2 = start;
                start = n2 + 1;
            }
            if (!isOuter && CharacterHelper.INSTANCE.isWhitespace(editor, chars.charAt(start), isBig) || isOuter && !CharacterHelper.INSTANCE.isWhitespace(editor, chars.charAt(start), isBig)) {
                if (isOuter) {
                    shouldEndOnWhitespace = true;
                }
                int offset = this.findNextWordOne(chars, editor, start, isBig, true);
                n = this.skipOneCharacterBack(offset);
            } else {
                n = this.findNextWordEndOne(chars, editor, start, isBig, true, false);
            }
            end = n;
            --count2;
        }
        block5: for (int startingCharacterType = 0; startingCharacterType < count2; ++startingCharacterType) {
            int it = startingCharacterType;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                case 1: {
                    int n;
                    int offset;
                    if (++end < chars.length() && chars.charAt(end) == '\n' && !this.isEmptyLine(chars, end)) {
                        ++end;
                    }
                    if (end >= chars.length()) {
                        end += -1;
                        continue block5;
                    }
                    if (!isOuter && CharacterHelper.INSTANCE.isWhitespace(editor, chars.charAt(end), isBig) || isOuter && !CharacterHelper.INSTANCE.isWhitespace(editor, chars.charAt(end), isBig)) {
                        offset = this.findNextWordOne(chars, editor, end, isBig, true);
                        n = this.skipOneCharacterBackOnCurrentLine(chars, offset);
                    } else {
                        n = this.findNextWordEndOne(chars, editor, end, isBig, true, false);
                    }
                    end = n;
                    break;
                }
                case 2: {
                    int offset;
                    if ((start += -1) > 0 && chars.charAt(start) == '\n' && !this.isEmptyLine(chars, start)) {
                        start += -1;
                    }
                    if (start < 0) {
                        ++start;
                        continue block5;
                    }
                    start = !isOuter && CharacterHelper.INSTANCE.isWhitespace(editor, chars.charAt(start), isBig) || isOuter && !CharacterHelper.INSTANCE.isWhitespace(editor, chars.charAt(start), isBig) ? (chars.charAt(offset = this.findPreviousWordEndOne(chars, editor, start, isBig, true) + 1) == '\n' ? offset + 1 : offset) : this.findPreviousWordOne(chars, editor, start, isBig, false);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        if (isOuter && shouldEndOnWhitespace && start > 0 && !CharacterHelper.INSTANCE.isWhitespace(editor, chars.charAt(end), isBig) && !CharacterHelper.INSTANCE.isWhitespace(editor, chars.charAt(start), isBig)) {
            int offset;
            for (offset = start - 1; offset >= 0 && chars.charAt(offset) != '\n' && CharacterHelper.INSTANCE.isWhitespace(editor, chars.charAt(offset), isBig); --offset) {
            }
            if (offset > 0 && chars.charAt(offset) != '\n') {
                start = offset + 1;
            }
        }
        if (start == end && chars.charAt(start) == '\n') {
            int n = end;
            end = n + 1;
        }
        return new TextRange(start, end + 1);
    }

    @Override
    @Nullable
    public TextRange findBlockTagRange(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, int count, boolean isOuter) {
        int selectionEndWithoutNewline;
        TextRange openingTag;
        TextRange closingTagTextRange;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        int counter = count;
        boolean isOuterVariable = isOuter;
        int position = caret.getOffset();
        CharSequence sequence = editor.text();
        int selectionStart = caret.getSelectionStart();
        int selectionEnd = caret.getSelectionEnd();
        boolean isRangeSelection = selectionEnd - selectionStart > 1;
        int searchStartPosition = 0;
        if (!isRangeSelection) {
            int line = caret.getBufferPosition().getLine();
            int lineBegin = editor.getLineStartOffset(line);
            v0 = this.ignoreWhitespaceAtLineStart(sequence, lineBegin, position);
        } else {
            v0 = searchStartPosition = selectionEnd;
        }
        if (this.isInHTMLTag(sequence, searchStartPosition, false)) {
            while (searchStartPosition < sequence.length() && sequence.charAt(searchStartPosition) != '>') {
                ++searchStartPosition;
            }
        } else if (this.isInHTMLTag(sequence, searchStartPosition, true)) {
            while (searchStartPosition > 0 && sequence.charAt(searchStartPosition) != '<') {
                --searchStartPosition;
            }
        }
        while (true) {
            Pair<TextRange, String> pair;
            if (this.findUnmatchedClosingTag(sequence, searchStartPosition, counter) == null) {
                return null;
            }
            closingTagTextRange = (TextRange)pair.component1();
            String tagName = (String)pair.component2();
            if (this.findUnmatchedOpeningTag(sequence, closingTagTextRange.getStartOffset(), tagName) == null) {
                return null;
            }
            if (!isRangeSelection || openingTag.getEndOffset() - 1 < selectionStart) break;
            searchStartPosition = closingTagTextRange.getEndOffset();
            counter = 1;
        }
        for (selectionEndWithoutNewline = selectionEnd; selectionEndWithoutNewline < sequence.length() && sequence.charAt(selectionEndWithoutNewline) == '\n'; ++selectionEndWithoutNewline) {
        }
        Mode mode = editor.getMode();
        if (mode instanceof Mode.VISUAL) {
            if (closingTagTextRange.getStartOffset() == selectionEndWithoutNewline && openingTag.getEndOffset() == selectionStart) {
                isOuterVariable = true;
            } else if (openingTag.getEndOffset() == closingTagTextRange.getStartOffset() && selectionStart == openingTag.getEndOffset()) {
                isOuterVariable = true;
            }
        }
        return isOuterVariable ? new TextRange(openingTag.getStartOffset(), closingTagTextRange.getEndOffset()) : new TextRange(openingTag.getEndOffset(), closingTagTextRange.getStartOffset());
    }

    private final int ignoreWhitespaceAtLineStart(CharSequence seq, int lineStart, int pos) {
        int position = pos;
        if (seq.subSequence(lineStart, position).chars().allMatch(VimSearchHelperBase::ignoreWhitespaceAtLineStart$lambda$0)) {
            while (position < seq.length() && seq.charAt(position) != '\n' && Character.isWhitespace(seq.charAt(position))) {
                ++position;
            }
        }
        return position;
    }

    private final boolean isInHTMLTag(CharSequence sequence, int position, boolean isEndtag) {
        boolean hasSlashAfterOpening;
        int openingBracket = 0;
        openingBracket = -1;
        VimSearchHelperBase $this$isInHTMLTag_u24lambda_u240 = this;
        boolean bl = false;
        for (int i = position; i >= 0 && i < sequence.length(); --i) {
            if (sequence.charAt(i) == '<') {
                openingBracket = i;
                break;
            }
            if (sequence.charAt(i) != '>' || i == position) continue;
            return false;
        }
        if (openingBracket == -1) {
            return false;
        }
        boolean bl2 = hasSlashAfterOpening = openingBracket + 1 < sequence.length() && sequence.charAt(openingBracket + 1) == '/';
        if (isEndtag && !hasSlashAfterOpening || !isEndtag && hasSlashAfterOpening) {
            return false;
        }
        int closingBracket = -1;
        int n = sequence.length();
        for (int i = openingBracket; i < n; ++i) {
            if (sequence.charAt(i) != '>') continue;
            closingBracket = i;
            break;
        }
        return closingBracket != -1 && sequence.charAt(closingBracket - 1) != '/';
    }

    private final TextRange findUnmatchedOpeningTag(CharSequence sequence, int position, String tagName) {
        String quotedTagName = Pattern.quote(tagName);
        String patternString = "(</%s>)|(<%s(\\s([^>]*[^/])?)?>)";
        Object[] objectArray = new Object[]{quotedTagName, quotedTagName};
        String string = String.format(patternString, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        Pattern tagPattern = Pattern.compile(string, 2);
        Matcher matcher = tagPattern.matcher(sequence.subSequence(0, position + 1));
        Deque openTags = new ArrayDeque();
        while (matcher.find()) {
            TextRange match = new TextRange(matcher.start(), matcher.end());
            if (sequence.charAt(matcher.start() + 1) == '/') {
                if (openTags.isEmpty()) continue;
                openTags.pop();
                continue;
            }
            openTags.push(match);
        }
        return openTags.isEmpty() ? null : (TextRange)openTags.pop();
    }

    private final Pair<TextRange, String> findUnmatchedClosingTag(CharSequence sequence, int position, int count) {
        int counter = count;
        String tagNamePattern = "([^/\\s>]+)";
        String string = "<%s(?:\\s[^>]*)?>";
        Object object = new Object[]{tagNamePattern};
        String string2 = String.format(string, Arrays.copyOf(object, ((Object[])object).length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String openingTagPattern = string2;
        object = "</%s>";
        Object object2 = new Object[]{tagNamePattern};
        String string3 = String.format((String)object, Arrays.copyOf(object2, ((Object[])object2).length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        String closingTagPattern = string3;
        object2 = "(?:%s)|(?:%s)";
        Object[] objectArray = new Object[]{openingTagPattern, closingTagPattern};
        String string4 = String.format((String)object2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        Pattern tagPattern = Pattern.compile(string4);
        Matcher matcher = tagPattern.matcher(sequence.subSequence(position, sequence.length()));
        Deque openTags = new ArrayDeque();
        while (matcher.find()) {
            String tagName;
            boolean isClosingTag;
            boolean bl = isClosingTag = matcher.group(1) == null;
            if (isClosingTag) {
                tagName = matcher.group(2);
                while (!openTags.isEmpty() && !StringsKt.equals((String)((String)openTags.peek()), (String)tagName, (boolean)true)) {
                    openTags.pop();
                }
                if (openTags.isEmpty()) {
                    if (counter <= 1) {
                        return new Pair((Object)new TextRange(position + matcher.start(), position + matcher.end()), (Object)tagName);
                    }
                    --counter;
                    continue;
                }
                openTags.pop();
                continue;
            }
            tagName = matcher.group(1);
            openTags.push(tagName);
        }
        return null;
    }

    private static final boolean ignoreWhitespaceAtLineStart$lambda$0(int codePoint) {
        return Character.isWhitespace(codePoint);
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(VimSearchHelperBase.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/maddyhome/idea/vim/api/VimSearchHelperBase$Companion;", "", "<init>", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.FORWARDS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.BACKWARDS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

