/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.handler;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.StringListOptionValue;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.Command;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.handler.VimActionHandler;
import com.maddyhome.idea.vim.state.mode.EditorExtensionsKt;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\"\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002J0\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J&\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH&J \u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH&R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/maddyhome/idea/vim/handler/ShiftedArrowKeyHandler;", "Lcom/maddyhome/idea/vim/handler/VimActionHandler$ConditionalMulticaret;", "runBothCommandsAsMulticaret", "", "<init>", "(Z)V", "runAsMulticaret", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "cmd", "Lcom/maddyhome/idea/vim/command/Command;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "withKeyOrNot", "Lkotlin/Triple;", "execute", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "motionWithKeyModel", "", "motionWithoutKeyModel", "vim-engine"})
public abstract class ShiftedArrowKeyHandler
extends VimActionHandler.ConditionalMulticaret {
    private final boolean runBothCommandsAsMulticaret;

    public ShiftedArrowKeyHandler(boolean runBothCommandsAsMulticaret) {
        this.runBothCommandsAsMulticaret = runBothCommandsAsMulticaret;
    }

    @Override
    public boolean runAsMulticaret(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull Command cmd, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        Triple<Boolean, Boolean, Boolean> triple = this.withKeyOrNot(editor);
        boolean inVisualMode = (Boolean)triple.component1();
        boolean inSelectMode = (Boolean)triple.component2();
        boolean withKey = (Boolean)triple.component3();
        if (withKey) {
            if (!inVisualMode && !inSelectMode) {
                boolean bl = VimInjectorKt.globalOptions(VimInjectorKt.getInjector()).getSelectmode().contains((Object)"key") ? VimInjectorKt.getInjector().getVisualMotionGroup().enterSelectMode(editor, SelectionType.CHARACTER_WISE) : (EditorExtensionsKt.isInsertionAllowed(editor) ? VimInjectorKt.getInjector().getVisualMotionGroup().enterVisualMode(editor, SelectionType.CHARACTER_WISE, editor.getMode()) : VimInjectorKt.getInjector().getVisualMotionGroup().enterVisualMode(editor, SelectionType.CHARACTER_WISE));
            }
            return true;
        }
        return this.runBothCommandsAsMulticaret;
    }

    private final Triple<Boolean, Boolean, Boolean> withKeyOrNot(VimEditor editor) {
        StringListOptionValue keymodelOption = VimInjectorKt.globalOptions(VimInjectorKt.getInjector()).getKeymodel();
        boolean startSel = keymodelOption.contains((Object)"startsel");
        boolean inVisualMode = EditorExtensionsKt.getInVisualMode(editor);
        boolean inSelectMode = EditorExtensionsKt.getInSelectMode(editor);
        boolean continueSelectSelection = keymodelOption.contains((Object)"continueselect") && inSelectMode;
        boolean continueVisualSelection = keymodelOption.contains((Object)"continuevisual") && inVisualMode;
        boolean withKey = startSel || continueSelectSelection || continueVisualSelection;
        return new Triple((Object)inVisualMode, (Object)inSelectMode, (Object)withKey);
    }

    @Override
    public boolean execute(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull ExecutionContext context, @NotNull Command cmd, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        if (this.runBothCommandsAsMulticaret) {
            boolean withKey = (Boolean)this.withKeyOrNot(editor).component3();
            if (withKey) {
                this.motionWithKeyModel(editor, caret, context, cmd);
            } else {
                this.motionWithoutKeyModel(editor, context, cmd);
            }
        } else {
            this.motionWithKeyModel(editor, caret, context, cmd);
        }
        return true;
    }

    @Override
    public final boolean execute(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull Command cmd, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        this.motionWithoutKeyModel(editor, context, cmd);
        return true;
    }

    public abstract void motionWithKeyModel(@NotNull VimEditor var1, @NotNull VimCaret var2, @NotNull ExecutionContext var3, @NotNull Command var4);

    public abstract void motionWithoutKeyModel(@NotNull VimEditor var1, @NotNull ExecutionContext var2, @NotNull Command var3);
}

