/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.helper;

import com.maddyhome.idea.vim.helper.CharacterHelper;
import java.util.Arrays;
import java.util.List;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\bH\u0007J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u0011"}, d2={"Lcom/maddyhome/idea/vim/helper/EngineStringHelper;", "", "<init>", "()V", "toPrintableCharacters", "", "keys", "", "Ljavax/swing/KeyStroke;", "toPrintableCharacter", "key", "c", "", "codepoint", "", "isPrintableCharacter", "", "vim-engine"})
public final class EngineStringHelper {
    @NotNull
    public static final EngineStringHelper INSTANCE = new EngineStringHelper();

    private EngineStringHelper() {
    }

    @NotNull
    public final String toPrintableCharacters(@NotNull List<? extends KeyStroke> keys) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        if (keys.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (KeyStroke keyStroke : keys) {
            builder.append(EngineStringHelper.toPrintableCharacter(keyStroke));
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String toPrintableCharacter(@NotNull KeyStroke key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        char c = key.getKeyChar();
        if (c == '\uffff' && key.getModifiers() == 0) {
            c = (char)key.getKeyCode();
        } else if (c == '\uffff' && (key.getModifiers() & 0x80) != 0) {
            int code = key.getKeyCode();
            if (code >= 65 && code <= 95) {
                c = (char)(code - 65 + 1);
            } else {
                return "^" + (char)code;
            }
        }
        return INSTANCE.toPrintableCharacter(c);
    }

    @NotNull
    public final String toPrintableCharacter(char c) {
        return this.toPrintableCharacter((int)c);
    }

    @NotNull
    public final String toPrintableCharacter(int codepoint) {
        if (codepoint <= 31) {
            return "^" + (char)(codepoint + 65 - 1);
        }
        if (codepoint == 127) {
            return "^" + (char)(codepoint - 65 + 1);
        }
        if (CharacterHelper.INSTANCE.isInvisibleControlCharacter(codepoint) || CharacterHelper.INSTANCE.isZeroWidthCharacter(codepoint)) {
            if (codepoint > 255) {
                String string = "<%04x>";
                Object[] objectArray = new Object[]{codepoint};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                return string2;
            }
            String string = "<%02x>";
            Object[] objectArray = new Object[]{codepoint};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            return string3;
        }
        char[] cArray = Character.toChars(codepoint);
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toChars(...)");
        char[] cArray2 = cArray;
        return new String(cArray2);
    }

    public final boolean isPrintableCharacter(char c) {
        return c >= ' ' && c != '\u007f' && !CharacterHelper.INSTANCE.isInvisibleControlCharacter(c) && !CharacterHelper.INSTANCE.isZeroWidthCharacter(c);
    }
}

