/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.put;

import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.MutableVimEditor;
import com.maddyhome.idea.vim.api.VimApplication;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimCaretKt;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimMarkServiceKt;
import com.maddyhome.idea.vim.api.VimMotionGroup;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.group.visual.VimSelection;
import com.maddyhome.idea.vim.helper.VimLockLabel;
import com.maddyhome.idea.vim.put.ProcessedTextData;
import com.maddyhome.idea.vim.put.PutData;
import com.maddyhome.idea.vim.put.VimPasteProvider;
import com.maddyhome.idea.vim.put.VimPut;
import com.maddyhome.idea.vim.put.VimPutBaseKt;
import com.maddyhome.idea.vim.state.mode.Mode;
import com.maddyhome.idea.vim.state.mode.ModeExtensionsKt;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\t\b&\u0018\u0000 72\u00020\u0001:\u00017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0017J$\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000bH\u0002J2\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0005H\u0003J(\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0005H\u0003J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\n\u001a\u00020\u000bH\u0002J@\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u0005H\u0004J0\u0010!\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016Jd\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00150#2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u0005H\u0002Jd\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00150#2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u0005H\u0002J\u0010\u0010+\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u0010H\u0002Jd\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00150#2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u0005H\u0002Jd\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00150#2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u0005H\u0002JB\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001b0/2\u0006\u00100\u001a\u00020\u00072\u0006\u00101\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u0005JD\u00103\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u0018H\u0003J8\u00104\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u00105\u001a\u00020\u0005H\u0017J<\u00106\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000b2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u0017\u00a8\u00068"}, d2={"Lcom/maddyhome/idea/vim/put/VimPutBase;", "Lcom/maddyhome/idea/vim/put/VimPut;", "<init>", "()V", "putText", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "data", "Lcom/maddyhome/idea/vim/put/PutData;", "updateVisualMarks", "saveToRegister", "collectPreModificationData", "", "", "", "wrapInsertedTextWithVisualMarks", "", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "deleteSelectedText", "processText", "Lcom/maddyhome/idea/vim/put/ProcessedTextData;", "moveCaretToEndPosition", "startOffset", "", "endOffset", "typeInRegister", "Lcom/maddyhome/idea/vim/state/mode/SelectionType;", "modeInEditor", "caretAfterInsertedText", "doIndent", "putTextCharacterwise", "Lkotlin/Pair;", "text", "type", "mode", "count", "indent", "cursorAfter", "putTextLinewise", "getMaxSegmentLength", "putTextBlockwise", "putTextInternal", "prepareDocumentAndGetStartOffsets", "", "vimEditor", "vimCaret", "additionalData", "putForCaret", "putTextForCaret", "modifyRegister", "putTextAndSetCaretPosition", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nVimPutBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimPutBase.kt\ncom/maddyhome/idea/vim/put/VimPutBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,609:1\n1068#2:610\n1869#2,2:611\n1563#2:613\n1634#2,3:614\n1869#2,2:617\n1068#2:619\n1869#2,2:620\n39#3:622\n*S KotlinDebug\n*F\n+ 1 VimPutBase.kt\ncom/maddyhome/idea/vim/put/VimPutBase\n*L\n119#1:610\n120#1:611,2\n430#1:613\n430#1:614,3\n512#1:617,2\n581#1:619\n583#1:620,2\n587#1:622\n*E\n"})
public abstract class VimPutBase
implements VimPut {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<VimLogger> logger$delegate = LazyKt.lazy(VimPutBase::logger_delegate$lambda$0);

    @Override
    @VimLockLabel.SelfSynchronized
    public boolean putText(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull PutData data, boolean updateVisualMarks, boolean saveToRegister) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Map<String, Object> additionalData = this.collectPreModificationData(editor, data);
        this.deleteSelectedText(editor, context, data, saveToRegister);
        ProcessedTextData processedTextData = this.processText(null, data);
        if (processedTextData == null) {
            return false;
        }
        ProcessedTextData processedText = processedTextData;
        this.putTextAndSetCaretPosition(editor, context, processedText, data, additionalData);
        if (updateVisualMarks) {
            this.wrapInsertedTextWithVisualMarks(editor.currentCaret(), data);
        }
        return true;
    }

    private final Map<String, Object> collectPreModificationData(VimEditor editor, PutData data) {
        Map map;
        if (data.getVisualSelection() != null && ModeExtensionsKt.isBlock(data.getVisualSelection().getTypeInEditor())) {
            VimSelection vimSelection = (VimSelection)MapsKt.getValue(data.getVisualSelection().getCaretsAndSelections(), (Object)editor.primaryCaret());
            BufferPosition selStart = editor.offsetToBufferPosition(vimSelection.getVimStart());
            BufferPosition selEnd = editor.offsetToBufferPosition(vimSelection.getVimEnd());
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"startColumnOfSelection", (Object)Math.min(selStart.getColumn(), selEnd.getColumn())), TuplesKt.to((Object)"selectedLines", (Object)Math.abs(selStart.getLine() - selEnd.getLine())), TuplesKt.to((Object)"firstSelectedLine", (Object)Math.min(selStart.getLine(), selEnd.getLine()))};
            map = MapsKt.mapOf((Pair[])pairArray);
        } else {
            map = new LinkedHashMap();
        }
        return map;
    }

    private final void wrapInsertedTextWithVisualMarks(VimCaret caret, PutData data) {
        Object object = data.getTextData();
        if (object == null || (object = ((PutData.TextData)object).getRawText()) == null) {
            return;
        }
        int textLength = ((String)object).length();
        Object object2 = data.getVisualSelection();
        if (object2 == null || (object2 = ((PutData.VisualSelection)object2).getCaretsAndSelections()) == null) {
            return;
        }
        Object caretsAndSelections = object2;
        VimSelection vimSelection = (VimSelection)caretsAndSelections.get(caret);
        if (vimSelection == null) {
            Map.Entry entry = (Map.Entry)CollectionsKt.firstOrNull((Iterable)caretsAndSelections.entrySet());
            vimSelection = entry != null ? (VimSelection)entry.getValue() : null;
            if (vimSelection == null) {
                return;
            }
        }
        VimSelection selection = vimSelection;
        int leftIndex = Math.min(selection.getVimStart(), selection.getVimEnd());
        int rightIndex = leftIndex + textLength - 1;
        TextRange rangeForMarks = new TextRange(leftIndex, rightIndex);
        VimMarkServiceKt.setVisualSelectionMarks(VimInjectorKt.getInjector().getMarkService(), caret, rangeForMarks);
    }

    @VimLockLabel.SelfSynchronized
    private final VimCaret deleteSelectedText(VimEditor editor, ExecutionContext context, VimCaret caret, PutData data, boolean saveToRegister) {
        if (data.getVisualSelection() == null) {
            return null;
        }
        if (!caret.isValid()) {
            return null;
        }
        VimSelection vimSelection = data.getVisualSelection().getCaretsAndSelections().get(caret);
        if (vimSelection == null) {
            return null;
        }
        VimSelection selectionForCaret = vimSelection;
        TextRange range = selectionForCaret.toVimTextRange(false).normalize();
        VimInjectorKt.getInjector().getApplication().runWriteAction(() -> VimPutBase.deleteSelectedText$lambda$0(editor, context, caret, range, selectionForCaret, saveToRegister));
        return caret.moveToInlayAwareOffset(range.getStartOffset());
    }

    /*
     * WARNING - void declaration
     */
    @VimLockLabel.SelfSynchronized
    private final void deleteSelectedText(VimEditor editor, ExecutionContext context, PutData data, boolean saveToRegister) {
        void $this$forEach$iv;
        if (data.getVisualSelection() == null) {
            return;
        }
        Iterable $this$sortedByDescending$iv = data.getVisualSelection().getCaretsAndSelections().entrySet();
        boolean $i$f$sortedByDescending = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = ((VimCaret)it.getKey()).getBufferPosition();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((VimCaret)it.getKey()).getBufferPosition());
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            VimCaret caret = (VimCaret)entry.getKey();
            VimSelection selection = (VimSelection)entry.getValue();
            if (!caret.isValid()) continue;
            TextRange range = selection.toVimTextRange(false).normalize();
            VimInjectorKt.getInjector().getApplication().runWriteAction(() -> VimPutBase.deleteSelectedText$lambda$2$0(editor, context, caret, range, selection, saveToRegister));
            caret.moveToInlayAwareOffset(range.getStartOffset());
        }
    }

    private final ProcessedTextData processText(VimCaret caret, PutData data) {
        Object object = data.getTextData();
        if (object == null || (object = ((PutData.TextData)object).getRawText()) == null) {
            VimPutBase $this$processText_u24lambda_u240 = this;
            boolean bl = false;
            if (caret == null) {
                return null;
            }
            if (data.getVisualSelection() != null) {
                int offset = caret.getOffset();
                VimInjectorKt.getInjector().getMarkService().setMark(caret, '.', offset);
                VimMarkServiceKt.setChangeMarks(VimInjectorKt.getInjector().getMarkService(), caret, new TextRange(offset, offset + 1));
            }
            return null;
        }
        Object text = object;
        Object object2 = data.getVisualSelection();
        boolean bl = object2 != null && (object2 = object2.getTypeInEditor()) != null ? ModeExtensionsKt.isLine((SelectionType)((Object)object2)) : false;
        if (bl && ModeExtensionsKt.isChar(data.getTextData().getTypeInRegister())) {
            text = (String)text + "\n";
        }
        if (ModeExtensionsKt.isLine(data.getTextData().getTypeInRegister()) && ((CharSequence)text).length() > 0 && StringsKt.last((CharSequence)((CharSequence)text)) != '\n') {
            text = (String)text + "\n";
        }
        if (ModeExtensionsKt.isChar(data.getTextData().getTypeInRegister())) {
            Character c = StringsKt.lastOrNull((CharSequence)((CharSequence)text));
            char c2 = '\n';
            if (c != null && c.charValue() == c2) {
                Object object3 = data.getVisualSelection();
                boolean bl2 = object3 != null && (object3 = object3.getTypeInEditor()) != null ? !ModeExtensionsKt.isLine((SelectionType)((Object)object3)) : false;
                if (bl2) {
                    text = StringsKt.dropLast((String)text, (int)1);
                }
            }
        }
        return new ProcessedTextData(data.getTextData().getRegisterChar(), data.getTextData().getCopiedText().updateText((String)text), data.getTextData().getTypeInRegister());
    }

    @NotNull
    protected final VimCaret moveCaretToEndPosition(@NotNull VimEditor editor, @NotNull VimCaret caret, int startOffset, int endOffset, @NotNull SelectionType typeInRegister, @NotNull SelectionType modeInEditor, boolean caretAfterInsertedText) {
        String cursorMode;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)((Object)typeInRegister), (String)"typeInRegister");
        Intrinsics.checkNotNullParameter((Object)((Object)modeInEditor), (String)"modeInEditor");
        return switch (cursorMode = (switch (WhenMappings.$EnumSwitchMapping$0[typeInRegister.ordinal()]) {
            case 2 -> {
                if (WhenMappings.$EnumSwitchMapping$0[modeInEditor.ordinal()] == 1) {
                    if (caretAfterInsertedText) {
                        yield "postEndOffset";
                    }
                    yield "startOffset";
                }
                if (caretAfterInsertedText) {
                    yield "preLineEndOfEndOffset";
                }
                yield "startOffset";
            }
            case 1 -> {
                if (caretAfterInsertedText) {
                    yield "postEndOffset";
                }
                yield "startOffsetSkipLeading";
            }
            case 3 -> {
                if (WhenMappings.$EnumSwitchMapping$0[modeInEditor.ordinal()] == 1) {
                    if (caretAfterInsertedText) {
                        yield "postEndOffset";
                    }
                    yield "startOffset";
                }
                if (caretAfterInsertedText) {
                    yield "preLineEndOfEndOffset";
                }
                yield "preEndOffset";
            }
            default -> throw new NoWhenBranchMatchedException();
        })) {
            case "startOffset" -> caret.moveToOffset(startOffset);
            case "preEndOffset" -> caret.moveToOffset(endOffset - 1);
            case "startOffsetSkipLeading" -> {
                VimCaret updated = caret.moveToOffset(startOffset);
                yield updated.moveToOffset(VimInjectorKt.getInjector().getMotion().moveCaretToCurrentLineStartSkipLeading(editor, updated));
            }
            case "postEndOffset" -> caret.moveToOffset(endOffset + 1);
            case "preLineEndOfEndOffset" -> {
                int rightestPosition = EngineEditorHelperKt.getLineEndForOffset(editor, endOffset - 1);
                if (!(editor.getMode() instanceof Mode.INSERT)) {
                    --rightestPosition;
                }
                int pos = Math.min(endOffset, rightestPosition);
                yield caret.moveToOffset(pos);
            }
            default -> throw new IllegalStateException("Unexpected mode".toString());
        };
    }

    @Override
    public int doIndent(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull ExecutionContext context, int startOffset, int endOffset) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    private final Pair<Integer, VimCaret> putTextCharacterwise(VimEditor editor, VimCaret caret, ExecutionContext context, String text, SelectionType type, SelectionType mode, int startOffset, int count, boolean indent, boolean cursorAfter) {
        VimCaret updatedCaret = caret.moveToOffset(startOffset);
        String insertedText = StringsKt.repeat((CharSequence)text, (int)count);
        updatedCaret = VimInjectorKt.getInjector().getChangeGroup().insertText(editor, updatedCaret, insertedText);
        int endOffset = indent ? this.doIndent(editor, updatedCaret, context, startOffset, startOffset + insertedText.length()) : startOffset + insertedText.length();
        updatedCaret = this.moveCaretToEndPosition(editor, updatedCaret, startOffset, endOffset, type, mode, cursorAfter);
        return TuplesKt.to((Object)endOffset, (Object)updatedCaret);
    }

    private final Pair<Integer, VimCaret> putTextLinewise(VimEditor editor, VimCaret caret, ExecutionContext context, String text, SelectionType type, SelectionType mode, int startOffset, int count, boolean indent, boolean cursorAfter) {
        ArrayList<VimCaret> overlappedCarets = new ArrayList<VimCaret>(editor.carets().size());
        for (VimCaret possiblyOverlappedCaret : editor.carets()) {
            if (possiblyOverlappedCaret.getOffset() != startOffset || Intrinsics.areEqual((Object)possiblyOverlappedCaret, (Object)caret)) continue;
            VimCaret updated = VimCaretKt.moveToMotion(possiblyOverlappedCaret, VimMotionGroup.getHorizontalMotion$default(VimInjectorKt.getInjector().getMotion(), editor, possiblyOverlappedCaret, 1, true, false, 16, null));
            overlappedCarets.add(updated);
        }
        Pair<Integer, VimCaret> endOffset = this.putTextCharacterwise(editor, caret, context, text, type, mode, startOffset, count, indent, cursorAfter);
        Iterator iterator = overlappedCarets.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            VimCaret overlappedCaret = (VimCaret)e;
            VimCaretKt.moveToMotion(overlappedCaret, VimMotionGroup.getHorizontalMotion$default(VimInjectorKt.getInjector().getMotion(), editor, overlappedCaret, -1, true, false, 16, null));
        }
        return endOffset;
    }

    private final int getMaxSegmentLength(String text) {
        StringTokenizer tokenizer = new StringTokenizer(text, "\n");
        int maxLen = 0;
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            maxLen = Math.max(s.length(), maxLen);
        }
        return maxLen;
    }

    private final Pair<Integer, VimCaret> putTextBlockwise(VimEditor editor, VimCaret caret, ExecutionContext context, String text, SelectionType type, SelectionType mode, int startOffset, int count, boolean indent, boolean cursorAfter) {
        BufferPosition startPosition = editor.offsetToBufferPosition(startOffset);
        int currentColumn = mode == SelectionType.LINE_WISE ? 0 : startPosition.getColumn();
        int currentLine = startPosition.getLine();
        int lineCount = VimPutBaseKt.access$getLineBreakCount(text) + 1;
        VimCaret updated = null;
        updated = caret;
        if (currentLine + lineCount >= editor.nativeLineCount()) {
            int limit = currentLine + lineCount - editor.nativeLineCount();
            int n = 0;
            while (n < limit) {
                int it = n++;
                boolean bl = false;
                updated = updated.moveToOffset((int)editor.fileSize());
                updated = VimInjectorKt.getInjector().getChangeGroup().insertText(editor, updated, "\n");
            }
        }
        int maxLen = this.getMaxSegmentLength(text);
        StringTokenizer tokenizer = new StringTokenizer(text, "\n");
        int endOffset = startOffset;
        while (tokenizer.hasMoreTokens()) {
            Object segment;
            Object origSegment = segment = tokenizer.nextToken();
            if (((String)segment).length() < maxLen) {
                segment = (String)segment + StringsKt.repeat((CharSequence)" ", (int)(maxLen - ((String)segment).length()));
                if (currentColumn != 0 && currentColumn < EngineEditorHelperKt.lineLength(editor, currentLine)) {
                    origSegment = segment;
                }
            }
            String pad = VimInjectorKt.getInjector().getEngineEditorHelper().pad(editor, currentLine, currentColumn);
            int insertOffset = editor.bufferPositionToOffset(new BufferPosition(currentLine, currentColumn, false, 4, null));
            updated = updated.moveToOffset(insertOffset);
            Object object = segment;
            Intrinsics.checkNotNull((Object)object);
            String insertedText = (String)origSegment + StringsKt.repeat((CharSequence)((CharSequence)object), (int)(count - 1));
            updated = VimInjectorKt.getInjector().getChangeGroup().insertText(editor, updated, insertedText);
            endOffset += insertedText.length();
            if (mode == SelectionType.LINE_WISE) {
                updated = updated.moveToOffset(endOffset);
                updated = VimInjectorKt.getInjector().getChangeGroup().insertText(editor, updated, "\n");
                ++endOffset;
            } else if (((CharSequence)pad).length() > 0) {
                updated = updated.moveToOffset(insertOffset);
                updated = VimInjectorKt.getInjector().getChangeGroup().insertText(editor, updated, pad);
                endOffset += pad.length();
            }
            ++currentLine;
        }
        if (indent) {
            endOffset = this.doIndent(editor, updated, context, startOffset, endOffset);
        }
        updated = this.moveCaretToEndPosition(editor, updated, startOffset, endOffset, type, mode, cursorAfter);
        return TuplesKt.to((Object)endOffset, (Object)updated);
    }

    private final Pair<Integer, VimCaret> putTextInternal(VimEditor editor, VimCaret caret, ExecutionContext context, String text, SelectionType type, SelectionType mode, int startOffset, int count, boolean indent, boolean cursorAfter) {
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 3 -> this.putTextCharacterwise(editor, caret, context, text, type, mode, startOffset, count, indent, cursorAfter);
            case 1 -> this.putTextLinewise(editor, caret, context, text, type, mode, startOffset, count, indent, cursorAfter);
            default -> this.putTextBlockwise(editor, caret, context, text, type, mode, startOffset, count, indent, cursorAfter);
        };
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @VimLockLabel.SelfSynchronized
    @NotNull
    protected final List<Integer> prepareDocumentAndGetStartOffsets(@NotNull VimEditor vimEditor, @NotNull VimCaret vimCaret, @NotNull SelectionType typeInRegister, @NotNull PutData data, @NotNull Map<String, ? extends Object> additionalData) {
        List list;
        int line;
        Intrinsics.checkNotNullParameter((Object)vimEditor, (String)"vimEditor");
        Intrinsics.checkNotNullParameter((Object)vimCaret, (String)"vimCaret");
        Intrinsics.checkNotNullParameter((Object)((Object)typeInRegister), (String)"typeInRegister");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter(additionalData, (String)"additionalData");
        VimApplication application = VimInjectorKt.getInjector().getApplication();
        PutData.VisualSelection visualSelection = data.getVisualSelection();
        if (visualSelection != null) {
            Character lastChar;
            List list2;
            if (ModeExtensionsKt.isChar(visualSelection.getTypeInEditor()) && ModeExtensionsKt.isLine(typeInRegister)) {
                application.runWriteAction(() -> VimPutBase.prepareDocumentAndGetStartOffsets$lambda$0(vimEditor, vimCaret));
                list2 = CollectionsKt.listOf((Object)(vimCaret.getOffset() + 1));
                return list2;
            }
            if (ModeExtensionsKt.isBlock(visualSelection.getTypeInEditor())) {
                Object object = additionalData.get("firstSelectedLine");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                int firstSelectedLine = (Integer)object;
                Object object2 = additionalData.get("selectedLines");
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Int");
                int selectedLines = (Integer)object2;
                Object object3 = additionalData.get("startColumnOfSelection");
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.Int");
                int startColumnOfSelection = (Integer)object3;
                int line2 = RangesKt.coerceAtMost((int)(data.getInsertTextBeforeCaret() ? firstSelectedLine : firstSelectedLine + selectedLines), (int)(vimEditor.lineCount() - 1));
                switch (WhenMappings.$EnumSwitchMapping$0[typeInRegister.ordinal()]) {
                    case 1: {
                        if (data.getInsertTextBeforeCaret()) {
                            list2 = CollectionsKt.listOf((Object)vimEditor.getLineStartOffset(line2));
                            return list2;
                        }
                        int pos = EngineEditorHelperKt.getLineEndOffset(vimEditor, line2, true);
                        application.runWriteAction(() -> VimPutBase.prepareDocumentAndGetStartOffsets$lambda$1(vimEditor, vimCaret, pos));
                        list2 = CollectionsKt.listOf((Object)(pos + 1));
                        return list2;
                    }
                    case 3: {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Iterable pos = (Iterable)RangesKt.downTo((int)(firstSelectedLine + selectedLines), (int)firstSelectedLine);
                        boolean $i$f$map = false;
                        void var15_19 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        Iterator iterator = $this$mapTo$iv$iv.iterator();
                        while (true) {
                            void it;
                            int item$iv$iv;
                            if (!iterator.hasNext()) {
                                list2 = (List)destination$iv$iv;
                                return list2;
                            }
                            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(vimEditor.bufferPositionToOffset(new BufferPosition((int)it, startColumnOfSelection, false, 4, null)));
                        }
                    }
                    case 2: {
                        list2 = CollectionsKt.listOf((Object)vimEditor.bufferPositionToOffset(new BufferPosition(firstSelectedLine, startColumnOfSelection, false, 4, null)));
                        return list2;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            if (!ModeExtensionsKt.isLine(visualSelection.getTypeInEditor())) {
                list2 = CollectionsKt.listOf((Object)vimCaret.getOffset());
                return list2;
            }
            Character c = lastChar = vimEditor.fileSize() > 0L ? Character.valueOf(EngineEditorHelperKt.getText(vimEditor, new TextRange((int)vimEditor.fileSize() - 1, (int)vimEditor.fileSize())).charAt(0)) : null;
            if (vimCaret.getOffset() == (int)vimEditor.fileSize() && (int)vimEditor.fileSize() != 0) {
                Character c2 = lastChar;
                char selectedLines = '\n';
                if (c2 == null || c2.charValue() != selectedLines) {
                    application.runWriteAction(() -> VimPutBase.prepareDocumentAndGetStartOffsets$lambda$3(vimEditor, vimCaret));
                    list2 = CollectionsKt.listOf((Object)(vimCaret.getOffset() + 1));
                    return list2;
                }
            }
            list2 = CollectionsKt.listOf((Object)vimCaret.getOffset());
            return list2;
        }
        if (data.getInsertTextBeforeCaret()) {
            List list3;
            if (WhenMappings.$EnumSwitchMapping$0[typeInRegister.ordinal()] == 1) {
                list3 = CollectionsKt.listOf((Object)VimInjectorKt.getInjector().getMotion().moveCaretToCurrentLineStart(vimEditor, vimCaret));
                return list3;
            }
            list3 = CollectionsKt.listOf((Object)vimCaret.getOffset());
            return list3;
        }
        Ref.IntRef startOffset = new Ref.IntRef();
        int n = line = data.getPutToLine() < 0 ? vimCaret.getBufferPosition().getLine() : data.getPutToLine();
        if (WhenMappings.$EnumSwitchMapping$0[typeInRegister.ordinal()] == 1) {
            startOffset.element = Math.min(vimEditor.text().length(), VimInjectorKt.getInjector().getMotion().moveCaretToLineEnd(vimEditor, line, true) + 1);
            if (startOffset.element > 0 && vimEditor.getDocument().getOffsetGuard(startOffset.element) != null) {
                application.runWriteAction(() -> VimPutBase.prepareDocumentAndGetStartOffsets$lambda$4(vimEditor, vimCaret, startOffset));
            }
            if (startOffset.element > 0 && startOffset.element == vimEditor.text().length() && vimEditor.text().charAt(startOffset.element - 1) != '\n') {
                application.runWriteAction(() -> VimPutBase.prepareDocumentAndGetStartOffsets$lambda$5(vimEditor, vimCaret, startOffset));
                int n2 = startOffset.element;
                startOffset.element = n2 + 1;
            }
        } else {
            startOffset.element = vimCaret.getOffset();
            if (!EngineEditorHelperKt.isLineEmpty(vimEditor, line, false)) {
                int n3 = startOffset.element;
                startOffset.element = n3 + 1;
            }
        }
        if (startOffset.element > vimEditor.text().length()) {
            list = CollectionsKt.listOf((Object)vimEditor.text().length());
            return list;
        }
        list = CollectionsKt.listOf((Object)startOffset.element);
        return list;
    }

    @VimLockLabel.SelfSynchronized
    private final VimCaret putForCaret(VimEditor editor, VimCaret caret, PutData data, Map<String, ? extends Object> additionalData, ExecutionContext context, ProcessedTextData text) {
        VimCaret updated = null;
        updated = caret;
        this.notifyAboutIdeaPut(editor);
        Object object = data.getVisualSelection();
        boolean bl = object != null && (object = object.getTypeInEditor()) != null ? ModeExtensionsKt.isLine((SelectionType)((Object)object)) : false;
        if (bl && editor.isOneLineMode()) {
            return updated;
        }
        List<Integer> startOffsets = this.prepareDocumentAndGetStartOffsets(editor, updated, text.getTypeInRegister(), data, additionalData);
        Iterable $this$forEach$iv = startOffsets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VimCaret updatedCaret;
            int startOffset = ((Number)element$iv).intValue();
            boolean bl2 = false;
            Object object2 = data.getVisualSelection();
            if (object2 == null || (object2 = object2.getTypeInEditor()) == null) {
                object2 = SelectionType.CHARACTER_WISE;
            }
            Object selectionType = object2;
            Pair<Integer, VimCaret> pair = this.putTextInternal(editor, updated, context, text.getCopiedText().getText(), text.getTypeInRegister(), (SelectionType)((Object)selectionType), startOffset, data.getCount(), data.getIndent(), data.getCaretAfterInsertedText());
            int endOffset = ((Number)pair.component1()).intValue();
            updated = updatedCaret = (VimCaret)pair.component2();
            VimMarkServiceKt.setChangeMarks(VimInjectorKt.getInjector().getMarkService(), updatedCaret, new TextRange(startOffset, endOffset));
            updated = this.moveCaretToEndPosition(editor, updatedCaret, startOffset, endOffset, text.getTypeInRegister(), (SelectionType)((Object)selectionType), data.getCaretAfterInsertedText());
        }
        return updated;
    }

    @Override
    @VimLockLabel.SelfSynchronized
    public boolean putTextForCaret(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull ExecutionContext context, @NotNull PutData data, boolean updateVisualMarks, boolean modifyRegister) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Map<String, Object> additionalData = this.collectPreModificationData(editor, data);
        VimCaret currentCaret = null;
        currentCaret = caret;
        PutData.VisualSelection visualSelection = data.getVisualSelection();
        if (visualSelection != null) {
            PutData.VisualSelection it = visualSelection;
            boolean bl = false;
            VimCaret vimCaret = this.deleteSelectedText(editor, context, caret, data, modifyRegister);
            if (vimCaret == null) {
                return false;
            }
            currentCaret = vimCaret;
        }
        ProcessedTextData processedTextData = this.processText(currentCaret, data);
        if (processedTextData == null) {
            return false;
        }
        ProcessedTextData processedText = processedTextData;
        currentCaret = this.putForCaret(editor, currentCaret, data, additionalData, context, processedText);
        if (updateVisualMarks) {
            this.wrapInsertedTextWithVisualMarks(currentCaret, data);
        }
        return true;
    }

    @Override
    @VimLockLabel.SelfSynchronized
    public void putTextAndSetCaretPosition(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull ProcessedTextData text, @NotNull PutData data, @NotNull Map<String, ? extends Object> additionalData) {
        Object object;
        block7: {
            block6: {
                VimPasteProvider idePasteProvider;
                Object selectionType;
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                Intrinsics.checkNotNullParameter(additionalData, (String)"additionalData");
                PutData.VisualSelection visualSelection = data.getVisualSelection();
                Object object2 = visualSelection;
                if (object2 == null || (object2 = object2.getTypeInEditor()) == null) {
                    object2 = selectionType = SelectionType.CHARACTER_WISE;
                }
                if (VimInjectorKt.globalOptions(VimInjectorKt.getInjector()).getClipboard().contains((Object)"ideaput") && (idePasteProvider = this.getProviderForPasteViaIde(editor, text.getTypeInRegister(), data)) != null) {
                    Companion.getLogger().debug("Perform put via idea paste");
                    this.putTextViaIde(idePasteProvider, editor, context, text, (SelectionType)((Object)selectionType), data, additionalData);
                    return;
                }
                Companion.getLogger().debug("Perform put via plugin");
                object = visualSelection;
                if (object == null || (object = ((PutData.VisualSelection)object).getCaretsAndSelections()) == null || (object = object.keySet()) == null) break block6;
                Iterable $this$sortedByDescending$iv = (Iterable)object;
                boolean $i$f$sortedByDescending = false;
                object = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        VimCaret it = (VimCaret)b;
                        boolean bl = false;
                        Comparable comparable = it.getBufferPosition();
                        it = (VimCaret)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getBufferPosition());
                    }
                });
                if (object != null) break block7;
            }
            object = CollectionsKt.reversed((Iterable)editor.sortedNativeCarets());
        }
        Collection<Object> myCarets = object;
        Iterable $this$forEach$iv = myCarets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VimCaret caret = (VimCaret)element$iv;
            boolean bl = false;
            this.putForCaret(editor, caret, data, additionalData, context, text);
        }
    }

    private static final boolean deleteSelectedText$lambda$0(VimEditor $editor, ExecutionContext $context, VimCaret $caret, TextRange $range, VimSelection $selectionForCaret, boolean $saveToRegister) {
        return VimInjectorKt.getInjector().getChangeGroup().deleteRange($editor, $context, $caret, $range, $selectionForCaret.getType(), false, $saveToRegister);
    }

    private static final boolean deleteSelectedText$lambda$2$0(VimEditor $editor, ExecutionContext $context, VimCaret $caret, TextRange $range, VimSelection $selection, boolean $saveToRegister) {
        return VimInjectorKt.getInjector().getChangeGroup().deleteRange($editor, $context, $caret, $range, $selection.getType(), false, $saveToRegister);
    }

    private static final Unit prepareDocumentAndGetStartOffsets$lambda$0(VimEditor $vimEditor, VimCaret $vimCaret) {
        Intrinsics.checkNotNull((Object)$vimEditor, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.api.MutableVimEditor");
        ((MutableVimEditor)$vimEditor).insertText($vimCaret, $vimCaret.getOffset(), "\n");
        return Unit.INSTANCE;
    }

    private static final Unit prepareDocumentAndGetStartOffsets$lambda$1(VimEditor $vimEditor, VimCaret $vimCaret, int $pos) {
        Intrinsics.checkNotNull((Object)$vimEditor, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.api.MutableVimEditor");
        ((MutableVimEditor)$vimEditor).insertText($vimCaret, $pos, "\n");
        return Unit.INSTANCE;
    }

    private static final Unit prepareDocumentAndGetStartOffsets$lambda$3(VimEditor $vimEditor, VimCaret $vimCaret) {
        Intrinsics.checkNotNull((Object)$vimEditor, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.api.MutableVimEditor");
        ((MutableVimEditor)$vimEditor).insertText($vimCaret, $vimCaret.getOffset(), "\n");
        return Unit.INSTANCE;
    }

    private static final Unit prepareDocumentAndGetStartOffsets$lambda$4(VimEditor $vimEditor, VimCaret $vimCaret, Ref.IntRef $startOffset) {
        Intrinsics.checkNotNull((Object)$vimEditor, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.api.MutableVimEditor");
        ((MutableVimEditor)$vimEditor).insertText($vimCaret, $startOffset.element - 1, "\n");
        return Unit.INSTANCE;
    }

    private static final Unit prepareDocumentAndGetStartOffsets$lambda$5(VimEditor $vimEditor, VimCaret $vimCaret, Ref.IntRef $startOffset) {
        Intrinsics.checkNotNull((Object)$vimEditor, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.api.MutableVimEditor");
        ((MutableVimEditor)$vimEditor).insertText($vimCaret, $startOffset.element, "\n");
        return Unit.INSTANCE;
    }

    private static final VimLogger logger_delegate$lambda$0() {
        boolean $i$f$vimLogger = false;
        return VimInjectorKt.getInjector().getLogger(VimPutBase.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/maddyhome/idea/vim/put/VimPutBase$Companion;", "", "<init>", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "getLogger", "()Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "logger$delegate", "Lkotlin/Lazy;", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VimLogger getLogger() {
            Lazy lazy = logger$delegate;
            return (VimLogger)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SelectionType.values().length];
            try {
                nArray[SelectionType.LINE_WISE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SelectionType.BLOCK_WISE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SelectionType.CHARACTER_WISE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

