/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.commands;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimCommandGroup;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.common.CommandAlias;
import com.maddyhome.idea.vim.ex.ranges.Range;
import com.maddyhome.idea.vim.helper.VimNlsSafe;
import com.maddyhome.idea.vim.vimscript.model.ExecutionResult;
import com.maddyhome.idea.vim.vimscript.model.commands.Command;
import com.maddyhome.idea.vim.vimscript.model.commands.CommandModifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.IntRange;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 .2\u00020\u0001:\u0001.B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J \u0010 \u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u0007H\u0002J\u0018\u0010#\u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0005H\u00c6\u0003J\t\u0010&\u001a\u00020\u0007H\u00c6\u0003J'\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010(\u001a\u00020!2\b\u0010)\u001a\u0004\u0018\u00010*H\u00d6\u0003J\t\u0010+\u001a\u00020,H\u00d6\u0001J\t\u0010-\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00070\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/CmdCommand;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$SingleExecution;", "range", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "modifier", "Lcom/maddyhome/idea/vim/vimscript/model/commands/CommandModifier;", "argument", "", "<init>", "(Lcom/maddyhome/idea/vim/ex/ranges/Range;Lcom/maddyhome/idea/vim/vimscript/model/commands/CommandModifier;Ljava/lang/String;)V", "getRange", "()Lcom/maddyhome/idea/vim/ex/ranges/Range;", "getModifier", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/CommandModifier;", "getArgument", "()Ljava/lang/String;", "argFlags", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgFlags", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "unsupportedArgs", "", "Lkotlin/Pair;", "Lkotlin/text/Regex;", "processCommand", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "listAlias", "", "filter", "addAlias", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "toString", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nCmdCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CmdCommand.kt\ncom/maddyhome/idea/vim/vimscript/model/commands/CmdCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,198:1\n774#2:199\n865#2,2:200\n1563#2:202\n1634#2,3:203\n648#3,5:206\n*S KotlinDebug\n*F\n+ 1 CmdCommand.kt\ncom/maddyhome/idea/vim/vimscript/model/commands/CmdCommand\n*L\n71#1:199\n71#1:200,2\n73#1:202\n73#1:203,3\n101#1:206,5\n*E\n"})
public final class CmdCommand
extends Command.SingleExecution {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Range range;
    @NotNull
    private final CommandModifier modifier;
    @NotNull
    private final String argument;
    @NotNull
    private final Command.CommandHandlerFlags argFlags;
    @NotNull
    private final List<Pair<Regex, String>> unsupportedArgs;
    @Deprecated
    @NotNull
    public static final String argsPrefix = "-nargs";
    @Deprecated
    @NotNull
    public static final String anyNumberOfArguments = "*";
    @Deprecated
    @NotNull
    public static final String zeroOrOneArguments = "?";
    @Deprecated
    @NotNull
    public static final String moreThanZeroArguments = "+";

    public CmdCommand(@NotNull Range range, @NotNull CommandModifier modifier, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)((Object)modifier), (String)"modifier");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        super(range, modifier, null, 4, null);
        this.range = range;
        this.modifier = modifier;
        this.argument = argument;
        this.argFlags = this.flags(Command.RangeFlag.RANGE_FORBIDDEN, Command.ArgumentFlag.ARGUMENT_OPTIONAL, Command.Access.READ_ONLY, new Command.Flag[0]);
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)new Regex("-range(=[^ ])?"), (Object)"-range"), TuplesKt.to((Object)new Regex("-complete=[^ ]*"), (Object)"-complete"), TuplesKt.to((Object)new Regex("-count=[^ ]*"), (Object)"-count"), TuplesKt.to((Object)new Regex("-addr=[^ ]*"), (Object)"-addr"), TuplesKt.to((Object)new Regex("-bang"), (Object)"-bang"), TuplesKt.to((Object)new Regex("-bar"), (Object)"-bar"), TuplesKt.to((Object)new Regex("-register"), (Object)"-register"), TuplesKt.to((Object)new Regex("-buffer"), (Object)"-buffer"), TuplesKt.to((Object)new Regex("-keepscript"), (Object)"-keepscript")};
        this.unsupportedArgs = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final Range getRange() {
        return this.range;
    }

    @NotNull
    public final CommandModifier getModifier() {
        return this.modifier;
    }

    @NotNull
    public final String getArgument() {
        return this.argument;
    }

    @Override
    @NotNull
    protected Command.CommandHandlerFlags getArgFlags() {
        return this.argFlags;
    }

    @Override
    @NotNull
    public ExecutionResult processCommand(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        boolean result = ((CharSequence)((Object)StringsKt.trim((CharSequence)this.argument)).toString()).length() == 0 ? this.listAlias(editor, context, "") : this.addAlias(editor, context);
        return result ? (ExecutionResult)ExecutionResult.Success.INSTANCE : (ExecutionResult)ExecutionResult.Error.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean listAlias(VimEditor editor, ExecutionContext context, String filter) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map.Entry it;
        void $this$filterTo$iv$iv;
        String lineSeparator = "\n";
        Set<Map.Entry<String, CommandAlias>> allAliases = VimInjectorKt.getInjector().getCommandGroup().listAliases();
        Iterable $this$filter$iv = allAliases;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!(((CharSequence)filter).length() == 0 || StringsKt.startsWith$default((String)((String)it.getKey()), (String)filter, (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.padEnd$default((String)((String)it.getKey()), (int)12, (char)'\u0000', (int)2, null) + StringsKt.padEnd$default((String)((CommandAlias)it.getValue()).getNumberOfArguments(), (int)11, (char)'\u0000', (int)2, null) + ((CommandAlias)it.getValue()).printValue());
        }
        String aliases = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE)), (CharSequence)lineSeparator, null, null, (int)0, null, null, (int)62, null);
        VimInjectorKt.getInjector().getOutputPanel().output(editor, context, "Name        Args       Definition" + lineSeparator + aliases);
        return true;
    }

    private final boolean addAlias(VimEditor editor, ExecutionContext context) {
        int maxNumberOfArgs;
        int minNumberOfArgs;
        boolean overrideAlias;
        String argument;
        block22: {
            String nargForTrim;
            block25: {
                Integer argNum;
                block23: {
                    String string;
                    block21: {
                        argument = null;
                        argument = ((Object)StringsKt.trim((CharSequence)this.argument)).toString();
                        overrideAlias = this.modifier == CommandModifier.BANG;
                        for (Pair<Regex, String> pair : this.unsupportedArgs) {
                            Regex arg = (Regex)pair.component1();
                            String message = (String)pair.component2();
                            MatchResult match = Regex.find$default((Regex)arg, (CharSequence)argument, (int)0, (int)2, null);
                            MatchResult matchResult = match;
                            if (matchResult == null || (matchResult = matchResult.getRange()) == null) continue;
                            MatchResult it = matchResult;
                            boolean bl = false;
                            argument = ((Object)StringsKt.removeRange((CharSequence)argument, (IntRange)it)).toString();
                            VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, "'" + message + "' is not supported by `command`");
                        }
                        boolean hasArguments = StringsKt.startsWith$default((String)argument, (String)argsPrefix, (boolean)false, (int)2, null);
                        minNumberOfArgs = 0;
                        maxNumberOfArgs = 0;
                        if (!hasArguments) break block22;
                        String $this$takeWhile$iv = argument;
                        boolean $i$f$takeWhile = false;
                        int it = $this$takeWhile$iv.length();
                        for (int index$iv = 0; index$iv < it; ++index$iv) {
                            char it22 = $this$takeWhile$iv.charAt(index$iv);
                            boolean bl = false;
                            if (it22 != ' ') continue;
                            String it22 = $this$takeWhile$iv;
                            int n = 0;
                            String string2 = it22.substring(n, index$iv);
                            string = string2;
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                            break block21;
                        }
                        string = $this$takeWhile$iv;
                    }
                    String trimmedInput = string;
                    MatchResult matchResult = Regex.find$default((Regex)new Regex("(?>-nargs=((|[-])\\d+|[?]|[+]|[*]))"), (CharSequence)trimmedInput, (int)0, (int)2, null);
                    if (matchResult == null) {
                        CmdCommand $this$addAlias_u24lambda_u242 = this;
                        boolean bl = false;
                        VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, VimInjectorKt.getInjector().getMessages().message("E176", new Object[0]));
                        return false;
                    }
                    MatchResult pattern = matchResult;
                    nargForTrim = (String)pattern.getGroupValues().get(0);
                    MatchGroup matchGroup = pattern.getGroups().get(1);
                    Intrinsics.checkNotNull((Object)matchGroup);
                    String argumentValue = matchGroup.getValue();
                    argNum = StringsKt.toIntOrNull((String)argumentValue);
                    if (argNum != null) break block23;
                    switch (argumentValue) {
                        case "*": {
                            minNumberOfArgs = 0;
                            maxNumberOfArgs = -1;
                            break block25;
                        }
                        case "?": {
                            maxNumberOfArgs = 1;
                            break block25;
                        }
                        case "+": {
                            minNumberOfArgs = 1;
                            maxNumberOfArgs = -1;
                            break block25;
                        }
                        default: {
                            VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, VimInjectorKt.getInjector().getMessages().message("E176", new Object[0]));
                            return false;
                        }
                    }
                }
                if (argNum > 1 || argNum < 0) {
                    VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, VimInjectorKt.getInjector().getMessages().message("E176", new Object[0]));
                    return false;
                }
                minNumberOfArgs = argNum;
                maxNumberOfArgs = argNum;
            }
            argument = ((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)argument, (CharSequence)nargForTrim))).toString();
        }
        argument = ((Object)StringsKt.trim((CharSequence)argument)).toString();
        String[] stringArray = new String[]{" "};
        String alias = (String)StringsKt.split$default((CharSequence)argument, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0);
        argument = ((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)argument, (CharSequence)alias))).toString();
        if (!Character.isUpperCase(alias.charAt(0))) {
            VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, VimInjectorKt.getInjector().getMessages().message("E183", new Object[0]));
            return false;
        }
        if (ArraysKt.contains((Object[])VimCommandGroup.Companion.getBLACKLISTED_ALIASES(), (Object)alias)) {
            VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, VimInjectorKt.getInjector().getMessages().message("E841", new Object[0]));
            return false;
        }
        if (((CharSequence)argument).length() == 0) {
            return this.listAlias(editor, context, alias);
        }
        if (!overrideAlias && VimInjectorKt.getInjector().getCommandGroup().hasAlias(alias)) {
            VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, VimInjectorKt.getInjector().getMessages().message("E174", new Object[0]));
            return false;
        }
        VimInjectorKt.getInjector().getCommandGroup().setAlias(alias, new CommandAlias.Ex(minNumberOfArgs, maxNumberOfArgs, alias, argument));
        return true;
    }

    @NotNull
    public final Range component1() {
        return this.range;
    }

    @NotNull
    public final CommandModifier component2() {
        return this.modifier;
    }

    @NotNull
    public final String component3() {
        return this.argument;
    }

    @NotNull
    public final CmdCommand copy(@NotNull Range range, @NotNull CommandModifier modifier, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)((Object)modifier), (String)"modifier");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        return new CmdCommand(range, modifier, argument);
    }

    public static /* synthetic */ CmdCommand copy$default(CmdCommand cmdCommand, Range range, CommandModifier commandModifier, String string, int n, Object object) {
        if ((n & 1) != 0) {
            range = cmdCommand.range;
        }
        if ((n & 2) != 0) {
            commandModifier = cmdCommand.modifier;
        }
        if ((n & 4) != 0) {
            string = cmdCommand.argument;
        }
        return cmdCommand.copy(range, commandModifier, string);
    }

    @NotNull
    public String toString() {
        return "CmdCommand(range=" + this.range + ", modifier=" + this.modifier + ", argument=" + this.argument + ")";
    }

    public int hashCode() {
        int result = this.range.hashCode();
        result = result * 31 + this.modifier.hashCode();
        result = result * 31 + this.argument.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CmdCommand)) {
            return false;
        }
        CmdCommand cmdCommand = (CmdCommand)other;
        if (!Intrinsics.areEqual((Object)this.range, (Object)cmdCommand.range)) {
            return false;
        }
        if (this.modifier != cmdCommand.modifier) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.argument, (Object)cmdCommand.argument);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/CmdCommand$Companion;", "", "<init>", "()V", "argsPrefix", "", "getArgsPrefix$annotations", "anyNumberOfArguments", "zeroOrOneArguments", "moreThanZeroArguments", "vim-engine"})
    private static final class Companion {
        private Companion() {
        }

        @VimNlsSafe
        public static /* synthetic */ void getArgsPrefix$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

