/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.commands.mapping;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimscriptParser;
import com.maddyhome.idea.vim.command.MappingMode;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.ex.ExExceptionsKt;
import com.maddyhome.idea.vim.ex.ranges.Range;
import com.maddyhome.idea.vim.key.MappingOwner;
import com.maddyhome.idea.vim.vimscript.model.ExecutionResult;
import com.maddyhome.idea.vim.vimscript.model.commands.Command;
import com.maddyhome.idea.vim.vimscript.model.commands.CommandModifier;
import com.maddyhome.idea.vim.vimscript.model.commands.mapping.CommandInfo;
import com.maddyhome.idea.vim.vimscript.model.expressions.Expression;
import com.maddyhome.idea.vim.vimscript.model.expressions.SimpleExpression;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 42\u00020\u0001:\u0003234B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010 \u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u0005H\u0002J\u0010\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u0005H\u0002J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\u0005H\u00c6\u0003J\t\u0010)\u001a\u00020\u0007H\u00c6\u0003J\t\u0010*\u001a\u00020\u0005H\u00c6\u0003J1\u0010+\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010,\u001a\u00020\u001f2\b\u0010-\u001a\u0004\u0018\u00010.H\u00d6\u0003J\t\u0010/\u001a\u000200H\u00d6\u0001J\t\u00101\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0014\u0010\u0012\u001a\u00020\u0013X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00065"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/mapping/MapCommand;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$SingleExecution;", "range", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "cmd", "", "modifier", "Lcom/maddyhome/idea/vim/vimscript/model/commands/CommandModifier;", "argument", "<init>", "(Lcom/maddyhome/idea/vim/ex/ranges/Range;Ljava/lang/String;Lcom/maddyhome/idea/vim/vimscript/model/commands/CommandModifier;Ljava/lang/String;)V", "getRange", "()Lcom/maddyhome/idea/vim/ex/ranges/Range;", "getCmd", "()Ljava/lang/String;", "getModifier", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/CommandModifier;", "getArgument", "argFlags", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgFlags", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "processCommand", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "executeCommand", "", "transformOldActionSyntax", "extractActionId", "parseCommandArguments", "Lcom/maddyhome/idea/vim/vimscript/model/commands/mapping/MapCommand$CommandArguments;", "input", "processBars", "fromString", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "", "toString", "SpecialArgument", "CommandArguments", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nMapCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapCommand.kt\ncom/maddyhome/idea/vim/vimscript/model/commands/mapping/MapCommand\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,237:1\n1#2:238\n739#3,9:239\n1869#3,2:248\n39#4:250\n*S KotlinDebug\n*F\n+ 1 MapCommand.kt\ncom/maddyhome/idea/vim/vimscript/model/commands/mapping/MapCommand\n*L\n201#1:239,9\n201#1:248,2\n192#1:250\n*E\n"})
public final class MapCommand
extends Command.SingleExecution {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Range range;
    @NotNull
    private final String cmd;
    @NotNull
    private final CommandModifier modifier;
    @NotNull
    private final String argument;
    @NotNull
    private final Command.CommandHandlerFlags argFlags;
    @NotNull
    private static final CommandInfo[] COMMAND_INFOS;
    private static final EnumSet<SpecialArgument> UNSUPPORTED_SPECIAL_ARGUMENTS;
    @NotNull
    private static final VimLogger logger;

    public MapCommand(@NotNull Range range, @NotNull String cmd, @NotNull CommandModifier modifier, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)((Object)modifier), (String)"modifier");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        super(range, modifier, argument);
        this.range = range;
        this.cmd = cmd;
        this.modifier = modifier;
        this.argument = argument;
        this.argFlags = this.flags(Command.RangeFlag.RANGE_FORBIDDEN, Command.ArgumentFlag.ARGUMENT_OPTIONAL, Command.Access.READ_ONLY, new Command.Flag[0]);
    }

    @NotNull
    public final Range getRange() {
        return this.range;
    }

    @NotNull
    public final String getCmd() {
        return this.cmd;
    }

    @NotNull
    public final CommandModifier getModifier() {
        return this.modifier;
    }

    @NotNull
    public final String getArgument() {
        return this.argument;
    }

    @Override
    @NotNull
    protected Command.CommandHandlerFlags getArgFlags() {
        return this.argFlags;
    }

    @Override
    @NotNull
    public ExecutionResult processCommand(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) throws ExException {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        return this.executeCommand(editor) ? (ExecutionResult)ExecutionResult.Success.INSTANCE : (ExecutionResult)ExecutionResult.Error.INSTANCE;
    }

    private final boolean executeCommand(VimEditor editor) throws ExException {
        MappingOwner mappingOwner;
        Object object;
        CommandInfo commandInfo;
        block10: {
            CommandInfo commandInfo2;
            boolean bang = this.modifier == CommandModifier.BANG;
            CommandInfo[] commandInfoArray = COMMAND_INFOS;
            int n = commandInfoArray.length;
            for (int i = 0; i < n; ++i) {
                CommandInfo commandInfo3;
                CommandInfo it = commandInfo3 = commandInfoArray[i];
                boolean bl = false;
                if (!(StringsKt.startsWith$default((String)this.cmd, (String)it.getPrefix(), (boolean)false, (int)2, null) && it.getBang() == bang)) continue;
                commandInfo2 = commandInfo3;
                break block10;
            }
            commandInfo2 = commandInfo = null;
        }
        if (commandInfo == null) {
            if (this.modifier == CommandModifier.BANG) {
                throw ExExceptionsKt.exExceptionMessage("E477", new Object[0]);
            }
            return false;
        }
        Set<MappingMode> modes = commandInfo.getMappingModes();
        if (StringsKt.isBlank((CharSequence)this.argument) || !StringsKt.contains$default((CharSequence)((Object)StringsKt.trim((CharSequence)this.argument)).toString(), (char)' ', (boolean)false, (int)2, null)) {
            List<KeyStroke> prefix = VimInjectorKt.getInjector().getParser().parseKeys(((Object)StringsKt.trim((CharSequence)this.argument)).toString());
            return VimInjectorKt.getInjector().getKeyGroup().showKeyMappings(modes, prefix, editor);
        }
        try {
            CommandArguments commandArguments = this.parseCommandArguments(this.argument);
            if (commandArguments == null) {
                return false;
            }
            object = commandArguments;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        CommandArguments arguments = object;
        Iterator iterator = UNSUPPORTED_SPECIAL_ARGUMENTS.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        object = iterator;
        while (object.hasNext()) {
            SpecialArgument unsupportedArgument = (SpecialArgument)((Object)object.next());
            if (!arguments.getSpecialArguments().contains((Object)unsupportedArgument)) continue;
            throw new ExException("Unsupported map argument: " + unsupportedArgument);
        }
        MappingOwner mappingOwner2 = mappingOwner = VimInjectorKt.getInjector().getVimscriptExecutor().getExecutingIdeaVimRcConfiguration() ? (MappingOwner)MappingOwner.IdeaVim.InitScript.INSTANCE : (MappingOwner)MappingOwner.IdeaVim.Other.INSTANCE;
        if (arguments.getSpecialArguments().contains((Object)SpecialArgument.EXPR)) {
            VimInjectorKt.getInjector().getStatisticsService().setIfMapExprUsed(true);
            VimInjectorKt.getInjector().getKeyGroup().putKeyMapping(modes, arguments.getFromKeys(), mappingOwner, arguments.getToExpr(), arguments.getSecondArgument(), commandInfo.isRecursive());
        } else {
            String mapping = this.transformOldActionSyntax(arguments.getSecondArgument());
            List<KeyStroke> toKeys = VimInjectorKt.getInjector().getParser().parseKeys(mapping);
            boolean isRecursive = !Intrinsics.areEqual((Object)mapping, (Object)arguments.getSecondArgument()) || commandInfo.isRecursive();
            VimInjectorKt.getInjector().getKeyGroup().putKeyMapping(modes, arguments.getFromKeys(), mappingOwner, toKeys, isRecursive);
        }
        return true;
    }

    private final String transformOldActionSyntax(String argument) {
        String string = this.extractActionId(argument);
        if (string != null) {
            String it = string;
            boolean bl = false;
            String newMapping = "<Action>(" + it + ")";
            logger.debug("Replaced " + argument + " with " + newMapping);
            return newMapping;
        }
        return argument;
    }

    private final String extractActionId(String argument) {
        String string;
        String patternStart = "^:+\\s*action\\s+";
        String patternEnd = "\\s*((<CR>)|(<Cr>)|(<cr>)|(<ENTER>)|(<Enter>)|(<enter>)|(<C-M>)|(<C-m>)|(<c-m>)|\n|\r|(\r\n))$";
        CharSequence charSequence = argument;
        if (new Regex(patternStart + "\\w+" + patternEnd).matches(charSequence)) {
            charSequence = argument;
            Regex regex = new Regex(patternStart);
            String string2 = "";
            charSequence = regex.replace(charSequence, string2);
            regex = new Regex(patternEnd);
            string2 = "";
            string = regex.replace(charSequence, string2);
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final CommandArguments parseCommandArguments(String input) {
        CommandArguments commandArguments;
        char c;
        void $this$forEach$iv;
        List list;
        HashSet<SpecialArgument> specialArguments = new HashSet<SpecialArgument>();
        StringBuilder toKeysBuilder = new StringBuilder();
        List<KeyStroke> fromKeys = null;
        String preprocessedInput = this.processBars(input);
        String[] stringArray = new String[]{" "};
        Iterable $this$dropLastWhile$iv = StringsKt.split$default((CharSequence)preprocessedInput, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            Iterator<Object> iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String part = (String)element$iv;
            boolean bl = false;
            if (fromKeys != null) {
                toKeysBuilder.append(" ");
                toKeysBuilder.append(part);
                continue;
            }
            SpecialArgument specialArgument = SpecialArgument.Companion.fromString(part);
            if (specialArgument != null) {
                specialArguments.add(specialArgument);
                continue;
            }
            fromKeys = VimInjectorKt.getInjector().getParser().parseKeys(this.processBars(part));
        }
        for (int i = preprocessedInput.length() - 1; -1 < i && (c = preprocessedInput.charAt(i)) == ' '; --i) {
            toKeysBuilder.append(c);
        }
        List<KeyStroke> list2 = fromKeys;
        if (list2 != null) {
            Expression expression;
            List<KeyStroke> it = list2;
            boolean bl = false;
            if (specialArguments.contains((Object)SpecialArgument.EXPR)) {
                VimscriptParser vimscriptParser = VimInjectorKt.getInjector().getVimscriptParser();
                String string = toKeysBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                expression = vimscriptParser.parseExpression(((Object)StringsKt.trim((CharSequence)string)).toString());
                if (expression == null) {
                    Object[] objectArray = new Object[1];
                    String string2 = toKeysBuilder.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                    objectArray[0] = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                    throw ExExceptionsKt.exExceptionMessage("E15", objectArray);
                }
            } else {
                String string = toKeysBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                expression = new SimpleExpression(((Object)StringsKt.trimStart((CharSequence)string)).toString());
            }
            Expression toExpr = expression;
            Set set = specialArguments;
            String string = toKeysBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            commandArguments = new CommandArguments(set, it, toExpr, ((Object)StringsKt.trimStart((CharSequence)string)).toString());
        } else {
            commandArguments = null;
        }
        return commandArguments;
    }

    private final String processBars(String fromString) {
        return StringsKt.replace$default((String)fromString, (String)"\\|", (String)"|", (boolean)false, (int)4, null);
    }

    @NotNull
    public final Range component1() {
        return this.range;
    }

    @NotNull
    public final String component2() {
        return this.cmd;
    }

    @NotNull
    public final CommandModifier component3() {
        return this.modifier;
    }

    @NotNull
    public final String component4() {
        return this.argument;
    }

    @NotNull
    public final MapCommand copy(@NotNull Range range, @NotNull String cmd, @NotNull CommandModifier modifier, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)((Object)modifier), (String)"modifier");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        return new MapCommand(range, cmd, modifier, argument);
    }

    public static /* synthetic */ MapCommand copy$default(MapCommand mapCommand, Range range, String string, CommandModifier commandModifier, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            range = mapCommand.range;
        }
        if ((n & 2) != 0) {
            string = mapCommand.cmd;
        }
        if ((n & 4) != 0) {
            commandModifier = mapCommand.modifier;
        }
        if ((n & 8) != 0) {
            string2 = mapCommand.argument;
        }
        return mapCommand.copy(range, string, commandModifier, string2);
    }

    @NotNull
    public String toString() {
        return "MapCommand(range=" + this.range + ", cmd=" + this.cmd + ", modifier=" + this.modifier + ", argument=" + this.argument + ")";
    }

    public int hashCode() {
        int result = this.range.hashCode();
        result = result * 31 + this.cmd.hashCode();
        result = result * 31 + this.modifier.hashCode();
        result = result * 31 + this.argument.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MapCommand)) {
            return false;
        }
        MapCommand mapCommand = (MapCommand)other;
        if (!Intrinsics.areEqual((Object)this.range, (Object)mapCommand.range)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.cmd, (Object)mapCommand.cmd)) {
            return false;
        }
        if (this.modifier != mapCommand.modifier) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.argument, (Object)mapCommand.argument);
    }

    static {
        CommandInfo[] commandInfoArray = new CommandInfo[]{new CommandInfo("map", "", MappingMode.NVO, true, false, 16, null), new CommandInfo("map", "", (Set<? extends MappingMode>)MappingMode.IC, true, true), new CommandInfo("nm", "ap", MappingMode.N, true, false, 16, null), new CommandInfo("vm", "ap", MappingMode.V, true, false, 16, null), new CommandInfo("xm", "ap", MappingMode.X, true, false, 16, null), new CommandInfo("smap", "", MappingMode.S, true, false, 16, null), new CommandInfo("om", "ap", MappingMode.O, true, false, 16, null), new CommandInfo("im", "ap", MappingMode.I, true, false, 16, null), new CommandInfo("cm", "ap", MappingMode.C, true, false, 16, null), new CommandInfo("no", "remap", MappingMode.NVO, false, false, 16, null), new CommandInfo("no", "remap", (Set<? extends MappingMode>)MappingMode.IC, false, true), new CommandInfo("nn", "oremap", MappingMode.N, false, false, 16, null), new CommandInfo("vn", "oremap", MappingMode.V, false, false, 16, null), new CommandInfo("xn", "oremap", MappingMode.X, false, false, 16, null), new CommandInfo("snor", "emap", MappingMode.S, false, false, 16, null), new CommandInfo("ono", "remap", MappingMode.O, false, false, 16, null), new CommandInfo("ino", "remap", MappingMode.I, false, false, 16, null), new CommandInfo("cno", "remap", MappingMode.C, false, false, 16, null)};
        COMMAND_INFOS = commandInfoArray;
        UNSUPPORTED_SPECIAL_ARGUMENTS = EnumSet.of((Enum)SpecialArgument.SCRIPT);
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(MapCommand.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B3\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/mapping/MapCommand$CommandArguments;", "", "specialArguments", "", "Lcom/maddyhome/idea/vim/vimscript/model/commands/mapping/MapCommand$SpecialArgument;", "fromKeys", "", "Ljavax/swing/KeyStroke;", "toExpr", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;", "secondArgument", "", "<init>", "(Ljava/util/Set;Ljava/util/List;Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;Ljava/lang/String;)V", "getSpecialArguments", "()Ljava/util/Set;", "getFromKeys", "()Ljava/util/List;", "getToExpr", "()Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;", "getSecondArgument", "()Ljava/lang/String;", "vim-engine"})
    private static final class CommandArguments {
        @NotNull
        private final Set<SpecialArgument> specialArguments;
        @NotNull
        private final List<KeyStroke> fromKeys;
        @NotNull
        private final Expression toExpr;
        @NotNull
        private final String secondArgument;

        public CommandArguments(@NotNull Set<? extends SpecialArgument> specialArguments, @NotNull List<? extends KeyStroke> fromKeys, @NotNull Expression toExpr, @NotNull String secondArgument) {
            Intrinsics.checkNotNullParameter(specialArguments, (String)"specialArguments");
            Intrinsics.checkNotNullParameter(fromKeys, (String)"fromKeys");
            Intrinsics.checkNotNullParameter((Object)toExpr, (String)"toExpr");
            Intrinsics.checkNotNullParameter((Object)secondArgument, (String)"secondArgument");
            this.specialArguments = specialArguments;
            this.fromKeys = fromKeys;
            this.toExpr = toExpr;
            this.secondArgument = secondArgument;
        }

        @NotNull
        public final Set<SpecialArgument> getSpecialArguments() {
            return this.specialArguments;
        }

        @NotNull
        public final List<KeyStroke> getFromKeys() {
            return this.fromKeys;
        }

        @NotNull
        public final Expression getToExpr() {
            return this.toExpr;
        }

        @NotNull
        public final String getSecondArgument() {
            return this.secondArgument;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R2\u0010\b\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/mapping/MapCommand$Companion;", "", "<init>", "()V", "COMMAND_INFOS", "", "Lcom/maddyhome/idea/vim/vimscript/model/commands/mapping/CommandInfo;", "[Lcom/maddyhome/idea/vim/vimscript/model/commands/mapping/CommandInfo;", "UNSUPPORTED_SPECIAL_ARGUMENTS", "Ljava/util/EnumSet;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/mapping/MapCommand$SpecialArgument;", "kotlin.jvm.PlatformType", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0083\u0081\u0002\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0010B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u0011"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/mapping/MapCommand$SpecialArgument;", "", "myName", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getMyName", "()Ljava/lang/String;", "BUFFER", "NOWAIT", "SILENT", "SPECIAL", "SCRIPT", "EXPR", "UNIQUE", "toString", "Companion", "vim-engine"})
    @NonNls
    private static final class SpecialArgument
    extends Enum<SpecialArgument> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String myName;
        public static final /* enum */ SpecialArgument BUFFER;
        public static final /* enum */ SpecialArgument NOWAIT;
        public static final /* enum */ SpecialArgument SILENT;
        public static final /* enum */ SpecialArgument SPECIAL;
        public static final /* enum */ SpecialArgument SCRIPT;
        public static final /* enum */ SpecialArgument EXPR;
        public static final /* enum */ SpecialArgument UNIQUE;
        private static final /* synthetic */ SpecialArgument[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private SpecialArgument(String myName) {
            this.myName = myName;
        }

        @NotNull
        public final String getMyName() {
            return this.myName;
        }

        @NotNull
        public String toString() {
            return this.myName;
        }

        public static SpecialArgument[] values() {
            return (SpecialArgument[])$VALUES.clone();
        }

        public static SpecialArgument valueOf(String value) {
            return Enum.valueOf(SpecialArgument.class, value);
        }

        @NotNull
        public static EnumEntries<SpecialArgument> getEntries() {
            return $ENTRIES;
        }

        static {
            BUFFER = new SpecialArgument("<buffer>");
            NOWAIT = new SpecialArgument("<nowait>");
            SILENT = new SpecialArgument("<silent>");
            SPECIAL = new SpecialArgument("<special>");
            SCRIPT = new SpecialArgument("<script>");
            EXPR = new SpecialArgument("<expr>");
            UNIQUE = new SpecialArgument("<unique>");
            $VALUES = specialArgumentArray = new SpecialArgument[]{SpecialArgument.BUFFER, SpecialArgument.NOWAIT, SpecialArgument.SILENT, SpecialArgument.SPECIAL, SpecialArgument.SCRIPT, SpecialArgument.EXPR, SpecialArgument.UNIQUE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/mapping/MapCommand$SpecialArgument$Companion;", "", "<init>", "()V", "fromString", "Lcom/maddyhome/idea/vim/vimscript/model/commands/mapping/MapCommand$SpecialArgument;", "s", "", "vim-engine"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final SpecialArgument fromString(@NotNull String s) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                for (SpecialArgument argument : SpecialArgument.getEntries()) {
                    if (!Intrinsics.areEqual((Object)s, (Object)argument.getMyName())) continue;
                    return argument;
                }
                return null;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

