/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.expressions;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.ex.ExExceptionsKt;
import com.maddyhome.idea.vim.options.NumberOption;
import com.maddyhome.idea.vim.options.Option;
import com.maddyhome.idea.vim.options.OptionAccessScope;
import com.maddyhome.idea.vim.options.StringListOption;
import com.maddyhome.idea.vim.options.StringOption;
import com.maddyhome.idea.vim.options.ToggleOption;
import com.maddyhome.idea.vim.vimscript.model.VimLContext;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimFloat;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimInt;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimString;
import com.maddyhome.idea.vim.vimscript.model.expressions.LValueExpression;
import com.maddyhome.idea.vim.vimscript.model.expressions.Scope;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J0\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0005H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\u001e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020\u00152\b\u0010 \u001a\u0004\u0018\u00010!H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020\u0005H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006%"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/expressions/OptionExpression;", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/LValueExpression;", "scope", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/Scope;", "optionName", "", "<init>", "(Lcom/maddyhome/idea/vim/vimscript/model/expressions/Scope;Ljava/lang/String;)V", "getScope", "()Lcom/maddyhome/idea/vim/vimscript/model/expressions/Scope;", "getOptionName", "()Ljava/lang/String;", "evaluate", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "vimContext", "Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "isStronglyTyped", "", "assign", "", "value", "assignmentTextForErrors", "getAccessScope", "Lcom/maddyhome/idea/vim/options/OptionAccessScope;", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "vim-engine"})
public final class OptionExpression
extends LValueExpression {
    @Nullable
    private final Scope scope;
    @NotNull
    private final String optionName;

    public OptionExpression(@Nullable Scope scope, @NotNull String optionName) {
        Intrinsics.checkNotNullParameter((Object)optionName, (String)"optionName");
        this.scope = scope;
        this.optionName = optionName;
    }

    @Nullable
    public final Scope getScope() {
        return this.scope;
    }

    @NotNull
    public final String getOptionName() {
        return this.optionName;
    }

    @Override
    @NotNull
    public VimDataType evaluate(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        Option<VimDataType> option = VimInjectorKt.getInjector().getOptionGroup().getOption(this.optionName);
        if (option == null) {
            Object[] objectArray = new Object[]{this.getOriginalString()};
            throw ExExceptionsKt.exExceptionMessage("E518", objectArray);
        }
        Option<VimDataType> option2 = option;
        return VimInjectorKt.getInjector().getOptionGroup().getOptionValue(option2, this.getAccessScope(editor));
    }

    @Override
    public boolean isStronglyTyped() {
        return true;
    }

    @Override
    public void assign(@NotNull VimDataType value, @NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext, @NotNull String assignmentTextForErrors) {
        VimDataType vimDataType;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        Intrinsics.checkNotNullParameter((Object)assignmentTextForErrors, (String)"assignmentTextForErrors");
        Option<VimDataType> option = VimInjectorKt.getInjector().getOptionGroup().getOption(this.optionName);
        if (option == null) {
            Object[] objectArray = new Object[]{this.getOriginalString()};
            throw ExExceptionsKt.exExceptionMessage("E518", objectArray);
        }
        Option<VimDataType> option2 = option;
        Option<VimDataType> option3 = option2;
        if (option3 instanceof NumberOption || option3 instanceof ToggleOption) {
            VimInt vimInt;
            if (value instanceof VimString) {
                VimInt number = ((VimString)value).toVimNumber();
                if (number.getValue() == 0 && !StringsKt.startsWith$default((CharSequence)((VimString)value).getValue(), (char)'0', (boolean)false, (int)2, null)) {
                    Object[] objectArray = new Object[]{assignmentTextForErrors};
                    throw ExExceptionsKt.exExceptionMessage("E521", objectArray);
                }
                vimInt = number;
            } else {
                vimInt = value.toVimNumber();
            }
            vimDataType = vimInt;
        } else {
            vimDataType = option3 instanceof StringOption || option3 instanceof StringListOption ? (VimDataType)(value instanceof VimFloat ? new VimString(((VimFloat)value).toOutputString()) : value.toVimString()) : value;
        }
        VimDataType newValue = vimDataType;
        VimInjectorKt.getInjector().getOptionGroup().setOptionValue(option2, this.getAccessScope(editor), newValue);
    }

    private final OptionAccessScope getAccessScope(VimEditor editor) {
        Scope scope = this.scope;
        return switch (scope == null ? -1 : WhenMappings.$EnumSwitchMapping$0[scope.ordinal()]) {
            case 1 -> new OptionAccessScope.GLOBAL(editor);
            case 2 -> new OptionAccessScope.LOCAL(editor);
            case -1 -> new OptionAccessScope.EFFECTIVE(editor);
            default -> throw new ExException("Invalid option scope");
        };
    }

    @Nullable
    public final Scope component1() {
        return this.scope;
    }

    @NotNull
    public final String component2() {
        return this.optionName;
    }

    @NotNull
    public final OptionExpression copy(@Nullable Scope scope, @NotNull String optionName) {
        Intrinsics.checkNotNullParameter((Object)optionName, (String)"optionName");
        return new OptionExpression(scope, optionName);
    }

    public static /* synthetic */ OptionExpression copy$default(OptionExpression optionExpression, Scope scope, String string, int n, Object object) {
        if ((n & 1) != 0) {
            scope = optionExpression.scope;
        }
        if ((n & 2) != 0) {
            string = optionExpression.optionName;
        }
        return optionExpression.copy(scope, string);
    }

    @NotNull
    public String toString() {
        return "OptionExpression(scope=" + this.scope + ", optionName=" + this.optionName + ")";
    }

    public int hashCode() {
        int result = this.scope == null ? 0 : this.scope.hashCode();
        result = result * 31 + this.optionName.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OptionExpression)) {
            return false;
        }
        OptionExpression optionExpression = (OptionExpression)other;
        if (this.scope != optionExpression.scope) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.optionName, (Object)optionExpression.optionName);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Scope.values().length];
            try {
                nArray[Scope.GLOBAL_VARIABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Scope.LOCAL_VARIABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

