/*
 * Decompiled with CFR 0.152.
 */
package ru.adelf.idea.dotenv.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import ru.adelf.idea.dotenv.psi.DotEnvElementType;
import ru.adelf.idea.dotenv.psi.DotEnvTokenType;
import ru.adelf.idea.dotenv.psi.impl.DotEnvKeyImpl;
import ru.adelf.idea.dotenv.psi.impl.DotEnvNestedVariableKeyImpl;
import ru.adelf.idea.dotenv.psi.impl.DotEnvPropertyImpl;
import ru.adelf.idea.dotenv.psi.impl.DotEnvValueImpl;

public interface DotEnvTypes {
    public static final IElementType KEY = new DotEnvElementType("KEY");
    public static final IElementType NESTED_VARIABLE_KEY = new DotEnvElementType("NESTED_VARIABLE_KEY");
    public static final IElementType PROPERTY = new DotEnvElementType("PROPERTY");
    public static final IElementType VALUE = new DotEnvElementType("VALUE");
    public static final IElementType COMMENT = new DotEnvTokenType("COMMENT");
    public static final IElementType CRLF = new DotEnvTokenType("CRLF");
    public static final IElementType EXPORT = new DotEnvTokenType("EXPORT");
    public static final IElementType KEY_CHARS = new DotEnvTokenType("KEY_CHARS");
    public static final IElementType NESTED_VARIABLE_END = new DotEnvTokenType("NESTED_VARIABLE_END");
    public static final IElementType NESTED_VARIABLE_START = new DotEnvTokenType("NESTED_VARIABLE_START");
    public static final IElementType QUOTE = new DotEnvTokenType("QUOTE");
    public static final IElementType SEPARATOR = new DotEnvTokenType("SEPARATOR");
    public static final IElementType VALUE_CHARS = new DotEnvTokenType("VALUE_CHARS");

    public static class Factory {
        public static PsiElement createElement(ASTNode node) {
            IElementType type = node.getElementType();
            if (type == KEY) {
                return new DotEnvKeyImpl(node);
            }
            if (type == NESTED_VARIABLE_KEY) {
                return new DotEnvNestedVariableKeyImpl(node);
            }
            if (type == PROPERTY) {
                return new DotEnvPropertyImpl(node);
            }
            if (type == VALUE) {
                return new DotEnvValueImpl(node);
            }
            throw new AssertionError((Object)("Unknown element type: " + String.valueOf(type)));
        }
    }
}

