/*
 * Decompiled with CFR 0.152.
 */
package mobi.hsz.idea.gitignore.actions;

import com.intellij.ide.IdeView;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import mobi.hsz.idea.gitignore.IgnoreBundle;
import mobi.hsz.idea.gitignore.command.CreateFileCommandAction;
import mobi.hsz.idea.gitignore.file.type.IgnoreFileType;
import mobi.hsz.idea.gitignore.ui.GeneratorDialog;
import mobi.hsz.idea.gitignore.util.Utils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lmobi/hsz/idea/gitignore/actions/NewFileAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "fileType", "Lmobi/hsz/idea/gitignore/file/type/IgnoreFileType;", "<init>", "(Lmobi/hsz/idea/gitignore/file/type/IgnoreFileType;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "idea-gitignore"})
public class NewFileAction
extends DumbAwareAction {
    @NotNull
    private final IgnoreFileType fileType;

    public NewFileAction(@NotNull IgnoreFileType fileType) {
        Intrinsics.checkNotNullParameter((Object)((Object)fileType), (String)"fileType");
        this.fileType = fileType;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Object[] objectArray;
        GeneratorDialog generatorDialog;
        PsiFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Project project2 = project;
        IdeView ideView = (IdeView)e.getData(LangDataKeys.IDE_VIEW);
        if (ideView == null) {
            return;
        }
        IdeView view = ideView;
        PsiDirectory psiDirectory = view.getOrChooseDirectory();
        if (psiDirectory == null) {
            return;
        }
        PsiDirectory directory = psiDirectory;
        String filename = this.fileType.getIgnoreLanguage().getFilename();
        PsiFile file = directory.findFile(filename);
        PsiFile psiFile = file;
        if (psiFile == null || (psiFile = psiFile.getVirtualFile()) == null) {
            psiFile = virtualFile = directory.getVirtualFile().findChild(filename);
        }
        if (file == null || virtualFile == null) {
            generatorDialog = new GeneratorDialog(project2, null, new CreateFileCommandAction(project2, directory, this.fileType), 2, null);
        } else {
            objectArray = new Object[]{this.fileType.getLanguageName()};
            String string = IgnoreBundle.INSTANCE.message("action.newFile.exists", objectArray);
            objectArray = new Object[]{virtualFile.getPath()};
            Notifications.Bus.notify((Notification)new Notification(this.fileType.getLanguageName(), string, IgnoreBundle.INSTANCE.message("action.newFile.exists.in", objectArray), NotificationType.INFORMATION), (Project)project2);
            file = Utils.INSTANCE.getPsiFile(project2, (VirtualFile)virtualFile);
            generatorDialog = new GeneratorDialog(project2, file, null, 4, null);
        }
        Object[] $this$actionPerformed_u24lambda_u240 = objectArray = generatorDialog;
        boolean bl = false;
        $this$actionPerformed_u24lambda_u240.show();
        Object[] dialog = objectArray;
        file = dialog.getFile();
        if (file != null) {
            Utils.INSTANCE.openFile(project2, file);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        PsiDirectory[] directory;
        IdeView view;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        IdeView ideView = view = (IdeView)e.getData(LangDataKeys.IDE_VIEW);
        PsiDirectory[] psiDirectoryArray = directory = ideView != null ? ideView.getDirectories() : null;
        if (psiDirectoryArray == null || psiDirectoryArray.length == 0 || project == null || !this.fileType.getIgnoreLanguage().isNewAllowed()) {
            e.getPresentation().setVisible(false);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }
}

