/*
 * Decompiled with CFR 0.152.
 */
package mobi.hsz.idea.gitignore.daemon;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mobi.hsz.idea.gitignore.IgnoreBundle;
import mobi.hsz.idea.gitignore.IgnoreManager;
import mobi.hsz.idea.gitignore.settings.IgnoreSettings;
import mobi.hsz.idea.gitignore.util.Icons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0002J,\u0010\u000f\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u0011\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0012\u0018\u00010\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lmobi/hsz/idea/gitignore/daemon/IgnoredEditingNotificationProvider;", "Lcom/intellij/ui/EditorNotificationProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "settings", "Lmobi/hsz/idea/gitignore/settings/IgnoreSettings;", "manager", "Lmobi/hsz/idea/gitignore/IgnoreManager;", "changeListManager", "Lcom/intellij/openapi/vcs/changes/ChangeListManager;", "Lorg/jetbrains/annotations/NotNull;", "createNotificationPanel", "Lcom/intellij/ui/EditorNotificationPanel;", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "idea-gitignore"})
@SourceDebugExtension(value={"SMAP\nIgnoredEditingNotificationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IgnoredEditingNotificationProvider.kt\nmobi/hsz/idea/gitignore/daemon/IgnoredEditingNotificationProvider\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,51:1\n40#2,3:52\n30#3,2:55\n*S KotlinDebug\n*F\n+ 1 IgnoredEditingNotificationProvider.kt\nmobi/hsz/idea/gitignore/daemon/IgnoredEditingNotificationProvider\n*L\n24#1:52,3\n25#1:55,2\n*E\n"})
public final class IgnoredEditingNotificationProvider
implements EditorNotificationProvider {
    @NotNull
    private final IgnoreSettings settings;
    @NotNull
    private final IgnoreManager manager;
    @NotNull
    private final ChangeListManager changeListManager;

    public IgnoredEditingNotificationProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        boolean $i$f$service = false;
        Class<IgnoreSettings> serviceClass$iv = IgnoreSettings.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        this.settings = (IgnoreSettings)object;
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service2 = false;
        Class<IgnoreManager> serviceClass$iv2 = IgnoreManager.class;
        Object object2 = $this$service$iv.getService(serviceClass$iv2);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv2);
        }
        this.manager = (IgnoreManager)object2;
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
        this.changeListManager = changeListManager;
    }

    private final EditorNotificationPanel createNotificationPanel() {
        EditorNotificationPanel editorNotificationPanel;
        EditorNotificationPanel $this$createNotificationPanel_u24lambda_u240 = editorNotificationPanel = new EditorNotificationPanel();
        boolean bl = false;
        $this$createNotificationPanel_u24lambda_u240.setText(IgnoreBundle.INSTANCE.message("daemon.ignoredEditing", new Object[0]));
        $this$createNotificationPanel_u24lambda_u240.icon(Icons.INSTANCE.getIGNORE());
        return editorNotificationPanel;
    }

    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (DumbService.Companion.isDumb(project)) {
            return null;
        }
        if (!file.isWritable()) {
            return null;
        }
        if (!this.settings.getNotifyIgnoredEditing() || !this.changeListManager.isIgnoredFile(file) && !this.manager.isFileIgnored(file)) {
            return null;
        }
        return arg_0 -> IgnoredEditingNotificationProvider.collectNotificationData$lambda$0(this, arg_0);
    }

    private static final EditorNotificationPanel collectNotificationData$lambda$0(IgnoredEditingNotificationProvider this$0, FileEditor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.createNotificationPanel();
    }
}

