/*
 * Decompiled with CFR 0.152.
 */
package mobi.hsz.idea.gitignore.reference;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.rd.util.PlatformDependentKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mobi.hsz.idea.gitignore.psi.IgnoreEntry;
import mobi.hsz.idea.gitignore.psi.IgnoreFile;
import mobi.hsz.idea.gitignore.services.IgnoreMatcher;
import mobi.hsz.idea.gitignore.util.Constants;
import mobi.hsz.idea.gitignore.util.Glob;
import mobi.hsz.idea.gitignore.util.MatcherUtil;
import mobi.hsz.idea.gitignore.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\b\u001a\u00060\tR\u00020\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u00140\u0013H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0011H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lmobi/hsz/idea/gitignore/reference/IgnoreReferenceSet;", "Lcom/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet;", "element", "Lmobi/hsz/idea/gitignore/psi/IgnoreEntry;", "<init>", "(Lmobi/hsz/idea/gitignore/psi/IgnoreEntry;)V", "matcher", "Lmobi/hsz/idea/gitignore/services/IgnoreMatcher;", "createFileReference", "Lmobi/hsz/idea/gitignore/reference/IgnoreReferenceSet$IgnoreReference;", "range", "Lcom/intellij/openapi/util/TextRange;", "index", "", "text", "", "isEndingSlashNotAllowed", "", "computeDefaultContexts", "", "Lcom/intellij/psi/PsiFileSystemItem;", "kotlin.jvm.PlatformType", "getLastReference", "Lcom/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference;", "couldBeConvertedTo", "relative", "reparse", "", "IgnoreReference", "idea-gitignore"})
@SourceDebugExtension(value={"SMAP\nIgnoreReferenceSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IgnoreReferenceSet.kt\nmobi/hsz/idea/gitignore/reference/IgnoreReferenceSet\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,174:1\n30#2,2:175\n1#3:177\n37#4:178\n36#4,3:179\n*S KotlinDebug\n*F\n+ 1 IgnoreReferenceSet.kt\nmobi/hsz/idea/gitignore/reference/IgnoreReferenceSet\n*L\n32#1:175,2\n88#1:178\n88#1:179,3\n*E\n"})
public final class IgnoreReferenceSet
extends FileReferenceSet {
    @NotNull
    private final IgnoreMatcher matcher;

    public IgnoreReferenceSet(@NotNull IgnoreEntry element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super((PsiElement)element);
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<IgnoreMatcher> serviceClass$iv = IgnoreMatcher.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.matcher = (IgnoreMatcher)object;
    }

    @NotNull
    public IgnoreReference createFileReference(@NotNull TextRange range, int index, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return new IgnoreReference(this, range, index, text);
    }

    public boolean isEndingSlashNotAllowed() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        Collection collection;
        Object object = this.getElement().getContainingFile().getParent();
        if (object != null) {
            PsiDirectory p0 = object;
            boolean bl = false;
            List list = CollectionsKt.listOf((Object)p0);
            object = list;
            if (list != null) {
                collection = (Collection)object;
                return collection;
            }
        }
        Collection collection = super.computeDefaultContexts();
        collection = collection;
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"computeDefaultContexts(...)");
        return collection;
    }

    @Nullable
    public FileReference getLastReference() {
        FileReference fileReference;
        FileReference fileReference2 = super.getLastReference();
        if (fileReference2 != null) {
            FileReference it = fileReference2;
            boolean bl = false;
            String string = it.getCanonicalText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalText(...)");
            String string2 = this.getSeparatorString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSeparatorString(...)");
            fileReference = StringsKt.endsWith$default((String)string, (String)string2, (boolean)false, (int)2, null) && this.myReferences != null && this.myReferences.length > 1 ? this.myReferences[this.myReferences.length - 2] : null;
        } else {
            fileReference = null;
        }
        return fileReference;
    }

    public boolean couldBeConvertedTo(boolean relative) {
        return false;
    }

    protected void reparse() {
        int n;
        ProgressManager.checkCanceled();
        String string = StringUtil.trimEnd((String)this.getPathString(), (String)this.getSeparatorString());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimEnd(...)");
        String str = string;
        List referencesList = new ArrayList();
        String separatorString = this.getSeparatorString();
        int sepLen = separatorString.length();
        int currentSlash = 0;
        currentSlash = -sepLen;
        int startInElement = this.getStartInElement();
        while (currentSlash + sepLen < str.length() && Character.isWhitespace(str.charAt(currentSlash + sepLen))) {
            int n2 = currentSlash;
            currentSlash = n2 + 1;
        }
        if (currentSlash + sepLen + sepLen < str.length()) {
            String string2 = str.substring(currentSlash + sepLen, currentSlash + sepLen + sepLen);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            if (Intrinsics.areEqual((Object)string2, (Object)separatorString)) {
                currentSlash += sepLen;
            }
        }
        int index = 0;
        if (Intrinsics.areEqual((Object)str, (Object)separatorString)) {
            IgnoreReference fileReference = this.createFileReference(new TextRange(startInElement, startInElement + sepLen), index++, separatorString);
            referencesList.add(fileReference);
        }
        do {
            String string3;
            ProgressManager.checkCanceled();
            CharSequence charSequence = str;
            Intrinsics.checkNotNull((Object)separatorString);
            int nextSlash = StringsKt.indexOf$default((CharSequence)charSequence, (String)separatorString, (int)(currentSlash + sepLen), (boolean)false, (int)4, null);
            if (nextSlash > 0) {
                String string4 = str.substring(0, nextSlash);
                string3 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            } else {
                string3 = str;
            }
            String subReferenceText = string3;
            TextRange range = new TextRange(startInElement + currentSlash + sepLen, startInElement + (nextSlash > 0 ? nextSlash : str.length()));
            IgnoreReference ref = this.createFileReference(range, index++, subReferenceText);
            referencesList.add(ref);
            int it = n = nextSlash;
            boolean bl = false;
            currentSlash = it;
        } while (n >= 0);
        Collection $this$toTypedArray$iv = referencesList;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.myReferences = thisCollection$iv.toArray(new FileReference[0]);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ0\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lmobi/hsz/idea/gitignore/reference/IgnoreReferenceSet$IgnoreReference;", "Lcom/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference;", "fileReferenceSet", "Lcom/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet;", "range", "Lcom/intellij/openapi/util/TextRange;", "index", "", "text", "", "<init>", "(Lmobi/hsz/idea/gitignore/reference/IgnoreReferenceSet;Lcom/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceSet;Lcom/intellij/openapi/util/TextRange;ILjava/lang/String;)V", "cacheMap", "", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "innerResolveInContext", "", "context", "Lcom/intellij/psi/PsiFileSystemItem;", "result", "", "Lcom/intellij/psi/ResolveResult;", "caseSensitive", "", "getPsiFileSystemItem", "manager", "Lcom/intellij/psi/PsiManager;", "file", "idea-gitignore"})
    @SourceDebugExtension(value={"SMAP\nIgnoreReferenceSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IgnoreReferenceSet.kt\nmobi/hsz/idea/gitignore/reference/IgnoreReferenceSet$IgnoreReference\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n3829#2:175\n4344#2,2:176\n382#3,3:178\n385#3,4:186\n774#4:181\n865#4,2:182\n1869#4,2:184\n1869#4,2:190\n1#5:192\n*S KotlinDebug\n*F\n+ 1 IgnoreReferenceSet.kt\nmobi/hsz/idea/gitignore/reference/IgnoreReferenceSet$IgnoreReference\n*L\n125#1:175\n125#1:176,2\n128#1:178,3\n128#1:186,4\n139#1:181\n139#1:182,2\n139#1:184,2\n151#1:190,2\n*E\n"})
    public final class IgnoreReference
    extends FileReference {
        @NotNull
        private final Map<String, Collection<VirtualFile>> cacheMap;

        public IgnoreReference(@Nullable FileReferenceSet fileReferenceSet, TextRange range, @Nullable int index, String text) {
            Intrinsics.checkNotNullParameter((Object)fileReferenceSet, (String)"fileReferenceSet");
            super(fileReferenceSet, range, index, text);
            this.cacheMap = PlatformDependentKt.concurrentMapOf();
        }

        /*
         * WARNING - void declaration
         */
        protected void innerResolveInContext(@NotNull String text, @NotNull PsiFileSystemItem context, @NotNull Collection<? super ResolveResult> result, boolean caseSensitive) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(result, (String)"result");
            ProgressManager.checkCanceled();
            super.innerResolveInContext(text, context, result, caseSensitive);
            PsiFile psiFile = IgnoreReferenceSet.this.getContainingFile();
            IgnoreFile ignoreFile = psiFile instanceof IgnoreFile ? (IgnoreFile)psiFile : null;
            if (ignoreFile == null) {
                return;
            }
            IgnoreFile containingFile = ignoreFile;
            VirtualFile contextVirtualFile = null;
            VirtualFile virtualFile = containingFile.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            Project project = this.getElement().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            if (!Utils.INSTANCE.isInProject(virtualFile, project)) {
                return;
            }
            contextVirtualFile = context.getVirtualFile();
            if (contextVirtualFile != null) {
                PsiElement psiElement = this.getFileReferenceSet().getElement();
                Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type mobi.hsz.idea.gitignore.psi.IgnoreEntry");
                IgnoreEntry entry = (IgnoreEntry)psiElement;
                String string = this.getCanonicalText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalText(...)");
                String current = string;
                Pattern pattern = Glob.createPattern$default(Glob.INSTANCE, current, entry.getSyntax(), false, 4, null);
                if (pattern == null) {
                    return;
                }
                Pattern pattern2 = pattern;
                PsiDirectory psiDirectory = this.getElement().getContainingFile().getParent();
                VirtualFile root = psiDirectory != null ? psiDirectory.getVirtualFile() : null;
                PsiManager psiManager = this.getElement().getManager();
                ConcurrentList concurrentList = ContainerUtil.createConcurrentList();
                IgnoreReferenceSet ignoreReferenceSet = IgnoreReferenceSet.this;
                ConcurrentList $this$innerResolveInContext_u24lambda_u240 = concurrentList;
                boolean bl = false;
                Project project2 = context.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                $this$innerResolveInContext_u24lambda_u240.addAll(MatcherUtil.Companion.getFilesForPattern(project2, pattern2));
                if ($this$innerResolveInContext_u24lambda_u240.isEmpty()) {
                    Intrinsics.checkNotNull((Object)$this$innerResolveInContext_u24lambda_u240);
                    Collection collection = (Collection)$this$innerResolveInContext_u24lambda_u240;
                    VirtualFile[] virtualFileArray = context.getVirtualFile().getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
                    CollectionsKt.addAll((Collection)collection, (Object[])virtualFileArray);
                } else if (StringsKt.endsWith$default((String)current, (String)Constants.INSTANCE.getSTAR(), (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)current, (Object)entry.getText())) {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    VirtualFile[] virtualFileArray = context.getVirtualFile().getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
                    Object[] objectArray = virtualFileArray;
                    ConcurrentList concurrentList2 = $this$innerResolveInContext_u24lambda_u240;
                    boolean $i$f$filter = false;
                    Iterator iterator = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (VirtualFileVisitor.Option[] element$iv$iv : $this$filterTo$iv$iv) {
                        VirtualFile it = (VirtualFile)element$iv$iv;
                        boolean bl2 = false;
                        if (!it.isDirectory()) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    concurrentList2.addAll((Collection)((List)destination$iv$iv));
                } else if (StringsKt.endsWith$default((String)current, (String)Constants.INSTANCE.getDOUBLESTAR(), (boolean)false, (int)2, null)) {
                    Object object;
                    void $this$getOrPut$iv;
                    Map<String, Collection<VirtualFile>> $i$f$filter = this.cacheMap;
                    String key$iv = entry.getText();
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        void $this$forEach$iv;
                        void $this$filterTo$iv$iv;
                        VirtualFileVisitor.Option[] element$iv$iv;
                        boolean bl3 = false;
                        List children2 = new ArrayList();
                        element$iv$iv = new VirtualFileVisitor.Option[]{};
                        VirtualFileVisitor<Object> visitor2 = new VirtualFileVisitor<Object>((List<VirtualFile>)children2, element$iv$iv){
                            final /* synthetic */ List<VirtualFile> $children;
                            {
                                this.$children = $children;
                                super($super_call_param$1);
                            }

                            public boolean visitFile(VirtualFile file) {
                                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                                boolean bl = file.isDirectory();
                                List<VirtualFile> list = this.$children;
                                boolean it = bl;
                                boolean bl2 = false;
                                if (it) {
                                    list.add(file);
                                }
                                return bl;
                            }
                        };
                        Intrinsics.checkNotNull((Object)$this$innerResolveInContext_u24lambda_u240);
                        Iterable $this$filter$iv = (Iterable)$this$innerResolveInContext_u24lambda_u240;
                        boolean $i$f$filter2 = false;
                        Iterable iterable = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                            VirtualFile p0 = (VirtualFile)element$iv$iv2;
                            boolean bl4 = false;
                            if (!p0.isDirectory()) continue;
                            destination$iv$iv.add(element$iv$iv2);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            VirtualFile it = (VirtualFile)element$iv;
                            boolean bl5 = false;
                            ProgressManager.checkCanceled();
                            VfsUtil.visitChildrenRecursively((VirtualFile)it, (VirtualFileVisitor)((VirtualFileVisitor)visitor2));
                            children2.remove(it);
                        }
                        Collection answer$iv = children2;
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    Collection children3 = (Collection)object;
                    $this$innerResolveInContext_u24lambda_u240.clear();
                    $this$innerResolveInContext_u24lambda_u240.addAll(children3);
                }
                Intrinsics.checkNotNull((Object)$this$innerResolveInContext_u24lambda_u240);
                Iterable $this$forEach$iv = (Iterable)$this$innerResolveInContext_u24lambda_u240;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PsiFileSystemItem psiFileSystemItem;
                    String name;
                    VirtualFile file = (VirtualFile)element$iv;
                    boolean bl6 = false;
                    ProgressManager.checkCanceled();
                    Intrinsics.checkNotNull((Object)file);
                    if (Utils.INSTANCE.isVcsDirectory(file)) continue;
                    VirtualFile virtualFile2 = root;
                    String string2 = name = virtualFile2 != null ? Utils.INSTANCE.getRelativePath(virtualFile2, file) : file.getName();
                    if (!ignoreReferenceSet.matcher.match(pattern2, name)) continue;
                    Intrinsics.checkNotNull((Object)psiManager);
                    if (this.getPsiFileSystemItem(psiManager, file) == null) continue;
                    result.add((ResolveResult)new PsiElementResolveResult((PsiElement)psiFileSystemItem));
                }
            }
        }

        private final PsiFileSystemItem getPsiFileSystemItem(PsiManager manager, VirtualFile file) {
            PsiDirectory psiDirectory;
            if (!file.isValid()) {
                return null;
            }
            PsiDirectory it = psiDirectory = manager.findDirectory(file);
            boolean bl = false;
            Object object = file.isDirectory() ? psiDirectory : null;
            return object != null ? (PsiFileSystemItem)object : (PsiFileSystemItem)manager.findFile(file);
        }
    }
}

