/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.acp.json;

import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.ml.llm.agents.acp.json.AcpAgentsDetectionServiceKt;
import com.intellij.ml.llm.agents.acp.json.AcpGlobalAgentsRegistry;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \t2\u00020\u0001:\u0002\b\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/agents/acp/json/AcpAgentsDetectionService;", "", "<init>", "()V", "getDetectedAgents", "", "Lcom/intellij/ml/llm/agents/acp/json/AcpAgentsDetectionService$DetectedAgent;", "detectAgentsInPath", "DetectedAgent", "Companion", "intellij.ml.llm.agents.acp.json"})
@ApiStatus.Internal
public final class AcpAgentsDetectionService {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<DetectedAgent> getDetectedAgents() {
        return this.detectAgentsInPath();
    }

    private final List<DetectedAgent> detectAgentsInPath() {
        AcpAgentsDetectionServiceKt.access$getLogger$p().info("Detecting ACP agents in PATH");
        String pathValue = PathEnvironmentVariableUtil.getPathVariableValue();
        AcpAgentsDetectionServiceKt.access$getLogger$p().debug("Current PATH: " + pathValue);
        List detected = new ArrayList();
        for (AcpGlobalAgentsRegistry.GlobalAgentInfo agentInfo : AcpGlobalAgentsRegistry.INSTANCE.getKnownAgents()) {
            try {
                File executable = PathEnvironmentVariableUtil.findInPath((String)agentInfo.getExecutableName());
                if (executable != null && executable.exists() && executable.canExecute()) {
                    AcpAgentsDetectionServiceKt.access$getLogger$p().info("Detected ACP agent '" + agentInfo.getExecutableName() + "' at: " + executable.getAbsolutePath());
                    Path path = Path.of(executable.getAbsolutePath(), new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
                    detected.add(new DetectedAgent(agentInfo, path));
                    continue;
                }
                AcpAgentsDetectionServiceKt.access$getLogger$p().debug("ACP agent '" + agentInfo.getExecutableName() + "' not found in PATH");
            }
            catch (Exception e) {
                AcpAgentsDetectionServiceKt.access$getLogger$p().warn("Error searching for agent '" + agentInfo.getExecutableName() + "' in PATH", (Throwable)e);
            }
        }
        AcpAgentsDetectionServiceKt.access$getLogger$p().info("Detected " + detected.size() + " ACP agent(s) in PATH");
        return detected;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/agents/acp/json/AcpAgentsDetectionService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/agents/acp/json/AcpAgentsDetectionService;", "intellij.ml.llm.agents.acp.json"})
    @SourceDebugExtension(value={"SMAP\nAcpAgentsDetectionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AcpAgentsDetectionService.kt\ncom/intellij/ml/llm/agents/acp/json/AcpAgentsDetectionService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,80:1\n42#2,3:81\n*S KotlinDebug\n*F\n+ 1 AcpAgentsDetectionService.kt\ncom/intellij/ml/llm/agents/acp/json/AcpAgentsDetectionService$Companion\n*L\n77#1:81,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AcpAgentsDetectionService getInstance() {
            boolean $i$f$service = false;
            Class<AcpAgentsDetectionService> serviceClass$iv = AcpAgentsDetectionService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (AcpAgentsDetectionService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/agents/acp/json/AcpAgentsDetectionService$DetectedAgent;", "", "agentInfo", "Lcom/intellij/ml/llm/agents/acp/json/AcpGlobalAgentsRegistry$GlobalAgentInfo;", "executablePath", "Ljava/nio/file/Path;", "<init>", "(Lcom/intellij/ml/llm/agents/acp/json/AcpGlobalAgentsRegistry$GlobalAgentInfo;Ljava/nio/file/Path;)V", "getAgentInfo", "()Lcom/intellij/ml/llm/agents/acp/json/AcpGlobalAgentsRegistry$GlobalAgentInfo;", "getExecutablePath", "()Ljava/nio/file/Path;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.ml.llm.agents.acp.json"})
    public static final class DetectedAgent {
        @NotNull
        private final AcpGlobalAgentsRegistry.GlobalAgentInfo agentInfo;
        @NotNull
        private final Path executablePath;

        public DetectedAgent(@NotNull AcpGlobalAgentsRegistry.GlobalAgentInfo agentInfo, @NotNull Path executablePath) {
            Intrinsics.checkNotNullParameter((Object)agentInfo, (String)"agentInfo");
            Intrinsics.checkNotNullParameter((Object)executablePath, (String)"executablePath");
            this.agentInfo = agentInfo;
            this.executablePath = executablePath;
        }

        @NotNull
        public final AcpGlobalAgentsRegistry.GlobalAgentInfo getAgentInfo() {
            return this.agentInfo;
        }

        @NotNull
        public final Path getExecutablePath() {
            return this.executablePath;
        }

        @NotNull
        public final AcpGlobalAgentsRegistry.GlobalAgentInfo component1() {
            return this.agentInfo;
        }

        @NotNull
        public final Path component2() {
            return this.executablePath;
        }

        @NotNull
        public final DetectedAgent copy(@NotNull AcpGlobalAgentsRegistry.GlobalAgentInfo agentInfo, @NotNull Path executablePath) {
            Intrinsics.checkNotNullParameter((Object)agentInfo, (String)"agentInfo");
            Intrinsics.checkNotNullParameter((Object)executablePath, (String)"executablePath");
            return new DetectedAgent(agentInfo, executablePath);
        }

        public static /* synthetic */ DetectedAgent copy$default(DetectedAgent detectedAgent, AcpGlobalAgentsRegistry.GlobalAgentInfo globalAgentInfo, Path path, int n, Object object) {
            if ((n & 1) != 0) {
                globalAgentInfo = detectedAgent.agentInfo;
            }
            if ((n & 2) != 0) {
                path = detectedAgent.executablePath;
            }
            return detectedAgent.copy(globalAgentInfo, path);
        }

        @NotNull
        public String toString() {
            return "DetectedAgent(agentInfo=" + this.agentInfo + ", executablePath=" + this.executablePath + ")";
        }

        public int hashCode() {
            int result = this.agentInfo.hashCode();
            result = result * 31 + ((Object)this.executablePath).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DetectedAgent)) {
                return false;
            }
            DetectedAgent detectedAgent = (DetectedAgent)other;
            if (!Intrinsics.areEqual((Object)this.agentInfo, (Object)detectedAgent.agentInfo)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.executablePath, (Object)detectedAgent.executablePath);
        }
    }
}

