/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray;

import io.kinference.ndarray.ParallelizeBody;
import io.kinference.ndarray.arrays.Strides;
import io.kinference.utils.ResourcesDispatcherKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.UByte;
import kotlin.UShort;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u000f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u00a2\u0006\u0002\u0010\u0003\u001a\u000f\u0010\u0004\u001a\u00020\u0005*\u00020\u0002\u00a2\u0006\u0002\u0010\u0006\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\t\u001a\u0012\u0010\n\u001a\u00020\b*\u00020\u000b2\u0006\u0010\f\u001a\u00020\b\u001a\u0012\u0010\n\u001a\u00020\b*\u00020\b2\u0006\u0010\r\u001a\u00020\u000b\u001a\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u001c\u0010$\u001a\u00020%*\u00020\b2\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u000bH\u0000\u001a.\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020-H\u0086@\u00a2\u0006\u0002\u0010.\u001a.\u0010/\u001a\u00020%2\u0006\u00100\u001a\u00020\u000b2\u0006\u00101\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020-H\u0086H\u00a2\u0006\u0002\u0010.\u001a \u00102\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\u000b2\u0006\u00101\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u000bH\u0000\u001a \u00103\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\u000b2\u0006\u00101\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u000bH\u0000\"\u000e\u0010\u000e\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\u0002X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0014X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u000e\u0010\u0019\u001a\u00020\u0014X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001a\u001a\u00020\u0014X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001b\u001a\u00020\u0014X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001c\u001a\u00020\u0014X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001d\u001a\u00020\u0014X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001e\u001a\u00020\u0002X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001f\u001a\u00020\u0002X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010 \u001a\u00020\u0002X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010!\u001a\u00020\u0002X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\"\u001a\u00020\u0002X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010#\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"toUShort", "Lkotlin/UShort;", "", "(D)S", "toUByte", "Lkotlin/UByte;", "(D)B", "reversed", "", "Lkotlin/ranges/IntRange;", "concat", "", "array", "value", "MIN_BLOCK_SIZE", "blockSizeByStrides", "strides", "Lio/kinference/ndarray/arrays/Strides;", "ERF_P_VALUE", "ERF_P_VALUE_FLOAT", "", "ERF_COEF", "", "getERF_COEF", "()[D", "ERF_COEF_1_FLOAT", "ERF_COEF_2_FLOAT", "ERF_COEF_3_FLOAT", "ERF_COEF_4_FLOAT", "ERF_COEF_5_FLOAT", "ERF_COEF_1", "ERF_COEF_2", "ERF_COEF_3", "ERF_COEF_4", "ERF_COEF_5", "INIT_STORAGE_SIZE", "swap", "", "leftIdx", "rightIdx", "parallelizeByBlocks", "blockSize", "countBlocks", "minDataPerLaunch", "body", "Lio/kinference/ndarray/ParallelizeBody;", "(IIILio/kinference/ndarray/ParallelizeBody;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "parallelizeByRows", "rowSize", "countRows", "countCoroutinesByData", "batchSizeByData", "ndarray-core"})
public final class UtilsKt {
    private static final int MIN_BLOCK_SIZE = 512;
    public static final double ERF_P_VALUE = 0.3275911;
    public static final float ERF_P_VALUE_FLOAT = 0.3275911f;
    @NotNull
    private static final double[] ERF_COEF;
    public static final float ERF_COEF_1_FLOAT = 0.2548296f;
    public static final float ERF_COEF_2_FLOAT = -0.28449672f;
    public static final float ERF_COEF_3_FLOAT = 1.4214138f;
    public static final float ERF_COEF_4_FLOAT = -1.4531521f;
    public static final float ERF_COEF_5_FLOAT = 1.0614054f;
    public static final double ERF_COEF_1 = 0.254829592;
    public static final double ERF_COEF_2 = -0.284496736;
    public static final double ERF_COEF_3 = 1.421413741;
    public static final double ERF_COEF_4 = -1.453152027;
    public static final double ERF_COEF_5 = 1.061405429;
    public static final int INIT_STORAGE_SIZE = 64;

    public static final short toUShort(double $this$toUShort) {
        return UShort.constructor-impl((short)((short)$this$toUShort));
    }

    public static final byte toUByte(double $this$toUByte) {
        return UByte.constructor-impl((byte)((byte)$this$toUByte));
    }

    @NotNull
    public static final int[] reversed(@NotNull IntRange $this$reversed) {
        Intrinsics.checkNotNullParameter((Object)$this$reversed, (String)"<this>");
        int size = $this$reversed.getLast() - $this$reversed.getFirst() + 1;
        int[] array = new int[size];
        int n = $this$reversed.getFirst();
        int n2 = $this$reversed.getLast();
        int n3 = 0;
        if (n <= n2) {
            int element;
            do {
                int i = n3++;
                array[size - i - 1] = element = n++;
            } while (element != n2);
        }
        return array;
    }

    @NotNull
    public static final int[] concat(int $this$concat, @NotNull int[] array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        int[] copy = new int[array.length + 1];
        ArraysKt.copyInto$default((int[])array, (int[])copy, (int)1, (int)0, (int)0, (int)12, null);
        copy[0] = $this$concat;
        return copy;
    }

    @NotNull
    public static final int[] concat(@NotNull int[] $this$concat, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$concat, (String)"<this>");
        int[] copy = new int[$this$concat.length + 1];
        ArraysKt.copyInto$default((int[])$this$concat, (int[])copy, (int)0, (int)0, (int)0, (int)14, null);
        copy[$this$concat.length] = value;
        return copy;
    }

    /*
     * WARNING - void declaration
     */
    public static final int blockSizeByStrides(@NotNull Strides strides) {
        int n;
        Intrinsics.checkNotNullParameter((Object)strides, (String)"strides");
        if (strides.getLinearSize() == 0) {
            n = 0;
        } else if (strides.getShape().length == 0) {
            n = 1;
        } else {
            void var2_3;
            int n2;
            int rowSize = ArraysKt.last((int[])strides.getShape());
            if (rowSize < 512) {
                n2 = rowSize;
            } else {
                int num = rowSize / 512;
                while (rowSize % num != 0) {
                    --num;
                }
                n2 = rowSize / num;
            }
            int blockSize = n2;
            n = var2_3;
        }
        return n;
    }

    @NotNull
    public static final double[] getERF_COEF() {
        return ERF_COEF;
    }

    public static final void swap(@NotNull int[] $this$swap, int leftIdx, int rightIdx) {
        Intrinsics.checkNotNullParameter((Object)$this$swap, (String)"<this>");
        int temp = $this$swap[leftIdx];
        $this$swap[leftIdx] = $this$swap[rightIdx];
        $this$swap[rightIdx] = temp;
    }

    @Nullable
    public static final Object parallelizeByBlocks(int blockSize, int countBlocks, int minDataPerLaunch, @NotNull ParallelizeBody body, @NotNull Continuation<? super Unit> $completion) {
        int batchSize = UtilsKt.batchSizeByData(blockSize, countBlocks, minDataPerLaunch);
        if (batchSize != countBlocks) {
            Object object = CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(countBlocks, batchSize, body, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ int $countBlocks;
                final /* synthetic */ int $batchSize;
                final /* synthetic */ ParallelizeBody $body;
                {
                    this.$countBlocks = $countBlocks;
                    this.$batchSize = $batchSize;
                    this.$body = $body;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            CoroutineScope $this$coroutineScope = (CoroutineScope)this.L$0;
                            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)this.$countBlocks)), (int)this.$batchSize);
                            int n = intProgression.getFirst();
                            int n2 = intProgression.getLast();
                            int n3 = intProgression.getStep();
                            int n4 = 0;
                            if (n3 > 0 && n <= n2 || n3 < 0 && n2 <= n) {
                                while (true) {
                                    int index2 = n4++;
                                    int blockStart = n;
                                    ResourcesDispatcherKt.launchWithLimitOrDefault($this$coroutineScope, (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$body, blockStart, this.$batchSize, this.$countBlocks, index2, null){
                                        int label;
                                        final /* synthetic */ ParallelizeBody $body;
                                        final /* synthetic */ int $blockStart;
                                        final /* synthetic */ int $batchSize;
                                        final /* synthetic */ int $countBlocks;
                                        final /* synthetic */ int $index;
                                        {
                                            this.$body = $body;
                                            this.$blockStart = $blockStart;
                                            this.$batchSize = $batchSize;
                                            this.$countBlocks = $countBlocks;
                                            this.$index = $index;
                                            super(2, $completion);
                                        }

                                        public final Object invokeSuspend(Object object) {
                                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)object);
                                                    this.$body.invoke(this.$blockStart, Math.min(this.$blockStart + this.$batchSize, this.$countBlocks), this.$index);
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }));
                                    if (blockStart == n2) break;
                                    n += n3;
                                }
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        body.invoke(0, countBlocks, 0);
        return Unit.INSTANCE;
    }

    @Nullable
    public static final Object parallelizeByRows(int rowSize, int countRows, int minDataPerLaunch, @NotNull ParallelizeBody body, @NotNull Continuation<? super Unit> $completion) {
        boolean $i$f$parallelizeByRows = false;
        Object object = UtilsKt.parallelizeByBlocks(rowSize, countRows, minDataPerLaunch, body, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final Object parallelizeByRows$$forInline(int rowSize, int countRows, int minDataPerLaunch, ParallelizeBody body, Continuation<? super Unit> $completion) {
        boolean $i$f$parallelizeByRows = false;
        InlineMarker.mark((int)0);
        UtilsKt.parallelizeByBlocks(rowSize, countRows, minDataPerLaunch, body, $completion);
        InlineMarker.mark((int)1);
        return Unit.INSTANCE;
    }

    public static final int countCoroutinesByData(int rowSize, int countRows, int minDataPerLaunch) {
        int batchSize = UtilsKt.batchSizeByData(rowSize, countRows, minDataPerLaunch);
        return (countRows + batchSize - 1) / batchSize;
    }

    public static final int batchSizeByData(int rowSize, int countRows, int minDataPerLaunch) {
        int batchSize = (minDataPerLaunch + rowSize - 1) / rowSize;
        return Math.min(batchSize, countRows);
    }

    static {
        double[] dArray = new double[]{0.254829592, -0.284496736, 1.421413741, -1.453152027, 1.061405429};
        ERF_COEF = dArray;
    }
}

