/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.extensions.utils;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0015\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a \u0010\u0003\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00012\b\b\u0002\u0010\u0005\u001a\u00020\u0001H\u0000\u001a\u0015\u0010\u0006\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0086\u0004\u001a\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0002H\u0000\u001a\u0018\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0002H\u0000\u001a\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001H\u0000\u001a7\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u0011*\b\u0012\u0004\u0012\u0002H\u00110\u00122\u0006\u0010\u0013\u001a\u00020\u00012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0015H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0017"}, d2={"inferShapeSize", "", "", "calculateBlock", "fromIdx", "toIdx", "divCeil", "b", "calculateInnerShapeSize", "shape", "computeColumnMajorIndex", "rowMajorIndex", "isInPadding", "", "actual", "bound", "getOrPut", "V", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "key", "defaultValue", "Lkotlin/Function0;", "(Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;ILkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "ndarray-core"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\nio/kinference/ndarray/extensions/utils/UtilsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,66:1\n12799#2,3:67\n12932#2,4:70\n*S KotlinDebug\n*F\n+ 1 Utils.kt\nio/kinference/ndarray/extensions/utils/UtilsKt\n*L\n9#1:67,3\n28#1:70,4\n*E\n"})
public final class UtilsKt {
    /*
     * WARNING - void declaration
     */
    public static final int inferShapeSize(@NotNull int[] $this$inferShapeSize) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)$this$inferShapeSize, (String)"<this>");
        int[] nArray = $this$inferShapeSize;
        int initial$iv = 1;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        int n = ((void)$this$fold$iv).length;
        for (int i = 0; i < n; ++i) {
            void i2;
            void element$iv;
            void var8_8 = element$iv = $this$fold$iv[i];
            int size = accumulator$iv;
            boolean bl = false;
            accumulator$iv = size * i2;
        }
        return accumulator$iv;
    }

    public static final int calculateBlock(@NotNull int[] $this$calculateBlock, int fromIdx, int toIdx) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateBlock, (String)"<this>");
        int result = 1;
        for (int idx = fromIdx; idx < toIdx; ++idx) {
            result *= $this$calculateBlock[idx];
        }
        return result;
    }

    public static /* synthetic */ int calculateBlock$default(int[] nArray, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = nArray.length;
        }
        return UtilsKt.calculateBlock(nArray, n, n2);
    }

    public static final int divCeil(int $this$divCeil, int b) {
        return ($this$divCeil + b - 1) / b;
    }

    /*
     * WARNING - void declaration
     */
    public static final int calculateInnerShapeSize(@NotNull int[] shape) {
        void $this$foldIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        int[] nArray = shape;
        int initial$iv = 1;
        boolean $i$f$foldIndexed = false;
        int index$iv = 0;
        int accumulator$iv = initial$iv;
        for (void element$iv : $this$foldIndexed$iv) {
            void i;
            void acc;
            int n = index$iv++;
            void var9_9 = element$iv;
            int n2 = accumulator$iv;
            int index2 = n;
            boolean bl = false;
            accumulator$iv = index2 >= 2 ? acc * i : acc;
        }
        return accumulator$iv;
    }

    public static final int computeColumnMajorIndex(int rowMajorIndex, @NotNull int[] shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        int[] index2 = new int[shape.length];
        int rowMajorIndex2 = rowMajorIndex;
        for (int i = ArraysKt.getLastIndex((int[])shape); -1 < i; --i) {
            index2[i] = rowMajorIndex2 % shape[i];
            rowMajorIndex2 /= shape[i];
        }
        int result = 0;
        int shapeSize = 1;
        int i = 2;
        int n = ArraysKt.getLastIndex((int[])index2);
        if (i <= n) {
            while (true) {
                result += shapeSize * index2[i];
                shapeSize *= shape[i];
                if (i == n) break;
                ++i;
            }
        }
        result += shapeSize * index2[1];
        return result += shapeSize * shape[1] * index2[0];
    }

    public static final boolean isInPadding(int actual, int bound) {
        return actual < 0 || actual >= bound;
    }

    public static final <V> V getOrPut(@NotNull Int2ObjectOpenHashMap<V> $this$getOrPut, int key, @NotNull Function0<? extends V> defaultValue) {
        Object object;
        Intrinsics.checkNotNullParameter($this$getOrPut, (String)"<this>");
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        boolean $i$f$getOrPut = false;
        V existingValue = $this$getOrPut.get(key);
        if (existingValue != null) {
            object = existingValue;
        } else {
            Object value = defaultValue.invoke();
            $this$getOrPut.put(key, value);
            object = value;
        }
        return object;
    }
}

