/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.agents.frontend.compose.ui.viewModels;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ide.ui.icons.IconId;
import com.intellij.ide.ui.icons.IconIdKt;
import com.intellij.ml.llm.agents.frontend.compose.model.Attachment;
import com.intellij.ml.llm.agents.frontend.compose.model.ChatSessionContext;
import com.intellij.ml.llm.agents.frontend.compose.ui.components.utils.FileOperationsKt;
import com.intellij.ml.llm.agents.frontend.compose.ui.viewModels.AgentMessageBlockViewModel;
import com.intellij.ml.llm.agents.frontend.compose.ui.viewModels.ChatMessageViewModel;
import com.intellij.ml.llm.chat.shared.ChatSessionAgent;
import com.intellij.ml.llm.chat.shared.ChatSessionAgentStateChanged;
import com.intellij.ml.llm.chat.shared.ChatSessionAgentStatusChanged;
import com.intellij.ml.llm.chat.shared.ChatSessionEvent;
import com.intellij.ml.llm.chat.shared.ChatSessionEventId;
import com.intellij.ml.llm.chat.shared.ChatSessionFailureEvent;
import com.intellij.ml.llm.chat.shared.ChatSessionId;
import com.intellij.ml.llm.chat.shared.ChatSessionMessageBlockEvent;
import com.intellij.ml.llm.chat.shared.ChatSessionMessageEvent;
import com.intellij.ml.llm.chat.shared.ChatSessionPlanUpdatedEvent;
import com.intellij.ml.llm.chat.shared.ChatSessionResponseReceived;
import com.intellij.ml.llm.chat.shared.ChatSessionRollbackEvents;
import com.intellij.ml.llm.chat.shared.ChatSessionUserPromptAttachment;
import com.intellij.ml.llm.chat.shared.ChatSessionUserPromptEvent;
import com.intellij.ml.llm.chat.shared.rpc.AIAssistantChatSessionApi;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ<\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0\b*\b\u0012\u0004\u0012\u00020\u000f0\bH\u0002J\u0018\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000f0\b*\b\u0012\u0004\u0012\u00020\u000f0\bH\u0002J*\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010'\u001a\u0004\u0018\u00010\u00152\u0006\u0010(\u001a\u00020\u000fH\u0002J*\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000f0)*\b\u0012\u0004\u0012\u00020\u000f0)2\b\u0010'\u001a\u0004\u0018\u00010\u00152\u0006\u0010(\u001a\u00020\u000fH\u0002J\u0018\u0010*\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#2\u0006\u0010'\u001a\u00020\u0015H\u0002J\u001c\u0010+\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020\u001a0,2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u000f0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/ml/llm/agents/frontend/compose/ui/viewModels/ChatMessageUpdatesManager;", "", "viewModelsParentScope", "Lkotlinx/coroutines/CoroutineScope;", "chatSessionContext", "Lcom/intellij/ml/llm/agents/frontend/compose/model/ChatSessionContext;", "availableAgents", "Lkotlinx/coroutines/flow/StateFlow;", "", "Lcom/intellij/ml/llm/chat/shared/ChatSessionAgent;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/ml/llm/agents/frontend/compose/model/ChatSessionContext;Lkotlinx/coroutines/flow/StateFlow;)V", "_messageViewModels", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lkotlinx/collections/immutable/PersistentList;", "Lcom/intellij/ml/llm/agents/frontend/compose/ui/viewModels/ChatMessageViewModel;", "messageViewModels", "getMessageViewModels", "()Lkotlinx/coroutines/flow/StateFlow;", "messageViewModelByEventId", "", "Lcom/intellij/ml/llm/chat/shared/ChatSessionEventId;", "revertedViewModelToEventId", "failureMessageEventIds", "", "updateViewModels", "", "project", "Lcom/intellij/openapi/project/Project;", "chatSessionEvent", "Lcom/intellij/ml/llm/chat/shared/ChatSessionEvent;", "getUpdatedViewModels", "event", "Lcom/intellij/ml/llm/chat/shared/ChatSessionMessageEvent;", "chatSessionId", "Lcom/intellij/ml/llm/chat/shared/ChatSessionId;", "removeRevertedMessages", "removeFailureMessages", "addRemembering", "eventId", "messageViewModel", "", "rollbackAction", "openAttachmentAction", "Lkotlin/Function1;", "Lcom/intellij/ml/llm/agents/frontend/compose/model/Attachment;", "intellij.ml.llm.agents.frontend"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nChatMessageUpdatesManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatMessageUpdatesManager.kt\ncom/intellij/ml/llm/agents/frontend/compose/ui/viewModels/ChatMessageUpdatesManager\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,196:1\n230#2,5:197\n543#3,6:202\n543#3,6:208\n1869#3,2:214\n669#3,11:218\n669#3,11:229\n1563#3:240\n1634#3,3:241\n827#3:244\n855#3,2:245\n1869#3,2:247\n827#3:249\n855#3,2:250\n1869#3,2:252\n1#4:216\n13#5:217\n*S KotlinDebug\n*F\n+ 1 ChatMessageUpdatesManager.kt\ncom/intellij/ml/llm/agents/frontend/compose/ui/viewModels/ChatMessageUpdatesManager\n*L\n38#1:197,5\n57#1:202,6\n61#1:208,6\n62#1:214,2\n111#1:218,11\n115#1:229,11\n116#1:240\n116#1:241,3\n148#1:244\n148#1:245,2\n149#1:247,2\n157#1:249\n157#1:250,2\n158#1:252,2\n90#1:217\n*E\n"})
public final class ChatMessageUpdatesManager {
    @NotNull
    private final CoroutineScope viewModelsParentScope;
    @NotNull
    private final ChatSessionContext chatSessionContext;
    @NotNull
    private final StateFlow<List<ChatSessionAgent>> availableAgents;
    @NotNull
    private final MutableStateFlow<PersistentList<ChatMessageViewModel>> _messageViewModels;
    @NotNull
    private final StateFlow<PersistentList<ChatMessageViewModel>> messageViewModels;
    @NotNull
    private final Map<ChatSessionEventId, ChatMessageViewModel> messageViewModelByEventId;
    @NotNull
    private final Map<ChatMessageViewModel, ChatSessionEventId> revertedViewModelToEventId;
    @NotNull
    private final Set<ChatSessionEventId> failureMessageEventIds;
    public static final int $stable = 8;

    public ChatMessageUpdatesManager(@NotNull CoroutineScope viewModelsParentScope, @NotNull ChatSessionContext chatSessionContext, @NotNull StateFlow<? extends List<ChatSessionAgent>> availableAgents) {
        Intrinsics.checkNotNullParameter((Object)viewModelsParentScope, (String)"viewModelsParentScope");
        Intrinsics.checkNotNullParameter((Object)chatSessionContext, (String)"chatSessionContext");
        Intrinsics.checkNotNullParameter(availableAgents, (String)"availableAgents");
        this.viewModelsParentScope = viewModelsParentScope;
        this.chatSessionContext = chatSessionContext;
        this.availableAgents = availableAgents;
        this._messageViewModels = StateFlowKt.MutableStateFlow((Object)ExtensionsKt.persistentListOf());
        this.messageViewModels = FlowKt.asStateFlow(this._messageViewModels);
        this.messageViewModelByEventId = new LinkedHashMap();
        this.revertedViewModelToEventId = new LinkedHashMap();
        this.failureMessageEventIds = new LinkedHashSet();
    }

    @NotNull
    public final StateFlow<PersistentList<ChatMessageViewModel>> getMessageViewModels() {
        return this.messageViewModels;
    }

    public final void updateViewModels(@NotNull Project project, @NotNull ChatSessionEvent chatSessionEvent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)chatSessionEvent, (String)"chatSessionEvent");
        ChatSessionEvent chatSessionEvent2 = chatSessionEvent;
        if (chatSessionEvent2 instanceof ChatSessionMessageEvent) {
            PersistentList it;
            PersistentList<ChatMessageViewModel> nextValue$iv;
            Object prevValue$iv;
            MutableStateFlow<PersistentList<ChatMessageViewModel>> $this$update$iv = this._messageViewModels;
            boolean $i$f$update = false;
            do {
                prevValue$iv = $this$update$iv.getValue();
                it = (PersistentList)prevValue$iv;
                boolean bl = false;
            } while (!$this$update$iv.compareAndSet(prevValue$iv, nextValue$iv = this.getUpdatedViewModels((PersistentList<? extends ChatMessageViewModel>)it, project, (ChatSessionMessageEvent)chatSessionEvent, this.viewModelsParentScope, this.chatSessionContext.getSessionId())));
        } else if (chatSessionEvent2 instanceof ChatSessionRollbackEvents) {
            int $i$f$update;
            int eventId = ((ChatSessionRollbackEvents)chatSessionEvent).getFrom().getId();
            if (eventId <= ($i$f$update = ((ChatSessionRollbackEvents)chatSessionEvent).getTo().getId())) {
                while (true) {
                    if (this.messageViewModelByEventId.get(new ChatSessionEventId(eventId)) != null) {
                        ChatMessageViewModel revertedViewModel;
                        boolean bl = false;
                        revertedViewModel.updateReverted(true);
                        this.revertedViewModelToEventId.put(revertedViewModel, new ChatSessionEventId(eventId));
                    }
                    if (eventId != $i$f$update) {
                        ++eventId;
                        continue;
                    }
                    break;
                }
            }
        } else if (chatSessionEvent2 instanceof ChatSessionResponseReceived) {
            StateFlow<List<AgentMessageBlockViewModel<?>>> lastAgentMessage;
            Object object;
            Object var6_11;
            block19: {
                Object v2;
                ChatMessageViewModel.PromptViewModel lastPrompt;
                Object v0;
                block18: {
                    List $this$lastOrNull$iv = (List)this._messageViewModels.getValue();
                    boolean $i$f$lastOrNull = false;
                    ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        Object element$iv = iterator$iv.previous();
                        ChatMessageViewModel it = (ChatMessageViewModel)element$iv;
                        boolean bl = false;
                        if (!(it instanceof ChatMessageViewModel.PromptViewModel)) continue;
                        v0 = element$iv;
                        break block18;
                    }
                    v0 = null;
                }
                Object $i$f$update = v0;
                ChatMessageViewModel.PromptViewModel promptViewModel = lastPrompt = $i$f$update instanceof ChatMessageViewModel.PromptViewModel ? (ChatMessageViewModel.PromptViewModel)$i$f$update : null;
                if (promptViewModel != null) {
                    promptViewModel.markAsResponded();
                }
                List $this$lastOrNull$iv = (List)this._messageViewModels.getValue();
                boolean $i$f$lastOrNull = false;
                ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    Object element$iv = iterator$iv.previous();
                    ChatMessageViewModel it = (ChatMessageViewModel)element$iv;
                    boolean bl = false;
                    if (!(it instanceof ChatMessageViewModel.AgentMessageViewModel)) continue;
                    v2 = element$iv;
                    break block19;
                }
                v2 = var6_11 = null;
            }
            if ((object = (lastAgentMessage = var6_11 instanceof ChatMessageViewModel.AgentMessageViewModel ? (StateFlow<List<AgentMessageBlockViewModel<?>>>)var6_11 : null)) != null && (object = object.getBlocks()) != null && (object = (List)object.getValue()) != null) {
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    AgentMessageBlockViewModel it = (AgentMessageBlockViewModel)element$iv;
                    boolean bl = false;
                    it.clearMenuItems();
                }
            }
        } else if (!(chatSessionEvent2 instanceof ChatSessionPlanUpdatedEvent || chatSessionEvent2 instanceof ChatSessionAgentStatusChanged || chatSessionEvent2 instanceof ChatSessionAgentStateChanged)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final PersistentList<ChatMessageViewModel> getUpdatedViewModels(PersistentList<? extends ChatMessageViewModel> messageViewModels, Project project, ChatSessionMessageEvent event, CoroutineScope viewModelsParentScope, ChatSessionId chatSessionId) {
        ChatSessionAgent currentAgent;
        PersistentList persistentList;
        ChatMessageViewModel viewModelToBeUpdated;
        ChatMessageViewModel chatMessageViewModel;
        Object object;
        ChatMessageViewModel viewModelByEventId = this.messageViewModelByEventId.get(event.getId());
        ChatMessageViewModel chatMessageViewModel2 = viewModelByEventId;
        if (chatMessageViewModel2 == null) {
            if (event instanceof ChatSessionMessageBlockEvent) {
                object = CollectionsKt.lastOrNull((List)((List)messageViewModels));
                ChatMessageViewModel it = (ChatMessageViewModel)object;
                boolean bl = false;
                chatMessageViewModel2 = (ChatMessageViewModel)(it instanceof ChatMessageViewModel.AgentMessageViewModel ? object : null);
            } else {
                chatMessageViewModel2 = null;
            }
        }
        if ((chatMessageViewModel = (viewModelToBeUpdated = chatMessageViewModel2)) instanceof ChatMessageViewModel.AgentMessageViewModel) {
            if (event instanceof ChatSessionMessageBlockEvent) {
                ((ChatMessageViewModel.AgentMessageViewModel)viewModelToBeUpdated).updateMessageBlocks((ChatSessionMessageBlockEvent)event);
                this.messageViewModelByEventId.put(((ChatSessionMessageBlockEvent)event).getId(), viewModelToBeUpdated);
            } else {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(ChatMessageUpdatesManager.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Update of " + Reflection.getOrCreateKotlinClass(viewModelToBeUpdated.getClass()).getSimpleName() + " by " + Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName() + " is not accounted for");
            }
            persistentList = messageViewModels;
            return persistentList;
        }
        if (chatMessageViewModel instanceof ChatMessageViewModel.PromptViewModel) {
            if (event instanceof ChatSessionUserPromptEvent) {
                ((ChatMessageViewModel.PromptViewModel)viewModelToBeUpdated).updatePrompt((ChatSessionUserPromptEvent)event);
                this.messageViewModelByEventId.put(((ChatSessionUserPromptEvent)event).getId(), viewModelToBeUpdated);
            }
            persistentList = messageViewModels;
            return persistentList;
        }
        if (chatMessageViewModel instanceof ChatMessageViewModel.FailureMessageViewModel) {
            if (event instanceof ChatSessionFailureEvent) {
                ((ChatMessageViewModel.FailureMessageViewModel)viewModelToBeUpdated).updateMessage((ChatSessionFailureEvent)event);
                this.messageViewModelByEventId.put(((ChatSessionFailureEvent)event).getId(), viewModelToBeUpdated);
                this.failureMessageEventIds.add(((ChatSessionFailureEvent)event).getId());
            }
            persistentList = messageViewModels;
            return persistentList;
        }
        if (chatMessageViewModel != null) throw new NoWhenBranchMatchedException();
        object = event;
        if (object instanceof ChatSessionMessageBlockEvent) {
            ChatSessionAgent chatSessionAgent;
            List list = (List)this.availableAgents.getValue();
            if (list != null) {
                Object object2;
                block21: {
                    void var14_19;
                    Iterable $this$singleOrNull$iv = list;
                    boolean $i$f$singleOrNull = false;
                    Object var14_18 = null;
                    boolean found$iv = false;
                    for (Object element$iv : $this$singleOrNull$iv) {
                        ChatSessionAgent it = (ChatSessionAgent)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)((ChatSessionMessageBlockEvent)event).getAgentId())) continue;
                        if (found$iv) {
                            object2 = null;
                            break block21;
                        }
                        Object t = element$iv;
                        found$iv = true;
                    }
                    object2 = !found$iv ? null : var14_19;
                }
                chatSessionAgent = (ChatSessionAgent)object2;
            } else {
                chatSessionAgent = null;
            }
            currentAgent = chatSessionAgent;
            persistentList = this.addRemembering((PersistentList<? extends ChatMessageViewModel>)messageViewModels, ((ChatSessionMessageBlockEvent)event).getId(), (ChatMessageViewModel)new ChatMessageViewModel.AgentMessageViewModel(viewModelsParentScope, chatSessionId, currentAgent));
            return persistentList;
        }
        if (object instanceof ChatSessionUserPromptEvent) {
            ChatSessionAgent chatSessionAgent;
            List list = (List)this.availableAgents.getValue();
            if (list != null) {
                Object object3;
                block22: {
                    void var14_22;
                    Iterable $this$singleOrNull$iv = list;
                    boolean $i$f$singleOrNull = false;
                    Object var14_21 = null;
                    boolean found$iv = false;
                    for (Object element$iv : $this$singleOrNull$iv) {
                        ChatSessionAgent it = (ChatSessionAgent)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)((ChatSessionUserPromptEvent)event).getAgentId())) continue;
                        if (found$iv) {
                            object3 = null;
                            break block22;
                        }
                        Object t = element$iv;
                        found$iv = true;
                    }
                    object3 = !found$iv ? null : var14_22;
                }
                chatSessionAgent = (ChatSessionAgent)object3;
            } else {
                chatSessionAgent = null;
            }
            currentAgent = chatSessionAgent;
            Iterable $this$map$iv = ((ChatSessionUserPromptEvent)event).getAttachments();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : iterable) {
                void it;
                ChatSessionUserPromptAttachment bl = (ChatSessionUserPromptAttachment)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new Attachment(it.getName(), IconIdKt.icon((IconId)it.getIcon()), it.getHint(), FileOperationsKt.urlToVirtualFile(it.getUrl())));
            }
            List attachments = (List)destination$iv$iv;
            ChatMessageViewModel.PromptViewModel promptViewModel = new ChatMessageViewModel.PromptViewModel(chatSessionId, ((ChatSessionUserPromptEvent)event).getPrompt(), (Function0<Unit>)((Function0)() -> ChatMessageUpdatesManager.getUpdatedViewModels$lambda$4(this, chatSessionId, event)), attachments, this.openAttachmentAction(project));
            persistentList = ExtensionsKt.toPersistentList((Iterable)this.addRemembering(this.addRemembering(CollectionsKt.toMutableList((Collection)this.removeFailureMessages(this.removeRevertedMessages((List)messageViewModels))), ((ChatSessionUserPromptEvent)event).getId(), (ChatMessageViewModel)promptViewModel), null, (ChatMessageViewModel)new ChatMessageViewModel.AgentMessageViewModel(viewModelsParentScope, chatSessionId, currentAgent)));
            return persistentList;
        }
        if (!(object instanceof ChatSessionFailureEvent)) throw new NoWhenBranchMatchedException();
        this.failureMessageEventIds.add(((ChatSessionFailureEvent)event).getId());
        persistentList = this.addRemembering(messageViewModels, ((ChatSessionFailureEvent)event).getId(), (ChatMessageViewModel)new ChatMessageViewModel.FailureMessageViewModel(chatSessionId, ((ChatSessionFailureEvent)event).getMessage()));
        return persistentList;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ChatMessageViewModel> removeRevertedMessages(List<? extends ChatMessageViewModel> $this$removeRevertedMessages) {
        List list;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = $this$removeRevertedMessages;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            ChatMessageViewModel it = (ChatMessageViewModel)element$iv$iv;
            boolean bl = false;
            if (this.revertedViewModelToEventId.containsKey(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List it = list = (List)destination$iv$iv;
        boolean bl = false;
        Iterable $this$forEach$iv = this.revertedViewModelToEventId.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChatSessionEventId eventId = (ChatSessionEventId)element$iv;
            boolean bl2 = false;
            this.messageViewModelByEventId.remove(eventId);
        }
        this.revertedViewModelToEventId.clear();
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ChatMessageViewModel> removeFailureMessages(List<? extends ChatMessageViewModel> $this$removeFailureMessages) {
        List list;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = $this$removeFailureMessages;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            ChatMessageViewModel it = (ChatMessageViewModel)element$iv$iv;
            boolean bl = false;
            if (it instanceof ChatMessageViewModel.FailureMessageViewModel) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List it = list = (List)destination$iv$iv;
        boolean bl = false;
        Iterable $this$forEach$iv = this.failureMessageEventIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChatSessionEventId eventId = (ChatSessionEventId)element$iv;
            boolean bl2 = false;
            this.messageViewModelByEventId.remove(eventId);
        }
        this.failureMessageEventIds.clear();
        return list;
    }

    private final PersistentList<ChatMessageViewModel> addRemembering(PersistentList<? extends ChatMessageViewModel> $this$addRemembering, ChatSessionEventId eventId, ChatMessageViewModel messageViewModel) {
        PersistentList persistentList;
        PersistentList it = persistentList = $this$addRemembering.add((Object)messageViewModel);
        boolean bl = false;
        if (eventId != null) {
            this.messageViewModelByEventId.put(eventId, messageViewModel);
        }
        return persistentList;
    }

    private final List<ChatMessageViewModel> addRemembering(List<ChatMessageViewModel> $this$addRemembering, ChatSessionEventId eventId, ChatMessageViewModel messageViewModel) {
        boolean bl;
        boolean it = bl = $this$addRemembering.add(messageViewModel);
        boolean bl2 = false;
        if (eventId != null) {
            this.messageViewModelByEventId.put(eventId, messageViewModel);
        }
        return $this$addRemembering;
    }

    private final void rollbackAction(ChatSessionId chatSessionId, ChatSessionEventId eventId) {
        BuildersKt.launch$default((CoroutineScope)this.viewModelsParentScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(chatSessionId, eventId, null){
            int label;
            final /* synthetic */ ChatSessionId $chatSessionId;
            final /* synthetic */ ChatSessionEventId $eventId;
            {
                this.$chatSessionId = $chatSessionId;
                this.$eventId = $eventId;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = AIAssistantChatSessionApi.Companion.getInstance((Continuation)this);
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        this.label = 2;
                        v1 = ((AIAssistantChatSessionApi)v0).rollbackResult(this.$chatSessionId, this.$eventId, (Continuation)this);
                        if (v1 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl21
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl21:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final Function1<Attachment, Unit> openAttachmentAction(Project project) {
        return arg_0 -> ChatMessageUpdatesManager.openAttachmentAction$lambda$0(project, arg_0);
    }

    private static final Unit getUpdatedViewModels$lambda$4(ChatMessageUpdatesManager this$0, ChatSessionId $chatSessionId, ChatSessionMessageEvent $event) {
        this$0.rollbackAction($chatSessionId, ((ChatSessionUserPromptEvent)$event).getId());
        return Unit.INSTANCE;
    }

    private static final Unit openAttachmentAction$lambda$0(Project $project, Attachment attachment) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
            VirtualFile virtualFile = attachment.getFile();
            if (virtualFile == null) break block1;
            VirtualFile file = virtualFile;
            boolean bl = false;
            if (file.isValid()) {
                FileEditorManager.getInstance((Project)$project).openFile(file, true);
            }
        }
        return Unit.INSTANCE;
    }
}

