/*
 * Decompiled with CFR 0.152.
 */
package com.agentclientprotocol.protocol;

import com.agentclientprotocol.protocol.AcpExpectedError;
import com.agentclientprotocol.protocol.JsonRpcException;
import com.agentclientprotocol.rpc.JsonRpcErrorCode;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.ExceptionsKt;
import kotlinx.serialization.SerializationException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0014\u0010\b\u001a\u00060\tj\u0002`\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"logger", "Lio/github/oshai/kotlinlogging/KLogger;", "acpFail", "", "message", "", "jsonRpcMethodNotFound", "jsonRpcInvalidParams", "convertJsonRpcExceptionIfPossible", "Ljava/lang/Exception;", "Lkotlin/Exception;", "jsonRpcException", "Lcom/agentclientprotocol/protocol/JsonRpcException;", "acp"})
public final class ProtocolKt {
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(ProtocolKt::logger$lambda$0);

    @NotNull
    public static final Void acpFail(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        throw new AcpExpectedError(message);
    }

    @NotNull
    public static final Void jsonRpcMethodNotFound(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        throw new JsonRpcException(JsonRpcErrorCode.METHOD_NOT_FOUND.getCode(), message, null, 4, null);
    }

    @NotNull
    public static final Void jsonRpcInvalidParams(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        throw new JsonRpcException(JsonRpcErrorCode.INVALID_PARAMS.getCode(), message, null, 4, null);
    }

    private static final Exception convertJsonRpcExceptionIfPossible(JsonRpcException jsonRpcException) {
        int n = jsonRpcException.getCode();
        if (n == JsonRpcErrorCode.PARSE_ERROR.getCode()) {
            return (Exception)((Object)new SerializationException(jsonRpcException.getMessage(), (Throwable)jsonRpcException));
        }
        if (n == JsonRpcErrorCode.INVALID_PARAMS.getCode()) {
            return new AcpExpectedError(jsonRpcException.getMessage());
        }
        if (n == JsonRpcErrorCode.CANCELLED.getCode()) {
            return ExceptionsKt.CancellationException((String)jsonRpcException.getMessage(), (Throwable)jsonRpcException);
        }
        return jsonRpcException;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ KLogger access$getLogger$p() {
        return logger;
    }

    public static final /* synthetic */ Exception access$convertJsonRpcExceptionIfPossible(JsonRpcException jsonRpcException) {
        return ProtocolKt.convertJsonRpcExceptionIfPossible(jsonRpcException);
    }
}

