/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.promptlog;

import com.intellij.lang.Language;
import com.intellij.ml.llm.core.promptlog.CodeSnippet;
import com.intellij.ml.llm.core.promptlog.CodeSnippetFormatting;
import com.intellij.ml.llm.core.promptlog.CodeSnippetSerializer;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.PrivacySafe;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=CodeSnippetSerializer.class)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B1\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0001\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0006\u0010\u0011\u001a\u00020\u0001R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/core/promptlog/CodeSnippet;", "Lcom/intellij/ml/llm/privacy/PSString;", "code", "path", "language", "formatting", "Lcom/intellij/ml/llm/core/promptlog/CodeSnippetFormatting;", "<init>", "(Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/privacy/PSString;Lcom/intellij/ml/llm/core/promptlog/CodeSnippetFormatting;)V", "getCode", "()Lcom/intellij/ml/llm/privacy/PSString;", "getPath", "getLanguage", "getFormatting", "()Lcom/intellij/ml/llm/core/promptlog/CodeSnippetFormatting;", "toString", "", "format", "Companion", "intellij.ml.llm.core"})
public class CodeSnippet
extends PSString {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PSString code;
    @Nullable
    private final PSString path;
    @Nullable
    private final PSString language;
    @NotNull
    private final CodeSnippetFormatting formatting;

    public CodeSnippet(@NotNull PSString code, @Nullable PSString path, @Nullable PSString language, @NotNull CodeSnippetFormatting formatting) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)((Object)formatting), (String)"formatting");
        super((PrivacySafe)code);
        this.code = code;
        this.path = path;
        this.language = language;
        this.formatting = formatting;
    }

    public /* synthetic */ CodeSnippet(PSString pSString, PSString pSString2, PSString pSString3, CodeSnippetFormatting codeSnippetFormatting, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            pSString2 = null;
        }
        if ((n & 4) != 0) {
            pSString3 = null;
        }
        if ((n & 8) != 0) {
            codeSnippetFormatting = CodeSnippetFormatting.NONE;
        }
        this(pSString, pSString2, pSString3, codeSnippetFormatting);
    }

    @NotNull
    public final PSString getCode() {
        return this.code;
    }

    @Nullable
    public final PSString getPath() {
        return this.path;
    }

    @Nullable
    public final PSString getLanguage() {
        return this.language;
    }

    @NotNull
    public final CodeSnippetFormatting getFormatting() {
        return this.formatting;
    }

    @NotNull
    public String toString() {
        return (String)this.format().unwrap();
    }

    @NotNull
    public final PSString format() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.formatting.ordinal()]) {
            case 1 -> this.code;
            case 2 -> com.intellij.ml.llm.core.promptlog.CodeSnippet$Companion.trimAndAddBackticks$default(Companion, this.code, null, 2, null);
            case 3 -> CodeSnippet.Companion.trimAndAddBackticks(this.code, this.language);
            case 4 -> CodeSnippet.Companion.addTripleBackticks(this.code, this.language);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0086@\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u001c\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\fH\u0002J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/core/promptlog/CodeSnippet$Companion;", "", "<init>", "()V", "createSnippet", "Lcom/intellij/ml/llm/core/promptlog/CodeSnippet;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "addTripleBackticks", "Lcom/intellij/ml/llm/privacy/PSString;", "code", "language", "addSingleBackticks", "trimAndAddBackticks", "serializer", "Lkotlinx/serialization/KSerializer;", "intellij.ml.llm.core"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Object createSnippet(@NotNull Project project, @NotNull VirtualFile file, @NotNull Continuation<? super CodeSnippet> $completion) {
            if (!($completion instanceof createSnippet.1)) ** GOTO lbl-1000
            var8_4 = $completion;
            if ((var8_4.label & -2147483648) != 0) {
                var8_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.createSnippet(null, null, (Continuation<? super CodeSnippet>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.L$0 = project;
                    $continuation.L$1 = file;
                    $continuation.label = 1;
                    v0 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, createSnippet$lambda$0(com.intellij.openapi.vfs.VirtualFile com.intellij.openapi.project.Project ), ()Lcom/intellij/ml/llm/privacy/PSString;)((VirtualFile)file, (Project)project), (Continuation)$continuation);
                    if (v0 == var9_6) {
                        return var9_6;
                    }
                    ** GOTO lbl24
                }
                case 1: {
                    file = (VirtualFile)$continuation.L$1;
                    project = (Project)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl24:
                    // 2 sources

                    content = (PSString)v0;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                    $continuation.L$1 = file;
                    $continuation.L$2 = content;
                    $continuation.label = 2;
                    v1 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, createSnippet$lambda$1(com.intellij.openapi.vfs.VirtualFile com.intellij.openapi.project.Project ), ()Lcom/intellij/ml/llm/privacy/PSString;)((VirtualFile)file, (Project)project), (Continuation)$continuation);
                    if (v1 == var9_6) {
                        return var9_6;
                    }
                    ** GOTO lbl39
                }
                case 2: {
                    content = (PSString)$continuation.L$2;
                    file = (VirtualFile)$continuation.L$1;
                    project = (Project)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl39:
                    // 2 sources

                    path = (PSString)v1;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)file);
                    $continuation.L$2 = content;
                    $continuation.L$3 = path;
                    $continuation.label = 3;
                    v2 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, createSnippet$lambda$2(com.intellij.openapi.vfs.VirtualFile ), ()Lcom/intellij/ml/llm/privacy/PSString;)((VirtualFile)file), (Continuation)$continuation);
                    if (v2 == var9_6) {
                        return var9_6;
                    }
                    ** GOTO lbl56
                }
                case 3: {
                    path = (PSString)$continuation.L$3;
                    content = (PSString)$continuation.L$2;
                    file = (VirtualFile)$continuation.L$1;
                    project = (Project)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl56:
                    // 2 sources

                    language = (PSString)v2;
                    return new CodeSnippet(content, path, language, CodeSnippetFormatting.TRIM_AND_ADD_BACKTICKS_LANGUAGE);
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private final PSString addTripleBackticks(PSString code, PSString language) {
            PSString pSString = ConstantsKt.getPrivacyConst((String)"\n```%s\n%s\n```");
            PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[2];
            PSString pSString2 = language;
            if (pSString2 == null) {
                pSString2 = ConstantsKt.getPrivacyConst((String)"");
            }
            pSStringConvertibleArray[0] = pSString2;
            pSStringConvertibleArray[1] = code;
            return pSString.format(pSStringConvertibleArray);
        }

        static /* synthetic */ PSString addTripleBackticks$default(Companion companion, PSString pSString, PSString pSString2, int n, Object object) {
            if ((n & 2) != 0) {
                pSString2 = null;
            }
            return companion.addTripleBackticks(pSString, pSString2);
        }

        private final PSString addSingleBackticks(PSString code) {
            PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{code};
            return ConstantsKt.getPrivacyConst((String)"\n`%s`").format(pSStringConvertibleArray);
        }

        private final PSString trimAndAddBackticks(PSString code, PSString language) {
            PSString pSString;
            char[] cArray = new char[]{'\n'};
            List split = PrivacySafe.split$default((PrivacySafe)((PrivacySafe)code), (char[])cArray, (boolean)false, (int)0, (int)6, null);
            if (split.size() == 1) {
                pSString = this.addSingleBackticks(((PSString)split.get(0)).trim());
            } else {
                cArray = new char[]{'\n'};
                pSString = this.addTripleBackticks(code.trimEnd().trimStart(cArray), language);
            }
            return pSString;
        }

        static /* synthetic */ PSString trimAndAddBackticks$default(Companion companion, PSString pSString, PSString pSString2, int n, Object object) {
            if ((n & 2) != 0) {
                pSString2 = null;
            }
            return companion.trimAndAddBackticks(pSString, pSString2);
        }

        @NotNull
        public final KSerializer<CodeSnippet> serializer() {
            return CodeSnippetSerializer.INSTANCE;
        }

        private static final PSString createSnippet$lambda$0(VirtualFile $file, Project $project) {
            return ExtensionsKtKt.privacySafe((VirtualFile)$file, (Project)$project).readText();
        }

        private static final PSString createSnippet$lambda$1(VirtualFile $file, Project $project) {
            return ExtensionsKtKt.privacySafe((VirtualFile)$file, (Project)$project).getProjectRelativePath();
        }

        private static final PSString createSnippet$lambda$2(VirtualFile $file) {
            FileType fileType = $file.getFileType();
            LanguageFileType languageFileType = fileType instanceof LanguageFileType ? (LanguageFileType)fileType : null;
            return languageFileType != null && (languageFileType = languageFileType.getLanguage()) != null && (languageFileType = ExtensionsKtKt.getPrivacySafe((Language)languageFileType)) != null ? languageFileType.getDisplayName() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CodeSnippetFormatting.values().length];
            try {
                nArray[CodeSnippetFormatting.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodeSnippetFormatting.TRIM_AND_ADD_BACKTICKS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodeSnippetFormatting.TRIM_AND_ADD_BACKTICKS_LANGUAGE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodeSnippetFormatting.ADD_TRIPLE_BACKTICKS_LANGUAGE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

