/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.settings;

import com.intellij.idea.AppMode;
import com.intellij.ml.llm.core.settings.LLMProjectSettings;
import com.intellij.ml.llm.core.settings.LLMProjectSettingsListener;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@State(name="LLMProjectSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000bJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000fJ\u0006\u0010\u0011\u001a\u00020\u000bR\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/core/settings/LLMProjectSettingsManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/ml/llm/core/settings/LLMProjectSettings;", "<init>", "()V", "state", "getState", "loadState", "", "newState", "isTurnedOn", "", "setTurnedOn", "value", "getProjectReviewRulesFilePath", "", "setProjectReviewRulesFilePath", "hasRemDevModeRestrictions", "Companion", "intellij.ml.llm.core"})
public final class LLMProjectSettingsManager
implements PersistentStateComponent<LLMProjectSettings> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private LLMProjectSettings state = new LLMProjectSettings();

    @NotNull
    public LLMProjectSettings getState() {
        return this.state;
    }

    public void loadState(@NotNull LLMProjectSettings newState) {
        Intrinsics.checkNotNullParameter((Object)((Object)newState), (String)"newState");
        this.state = newState;
    }

    public final boolean isTurnedOn() {
        return this.state.isTurnedOn();
    }

    public final void setTurnedOn(boolean value) {
        this.state.setTurnedOn(value);
    }

    @NotNull
    public final String getProjectReviewRulesFilePath() {
        String string = this.state.getProjectReviewRulesFilePath();
        if (string == null) {
            string = "";
        }
        return string;
    }

    public final void setProjectReviewRulesFilePath(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.state.setProjectReviewRulesFilePath(value);
    }

    public final boolean hasRemDevModeRestrictions() {
        if (AppMode.isRemoteDevHost()) {
            return !Registry.Companion.is("llm.remdev.all.actions.enabled");
        }
        return false;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/core/settings/LLMProjectSettingsManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/core/settings/LLMProjectSettingsManager;", "project", "Lcom/intellij/openapi/project/Project;", "fireSettingsChanged", "", "intellij.ml.llm.core"})
    @SourceDebugExtension(value={"SMAP\nLLMProjectSettingsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLMProjectSettingsManager.kt\ncom/intellij/ml/llm/core/settings/LLMProjectSettingsManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,65:1\n30#2,2:66\n*S KotlinDebug\n*F\n+ 1 LLMProjectSettingsManager.kt\ncom/intellij/ml/llm/core/settings/LLMProjectSettingsManager$Companion\n*L\n18#1:66,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LLMProjectSettingsManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<LLMProjectSettingsManager> serviceClass$iv = LLMProjectSettingsManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (LLMProjectSettingsManager)object;
        }

        public final void fireSettingsChanged(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ((LLMProjectSettingsListener)project.getMessageBus().syncPublisher(LLMProjectSettingsListener.Companion.getTOPIC())).settingsChanged();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

