/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.statistics;

import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.ml.llm.privacy.PSString;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\r\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018J\f\u0010\u0019\u001a\u00020\u001a*\u00020\u001bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000f\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ml/llm/core/statistics/UserPromptDescriptor;", "", "<init>", "()V", "WORDS_DELIMITERS", "", "WORDS_SEPARATOR_REGEXP", "Lkotlin/text/Regex;", "USER_PROMPT_CHARS_COUNT", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "USER_PROMPT_WORDS_COUNT", "USER_PROMPT_LINES_COUNT", "USER_PROMPT_HAS_BACKTICKS", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "eventFields", "", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "getEventFields", "()[Lcom/intellij/internal/statistic/eventLog/events/EventField;", "[Lcom/intellij/internal/statistic/eventLog/events/EventField;", "describe", "", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "prompt", "Lcom/intellij/ml/llm/privacy/PSString;", "wordsCount", "", "", "intellij.ml.llm.core"})
@SourceDebugExtension(value={"SMAP\nUserPromptDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserPromptDescriptor.kt\ncom/intellij/ml/llm/core/statistics/UserPromptDescriptor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,50:1\n1788#2,4:51\n*S KotlinDebug\n*F\n+ 1 UserPromptDescriptor.kt\ncom/intellij/ml/llm/core/statistics/UserPromptDescriptor\n*L\n47#1:51,4\n*E\n"})
public final class UserPromptDescriptor {
    @NotNull
    public static final UserPromptDescriptor INSTANCE = new UserPromptDescriptor();
    @NotNull
    private static final String WORDS_DELIMITERS = "\\s\\p{P}";
    @NotNull
    private static final Regex WORDS_SEPARATOR_REGEXP = new Regex("[\\s\\p{P}]+");
    @NotNull
    private static final IntEventField USER_PROMPT_CHARS_COUNT = EventFields.Int((String)"user_prompt_chars_count", (String)"Number of characters in the user prompt");
    @NotNull
    private static final IntEventField USER_PROMPT_WORDS_COUNT = EventFields.Int((String)"user_prompt_words_count", (String)"Number of words in the user prompt");
    @NotNull
    private static final IntEventField USER_PROMPT_LINES_COUNT = EventFields.Int((String)"user_prompt_lines_count", (String)"Number of lines in the user prompt");
    @NotNull
    private static final BooleanEventField USER_PROMPT_HAS_BACKTICKS = EventFields.Boolean((String)"user_prompt_has_backticks", (String)"Whether the user prompt contains backticks");
    @NotNull
    private static final EventField<?>[] eventFields;

    private UserPromptDescriptor() {
    }

    @NotNull
    public final EventField<?>[] getEventFields() {
        return eventFields;
    }

    @NotNull
    public final List<EventPair<?>> describe(@NotNull PSString prompt) {
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        String promptStr = prompt.toString();
        Object[] objectArray = new EventPair[]{USER_PROMPT_CHARS_COUNT.with((Object)promptStr.length()), USER_PROMPT_WORDS_COUNT.with((Object)this.wordsCount(promptStr)), USER_PROMPT_LINES_COUNT.with((Object)StringsKt.lines((CharSequence)promptStr).size()), USER_PROMPT_HAS_BACKTICKS.with((Object)StringsKt.contains$default((CharSequence)promptStr, (CharSequence)"`", (boolean)false, (int)2, null))};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final int wordsCount(CharSequence $this$wordsCount) {
        int n;
        CharSequence charSequence = $this$wordsCount;
        Regex regex = WORDS_SEPARATOR_REGEXP;
        int n2 = 0;
        Iterable $this$count$iv = regex.split(charSequence, n2);
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                if (!bl2 || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n;
    }

    static {
        EventField[] eventFieldArray = new EventField[]{USER_PROMPT_CHARS_COUNT, USER_PROMPT_WORDS_COUNT, USER_PROMPT_LINES_COUNT, USER_PROMPT_HAS_BACKTICKS};
        eventFields = eventFieldArray;
    }
}

