/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.core.statistics.fus.jcp;

import com.intellij.ml.llm.core.statistics.fus.jcp.IJcpAnalyticsClient;
import com.intellij.ml.llm.core.statistics.fus.jcp.JcpAnalyticsClientImpl;
import com.intellij.ml.llm.core.statistics.fus.jcp.JcpAnalyticsSender;
import com.intellij.ml.llm.core.statistics.fus.jcp.JcpTokenProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.registry.Registry;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.analytics.EventAgent;
import org.jetbrains.analytics.EventData;
import org.jetbrains.analytics.EventLogMetadata;
import org.jetbrains.analytics.lifecycle.AnalyticsClient;
import org.jetbrains.analytics.lifecycle.AnalyticsConfig;
import org.jetbrains.analytics.utils.AsBuildNumberKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00122\u00020\u00012\u00020\u0002:\u0001\u0012B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/core/statistics/fus/jcp/JcpAnalyticsClient;", "Lcom/intellij/ml/llm/core/statistics/fus/jcp/IJcpAnalyticsClient;", "Lcom/intellij/openapi/Disposable;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "jcpTokenProvider", "Lcom/intellij/ml/llm/core/statistics/fus/jcp/JcpTokenProvider;", "analyticsClient", "Lorg/jetbrains/analytics/lifecycle/AnalyticsClient;", "clientImpl", "Lcom/intellij/ml/llm/core/statistics/fus/jcp/JcpAnalyticsClientImpl;", "submitEvent", "", "event", "Lorg/jetbrains/analytics/EventData;", "dispose", "Companion", "intellij.ml.llm.core"})
public final class JcpAnalyticsClient
implements IJcpAnalyticsClient,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JcpTokenProvider jcpTokenProvider;
    @NotNull
    private final AnalyticsClient analyticsClient;
    @NotNull
    private final JcpAnalyticsClientImpl clientImpl;
    @NotNull
    private static final String JCP_ANALYTICS_BATCH_SIZE_KEY = "llm.jcp.analytics.batch.size";
    @NotNull
    private static final String JCP_ANALYTICS_EVENTS_THRESHOLD_KEY = "llm.jcp.analytics.events.threshold";
    @NotNull
    private static final Lazy<Integer> batchSize$delegate = LazyKt.lazy(JcpAnalyticsClient::batchSize_delegate$lambda$0);
    @NotNull
    private static final Lazy<Integer> eventsThreshold$delegate = LazyKt.lazy(JcpAnalyticsClient::eventsThreshold_delegate$lambda$0);
    @NotNull
    private static final Lazy<AnalyticsConfig> defaultConfig$delegate = LazyKt.lazy(JcpAnalyticsClient::defaultConfig_delegate$lambda$0);

    public JcpAnalyticsClient(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.jcpTokenProvider = new JcpTokenProvider(cs);
        this.analyticsClient = new AnalyticsClient(JcpAnalyticsClient.Companion.getDefaultConfig(), new JcpAnalyticsSender(this.jcpTokenProvider), null, 4, null);
        this.clientImpl = new JcpAnalyticsClientImpl(cs, this.jcpTokenProvider, this.analyticsClient);
    }

    @Override
    public void submitEvent(@NotNull EventData event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.clientImpl.submitEvent(event);
    }

    public void dispose() {
        this.clientImpl.dispose();
    }

    private static final int batchSize_delegate$lambda$0() {
        return Registry.Companion.intValue(JCP_ANALYTICS_BATCH_SIZE_KEY, 1);
    }

    private static final int eventsThreshold_delegate$lambda$0() {
        return Registry.Companion.intValue(JCP_ANALYTICS_EVENTS_THRESHOLD_KEY, 1);
    }

    private static final AnalyticsConfig defaultConfig_delegate$lambda$0() {
        String string = ApplicationInfo.getInstance().getBuild().getProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProductCode(...)");
        String string2 = ApplicationInfo.getInstance().getBuild().asStringWithoutProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asStringWithoutProductCode(...)");
        EventLogMetadata eventLogMetadata = new EventLogMetadata(null, null, null, null, new EventAgent(string, AsBuildNumberKt.asBuildNumber(string2)));
        int n = JcpAnalyticsClient.Companion.getEventsThreshold();
        int n2 = JcpAnalyticsClient.Companion.getBatchSize();
        String[] stringArray = new String[]{"llm-jcp-outbox"};
        Path path = Paths.get(PathManager.getSystemPath(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return new AnalyticsConfig(eventLogMetadata, n, n2, null, null, null, path, 0, null, null, 0.0, 1976, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001b\u0010\r\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\f\u001a\u0004\b\u000e\u0010\nR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\f\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/core/statistics/fus/jcp/JcpAnalyticsClient$Companion;", "", "<init>", "()V", "JCP_ANALYTICS_BATCH_SIZE_KEY", "", "JCP_ANALYTICS_EVENTS_THRESHOLD_KEY", "batchSize", "", "getBatchSize", "()I", "batchSize$delegate", "Lkotlin/Lazy;", "eventsThreshold", "getEventsThreshold", "eventsThreshold$delegate", "defaultConfig", "Lorg/jetbrains/analytics/lifecycle/AnalyticsConfig;", "getDefaultConfig", "()Lorg/jetbrains/analytics/lifecycle/AnalyticsConfig;", "defaultConfig$delegate", "intellij.ml.llm.core"})
    public static final class Companion {
        private Companion() {
        }

        private final int getBatchSize() {
            Lazy lazy = batchSize$delegate;
            return ((Number)lazy.getValue()).intValue();
        }

        private final int getEventsThreshold() {
            Lazy lazy = eventsThreshold$delegate;
            return ((Number)lazy.getValue()).intValue();
        }

        private final AnalyticsConfig getDefaultConfig() {
            Lazy lazy = defaultConfig$delegate;
            return (AnalyticsConfig)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

