/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.analytics.storage;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.analytics.EventData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ \u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u000fJ\u0014\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/analytics/storage/SimpleOnDiskSpooler;", "", "root", "Ljava/nio/file/Path;", "retention", "Ljava/time/Duration;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "<init>", "(Ljava/nio/file/Path;Ljava/time/Duration;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "eventsDir", "persist", "event", "Lorg/jetbrains/analytics/EventData;", "count", "", "loadBatch", "", "Lkotlin/Pair;", "limit", "deleteAll", "", "paths", "", "purgeOlderThan", "maxAge", "Analytics Charts Library"})
@SourceDebugExtension(value={"SMAP\nSimpleOnDiskSpooler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleOnDiskSpooler.kt\norg/jetbrains/analytics/storage/SimpleOnDiskSpooler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1#2:111\n*E\n"})
public final class SimpleOnDiskSpooler {
    @NotNull
    private final Path root;
    @NotNull
    private final Duration retention;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final Path eventsDir;

    public SimpleOnDiskSpooler(@NotNull Path root, @NotNull Duration retention, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)retention, (String)"retention");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.root = root;
        this.retention = retention;
        this.objectMapper = objectMapper;
        Path path = this.root.resolve("event-logs");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        this.eventsDir = path;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(this.eventsDir, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        this.purgeOlderThan(this.retention);
    }

    public /* synthetic */ SimpleOnDiskSpooler(Path path, Duration duration, ObjectMapper objectMapper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            objectMapper = ExtensionsKt.registerKotlinModule((ObjectMapper)new ObjectMapper());
        }
        this(path, duration, objectMapper);
    }

    @Nullable
    public final synchronized Path persist(@NotNull EventData event) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String id = string;
        Path tmp = this.eventsDir.resolve(id + ".tmp");
        Path dst = this.eventsDir.resolve(id + ".json");
        try {
            Files.writeString(tmp, (CharSequence)this.objectMapper.writeValueAsString((Object)event), StandardCharsets.UTF_8, new OpenOption[0]);
            object = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING};
            Files.move(tmp, dst, object);
            object = dst;
        }
        catch (Throwable t) {
            SimpleOnDiskSpooler simpleOnDiskSpooler = this;
            try {
                SimpleOnDiskSpooler $this$persist_u24lambda_u240 = simpleOnDiskSpooler;
                boolean bl = false;
                Object object2 = Result.constructor-impl((Object)Files.deleteIfExists(tmp));
            }
            catch (Throwable throwable) {
                Object object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object = null;
        }
        return object;
    }

    public final int count() {
        this.purgeOlderThan(this.retention);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return !Files.exists(this.eventsDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? 0 : ((Collection)PathsKt.listDirectoryEntries((Path)this.eventsDir, (String)"*.json")).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Pair<Path, EventData>> loadBatch(int limit) {
        block15: {
            block14: {
                this.purgeOlderThan(this.retention);
                if (limit <= 0) break block14;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.exists(this.eventsDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block15;
            }
            return CollectionsKt.emptyList();
        }
        Object object = this;
        try {
            SimpleOnDiskSpooler $this$loadBatch_u24lambda_u246 = object;
            boolean bl = false;
            AutoCloseable autoCloseable = Files.walk($this$loadBatch_u24lambda_u246.eventsDir, new FileVisitOption[0]);
            Throwable throwable = null;
            try {
                Stream stream = (Stream)autoCloseable;
                boolean bl2 = false;
                List<Object> files = stream.filter(arg_0 -> SimpleOnDiskSpooler.loadBatch$lambda$6$lambda$5$lambda$2(SimpleOnDiskSpooler::loadBatch$lambda$6$lambda$5$lambda$1, arg_0)).sorted((arg_0, arg_1) -> SimpleOnDiskSpooler.loadBatch$lambda$6$lambda$5$lambda$4(SimpleOnDiskSpooler::loadBatch$lambda$6$lambda$5$lambda$3, arg_0, arg_1)).limit(limit).toList();
                List result2 = new ArrayList();
                for (Path path : files) {
                    try {
                        String json = Files.readString(path, StandardCharsets.UTF_8);
                        EventData ev = (EventData)$this$loadBatch_u24lambda_u246.objectMapper.readValue(json, EventData.class);
                        ((Collection)result2).add(TuplesKt.to((Object)path, (Object)ev));
                    }
                    catch (Exception exception) {}
                }
                List list = result2;
                return list;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Throwable throwable3;
                Throwable it = throwable3 = throwable;
                boolean bl3 = false;
                return CollectionsKt.emptyList();
            }
            Void void_ = (Void)(Result.isFailure-impl((Object)object) ? null : object);
            return void_ != null ? (List)((Object)void_) : CollectionsKt.emptyList();
        }
    }

    public final void deleteAll(@NotNull Collection<? extends Path> paths) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        for (Path path : paths) {
            Object object;
            SimpleOnDiskSpooler simpleOnDiskSpooler = this;
            try {
                SimpleOnDiskSpooler $this$deleteAll_u24lambda_u248 = simpleOnDiskSpooler;
                boolean bl = false;
                object = Result.constructor-impl((Object)Files.deleteIfExists(path));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void purgeOlderThan(Duration maxAge) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(this.eventsDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return;
        }
        long cutoffMillis = Instant.now().minus(maxAge).toEpochMilli();
        SimpleOnDiskSpooler simpleOnDiskSpooler = this;
        try {
            SimpleOnDiskSpooler $this$purgeOlderThan_u24lambda_u2415 = simpleOnDiskSpooler;
            boolean bl = false;
            AutoCloseable autoCloseable = Files.walk($this$purgeOlderThan_u24lambda_u2415.eventsDir, new FileVisitOption[0]);
            Throwable throwable = null;
            try {
                Stream stream = (Stream)autoCloseable;
                boolean bl2 = false;
                stream.filter(arg_0 -> SimpleOnDiskSpooler.purgeOlderThan$lambda$15$lambda$14$lambda$10(SimpleOnDiskSpooler::purgeOlderThan$lambda$15$lambda$14$lambda$9, arg_0)).forEach(arg_0 -> SimpleOnDiskSpooler.purgeOlderThan$lambda$15$lambda$14$lambda$13(arg_0 -> SimpleOnDiskSpooler.purgeOlderThan$lambda$15$lambda$14$lambda$12($this$purgeOlderThan_u24lambda_u2415, cutoffMillis, arg_0), arg_0));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    private static final boolean loadBatch$lambda$6$lambda$5$lambda$1(Path it) {
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && StringsKt.equals((String)PathsKt.getExtension((Path)it), (String)"json", (boolean)true);
    }

    private static final boolean loadBatch$lambda$6$lambda$5$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final int loadBatch$lambda$6$lambda$5$lambda$3(Path a, Path b) {
        return Files.getLastModifiedTime(b, new LinkOption[0]).compareTo(Files.getLastModifiedTime(a, new LinkOption[0]));
    }

    private static final int loadBatch$lambda$6$lambda$5$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final boolean purgeOlderThan$lambda$15$lambda$14$lambda$9(Path it) {
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && StringsKt.equals((String)PathsKt.getExtension((Path)it), (String)"json", (boolean)true);
    }

    private static final boolean purgeOlderThan$lambda$15$lambda$14$lambda$10(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit purgeOlderThan$lambda$15$lambda$14$lambda$12(SimpleOnDiskSpooler $this_runCatching, long $cutoffMillis, Path p) {
        SimpleOnDiskSpooler simpleOnDiskSpooler = $this_runCatching;
        try {
            SimpleOnDiskSpooler $this$purgeOlderThan_u24lambda_u2415_u24lambda_u2414_u24lambda_u2412_u24lambda_u2411 = simpleOnDiskSpooler;
            boolean bl = false;
            long lm = Files.getLastModifiedTime(p, new LinkOption[0]).toMillis();
            if (lm < $cutoffMillis) {
                Files.deleteIfExists(p);
            }
            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return Unit.INSTANCE;
    }

    private static final void purgeOlderThan$lambda$15$lambda$14$lambda$13(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

